<?php
class ControllerExtensionCustomercart extends Controller {
	
	private $error = array();

	public function index() {
		$this->language->load('extension/customer_cart');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('extension/customer_cart');
		
		$this->load->model('catalog/product');

		$this->getList();
	}
	// New work start
	public function delete() {
		
		
		$url = '';

		if (isset($this->request->get['filter_customer'])) {
			$url .= '&filter_customer=' . $this->request->get['filter_customer'];
		}
		
		if (isset($this->request->get['filter_email'])) {
			$url .= '&filter_email=' . $this->request->get['filter_email'];
		}

		if (isset($this->request->get['filter_notify'])) {
			$url .= '&filter_notify=' . $this->request->get['filter_notify'];
		}

		if (isset($this->request->get['filter_notify_order'])) {
			$url .= '&filter_notify_order=' . $this->request->get['filter_notify_order'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}	
			$this->language->load('extension/customer_cart');
				$this->load->model('extension/customer_cart');
			if (isset($this->request->get['storecart_id'])) {
				$this->model_extension_customer_cart->deletestorecart($this->request->get['storecart_id']);$this->session->data['success'] = $this->language->get('text_success');
				$this->response->redirect($this->url->link('extension/customer_cart', 'user_token=' . $this->session->data['user_token'].$url, true));
			}
			else
			{
				
				$this->response->redirect($this->url->link('extension/customer_cart', 'user_token=' . $this->session->data['user_token'].$url, true));
			}
			
		
		
  }
	// New work end
	protected function getList() {
		if (isset($this->request->get['filter_customer'])) {
			$filter_customer = $this->request->get['filter_customer'];
		} else {
			$filter_customer = null;
		}
		
		if (isset($this->request->get['filter_email'])) {
			$filter_email = $this->request->get['filter_email'];
		} else {
			$filter_email = null;
		}
		
		if (isset($this->request->get['filter_notify'])) {
			$filter_notify = $this->request->get['filter_notify'];
		} else {
			$filter_notify = null;
		}
		
		if (isset($this->request->get['filter_notify_order'])) {
			$filter_notify_order = $this->request->get['filter_notify_order'];
		} else {
			$filter_notify_order = null;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date_added';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		
		$url = '';

		if (isset($this->request->get['filter_customer'])) {
			$url .= '&filter_customer=' . $this->request->get['filter_customer'];
		}
		
		if (isset($this->request->get['filter_email'])) {
			$url .= '&filter_email=' . $this->request->get['filter_email'];
		}

		if (isset($this->request->get['filter_notify'])) {
			$url .= '&filter_notify=' . $this->request->get['filter_notify'];
		}

		if (isset($this->request->get['filter_notify_order'])) {
			$url .= '&filter_notify_order=' . $this->request->get['filter_notify_order'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}		
		
		$filter_data = array(
			'filter_customer'  => $filter_customer,
			'filter_email'  => $filter_email,
			'filter_notify'  => $filter_notify,
			'filter_notify_order'  => $filter_notify_order,
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);
		
		$total_storecart_extensions = $this->model_extension_customer_cart->getTotalStoreCartCustomers($filter_data);		
		$results = $this->model_extension_customer_cart->getStoreCartCustomers($filter_data);		
		
		$data['customer_lists'] = array();
		foreach($results as $result) {
			$filter_datas = array(
				'email'      	 			  => $result['email'],
				'filter_notify' 			=> $filter_notify,
				'filter_notify_order' => $filter_notify_order,
			);
			
			$carts_products = $this->model_extension_customer_cart->getStoreCartsByEmail($filter_datas);
			$products = array();
			foreach($carts_products as $carts_product) {
				$product_info  = $this->model_catalog_product->getProduct($carts_product['product_id']);
				/* 6 march */
				$this->load->model('tool/image');
				if (is_file(DIR_IMAGE . $product_info['image'])) {
				$image = $this->model_tool_image->resize($product_info['image'], 40, 40);
					} else {
						$image = $this->model_tool_image->resize('no_image.png', 40, 40);
					}
				/* 6 march */
				if($product_info){
					$products[] = array(
						'name'      			 => $product_info['name'],
						/* 6 march */
						'image'      => $image,
						/* 6 march */
						'model'      			 => $product_info['model'],
						'quantity'      	 => $carts_product['quantity'],
						'email_notify'     => ($carts_product['email_notify']) ? $this->language->get('text_yes') : $this->language->get('text_no'),
						'date_added'       => $carts_product['date_added'],
						'href'       			 => $this->url->link('catalog/product/edit', 'user_token='. $this->session->data['user_token'] . '&product_id='. $product_info['product_id'], true),
					);
				}
			}
			/* 8 march */
			$this->load->model('localisation/language');
			
			if(isset($result['language_id'])){
			$languageinfo = $this->model_localisation_language->getLanguage($result['language_id']);
			} else {
			$languageinfo ='';	
			}
			if(isset($languageinfo['image'])){
			$flagimage = 'language/'.$languageinfo['code'].'/'.$languageinfo['code'].'.png';
			} else {
			$flagimage='';	
			}
			if(!empty($languageinfo['name'])){
			$languagename = $languageinfo['name'];
			} else {
			$languagename ='';	
			}
			if(!isset($result['ip']))
			{
			$result['ip']='';
			}
			
			/* 8 march */
			
			$data['customer_lists'][] = array(
				'cart_id' 		=> $result['cart_id'],
				'customer_id' => $result['customer_id'],
				'firstname'   => $result['firstname'],
				'lastname'    => $result['lastname'],
				'telephone'   => $result['telephone'],
				'email'      	=> $result['email'],
				/* 6-march-2018 */
				'ip'      	  => $result['ip'],	
				'languageid'  => $languagename,				
				'flagimage'   =>  $flagimage,			
				/* 6-march-2018 */
				'type'      	=> ucfirst($result['type']),
				'products'    => $products,
				'customer_link' => $this->url->link('customer/customer/edit', 'user_token='. $this->session->data['user_token'] . '&customer_id='. $result['customer_id'], true),
				// new work start
				'delete' => $this->url->link('extension/customer_cart/delete', 'user_token='. $this->session->data['user_token'] . '&storecart_id='. $result['storecart_id'], true),
				// new work start
			); 
		}
		 
		
		$data['heading_title'] = $this->language->get('heading_title');
		$data['text_customer_detail'] = $this->language->get('text_customer_detail');
		$data['text_products'] = $this->language->get('text_products');
		$data['text_customer'] = $this->language->get('text_customer');
		$data['text_email'] = $this->language->get('text_email');
		$data['text_telephone'] = $this->language->get('text_telephone');
		$data['text_type'] = $this->language->get('text_type');
		$data['text_mail_template'] = $this->language->get('text_mail_template');
		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no'] = $this->language->get('text_no');
		$data['text_notify_order'] = $this->language->get('text_notify_order');
		/* 6-march-2018  */
		$data['text_ip'] = $this->language->get('text_ip');
		$data['help_ip'] = $this->language->get('help_ip');
		$data['text_remove'] = $this->language->get('text_remove');
		$data['column_image'] = $this->language->get('column_image');
		$data['column_chkip'] = $this->language->get('column_chkip');
		$data['column_language'] = $this->language->get('column_language');
		$data['help_chkbox'] = $this->language->get('help_chkbox');			
		/* 6-march-2018  */
		$data['column_product'] = $this->language->get('column_product');
		$data['column_model'] = $this->language->get('column_model');
		$data['column_quantity'] = $this->language->get('column_quantity');
		$data['column_date_added'] = $this->language->get('column_date_added');
		$data['column_notify'] = $this->language->get('column_notify');
		
		$data['entry_name'] = $this->language->get('entry_name');
		$data['entry_email'] = $this->language->get('entry_email');
		$data['entry_notify'] = $this->language->get('entry_notify');
		$data['entry_notify_order'] = $this->language->get('entry_notify_order');
		
		$data['button_send'] = $this->language->get('button_send');
		$data['button_filter'] = $this->language->get('button_filter');
		
		
		$data['user_token'] = $this->session->data['user_token'];
	  	 
		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}
		
		$url = '';
		
		if (isset($this->request->get['filter_customer'])) {
			$url .= '&filter_customer=' . $this->request->get['filter_customer'];
		}
		
		if (isset($this->request->get['filter_email'])) {
			$url .= '&filter_email=' . $this->request->get['filter_email'];
		}
		
		if (isset($this->request->get['filter_notify'])) {
			$url .= '&filter_notify=' . $this->request->get['filter_notify'];
		}
		
		if (isset($this->request->get['filter_notify_order'])) {
			$url .= '&filter_notify_order=' . $this->request->get['filter_notify_order'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/customer_cart', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);
		
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		        		
		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
	
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['filter_customer'])) {
			$url .= '&filter_customer=' . $this->request->get['filter_customer'];
		}
		
		if (isset($this->request->get['filter_email'])) {
			$url .= '&filter_email=' . $this->request->get['filter_email'];
		}

		if (isset($this->request->get['filter_notify'])) {
			$url .= '&filter_notify=' . $this->request->get['filter_notify'];
		}
		
		if (isset($this->request->get['filter_notify_order'])) {
			$url .= '&filter_notify_order=' . $this->request->get['filter_notify_order'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		$pagination = new Pagination();
		$pagination->total = $total_storecart_extensions;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('extension/customer_cart', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_storecart_extensions) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_storecart_extensions - $this->config->get('config_limit_admin'))) ? $total_storecart_extensions : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_storecart_extensions, ceil($total_storecart_extensions / $this->config->get('config_limit_admin')));
		
		$data['filter_customer'] = $filter_customer;
		$data['filter_email'] = $filter_email;
		$data['filter_notify'] = $filter_notify;
		$data['filter_notify_order'] = $filter_notify_order;
		$data['sort'] = $sort;
		$data['order'] = $order;
		
		$this->load->model('extension/mail_template');
		
		$data['storecart_templates'] = $this->model_extension_mail_template->getMailTemplates();
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['store_cart_menu'] = $this->load->controller('extension/store_cart_menu');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/customer_cart_list', $data));
  }
	
	public function SendMailToCustomerCarts() {
		$json = array();
		
		$this->load->language('extension/customer_cart');
		
		$this->load->model('extension/customer_cart');
		
		$this->load->model('extension/mail_template');
		
		$this->load->model('extension/store_cart_products');
		
		$this->load->model('tool/image');
		
		$data['text_product'] = $this->language->get('text_product');
		$data['text_model'] = $this->language->get('text_model');
		$data['text_quantity'] = $this->language->get('text_quantity');
		$data['text_image'] = $this->language->get('text_image');
		$data['text_price'] = $this->language->get('text_price');
		$data['text_total'] = $this->language->get('text_total');
						
		if (isset($this->request->get['filter_notify'])) {
			$filter_notify = $this->request->get['filter_notify'];
		} else {
			$filter_notify = null;
		}	
		
		if(empty($this->request->post['selected'])) {
			$json['error']['warning'] = $this->language->get('error_selected');
		}
		
		if(empty($this->request->post['storecart_template_id'])) {
			$json['error']['warning'] = $this->language->get('error_email_template_id');
		}
		
		if(!$json) {
			if(!empty($this->request->post['selected'])) {
				foreach($this->request->post['selected'] as $email) {
					$storecart_info = $this->model_extension_customer_cart->getOneStoreCartsByEmail($email);
					/* update 8 march */
					$mailinfo = $this->model_extension_mail_template->getMailTemplate($this->request->post['storecart_template_id'], $storecart_info['language_id']);
					/* update 8 march */
					/* Update 30  march */
					$this->load->model('localisation/language');
					$language_info = $this->model_localisation_language->getLanguage($storecart_info['language_id']);
					$language = new Language($language_info['code']);
					$language->load($language_info['code']);
					$language->load('extension/customer_cart');
					$data['text_image'] = $language->get('text_image');
					$data['text_product'] = $language->get('text_product');
					$data['text_quantity'] = $language->get('text_quantity');
					$data['text_price'] = $language->get('text_price');
					$data['text_model'] = $language->get('text_model');
					$data['text_total'] = $language->get('text_total');
					$this->session->data['currency']=$this->config->get('config_currency');
					/* Update 30  march */
					if($storecart_info && $mailinfo) {
						$find = array(
							'{store}',
							'{logo}',
							'{firstname}',
							'{lastname}',
							'{email}',
							'{telephone}',
							'{customer_id}',
							'{cart}',
							'{type}',
							'{date_added}',
							/* 7 march */
							'{grabnowlink}',
							/* 7 march */
						);

						$carts_products = $this->model_extension_store_cart_products->getStoreCcartProducts($storecart_info['email']);
								
						$data['products'] = array();
						foreach($carts_products as $product) {
							if ($product['image']) {
								$image = str_replace(' ','%20',$this->model_tool_image->resize($product['image'],150,150));
							} else {
								$image = '';
							}
							
							$option_data = array();

							foreach ($product['option'] as $option) {
								if ($option['type'] != 'file') {
									$value = $option['value'];
								} else {
									$upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

									if ($upload_info) {
										$value = $upload_info['name'];
									} else {
										$value = '';
									}
								}

								$option_data[] = array(
									'name'  => $option['name'],
									'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value),
									'type'  => $option['type']
								);
							}
							
							// Display prices
							$price = $this->currency->format($product['price'], $this->session->data['currency']);

							// Display prices
							$total = $this->currency->format($product['price'] * $product['quantity'], $this->session->data['currency']);

							$data['products'][] = array(
								'cart_id'   => $product['cart_id'],
								'thumb'     => $image,
								'name'      => $product['name'],
								'model'     => $product['model'],
								'option'    => $option_data,
								'recurring' => ($product['recurring'] ? $product['recurring']['name'] : ''),
								'quantity'  => $product['quantity'],
								'price'     => $price,
								'total'     => $total,
							);
						}
						
						$cart_html = $this->load->view('extension/customer_cart_products', $data);
						
						$replace = array(
							'store'     					=> $this->config->get('config_name'),
							'logo'      					=> "<img src='". HTTP_CATALOG . 'image/' . $this->config->get('config_logo')."'/>",
							'firstname' 					=> $storecart_info['firstname'],
							'lastname' 	 					=> $storecart_info['lastname'],
							'email'           	  => $storecart_info['email'],
							'telephone' 					=> $storecart_info['telephone'],
							'customer_id' 				=> $storecart_info['customer_id'],
							'cart'					 			=> $cart_html,
							'type' 								=> ucfirst($storecart_info['type']),
							'date_added' 					=> $storecart_info['date_added'],
							/* 7 march */
							'grabnowlink' 					=> HTTP_CATALOG.'index.php?route=extension/grabnow'. '&storecart_id='. base64_encode($storecart_info['storecart_id']),
							/* 7 march */
						);

						$subject = str_replace(array("\r\n", "\r", "\n"), '', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '', trim(str_replace($find, $replace, $mailinfo['subject']))));

						$message = str_replace(array("\r\n", "\r", "\n"), '', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '', trim(str_replace($find, $replace, $mailinfo['message']))));
						
						
						$this->model_extension_customer_cart->updateNotifyByEmail($storecart_info['email']);
						
						$mail = new Mail($this->config->get('config_mail_engine'));
						$mail->parameter = $this->config->get('config_mail_parameter');
						$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
						$mail->smtp_username = $this->config->get('config_mail_smtp_username');
						$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
						$mail->smtp_port = $this->config->get('config_mail_smtp_port');
						$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');
							
						$mail->setTo($storecart_info['email']);
						$mail->setFrom($this->config->get('config_email'));
						$mail->setSender(html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8'));
						$mail->setSubject($subject);
						$mail->setHtml(html_entity_decode($message));
						if(!empty($data['products']))
						{
						$mail->send();
						}
					}
				}
				
				$json['success'] = $this->language->get('text_mail_success');
			}
		}
		
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}