<?php
class ControllerExtensionReviewlist extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/reviewlist');
		$this->load->model('extension/reviewpro');
		$this->load->model('tool/upload');
		$this->load->model('tool/image');
		$this->load->model('catalog/product');
		$this->load->model('customer/customer');
		
		$this->model_extension_reviewpro->ExtTables();
		
		$this->document->setTitle($this->language->get('heading_title'));
		
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		
		$data['user_token'] = $this->session->data['user_token'];
		$data['entry_product'] = $this->language->get('entry_product');
		$data['entry_rating'] = $this->language->get('entry_rating');
		$data['entry_customername'] = $this->language->get('entry_customername');
		$data['entry_userrating'] = $this->language->get('entry_userrating');
		$data['entry_revewabuse'] = $this->language->get('entry_revewabuse');
		$data['entry_reason'] = $this->language->get('entry_reason');
		$data['entry_view_user'] = $this->language->get('entry_view_user');
		$data['entry_comment'] = $this->language->get('entry_comment');
		$data['text_registered'] = $this->language->get('text_registered');
		$data['text_guest'] = $this->language->get('text_guest');
		$data['text_action'] = $this->language->get('text_action');
		$data['text_adminreplies'] = $this->language->get('text_adminreplies');
		$data['text_replies'] = $this->language->get('text_replies');
		$data['text_reply'] = $this->language->get('text_reply');
		$data['text_submit'] = $this->language->get('text_submit');
		$data['text_attachment'] = $this->language->get('text_attachment');
		$data['entry_image'] = $this->language->get('entry_image');
		$data['entry_productname'] = $this->language->get('entry_productname');
		$data['entry_view'] = $this->language->get('entry_view');
		$data['text_date_added'] = $this->language->get('text_date_added');

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/wseo_pack', 'user_token=' . $this->session->data['user_token'], true)
		);
		
		$data['oldreviews'] = $this->url->link('extension/reviewlist/oldreviews', 'user_token=' . $this->session->data['user_token'], true);
		//$data['refreshreviews'] = $this->url->link('extension/reviewlist/refreshreviews', 'user_token=' . $this->session->data['user_token'], true);
		$data['updatereviews'] = $this->url->link('extension/reviewlist/updatereviews', 'user_token=' . $this->session->data['user_token'], true);
		$data['allratingList'] = $this->model_extension_reviewpro->ratingList();
		
		$url = '';
		
		if (isset($this->request->get['limit'])) {
			$url .= '&limit=' . $this->request->get['limit'];
		}
		if (isset($this->request->get['review_id'])) {
			$url .= '&review_id=' . $this->request->get['review_id'];
		}
		if (isset($this->request->get['product_id'])) {
			$url .= '&product_id=' . $this->request->get['product_id'];
		}
		
		if (isset($this->request->get['customer_id'])) {
			$url .= '&customer_id=' . $this->request->get['customer_id'];
		}
		
		if (isset($this->request->get['status'])) {
			$url .= '&status=' . $this->request->get['status'];
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if(isset($this->request->get['review_id'])){
			$review_id = $this->request->get['review_id'];
		}
		
		if(isset($this->request->get['product_id'])){
			$product_id = $this->request->get['product_id'];
			$data['product_id'] = $this->model_catalog_product->getProduct($this->request->get['product_id']);
		}
		
		if(isset($this->request->get['customer_id'])){
			$customer_id = $this->request->get['customer_id'];
			$data['customer_id'] = $this->model_customer_customer->getCustomer($this->request->get['customer_id']);
		}
		
		if(isset($this->request->get['status'])){
			$status = $this->request->get['status'];
			$data['status'] = $this->request->get['status'];
		}
		
		if(isset($this->request->get['userreview'])){
			$userreview = $this->request->get['userreview'];
			$data['userreview'] = $this->request->get['userreview'];
		}
		
		if (isset($this->request->get['filter_date_added'])) {
			$filter_date_added = $this->request->get['filter_date_added'];
		}else{
			$filter_date_added = null;
		}
		
		if (isset($this->request->get['limit'])) {
			$limit = $this->request->get['limit'];
		}else{
			$limit = 8;
		}
		
		$filter_data = array(
			'review_id'  => isset($review_id) ? $review_id : '',
			'product_id'  => isset($product_id) ? $product_id : '',
			'customer_id'  => isset($customer_id) ? $customer_id : '',
			'status'  => isset($status) ? $status : '',
			'filter_date_added'  => $filter_date_added,
			'userreview'  => isset($userreview) ? $userreview : '',
			'limit' => $limit,
			'start' => ($page - 1) * $limit,
		);
		
		
		$results = $this->model_extension_reviewpro->getReviews($filter_data);
		$totalreview = $this->model_extension_reviewpro->getTotalReview($filter_data);
		
		$data['reviews'] = array();
		
		//print_r($results);
		
		foreach ($results as $result) {
			$rating = array();
			$replies = array();
			$getreviewrating = $this->model_extension_reviewpro->getreviewrating($result['review_id']);
			$total_yesvote = $this->model_extension_reviewpro->getyesvote($result['review_id']);
			$total_novote = $this->model_extension_reviewpro->getnovote($result['review_id']);
			$getadminreply = $this->model_extension_reviewpro->getadminreply($result['review_id']);
			$getproduct = $this->model_catalog_product->getProduct($result['product_id']);
			$getreports = $this->model_extension_reviewpro->getreviewreport($result['review_id']);
			$getverifiespurchased = $this->model_extension_reviewpro->getverifiespurchased($result['product_id'], $result['customer_id']);
			$data['rating_desc'] = $this->model_extension_reviewpro->getratinglist();
			$attachments = $this->model_extension_reviewpro->getattachments($result['review_id']);
			$attachfiles = array();
			foreach($attachments as $attachment){
				$attachfiles[] = $this->model_tool_upload->getUploadByCode($attachment['file']);
			}
			
			if ($this->request->server['HTTPS']) {
				$server = $this->config->get('config_ssl');
				$frontlink = HTTPS_CATALOG;
			} else {
				$server = $this->config->get('config_url');
				$frontlink = HTTP_CATALOG;
			}
			
			$attachmentfiles = array();
			if(isset($attachfiles)){
				foreach($attachfiles as $attachfile){
					$filename = explode(".", $attachfile['name']);
					$filename = end($filename);
					$attachmentfiles[] = array(
						'code' => $attachfile['code']
					);
				}
			}
			
			if($getreviewrating){
				foreach($getreviewrating as $value){
					$rating[$value['rating_id']] = array(
						'rating'     => $value['rating'],
					);
				}
			}
			if($getadminreply){
				$i = 0;
				foreach($getadminreply as $value){
					$adminreply[$result['review_id']][] =array(
						'comment' => $value['comment'],
						'review_id' => $value['review_id'],
						'vote_id' => $value['vote_id'],
						'date' => date($this->language->get('date_format_short'), strtotime($value['date_added']))
					);
					$i++;
				}
				$data['totaladminreply'][$result['review_id']] = $i;
			}
			
			if($getproduct['image']){
				$pimage = $this->model_tool_image->resize($getproduct['image'], 50, 50);
			}
			
			$getreviewreports = array(
				'customer_link' => isset($getreports['customer_id']) ? $this->url->link('customer/customer/edit', 'user_token='. $this->session->data['user_token'] . '&customer_id='.(int)$getreports['customer_id']) : '',
				'comment' => isset($getreports['comment']) ? $getreports['comment'] : '',
				'name' => isset($getreports['name']) ? $getreports['name'] : '',
				'customer_id' => isset($getreports['customer_id']) ? $getreports['customer_id'] : '',
			);
			
			$data['reviews'][] = array(
				'author'     => $result['name'],
				'email'     => $result['email'],
				'customer_id'     => $result['customer_id'],
				'getproduct'      => $getproduct['name'],
				'productlink'      => $frontlink . 'index.php?route=product/product&product_id=' . (int)$getproduct['product_id'],
				'thumb'      	 => $pimage,
				'attachfile'     => isset($attachmentfiles) ? $attachmentfiles : '',
				'verifyreview'     => isset($getverifiespurchased) ? $getverifiespurchased : '',
				'status'  => $result['status'],
				'featured'  => $result['featured'],
				'review_id'  => $result['review_id'],
				'title'      => nl2br($result['title']),
				'text'       => nl2br($result['comment']),
				'rating'     => $rating,
				'replies'     => isset($adminreply) ? $adminreply : '',
				'yesvotes'     => $total_yesvote,
				'novotes'     => $total_novote,
				'getreports'     => $getreviewreports,
				'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added']))
			);
		}
		
		$pagination = new Pagination();
		$pagination->total = $totalreview;
		$pagination->page = $page;
		$pagination->limit = $limit;
		$pagination->url = $this->url->link('extension/reviewlist', 'user_token='. $this->session->data['user_token'] . $url . '&page={page}');

		$data['pagination'] = $pagination->render();
		$data['filter_date_added'] = $filter_date_added;
		
		$data['results'] = sprintf($this->language->get('text_pagination'), ($totalreview) ? (($page - 1) * $limit) + 1 : 0, ((($page - 1) * $limit) > ($totalreview - $limit)) ? $totalreview : ((($page - 1) * $limit) + $limit), $totalreview, ceil($totalreview / $limit));

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/reviewlist', $data));
	}
	
	public function downloadattachment() {
		$json = array();
		if($this->validate()){
			if (isset($this->request->get['file'])) {
				$file = $this->request->get['file'];
			} else {
				$file = 0;
			}
			$this->load->model('tool/upload');
			$download_info = $this->model_tool_upload->getUploadByCode($file);
			if ($download_info) {
				$file = DIR_IMAGE . 'reviewmanager/'.$download_info['filename'];
				if(is_file($file)){
					$json['download'] = $this->url->link('extension/reviewlist/downloadfile&fname='.$download_info['filename'].'&user_token=' . $this->session->data['user_token']);
				}
			}
		}else{
			$json['error'] = $this->language->get('error_permission');
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function removeattachment() {
		$this->load->model('tool/upload');
		$this->load->model('extension/reviewpro');
		$json = array();
		if($this->validate()){
			if (isset($this->request->get['file'])) {
				$code = $this->request->get['file'];
			} else {
				$code = 0;
			}
			$download_info = $this->model_tool_upload->getUploadByCode($code);
			if ($download_info) {
				$file = DIR_IMAGE . 'reviewmanager/'.$download_info['filename'];
				$this->model_extension_reviewpro->removeattachment($code);
				if(is_file($file)){
					unlink($file);
				}
			}
		}else{
			$json['error'] = $this->language->get('error_permission');
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function replydelete() {
		$this->load->model('extension/reviewpro');
		$json = array();
		if($this->validate()){
			if (isset($this->request->get['review_id'])) {
				$review_id = $this->request->get['review_id'];
			} else {
				$review_id = 0;
			}
			
			if (isset($this->request->get['vote_id'])) {
				$vote_id = $this->request->get['vote_id'];
			} else {
				$vote_id = 0;
			}
			$this->model_extension_reviewpro->replydelete($review_id,$vote_id);
		}else{
			$json['error'] = $this->language->get('error_permission');
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function removereview() {
		$this->load->model('extension/reviewpro');
		$json = array();
		if($this->validate()){
			if (isset($this->request->get['review_id'])) {
				$review_id = $this->request->get['review_id'];
			} else {
				$review_id = 0;
			}
			$this->model_extension_reviewpro->removereview($review_id);
		}else{
			$json['error'] = $this->language->get('error_permission');
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function getreviews() {
		$this->load->model('extension/reviewpro');
		$this->load->model('catalog/product');
		$this->load->language('extension/reviewlist');
		$this->load->language('tool/upload');
		$this->load->model('tool/upload');
		$this->load->model('tool/image');
		
		$data['user_token'] = $this->session->data['user_token'];
		
		if (isset($this->request->get['review_id'])) {
			$review_id = $this->request->get['review_id'];
		} else {
			$review_id = 0;
		}
		
		$data['allreviews'] = $this->model_extension_reviewpro->getreview($review_id);
		
		$attachments = $this->model_extension_reviewpro->getattachments($review_id);
		$attachfiles = array();
		foreach($attachments as $attachment){
			$attachfiles[] = $this->model_tool_upload->getUploadByCode($attachment['file']);
		}
		
		$data['rating_desc'] = array();
		
		$ratingdesc = $this->model_extension_reviewpro->getratinglist();
		
		foreach($ratingdesc as $ratings){
			$rating = $this->model_extension_reviewpro->getreviewratings($review_id,$ratings['rating_id']);
			$data['rating_desc'][] = array(
				'rating_name' => $ratings['rating_name'],
				'rating' => $rating,
				'rating_id' => $ratings['rating_id'],
			);
		}
		
		$data['getproduct'] = $this->model_catalog_product->getProduct($data['allreviews']['product_id']);
			
		$thumb = '';
		$imagelink = '';
		$data['attachmentfiles'] = array();
		if(isset($attachfiles)){
			foreach($attachfiles as $attachfile){
				$filename = explode(".", $attachfile['name']);
				$filename = end($filename);
				if($filename == 'jpg' || $filename == 'png' || $filename == 'gif' || $filename == 'jpeg'){
					if(is_file(DIR_IMAGE.'reviewmanager/'.$attachfile['filename'])){
						$imagelink = 'reviewmanager/'.$attachfile['filename'];
						$thumb = $this->model_tool_image->resize($imagelink, 100, 100);
					}
				}else{
					$thumb = '';
				}
				$code = $attachfile['code'];
				$data['attachmentfiles'][] = array(
					'thumb' => $thumb,
					'file' => $code
				);
			}
		}
		
		$this->response->setOutput($this->load->view('extension/reviewproform', $data));
	}
	
	public function addnewreview() {
		$this->load->model('extension/reviewpro');
		$this->load->language('extension/reviewlist');
		$this->load->language('tool/upload');
		$this->load->model('tool/upload');
		$this->load->model('tool/image');
		
		$data['user_token'] = $this->session->data['user_token'];
		
		$data['rating_desc'] = $this->model_extension_reviewpro->getratinglist();
	
		$this->response->setOutput($this->load->view('extension/reviewproform', $data));
		
	}
	
	public function editreview() {
		$this->load->model('extension/reviewpro');
		$json = array();
		if($this->validate()){
			if (isset($this->request->get['review_id'])) {
				$review_id = $this->request->get['review_id'];
			} else {
				$review_id = 0;
			}
			$this->model_extension_reviewpro->editreview($review_id,$this->request->post);
			$json['success'] = true;
		}else{
			$json['error'] = $this->language->get('error_permission');
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function newreview() {
		$this->load->model('extension/reviewpro');
		$this->load->language('extension/reviewlist');
		$json = array();
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->reviewvalidate()) {
			$this->model_extension_reviewpro->addnewreview($this->request->post);
			$json['success'] = true;
		}else{
			$json['error'] = $this->language->get('error_permissionn');
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function reviewstatus() {
		$this->load->model('extension/reviewpro');
		$json = array();
		if($this->validate()){
			if (isset($this->request->get['review_id'])) {
				$data['review_id'] = $this->request->get['review_id'];
			} else {
				$data['review_id'] = 0;
			}
			if (isset($this->request->get['status'])) {
				$data['status'] = $this->request->get['status'];
			} else {
				$data['status'] = 0;
			}
			$this->model_extension_reviewpro->reviewstatus($data);
		}else{
			$json['error'] = $this->language->get('error_permission');
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function reviewfeatured() {
		$this->load->model('extension/reviewpro');
		$json = array();
		if($this->validate()){
			if (isset($this->request->get['review_id'])) {
				$data['review_id'] = $this->request->get['review_id'];
			} else {
				$data['review_id'] = 0;
			}
			if (isset($this->request->get['featured'])) {
				$data['featured'] = $this->request->get['featured'];
			} else {
				$data['featured'] = 0;
			}
			$this->model_extension_reviewpro->reviewfeatured($data);
		}else{
			$json['error'] = $this->language->get('error_permission');
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function replyreview() {
		$this->load->model('extension/reviewpro');
		$json = array();
		if($this->validate()){
			$this->model_extension_reviewpro->addreply($this->request->post);
		}else{
			$json['error'] = $this->language->get('error_permission');
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function downloadfile() {
		if($this->request->get['fname']){
			$file = DIR_IMAGE . 'reviewmanager/'.$this->request->get['fname'];
			if(is_file($file)){
				header('Content-Type: application/octet-stream'); 
				header('Content-Disposition: attachment;filename='.basename($file)); 
				header('Cache-Control: max-age=0'); 
				header('Expires: 0');
				header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
				header('Pragma: public');
				header('Content-Length: ' . filesize($file));
				readfile($file, 'rb');
			}
			exit();
		}
	}
	
	public function oldreviews(){
		if($this->validate()){
			$this->load->model('extension/reviewpro');
			$results = $this->model_extension_reviewpro->getOldReviews();
			if($results){
				foreach($results as $result){
					$checkprev = $this->model_extension_reviewpro->checkoldreview($result);
					if(!$checkprev){
						$returnarray = $this->model_extension_reviewpro->addreview($result);
						if($returnarray){
							$ratingList = $this->model_extension_reviewpro->ratingList();
							foreach($ratingList as $ratingbar){
								$this->model_extension_reviewpro->addoldrating($returnarray, $ratingbar['rating_id']);
							}
						}
					}
					/* if($checkprev){
						$this->model_extension_reviewpro->deleteratingvalues($checkprev);
						$ratingList = $this->model_extension_reviewpro->ratingList();
						foreach($ratingList as $ratingbar){
							$this->model_extension_reviewpro->updateoldrating($checkprev, $ratingbar['rating_id'], $result['rating']);
						}
					}else{
						$returnarray = $this->model_extension_reviewpro->addreview($result);
						if($returnarray){
							$ratingList = $this->model_extension_reviewpro->ratingList();
							foreach($ratingList as $ratingbar){
								$this->model_extension_reviewpro->addoldrating($returnarray, $ratingbar['rating_id']);
							}
						}
					} */
				}
			}
		}
		$this->response->redirect($this->url->link('extension/reviewlist', 'user_token=' . $this->session->data['user_token'], true));
	}
	
	public function updatereviews(){
		if($this->validate()){
			$this->load->model('extension/reviewpro');
			$allreviews = $this->model_extension_reviewpro->getallReviews();
				if($allreviews){
					foreach($allreviews as $allreview){
						$ratingList = $this->model_extension_reviewpro->ratingList();
						$countreview = 0;
						$reviewadd = 0;
						$newreviewbar = array();
						foreach($ratingList as $ratingbar){
							$ratingreview = $this->model_extension_reviewpro->getreviewratings($allreview['review_id'], $ratingbar['rating_id']);
							if($ratingreview){
								$reviewadd = $reviewadd + $ratingreview['rating'];
								$countreview++;
							}else{
								$newreviewbar[] = $ratingbar['rating_id'];
							}
						}
						if($countreview){
							$avgrating = $reviewadd/$countreview;
							foreach($newreviewbar as $insertreview){
								$data = array(
									'review_id' => $allreview['review_id'],
									'rating' 	=> round($avgrating,1),
								);
								$this->model_extension_reviewpro->addoldrating($data, $insertreview);
							}
						}
					}
				}
			}
		$this->response->redirect($this->url->link('extension/reviewlist', 'user_token=' . $this->session->data['user_token'], true));
	}
	
	/* public function refreshreviews(){
		$allreviews = $this->model_extension_reviewpro->getallReviews();
		foreach($allreviews as $allreview){
			$ratingList = $this->model_extension_reviewpro->ratingList();
			foreach($ratingList as $ratingbar){
				$ratingreview = $this->model_extension_reviewpro->getratingreview($allreview['review_id'],$ratingbar['rating_id']);
				if($ratingreview){
					$this->model_extension_reviewpro->updateoldrating($ratingreview, $ratingreview['rating_id'],$allreview['rating']);
				}
			}
		}
		
	} */

	public function reviewfileupload() {
		$data['user_token'] = $this->session->data['user_token'];
		$this->load->language('extension/reviewlist');
		$this->load->model('tool/upload');

		$json = array();
		
		if (!empty($this->request->files['file']['name']) && is_file($this->request->files['file']['tmp_name'])) {
			// Sanitize the filename
			$filename = basename(preg_replace('/[^a-zA-Z0-9\.\-\s+]/', '', html_entity_decode($this->request->files['file']['name'], ENT_QUOTES, 'UTF-8')));

			// Validate the filename length
			if ((utf8_strlen($filename) < 3) || (utf8_strlen($filename) > 64)) {
				$json['error'] = $this->language->get('error_filename');
			}

			// Allowed file extension types
			$allowed = array();

			$extension_allowed = preg_replace('~\r?\n~', "\n", $this->config->get('reviewpro_fields')['imageformat']);

			$filetypes = explode("\n", $extension_allowed);
		
			foreach ($filetypes as $filetype) {
				$allowed[] = trim($filetype);
			}

			if (!in_array(strtolower(substr(strrchr($filename, '.'), 1)), $allowed)) {
				$json['error'] = $this->language->get('error_filetype');
			}

			// Allowed file mime types
			$allowed = array();

			$mime_allowed = preg_replace('~\r?\n~', "\n", $this->config->get('config_file_mime_allowed'));

			$filetypes = explode("\n", $mime_allowed);

			foreach ($filetypes as $filetype) {
				$allowed[] = trim($filetype);
			}

			if (!in_array($this->request->files['file']['type'], $allowed)) {
				$json['error'] = $this->language->get('error_filetype');
			}

			// Check to see if any PHP files are trying to be uploaded
			$content = file_get_contents($this->request->files['file']['tmp_name']);

			if (preg_match('/\<\?php/i', $content)) {
				$json['error'] = $this->language->get('error_filetype');
			}

			// Return any upload error
			if ($this->request->files['file']['error'] != UPLOAD_ERR_OK) {
				$json['error'] = $this->language->get('error_upload_' . $this->request->files['file']['error']);
			}
		} else {
			$json['error'] = $this->language->get('error_upload');
		}

		if (!$json) {
			$file = token(32) . '.' . $filename;
			$imagemanager = DIR_IMAGE.'reviewmanager/';
			if (!is_dir($imagemanager)) {
				mkdir($imagemanager, 0777);
			}
			move_uploaded_file($this->request->files['file']['tmp_name'], $imagemanager . $file);

			// Hide the uploaded file name so people can not link to it directly.
			$this->load->model('tool/upload');
			$this->load->language('tool/upload');

			$json['code'] = $this->model_tool_upload->addUpload($filename, $file);
			
			if(strtolower(substr(strrchr($filename, '.'), 1)) == 'zip'){
				$json['image'] = $filename;
				$json['href'] = HTTP_CATALOG . 'image/reviewmanager/'.$file;
			}else{
				$json['image'] = HTTP_CATALOG . 'image/reviewmanager/'.$file;
				$json['href'] = '';
			}
			$json['type'] = strtolower(substr(strrchr($filename, '.'), 1));

			$json['success'] = $this->language->get('text_upload');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	protected function reviewvalidate() {
		$this->language->load('extension/reviewlist');
		if (!$this->user->hasPermission('modify', 'extension/reviewlist')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if ((utf8_strlen($this->request->post['name']) < 1) || (utf8_strlen($this->request->post['name']) > 64)) {
			$this->error['name'] = $this->language->get('error_name');
		}
		
		if ((utf8_strlen($this->request->post['title']) < 1) || (utf8_strlen($this->request->post['title']) > 64)) {
			$this->error['title'] = $this->language->get('error_title');
		} 
		
		if (empty($this->request->post['email']) && !filter_var($this->request->post['email'], FILTER_VALIDATE_EMAIL)) {
			$this->error['email'] = $this->language->get('error_email');
		}
		
		if ((utf8_strlen($this->request->post['comment']) < 1) || (utf8_strlen($this->request->post['comment']) > 250)) {
			$this->error['comment'] = $this->language->get('error_comment');
		}
		
		if (empty($this->request->post['product_id'])) {
			$this->error['product'] = $this->language->get('error_product');
		}
		
		if (empty($this->request->post['date_added'])) {
			$this->error['date_added'] = $this->language->get('error_date_added');
		}
		
		if (empty($this->request->post['rating'])) {
			$this->error['rating'] = $this->language->get('error_rating');
		} 
		
		return !$this->error;
	}
	
	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/reviewlist')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		return !$this->error;
	}
	
}