<?php
class ControllerExtensionReviewpro extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/reviewpro');
		$this->load->model('setting/store');
		$this->load->model('localisation/language');
		$this->load->model('extension/reviewpro');
		$this->load->model('catalog/product');
		$this->load->model('catalog/category');
		$this->load->model('tool/image');
		$this->load->model('customer/customer_group');
		
		$this->model_extension_reviewpro->ExtTables();
		
		$this->document->setTitle($this->language->get('heading_title'));
		$data['stores'] = $this->model_setting_store->getStores();
		$data['languages'] = $this->model_localisation_language->getLanguages();
		$data['ratinglists'] = $this->model_extension_reviewpro->ratingList();
		$data['reportreasons'] = $this->model_extension_reviewpro->abuselist();
		$data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();
		
		$data['text_general'] = $this->language->get('text_general');
		$data['text_reviewpage'] = $this->language->get('text_reviewpage');
		$data['text_emailnotification'] = $this->language->get('text_emailnotification');
		$data['text_customcss'] = $this->language->get('text_customcss');
		$data['text_language'] = $this->language->get('text_language');
		$data['text_reviewsetting'] = $this->language->get('text_reviewsetting');
		$data['text_reviewform'] = $this->language->get('text_reviewform');
		$data['text_reviewattachments'] = $this->language->get('text_reviewattachments');
		$data['text_rating'] = $this->language->get('text_rating');
		$data['text_vote'] = $this->language->get('text_vote');
		$data['text_abuse'] = $this->language->get('text_abuse');
		$data['text_page'] = $this->language->get('text_page');
		$data['text_coupon'] = $this->language->get('text_coupon');
		$data['text_reward_point'] = $this->language->get('text_reward_point');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_approve_reviews'] = $this->language->get('entry_approve_reviews');
		$data['text_guest'] = $this->language->get('text_guest');
		$data['text_loggin'] = $this->language->get('text_loggin');
		$data['text_both'] = $this->language->get('text_both');
		$data['text_settings_updates'] = $this->language->get('text_settings_updates');
		$data['error_permission'] = $this->language->get('error_permission');
		$data['entry_guest_review'] = $this->language->get('entry_guest_review');
		$data['entry_review_share'] = $this->language->get('entry_review_share');
		$data['entry_approve_ifabove'] = $this->language->get('entry_approve_ifabove');
		$data['entry_name'] = $this->language->get('entry_name');
		$data['text_yes_required'] = $this->language->get('text_yes_required');
		$data['entry_email'] = $this->language->get('entry_email');
		$data['entry_title'] = $this->language->get('entry_title');
		$data['entry_comment'] = $this->language->get('entry_comment');
		$data['entry_capcha'] = $this->language->get('entry_capcha');
		$data['entry_noofreview'] = $this->language->get('entry_noofreview');
		$data['entry_reviewby'] = $this->language->get('entry_reviewby');
		$data['entry_replyby'] = $this->language->get('entry_replyby');
		$data['entry_attachmentfile'] = $this->language->get('entry_attachmentfile');
		$data['entry_imageformat'] = $this->language->get('entry_imageformat');
		$data['entry_votereview'] = $this->language->get('entry_votereview');
		$data['entry_guestreview'] = $this->language->get('entry_guestreview');
		$data['entry_helpfultext'] = $this->language->get('entry_helpfultext');
		$data['entry_nothelpfultext'] = $this->language->get('entry_nothelpfultext');
		$data['entry_showreviewrating'] = $this->language->get('entry_showreviewrating');
		$data['entry_differentratingbar'] = $this->language->get('entry_differentratingbar');
		$data['text_ratingbar'] = $this->language->get('text_ratingbar');
		$data['text_sort_order'] = $this->language->get('text_sort_order');
		$data['text_delete'] = $this->language->get('text_delete');
		$data['entry_addratingbar'] = $this->language->get('entry_addratingbar');
		$data['text_save'] = $this->language->get('text_save');
		$data['text_rating_added'] = $this->language->get('text_rating_added');
		$data['entry_showreviewabuse'] = $this->language->get('entry_showreviewabuse');
		$data['entry_showreviewguestabuse'] = $this->language->get('entry_showreviewguestabuse');
		$data['entry_coupon'] = $this->language->get('entry_coupon');
		$data['entry_couponamount'] = $this->language->get('entry_couponamount');
		$data['entry_coupondiscount'] = $this->language->get('entry_coupondiscount');
		$data['entry_couponvalidity'] = $this->language->get('entry_couponvalidity');
		$data['entry_couponuses'] = $this->language->get('entry_couponuses');
		$data['entry_couponusescustomer'] = $this->language->get('entry_couponusescustomer');
		$data['text_fixedamount'] = $this->language->get('text_fixedamount');
		$data['text_percentage'] = $this->language->get('text_percentage');
		$data['entry_customer_group'] = $this->language->get('entry_customer_group');
		$data['entry_reward'] = $this->language->get('entry_reward');
		$data['help_points'] = $this->language->get('help_points');
		$data['entry_points'] = $this->language->get('entry_points');
		$data['entry_title'] = $this->language->get('entry_title');
		$data['entry_description'] = $this->language->get('entry_description');
		$data['entry_meta_title'] = $this->language->get('entry_meta_title');
		$data['entry_meta_description'] = $this->language->get('entry_meta_description');
		$data['entry_meta_keyword'] = $this->language->get('entry_meta_keyword');
		$data['entry_tag'] = $this->language->get('entry_tag');
		$data['text_settings'] = $this->language->get('text_settings');
		$data['entry_reviewperrow'] = $this->language->get('entry_reviewperrow');
		$data['entry_reviewlimit'] = $this->language->get('entry_reviewlimit');
		$data['entry_productlimit'] = $this->language->get('entry_productlimit');
		$data['entry_productimagewh'] = $this->language->get('entry_productimagewh');
		$data['entry_productimagew'] = $this->language->get('entry_productimagew');
		$data['entry_productimageh'] = $this->language->get('entry_productimageh');
		$data['entry_attachimagewh'] = $this->language->get('entry_attachimagewh');
		$data['entry_showrandomproduct'] = $this->language->get('entry_showrandomproduct');
		$data['text_notification'] = $this->language->get('text_notification');
		$data['text_popup'] = $this->language->get('text_popup');
		$data['entry_popup'] = $this->language->get('entry_popup');
		$data['text_crownjob'] = $this->language->get('text_crownjob');
		$data['entry_messsage'] = $this->language->get('entry_messsage');
		$data['entry_subject'] = $this->language->get('entry_subject');
		$data['entry_customcss'] = $this->language->get('entry_customcss');
		$data['entry_showreviewpoints'] = $this->language->get('entry_showreviewpoints');
		$data['entry_backgroundimage'] = $this->language->get('entry_backgroundimage');
		$data['entry_logo'] = $this->language->get('entry_logo');
		$data['text_reasons'] = $this->language->get('text_reasons');
		$data['entry_addrasons'] = $this->language->get('entry_addrasons');
		$data['text_reason_added'] = $this->language->get('text_reason_added');
		$data['text_reason'] = $this->language->get('text_reason');
		$data['entry_rating'] = $this->language->get('entry_rating');
		$data['entry_popupsize'] = $this->language->get('entry_popupsize');
		$data['entry_attachemnt_visible'] = $this->language->get('entry_attachemnt_visible');
		$data['entry_select_reason'] = $this->language->get('entry_select_reason');
		$data['entry_type'] = $this->language->get('entry_type');
		$data['entry_discount'] = $this->language->get('entry_discount');
		$data['entry_seourl'] = $this->language->get('entry_seourl');
		$data['entry_couponmail'] = $this->language->get('entry_couponmail');
		$data['entry_average_rating'] = $this->language->get('entry_average_rating');
		$data['entry_verify_purchased'] = $this->language->get('entry_verify_purchased');
		$data['entry_votelanguage'] = $this->language->get('entry_votelanguage');
		$data['entry_reportlanguage'] = $this->language->get('entry_reportlanguage');
		$data['entry_reviewform'] = $this->language->get('entry_reviewform');
		$data['entry_askreview'] = $this->language->get('entry_askreview');
		$data['entry_reviewbtn'] = $this->language->get('entry_reviewbtn');
		$data['text_edit_reason'] = $this->language->get('text_edit_reason');
		$data['entry_already_vote'] = $this->language->get('entry_already_vote');
		$data['entry_login_vote'] = $this->language->get('entry_login_vote');
		$data['entry_review'] = $this->language->get('entry_review');
		$data['entry_reportreview'] = $this->language->get('entry_reportreview');
		$data['entry_alreadyreport'] = $this->language->get('entry_alreadyreport');
		$data['entry_thankyou_report'] = $this->language->get('entry_thankyou_report');
		$data['entry_loginreport'] = $this->language->get('entry_loginreport');
		$data['entry_formtitle'] = $this->language->get('entry_formtitle');
		$data['entry_field_reason'] = $this->language->get('entry_field_reason');
		$data['entry_commentfied'] = $this->language->get('entry_commentfied');
		$data['entry_reportbtn'] = $this->language->get('entry_reportbtn');
		$data['entry_reviewtitle'] = $this->language->get('entry_reviewtitle');
		$data['entry_field_Customer'] = $this->language->get('entry_field_Customer');
		$data['entry_fieldname_error'] = $this->language->get('entry_fieldname_error');
		$data['entry_emailfield'] = $this->language->get('entry_emailfield');
		$data['entry_emailfield_error'] = $this->language->get('entry_emailfield_error');
		$data['entry_formreview_title'] = $this->language->get('entry_formreview_title');
		$data['entry_reviewtitle_error'] = $this->language->get('entry_reviewtitle_error');
		$data['entry_fieldcomment'] = $this->language->get('entry_fieldcomment');
		$data['entry_fieldcomment_error'] = $this->language->get('entry_fieldcomment_error');
		$data['entry_submitbtn'] = $this->language->get('entry_submitbtn');
		$data['entry_attachemtnttext'] = $this->language->get('entry_attachemtnttext');
		$data['entry_captcha'] = $this->language->get('entry_captcha');
		$data['entry_captcha_error'] = $this->language->get('entry_captcha_error');
		$data['entry_fieldrating_error'] = $this->language->get('entry_fieldrating_error');
		$data['entry_order_status'] = $this->language->get('entry_order_status');
		$data['entry_displayform'] = $this->language->get('entry_displayform');
		$data['entry_successmsg'] = $this->language->get('entry_successmsg');
		$data['entry_login_review'] = $this->language->get('entry_login_review');
		
		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		
		if (isset($this->request->post['reviewpro_fields'])) {
			$data['reviewpro_fields'] = $this->request->post['reviewpro_fields'];
		} else {
			$data['reviewpro_fields'] = $this->config->get('reviewpro_fields');
		}
		
		if (isset($this->request->post['reviewpro_fields_seourl'])) {
			$data['reviewpro_fields_seourl'] = $this->request->post['reviewpro_fields_seourl'];
		} else {
			$data['reviewpro_fields_seourl'] = $this->model_extension_reviewpro->geturl('extension/reviewpro');;
		}
		
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		
		$data['user_token'] = $this->session->data['user_token'];

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/wseo_pack', 'user_token=' . $this->session->data['user_token'], true)
		);
		
		if ($this->request->server['HTTPS']) {
			$server = HTTPS_CATALOG;
		} else {
			$server = HTTP_CATALOG;
		}
		
		$data['crownjob_link'] = $server.'index.php?route=extension/reviewpro/emailinvitation';
		
		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		$data['products'] = array();
		if(isset($data['reviewpro_fields']['couponproducts'])) {
			foreach($data['reviewpro_fields']['couponproducts'] as $product_id){
				$products = $this->model_catalog_product->getProduct($product_id);
				$data['products'][] =array(
					'product_id' => $products['product_id'],
					'name' => $products['name']
				);
			}
		}
		
		$data['related_products'] = array();
		if(isset($data['reviewpro_fields']['relatedproducts'])) {
			foreach($data['reviewpro_fields']['relatedproducts'] as $product_id){
				$related_products = $this->model_catalog_product->getProduct($product_id);
				$data['related_products'][] =array(
					'product_id' => $related_products['product_id'],
					'name' => $related_products['name']
				);
			}
		}
		
		$data['categories'] = array();
		
		if(isset($data['reviewpro_fields']['couponcategorys'])) {
			foreach($data['reviewpro_fields']['couponcategorys'] as $category_id){
				$categorys = $this->model_catalog_category->getCategory($category_id);
				$data['categories'][] =array(
					'category_id' => $categorys['category_id'],
					'name' => $categorys['name']
				);
			}
		}

		if (isset($data['reviewpro_fields']['popuplogo']) && is_file(DIR_IMAGE . $data['reviewpro_fields']['popuplogo'])) {
			$data['logo'] = $this->model_tool_image->resize($data['reviewpro_fields']['popuplogo'], 100, 100);
		} else {
			$data['logo'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}
		
		if (isset($data['reviewpro_fields']['popupbg']) && is_file(DIR_IMAGE . $data['reviewpro_fields']['popupbg'])) {
			$data['popupbg'] = $this->model_tool_image->resize($data['reviewpro_fields']['popupbg'], 100, 100);
		} else {
			$data['popupbg'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}
		
		$data['redirect'] =  $this->url->link('extension/reviewpro','user_token=' . $this->session->data['user_token']);

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/reviewpro', $data));
	}
	
	
	// Save Extension configration
	public function savesettings() {
		$json=array();
		$this->load->language('extension/reviewpro');
		$this->load->model('setting/setting');
		$this->load->model('extension/reviewpro');
		if(isset($this->request->get['store_id'])){
			$store_id = $this->request->get['store_id'];
		}else{
			$store_id = 0;
		}
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('reviewpro_fields', $this->request->post, $store_id);
			
			$this->model_extension_reviewpro->seturl($this->request->post['reviewpro_fields_seourl'],$store_id);
			
			$json['success'] = $this->language->get('text_success');
		}else{
			$json['warning'] = $this->language->get('error_permission');
		}
		print_r(json_encode($json));
	}
	
	// Add rating
	public function addratingbar() {
		$json=array();
		$this->load->language('extension/reviewpro');
		$this->load->model('extension/reviewpro');
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_extension_reviewpro->addrating($this->request->post);
			$json['success'] = $this->language->get('text_success');
		}else{
			$json['warning'] = $this->language->get('error_permission');
		}
		print_r(json_encode($json));
	}
	
	// Update rating
	public function updaterating() {
		$json=array();
		$this->load->language('extension/reviewpro');
		$this->load->model('extension/reviewpro');
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_extension_reviewpro->updaterating($this->request->post);
			$json['success'] = $this->language->get('text_success');
		}else{
			$json['warning'] = $this->language->get('error_permission');
		}
		print_r(json_encode($json));
	}
	
	// Get rating
	public function getrating() {
		$json=array();
		$this->load->language('extension/reviewpro');
		$this->load->model('extension/reviewpro');
		if ($this->validate()) {
			$ratinglist = $this->model_extension_reviewpro->getratingbyId($this->request->get['rating_id']);
			if($ratinglist){
				foreach($ratinglist as $rating){
					$json['success'][$rating['language_id']] = array(
						'rating_name' => $rating['rating_name'],
					);
				}
			}
		}else{
			$json['warning'] = $this->language->get('error_permission');
		}
		print_r(json_encode($json));
	}
	
	// Add Report Reason
	public function addreasons() {
		$json=array();
		$this->load->language('extension/reviewpro');
		$this->load->model('extension/reviewpro');
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_extension_reviewpro->addreport($this->request->post);
			$json['success'] = $this->language->get('text_success');
		}else{
			$json['warning'] = $this->language->get('error_permission');
		}
		print_r(json_encode($json));
	}
	
	// Edit Report Reason
	public function updatereasons() {
		$json=array();
		$this->load->language('extension/reviewpro');
		$this->load->model('extension/reviewpro');
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_extension_reviewpro->updatereasons($this->request->post);
			$json['success'] = $this->language->get('text_success');
		}else{
			$json['warning'] = $this->language->get('error_permission');
		}
		print_r(json_encode($json));
	}
	
	// Delete rating
	public function deleterating() {
		$json=array();
		$this->load->language('extension/reviewpro');
		$this->load->model('extension/reviewpro');
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_extension_reviewpro->deleterating($this->request->get);
			$json['success'] = $this->language->get('text_success');
		}else{
			$json['warning'] = $this->language->get('error_permission');
		}
		print_r(json_encode($json));
	}
	
	// Delete Reason
	public function deletereason() {
		$json=array();
		$this->load->language('extension/reviewpro');
		$this->load->model('extension/reviewpro');
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_extension_reviewpro->deletereason($this->request->get);
			$json['success'] = $this->language->get('text_success');
		}else{
			$json['warning'] = $this->language->get('error_permission');
		}
		print_r(json_encode($json));
	}
	
	// Get Report Reason
	public function getreaons() {
		$json=array();
		$this->load->language('extension/reviewpro');
		$this->load->model('extension/reviewpro');
		if ($this->validate()) {
			$reasonlist = $this->model_extension_reviewpro->getreaonsbyID($this->request->get['reason_id']);
			//print_r($reasonlist); die();
			if($reasonlist){
				foreach($reasonlist as $reason){
					$json['success'][$reason['language_id']] = array(
						'name' => $reason['name'],
					);
				}
			}
		}else{
			$json['warning'] = $this->language->get('error_permission');
		}
		print_r(json_encode($json));
	}
	
	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/reviewpro')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		return !$this->error;
	}
}