<?php
class ControllerExtensionReviewprocj extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/reviewpro');
		$this->load->model('setting/store');
		$this->load->model('localisation/language');
		$this->load->model('localisation/order_status');
		$this->load->model('extension/reviewpro');
		$this->load->model('catalog/product');
		$this->load->model('catalog/category');
		$this->load->model('tool/image');
		$this->load->model('setting/setting');
		
		$this->model_extension_reviewpro->ExtTables();
		
		$this->document->setTitle($this->language->get('heading_title'));
		$data['languages'] = $this->model_localisation_language->getLanguages();
		$data['order_statuss'] = $this->model_localisation_order_status->getOrderStatuses();
		
		$data['text_general'] = $this->language->get('text_general');
		$data['text_reviewpage'] = $this->language->get('text_reviewpage');
		$data['entry_message'] = $this->language->get('entry_message');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('reviewprocj', $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/reviewprocj', 'user_token=' . $this->session->data['user_token'], true));
		}
	
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}
		
		$data['user_token'] = $this->session->data['user_token'];

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_reviewprocj'),
			'href' => $this->url->link('extension/reviewprocj', 'user_token=' . $this->session->data['user_token'], true)
		);
		
		if ($this->request->server['HTTPS']) {
			$server = HTTPS_CATALOG;
		} else {
			$server = HTTP_CATALOG;
		}
		
		if(isset($this->request->post['reviewprocj_crownjob'])){
			$data['reviewprocj_crownjob'] = $this->request->post['reviewprocj_crownjob'];
		}elseif($this->config->get('reviewprocj_crownjob')){
			$data['reviewprocj_crownjob'] = $this->config->get('reviewprocj_crownjob');
		}else{
			$data['reviewprocj_crownjob'] = array();
		}
		
		if(isset($this->request->post['reviewprocj_orderstatus'])){
			$data['reviewprocj_orderstatus'] = $this->request->post['reviewprocj_orderstatus'];
		}elseif($this->config->get('reviewprocj_orderstatus')){
			$data['reviewprocj_orderstatus'] = $this->config->get('reviewprocj_orderstatus');
		}else{
			$data['reviewprocj_orderstatus'] = array();
		}
		
		$data['crownjob_link'] = $server.'index.php?route=extension/reviewpro/emailinvitation';
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/reviewprocj', $data));
	}
	
	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/reviewprocj')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		return !$this->error;
	}
}