<?php
class ControllerExtensionStatistics extends Controller {
	private $error = array();

	public function index() {
		$this->language->load('extension/statistics');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->getForm();
	}

	protected function getForm() {
	
		$this->load->model('extension/store_cart');		
		$this->load->model('extension/customer_cart');
		$this->load->language('extension/store_cart');
		
		$data['heading_title'] = $this->language->get('heading_title');
		
		$data['text_form'] = !isset($this->request->get['statistics_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
		$data['text_default'] = $this->language->get('text_default');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_product'] = $this->language->get('text_product');
		$data['text_email_notify'] = $this->language->get('text_email_notify');
		$data['text_unuse_coupon'] = $this->language->get('text_unuse_coupon');
		$data['text_coupon'] = $this->language->get('text_coupon');
		$data['text_order'] = $this->language->get('text_order');
		$data['text_customer'] = $this->language->get('text_customer');
		$data['text_notify_customer_order'] = $this->language->get('text_notify_customer_order');
		$data['text_crownjob'] = $this->language->get('text_crownjob');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_view'] = $this->language->get('text_view');
		
		
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/statistics', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);
	
		$data['user_token'] = $this->session->data['user_token'];
		
		$data['product_link'] = $this->url->link('extension/customer_cart', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['customer_cart_link'] = $this->url->link('extension/customer_cart', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['customer_cart_notify_link'] = $this->url->link('extension/customer_cart', 'user_token=' . $this->session->data['user_token'] . '&filter_notify=1', true);
		$data['customer_cart_notify_completed_link'] = $this->url->link('extension/customer_cart', 'user_token=' . $this->session->data['user_token'] . '&filter_notify_order=1', true);
		$data['coupon_link'] = $this->url->link('extension/coupons', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['unuse_coupon_link'] = $this->url->link('extension/customer_cart', 'user_token=' . $this->session->data['user_token'] . $url, true);
		
		// Total All Products
		$data['total_storecart_products'] = $this->model_extension_store_cart->getTotalStorecartProducts();
		
		
		// Total Carts Group BY email
		$data['total_abandoned_carts'] = $this->model_extension_customer_cart->getTotalStoreCartCustomers();
		
		// Total Notify Carts Group BY email
		$filter_data = array(
			'filter_notify'  => 1,
		);
		$data['total_email_notify'] = $this->model_extension_customer_cart->getTotalStoreCartCustomers($filter_data);
		
		
		// Total Notify Orders Customers Group BY email
		$filter_data = array(
			'filter_notify_order'  => 1,
		);
		$data['total_notify_orders_customers'] = $this->model_extension_customer_cart->getTotalStoreCartCustomers($filter_data);		
		
		// Total Coupons
		$filter_data = array(
			'filter_notify_order'  => 1,
		);
		$data['total_used_coupons'] = $this->model_extension_store_cart->getTotalUseCoupons();
		
		
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['store_cart_menu'] = $this->load->controller('extension/store_cart_menu');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/statistics_form', $data));
	}
}