<?php

use Opencartvip\Opencart\Controller;
use Opencartvip\Utils\Arr;

class ControllerOpencartvipBlogSetting extends Controller {

	public function __construct($registry) {
		parent::__construct($registry);
		$this->load->model('opencartvip/setting');
		$this->load->language('error/permission');
	}

	public function get() {
		try {
			$id = $this->input(self::GET, 'id');

			$this->renderJson(self::SUCCESS, $this->model_opencartvip_setting->get($id, array(
				'blog',
			)));

			$this->opencartvip->cache->delete();
		} catch (Exception $e) {
			$this->renderJson(self::ERROR, $e->getMessage());
		}
	}

	public function edit() {
		try {
			if (!$this->user->hasPermission('modify', 'opencartvip/blog_setting')) {
				throw new Exception($this->language->get('text_permission'));
			}

			$id = $this->input(self::GET, 'id');
			$data = $this->input(self::POST, 'data');

			$this->renderJson(self::SUCCESS, $this->model_opencartvip_setting->edit($id, array(
				'blog' => Arr::get($data, 'blog', array()),
			)));

			$this->opencartvip->cache->delete();
		} catch (Exception $e) {
			$this->renderJson(self::ERROR, $e->getMessage());
		}
	}

}
