<?php
$_['heading_title']              = 'Promotions';

$_['text_promotions']            = 'Promotions';
$_['text_manage']                = 'Manage';
$_['text_settings']              = 'Settings';
$_['text_module']                = 'Module';
$_['text_page']                  = 'Page';
$_['text_support']               = 'Support';
$_['text_add_promo']             = 'Add Promotions';
$_['text_edit_promo']            = 'Edit Promotions';
$_['text_design_options']        = 'Design Options';

$_['text_information']           = 'Information';
$_['text_modules']               = 'Modules';
$_['text_enabled']               = 'Enabled';
$_['text_disabled']              = 'Disabled';
$_['button_cancel']              = 'Cancel';
$_['text_default']               = 'Default';
$_['text_close']                 = 'Close';
$_['text_save']                  = 'Save';
$_['text_no']                    = 'No';
$_['text_yes']                   = 'Yes';
$_['text_priority']              = 'Priority';
$_['text_random']                = 'Random';

$_['entry_title']                = 'Title';
$_['entry_global_status']        = 'Global Status';
$_['entry_status']               = 'Status';
$_['entry_limit']                = 'Limit';
$_['entry_sort_order']           = 'Sort Order';
$_['entry_banner_image']         = 'Banner Image';
$_['entry_banner_link']          = 'Banner Image Link';
$_['entry_navbar']               = 'Main Navigation';
$_['entry_custom_css']           = 'Custom CSS';
$_['entry_seo_options']          = 'SEO Options';
$_['entry_meta_title']           = 'Meta Title';
$_['entry_meta_desc']            = 'Meta Description';
$_['entry_meta_keywords']        = 'Meta Keywords';
$_['entry_url_alias']            = 'URL Alias';

$_['entry_stores']               = 'Stores';
$_['entry_test_mode']            = 'Test Mode';
$_['entry_promo_rule']           = 'Promo Rule';
$_['entry_promo_options']        = 'Promo Options';
$_['entry_customer_group']       = 'Customer Group';
$_['entry_customer_profile']     = 'Customer Profile';
$_['entry_date_duration']        = 'Date Duration';
$_['entry_priority_order']       = 'Priority Order';
$_['entry_design_status']        = 'Design Status';
$_['entry_module_banner']        = 'Module Banner';
$_['entry_page_header_banner']   = 'Page Header Banner';
$_['entry_page_message']         = 'Page Message';

$_['text_discount_shipping']     = 'Shipping discount';
$_['text_discount_product']      = 'Product discount';
$_['text_discount_manufacturer'] = 'Manufacturer discount';
$_['text_discount_category']     = 'Category discount';
$_['text_discount_order']        = 'Order discount';
$_['text_discount_customer']     = 'Customer discount';

// All helper
$_['entry_navbar_help']          = 'Display in the top main navigation bar.';
$_['entry_page_banner_help']     = 'Banner image placed at top of the page. For best result, width size at least 1920px';
$_['entry_page_message_help']    = '<p>Available shortcode:</p>
<ul class="isl-list">
  <li>{condition_items}</li>
  <li>{discount_items}</li>
</ul>';

$_['text_info_list']             = array(
  '<code>Priority</code> is the order in which each promotion will be executed. We recommend you to prioritize Shipping, Product, Brand and Category promotion group over the other promotion rules.',
  'When <code>Stop</code> is enabled then once the promotion is executed and <b>evaluates to true</b>, all other promotions with higher priority will not be applied.',
  'When promotion <b>evaluates to false</b>, the next promotion will be executed even if Stop is enabled.',
  'Promotion evaluation returns <code>true</code> when a product in the shopping cart is <b>Eligible</b> for or <b>Valid to apply</b> the promotion discount.',
  'If the promotion is <code>not stoppped</code> when the evaluation returns true, the next promotion evaluation will use the same products in the shopping cart as an evaluation basis.'
);
$_['text_info_module_intro']     = '';
$_['text_info_module']           = array(
  'It is required to place the module through <code>Design > Layout</code> into site block position.',
  'At product, category and manufacture page the module will recognise <code>product_id</code>, <code>path</code> and <code>manufacturer_id</code> and show promo banner related to the page. ',
  'The <b>Limit</b> field will be applied to layouts other than product, category and manufactured. The three specific layouts will always have a limit of 3 banners.',
  '<b>Pro Tips</b>:',
  'Promotions module have specific css class <code>.islpr-module</code> which you can use to have custom design.',
  'Specific class added to module at product page <code>.islpr-product</code>, category page <code>.islpr-category</code> and manufacturer <code>.islpr-category</code>.',
  'To customize your design further, you can use the Banner, Carousel, Slideshow & HTML Content modules to create your promotion banner images.'
);
$_['text_info_page_intro']       = '';
$_['text_info_page']             = array(
  '<b>Title</b>: This will be the page name displayed in your main navigation and page headline.',
  '<b>Main Navigation</b>: Select whether the Promotions page will be linked in your navigation. If not, you will need to find alternative ways to link to your page. For example, social media or email marketing campaigns.',
  '<b>SEO Options</b>: Use the meta data fields to optimize your new page for search engines.',
  '<b>Pro Tips</b>:',
  'Promotions page have specific css class <code>.islpr-page</code> which you can use to have custom design.',
  'Promo page listing have css class <code>.islpr-promo-all</code>, while specific promo page have <code>.islpr-promo-xx</code> where <i>xx</i> is your promo_id.',
);
$_['text_info_setting']          = array(
  '<b>Global Status</b>: Enable or disable your Promotions extension.',
  '<b>Test Mode</b>: We recommend you run a test for your promotions before activating them for your customers. If Test Mode is enabled, only logged in admins will see and interact with the promotions on the storefront. Only you will be able to see the banners and changes in the cart total when a promotion is added to the cart.'
);

// Tab Support
$_['text_your_license']          = 'Your license';
$_['text_please_enter_the_code'] = 'Please enter your product purchase license code';
$_['text_activate_license']      = 'Activate License';
$_['text_not_having_a_license']  = "Don't have a code? Get it from here.";
$_['text_license_holder']        = 'License Holder';
$_['text_registered_domains']    = 'Registered domains';
$_['text_expires_on']            = 'License Expires on';
$_['text_valid_license']         = 'VALID LICENSE';
$_['text_get_support']           = 'Get Support';
$_['text_community']             = 'Community';
$_['text_ask_our_community']     = 'Ask the community about your issue on the iSenseLabs forum.';
$_['text_tickets']               = 'Tickets';
$_['text_open_a_ticket']         = 'Want to communicate one-to-one with our tech people? Then open a support ticket.';
$_['text_pre_sale']              = 'Pre-sale';
$_['text_pre_sale_desc']         = 'Have a brilliant idea for your webstore? Our team of top-notch developers can make it real.';
$_['text_browse_forums']         = 'Browse forums';
$_['text_open_ticket_for_real']  = 'Open a ticket';
$_['text_bump_the_sales']        = 'Bump the sales';


// Promotions Form
// ====================================
$_['text_notifications']               = 'Notifications';
$_['text_ntf_congrats']                = 'Congratulations Message';
$_['text_ntf_upsell']                  = 'Upsell Message';
$_['text_ntf_eligible']                = 'Eligible Message';

$_['text_used_promotion']              = 'This promotion can only be used {x} time(s).';
$_['text_promotion_percustomer']       = 'Per customer can only use promotion  {x} time(s).';
$_['text_apply_special_price']         = 'Apply to product with special price.';
$_['text_apply_coupon']                = 'Evaluate promotions with coupon code {x}';
$_['text_stop_promotion']              = 'Stop promotion after this rule.';
$_['text_all_customer']                = 'All customers.';
$_['text_selected_customer']           = 'Only customers within the following customer groups.';
$_['text_selected_customer_profile']   = 'Only apply to selected logged-in customers below.';

$_['text_used_promotion_help']         = 'When the maximum promotion usage is reached, it will become invalid.';
$_['text_apply_special_price_help']    = 'The module excludes products with a special price by default when checking whether the products in the cart satisfy the conditions. Check this option so that the module can take into account such products.';
$_['text_apply_coupon_price_help']     = 'Enter a coupon code which would trigger the promotion evaluation.';
$_['text_stop_promotion_help']         = 'If this option is ticked then once this promotion is executed and evaluates to true, none of the next promotions order is executed.<br><br>Info: Execution order based on priority order.';

$_['text_select_promo_rule']           = 'Select promotions rule to show notification editor.';
$_['text_promo_rule_alert']            = 'Promo rule is changed! Content of <a href="%s">notification</a> editor automatically changed to reflect selected promo rule.
<br>Previously saved promo rule and notification is not lost until current configuration is saved.';

$_['text_promo_buyxgetfreeshipping']   = 'Order at least X units of product Y, get free shipping to specific shipping zones.';
$_['text_promo_freeshippingwhenoverx'] = 'Order at least fixed amount, get free shipping to specific shipping zones.';

$_['text_promo_buyxgetx']              = 'Buy one get one free.';
$_['text_promo_buyxgety']              = 'Buy one get something else free.';
$_['text_promo_buyxgetamountoffy']     = 'Buy (X units) of Product A, get (Y units) of Product B for amount or percentage off per unit.';
$_['text_promo_amountoffy']            = 'Apply an amount or percentage off to Product X.';

$_['text_promo_xoffitemsinybrands']    = 'Apply an amount or percentage discount to each item in one or more brands.';
$_['text_promo_buyxgetysamebrands']    = 'Buy X units, get Y additional units in the same brand free.';

$_['text_promo_percentoffitemsincat']  = 'Apply an amount or percentage discount for each item in one or more categories.';
$_['text_promo_buyxgetysamecategory']  = 'Buy X units of Category A, get Y additional units in the same category for free.';
$_['text_promo_buyxfromygetoffonz']    = 'Buy X units of category A, get amount or percentage off per unit of category B.';
$_['text_promo_xoffitemsinycategoriestiered'] = 'Apply a tiered discount to applicable products based on the quantity of items ordered within one or more categories.';

$_['text_promo_xamountoffwhenxormore'] = 'Apply an amount or percentage discount to the order total, on orders of fixed amount or more.';
$_['text_promo_ordersofatleastxgety']  = 'Order at least fixed amount, get one unit of Product Y for amount or percentage off.';
$_['text_promo_ordersofatleastxgetyoffproduct'] = 'Order at least fixed amount, get percentage off Z unit(s) of the (least or most) expensive item(s) in the cart.';

$_['text_promo_xoffforrepeatcustomers'] = 'Fixed amount discount for regular customers.';
$_['text_promo_xpercentoffforrepeatcustomers'] = 'Percentage discount for regular customers';


$_['text_info_promo_rule'] = array(
  'Discounts of a free item selected from a product with an equal or lesser price. '
);
$_['text_info_promo_rule_shipping'] = 'Shipping Discount
  <ul class="isl-list">
    <li>The discount is applied after a customer <b>select shipping method</b>. This will reduce the cost of the shipping.</li>
    <li><code>Order at least X units of product Y</code> applies a discount based on the required quantity regardless of the product variations.</li>
    <li><code>Order at least fixed amount</code> checks if the cart total is larger than the required amount that is set in the promotion rule.</li>
  </ul>';
$_['text_info_promo_rule_product'] = 'Product Discount
  <ul class="isl-list">
    <li><code>Buy one get one free</code> discount can be applied to the same product/s that is/are set in the promotion rule.</li>
    <li>Quantity based discounts apply a discount based on the required quantity in cart regardless of the product variations.</li>
  </ul>';
$_['text_info_promo_rule_manufacturer'] = 'Manufacturer Discount
  <ul class="isl-list">
    <li>Apply discounts to all products in selected manufacturers.</li>
  </ul>';
$_['text_info_promo_rule_category'] = 'Category Discount
  <ul class="isl-list">
    <li>Apply discounts to all products in selected categories.</li>
    <li>Quantity based discounts apply a discount based on the required quantity in cart regardless of the product variations.</li>
  </ul>';
$_['text_info_promo_rule_order'] = 'Order Discount
  <ul class="isl-list">
    <li><code>Order total</code> uses in its evaluation all applied discount/s, but does not take into account the tax.</li>
  </ul>';
$_['text_info_promo_rule_customer'] = 'Customer Discount
  <ul class="isl-list">
    <li>Only order(s) with status <code>Complete</code> are checked against the promotion requirements.</li>
    <li><code>Order total</code> uses in its evaluation all applied discount/s, but does not take into account the tax.</li>
  </ul>';

$_['text_info_promo_setting'] = array();

$_['text_info_promo_design_options'] = array(
  'This section is related to the appearance of the promotion banner on the front-page.',
  'Disabling the <b>Design Status</b> will hide the promotion banner from the front-page, but the promotion rule is still applicable for the products in the cart.',
  '<b>Page Message</b> shortcode
  <ul class="isl-list">
    <li><code>{condition_items}</code> available for Product promotion rule.</li>
    <li><code>{discount_items}</code> available for Product, Manufacturer and Category promotion rule.</li>
    <li>Shortcode will show the products in a carousel.</li>
  </ul>'
);

$_['text_info_promo_notifications'] = array(
  'Each promotion rule has its own type of notification message and shortcode/s.',
  'Notification message/s will appear when the condition/s for the promotions is/are satisfied.',
  'Use the button below to reset all notification messages to the default one.<br>
  <a class="btn btn-primary btn-sm btn-reset-notification isl-mt-5">Default Message</a>',
);

// Notification
$_['text_loading']               = 'Loading..';
$_['text_processing']            = 'Processing..';
$_['text_success']               = 'Success: You have modified module Promotions!';
$_['text_success_save']          = 'Successfully saved!';

$_['error_general']              = 'Error occured, please try again later!';
$_['error_permission']           = 'Warning: You do not have permission to modify module Promotions!';
$_['error_form']                 = 'Error found, please check all required form!';
$_['error_title']                = 'Promotion title must be between 3-225 characters.';
$_['error_select_promo']         = 'Please select promotion rule.';
$_['error_banner_module']        = 'Enabled design require module banner image.';
