<?php
class ModelExtensionCustomercart extends Model {
	public function getStoreCartCustomers($data = array()) {
		if (!empty($data['filter_notify_order'])) {
			$sql = "SELECT * FROM " . DB_PREFIX . "storecart_order WHERE `email` !=''";
		}else{
			$sql = "SELECT * FROM " . DB_PREFIX . "storecart WHERE `email` !=''";
		}
		
		if (!empty($data['filter_customer'])) {
			$sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['filter_customer']) . "%'";
		}
		
		if (!empty($data['filter_email'])) {
			$sql .= " AND email LIKE '%" . $this->db->escape($data['filter_email']) . "%'";
		}
		
		if (isset($data['filter_notify']) && !is_null($data['filter_notify'])) {
			$sql .= " AND email_notify LIKE '%" . $this->db->escape($data['filter_notify']) . "%'";
		}
		
		$sort_data = array(
			'date_added',
		);

		$sql .= " GROUP BY `email`";
		
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY date_added";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		// echo $sql; die();
		
		$query = $this->db->query($sql);

		// print_r($query->rows); die();
		
		
		return $query->rows;
  }
	
	public function getTotalStoreCartCustomers($data = array()){ 	
		if (!empty($data['filter_notify_order'])) {
			$sql = "SELECT * FROM " . DB_PREFIX . "storecart_order WHERE `email` !='' ";
		}else{
			$sql = "SELECT * FROM " . DB_PREFIX . "storecart WHERE `email` !='' ";
		}
		
		if (!empty($data['filter_customer'])) {
			$sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['filter_customer']) . "%'";
		}
		
		if (!empty($data['filter_email'])) {
			$sql .= " AND email LIKE '%" . $this->db->escape($data['filter_email']) . "%'";
		}
		
		if (isset($data['filter_notify']) && !is_null($data['filter_notify'])) {
			$sql .= " AND email_notify LIKE '%" . $this->db->escape($data['filter_notify']) . "%'";
		}
		
		$sql .= " GROUP BY `email`";
		
		$query = $this->db->query($sql);

		return $query->num_rows;
  }
	
	public function getStoreCartsByEmail($data = array()) { 	
		if (!empty($data['filter_notify_order'])) {
			$sql = "SELECT `email_notify`, `product_id`, `option`, `date_added`, `quantity`  FROM " . DB_PREFIX . "storecart_order WHERE LCASE(email) = '". $this->db->escape(utf8_strtolower($data['email'])) ."'";
		}else{
			$sql = "SELECT `email_notify`, `product_id`, `option`, `date_added`, `quantity`  FROM " . DB_PREFIX . "storecart WHERE LCASE(email) = '". $this->db->escape(utf8_strtolower($data['email'])) ."'";
		}
		
		if (isset($data['filter_notify']) && !is_null($data['filter_notify'])) {
			$sql .= " AND email_notify LIKE '%" . $this->db->escape($data['filter_notify']) . "%'";
		}
		
		 $sql .= "ORDER BY date_added DESC";
		
		$query = $this->db->query($sql);

		return $query->rows;
  }
	
	public function getOneStoreCartsByEmail($email){ 	
		$sql = "SELECT * FROM " . DB_PREFIX . "storecart WHERE LCASE(email) = '". $this->db->escape(utf8_strtolower($email)) ."' ORDER BY date_added DESC LIMIT 0,1";
		
		$query = $this->db->query($sql);

		return $query->row;
  }
	
	public function updateNotifyByEmail($email) {
		$this->db->query("UPDATE " . DB_PREFIX . "storecart SET email_notify = 1 WHERE LCASE(email) = '". $this->db->escape(utf8_strtolower($email)) ."'");
	}
    /// New work  start ///
	public function deletestorecart($storecart_id){ 	
		$this->db->query("delete FROM " . DB_PREFIX . "storecart WHERE storecart_id='".$storecart_id."'");
		
  }
  /// New work  end ///
}	
