<?php
class ModelExtensionMailTemplate extends Model {
	public function addMailTemplate($data) {
		

		$this->db->query("INSERT INTO " . DB_PREFIX . "storecart_template SET status = '" . (int)$data['status'] . "', store_id = '" . (int)$data['store_id'] . "', `default` = '" . (int)$data['default'] . "', date_added = NOW()");

		$storecart_template_id = $this->db->getLastId();

		foreach ($data['template_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "storecart_template_description SET storecart_template_id = '" . (int)$storecart_template_id . "', language_id = '" . (int)$language_id . "', title = '" . $this->db->escape($value['title']) . "', subject = '" . $this->db->escape($value['subject']) . "', message = '" . $this->db->escape($value['message']) . "'");
		}

		

		return $storecart_template_id;
	}
	
	public function editMailTemplate($storecart_template_id, $data) {
		

		$this->db->query("UPDATE " . DB_PREFIX . "storecart_template SET status = '" . (int)$data['status'] . "', store_id = '" . (int)$data['store_id'] . "', `default` = '" . (int)$data['default'] . "', date_added = NOW() WHERE storecart_template_id = '". (int)$storecart_template_id ."'");

		$this->db->query("DELETE FROM " . DB_PREFIX . "storecart_template_description WHERE storecart_template_id = '" . (int)$storecart_template_id . "'");
		
		foreach ($data['template_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "storecart_template_description SET storecart_template_id = '" . (int)$storecart_template_id . "', language_id = '" . (int)$language_id . "', title = '" . $this->db->escape($value['title']) . "', subject = '" . $this->db->escape($value['subject']) . "', message = '" . $this->db->escape($value['message']) . "'");
		}

		
		return $storecart_template_id;
	}
	
	public function deleteMailTemplate($storecart_template_id) {
		
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "storecart_template WHERE storecart_template_id = '" . (int)$storecart_template_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "storecart_template_description WHERE storecart_template_id = '" . (int)$storecart_template_id . "'");
		
			}
		
	public function getMailTemplates($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "storecart_template st LEFT JOIN " . DB_PREFIX . "storecart_template_description std ON (st.storecart_template_id = std.storecart_template_id) WHERE std.language_id = '" . (int)$this->config->get('config_language_id') . "'";

			$sort_data = array(
				'std.title',
				'i.status'
			);

			if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
				$sql .= " ORDER BY " . $data['sort'];
			} else {
				$sql .= " ORDER BY std.title";
			}

			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}

			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}

				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}

			$query = $this->db->query($sql);

			return $query->rows;
	}
	
	public function getStoreTemplate($storecart_template_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "storecart_template WHERE storecart_template_id = '" . (int)$storecart_template_id . "'");

		return $query->row;
	}
	
	/* update march */
	public function getMailTemplate($storecart_template_id, $language_id) {
		if($language_id==0){
			$language_id = $this->config->get('config_language_id');
		} 
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "storecart_template st LEFT JOIN " . DB_PREFIX . "storecart_template_description std ON (st.storecart_template_id=std.storecart_template_id) WHERE st.storecart_template_id = '" . (int)$storecart_template_id . "' AND std.language_id='". (int)$language_id ."'");

		return $query->row;
	}
	/* update march */
	
	public function getStoreTemplateDescriptions($storecart_template_id) {
		$storecart_template_description_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "storecart_template_description WHERE storecart_template_id = '" . (int)$storecart_template_id . "'");

		foreach ($query->rows as $result) {
			$storecart_template_description_data[$result['language_id']] = array(
				'title'            => $result['title'],
				'subject'      => $result['subject'],
				'message'      => $result['message'],
			);
		}

		return $storecart_template_description_data;
	}
	
	public function getTotalMailTemplates($data = array()) {
		$sql = "SELECT COUNT(*) as total FROM " . DB_PREFIX . "storecart_template";

		$query = $this->db->query($sql);

		return $query->row['total'];
	}
}