<?php
/*
  Price Tax Calculator
  Premium Extension
  
  Copyright (c) 2013 - 2019 Adikon.eu
  http://www.adikon.eu/
  
  You may not copy or reuse code within this file without written permission.
*/
class ModelExtensionModulePriceTaxCalculator extends Model {
	private $compatibility = null;

	/*
	  Set compatibility for all versions of Opencart
	*/
	public function __construct($registry) {
		parent::__construct($registry);

		include_once DIR_SYSTEM . 'library/vendors/price_tax_calculator/compatibility.php';

		$this->compatibility = new OVCompatibility_13($registry);
		$this->compatibility->setApp('admin');
	}

	/*
	  Return compatibility instance
	*/
	public function compatibility() {
		return $this->compatibility;
	}

	/*
	  Installation & Update
	  Table structure for the module
	*/
	public function install() {

	}

	public function uninstall() {

	}
}