<?php
class ModelExtensionReviewpro extends Model {
	
	public function ExtTables(){
		$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."reviewpro` (`review_id` int(11) NOT NULL AUTO_INCREMENT, `customer_id` int(255) DEFAULT NULL, `product_id` int(11) NOT NULL DEFAULT '0',`name` varchar(255) NOT NULL, `title` varchar(255) DEFAULT NULL, `comment` text DEFAULT NULL, `email` varchar(255) NOT NULL, `file` varchar(1024) NOT NULL, `status` tinyint(1) NOT NULL, `date_added` datetime NOT NULL,`date_modify` datetime NOT NULL, PRIMARY KEY (`review_id`)) CHARACTER SET utf8 COLLATE utf8_general_ci");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."reviewpro_invitation` (`invitation_id` int(11) NOT NULL AUTO_INCREMENT, `customer_id` int(255) DEFAULT NULL, `order_id` int(11) NOT NULL DEFAULT '0', `status` tinyint(1) NOT NULL, `date_added` datetime NOT NULL, PRIMARY KEY (`invitation_id`))");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."reviewpro_attachments` (`reviewpro_attachments_id` int(11) NOT NULL AUTO_INCREMENT, `review_id` int(11) NOT NULL, `file` varchar(1024) NOT NULL, PRIMARY KEY (`reviewpro_attachments_id`))");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."reviewpro_rating` (`reviewpro_rating_id` int(11) NOT NULL AUTO_INCREMENT, `reviewpro_id` int(255) DEFAULT NULL, `rating_id` int(11) NOT NULL DEFAULT '0', `rating` int(11) NOT NULL, PRIMARY KEY (`reviewpro_rating_id`))");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."review_abuse` (`abuse_id` int(11) NOT NULL AUTO_INCREMENT, `reason` int(11) DEFAULT NULL, `comment` varchar(255) NOT NULL, `customer_id` int(11) NOT NULL, `review_id` int(11) NOT NULL, PRIMARY KEY (`abuse_id`))");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."review_reply` (`vote_id` int(11) NOT NULL AUTO_INCREMENT, `review_id` int(11) DEFAULT NULL, `customer_id` int(11) DEFAULT NULL, `yes` int(11) DEFAULT NULL, `no` int(11) DEFAULT NULL, `comment` varchar(255) NOT NULL, `user_id` int(11) NOT NULL, `date_added` datetime NOT NULL, PRIMARY KEY (`vote_id`))");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."review_vote` (`reviewreply_id` int(11) NOT NULL AUTO_INCREMENT, `comment` varchar(255) NOT NULL, `user_id` int(11) NOT NULL, `review_id` int(11) NOT NULL, `yes` int(11) DEFAULT NULL,`no` int(11) DEFAULT NULL, `customer_id` int(11) NOT NULL, `date_added` datetime NOT NULL, PRIMARY KEY (`reviewreply_id`))");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."wrating` (`rating_id` int(11) NOT NULL AUTO_INCREMENT, `sort_order` int(11) DEFAULT NULL, `date_added` datetime NOT NULL,`date_modified` datetime NOT NULL, PRIMARY KEY (`rating_id`))");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."wrating_description` (`rating_descroption_id` int(11) NOT NULL AUTO_INCREMENT, `rating_id` int(11) NOT NULL, `language_id` int(11) NOT NULL, `rating_name` varchar(255) NOT NULL, PRIMARY KEY (`rating_descroption_id`))");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."reportreasons` (`reason_id` int(11) NOT NULL AUTO_INCREMENT, `date_added` datetime NOT NULL,`date_modify` datetime NOT NULL, PRIMARY KEY (`reason_id`))");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."reportreasons_description` (`abuse_id` int(11) NOT NULL AUTO_INCREMENT, `reason_id` int(11) NOT NULL, `name` varchar(255) DEFAULT NULL, `language_id` int(11) NOT NULL, PRIMARY KEY (`abuse_id`))");
		
		//for exists user
		$query = $this->db->query("SHOW COLUMNS FROM `" . DB_PREFIX . "reviewpro` LIKE 'featured'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `" . DB_PREFIX . "reviewpro` ADD `featured` tinyint(4) NOT NULL AFTER `date_modify`");
		}
	}
	
	public function seturl($reviewproseo,$store_id){
		$this->db->query("DELETE FROM " . DB_PREFIX . "seo_url WHERE query = 'extension/reviewpro'");
		if(isset($reviewproseo)){
			foreach($reviewproseo as $language_id => $keyword){
				$this->db->query("INSERT INTO " . DB_PREFIX . "seo_url SET query = 'extension/reviewpro', keyword = '" . $this->db->escape($keyword) . "',language_id = '" . (int)$language_id . "',store_id = '" . (int)$store_id . "'");
			}
		}
	}
	
	public function geturl($path){
	  $query = $this->db->query("SELECT keyword FROM ".DB_PREFIX."seo_url WHERE query = '".$this->db->escape($path)."'")->row;
	  if(!empty($query['keyword'])){
		  return $query['keyword'];
	  }else{
		  return '';
	  }
	}

	public function addrating($data){
		$this->db->query("INSERT INTO " . DB_PREFIX . "wrating SET date_modified = NOW(), date_added = NOW()");
		$rating_id = $this->db->getLastId();
		foreach ($data['ratingadd'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "wrating_description SET rating_id = '" . (int)$rating_id . "', language_id = '" . (int)$language_id . "', rating_name = '" . $this->db->escape($value) . "'");
		}
	}
	
	public function updaterating($data){
		$this->db->query("UPDATE " . DB_PREFIX . "wrating SET date_modified = NOW() WHERE rating_id = '" . (int)$data['rating_id'] . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "wrating_description WHERE rating_id = '" . (int)$data['rating_id'] . "'");
		foreach ($data['ratingedit'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "wrating_description SET rating_id = '" . (int)$data['rating_id'] . "', language_id = '" . (int)$language_id . "', rating_name = '" . $this->db->escape($value) . "'");
		}
	}
	
	public function deleterating($data){
		$this->db->query("DELETE FROM " . DB_PREFIX . "wrating WHERE rating_id = '" . (int)$data['rating_id'] . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "wrating_description WHERE rating_id = '" . (int)$data['rating_id'] . "'");
	}
	
	public function ratingList(){
		$sql = "SELECT * FROM ".DB_PREFIX."wrating r LEFT JOIN ".DB_PREFIX."wrating_description rd ON r.rating_id = rd.rating_id WHERE rd.language_id = '" . (int)$this->config->get('config_language_id') . "'";
		$query = $this->db->query($sql);
		return $query->rows;
	}
	
	public function getratingbyId($rating_id){
		$sql = "SELECT * FROM ".DB_PREFIX."wrating r LEFT JOIN ".DB_PREFIX."wrating_description rd ON r.rating_id = rd.rating_id WHERE r.rating_id = '". $rating_id ."'";
		$query = $this->db->query($sql);
		return $query->rows;
	}
	
	public function abuselist(){
		$sql = "SELECT * FROM ".DB_PREFIX."reportreasons rr LEFT JOIN ".DB_PREFIX."reportreasons_description rrd ON rr.reason_id = rrd.reason_id WHERE rrd.language_id = '" . (int)$this->config->get('config_language_id') . "'";
		$query = $this->db->query($sql);
		return $query->rows;
	}
	
	public function updatereasons($data){
		$this->db->query("UPDATE " . DB_PREFIX . "reportreasons SET date_modify = NOW() WHERE reason_id = '" . (int)$data['reason_id'] . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "reportreasons_description WHERE reason_id = '" . (int)$data['reason_id'] . "'");
		foreach ($data['reasonsedit'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "reportreasons_description SET reason_id = '" . (int)$data['reason_id'] . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value) . "'");
		}
	}
	
	public function deletereason($data){
		$this->db->query("DELETE FROM " . DB_PREFIX . "reportreasons_description WHERE reason_id = '" . (int)$data['reason_id'] . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "reportreasons WHERE reason_id = '" . (int)$data['reason_id'] . "'");
	}
	
	public function getreaonsbyID($reason_id){
		$sql = "SELECT * FROM ".DB_PREFIX."reportreasons rr LEFT JOIN ".DB_PREFIX."reportreasons_description rrd ON rr.reason_id = rrd.reason_id WHERE rr.reason_id = '" . (int)$reason_id . "'";
		$query = $this->db->query($sql);
		return $query->rows;
	}
	public function getreviewreport($review_id){
		$sql = "SELECT * FROM ".DB_PREFIX."review_abuse ra LEFT JOIN ".DB_PREFIX."reportreasons_description rrd ON ra.reason = rrd.reason_id WHERE ra.review_id = '" . (int)$review_id . "' AND rrd.language_id = '".$this->config->get('config_language_id')."'";
		$query = $this->db->query($sql);
		return $query->row;
	}
	
	public function addreport($data){
		$this->db->query("INSERT INTO " . DB_PREFIX . "reportreasons SET date_modify = NOW(), date_added = NOW()");
		$reason_id = $this->db->getLastId();
		foreach ($data['reasonsadd'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "reportreasons_description SET reason_id = '" . (int)$reason_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value) . "'");
		}
	}
	
	public function getreport($reason_id){
		$this->db->query("SELECL * FROM " . DB_PREFIX . "reportreasons r LEFT JOIN " . DB_PREFIX . "reportreasons_description rd ON r.reason_id = rd.reason_id WHERE r.reason_id = '". $reason_id ."' GROUP BY r.reason_id");
		return $query->rows;
	}
	
	public function getreviewrating($reviewpro_id){
		$query = $this->db->query("SELECT * from " . DB_PREFIX . "reviewpro_rating WHERE reviewpro_id = '". $reviewpro_id ."'");
		return $query->rows;
	}
	
	public function getreviewratings($reviewpro_id,$rating_id){
		$query = $this->db->query("SELECT * from " . DB_PREFIX . "reviewpro_rating WHERE reviewpro_id = '". $reviewpro_id ."' AND rating_id = '". $rating_id ."'");
		return $query->row;
	}
	
	public function getyesvote($review_id){
		$query = $this->db->query("SELECT count(*) As total from " . DB_PREFIX . "review_vote WHERE review_id = '". $review_id ."' AND yes = 1");
		return $query->row['total'];
	}
	
	public function getnovote($review_id){
		$query = $this->db->query("SELECT count(*) As total from " . DB_PREFIX . "review_vote WHERE review_id = '". $review_id ."' AND no = 1");
		return $query->row['total'];
	}
	
	public function getreports(){
		$query = $this->db->query("SELECT * from " . DB_PREFIX . "reportreasons r LEFT JOIN " . DB_PREFIX . "reportreasons_description rd ON r.reason_id = rd.reason_id WHERE language_id = '". (int) $this->config->get('config_language_id') ."'");
		if ($query->num_rows) {
			return $query->rows;
		}
	}
	
	public function getratinglist() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wrating r LEFT JOIN " . DB_PREFIX . "wrating_description rd ON r.rating_id = rd.rating_id WHERE rd.language_id = '". $this->config->get('config_language_id') ."'");
		
		return $query->rows;
	}
	
	public function addreply($data){
		$this->db->query("INSERT INTO " . DB_PREFIX . "review_reply SET review_id = '" . (int)$data['reply_review_id'] . "', comment = '" . $data['comment'] . "', user_id = '" . (int)$this->session->data['user_id'] . "', date_added = NOW()");
	}
	
	public function getadminreply($review_id){
		$query = $this->db->query("SELECT * from " . DB_PREFIX . "review_reply WHERE review_id = '" . (int)$review_id . "'");
		return $query->rows;
	}
	
	public function getverifiespurchased($product_id, $customer_id){
		$query = $this->db->query("SELECT * from " . DB_PREFIX . "order o LEFT JOIN " . DB_PREFIX . "order_product op ON o.order_id = op.order_id WHERE o.customer_id = '" . (int)$customer_id . "' AND op.product_id = '". (int)$product_id ."' AND o.order_status_id = 5");
		if ($query->num_rows) {
			return $query->rows;
		}
	}
	
	public function removeattachment($data){
		$this->db->query("DELETE FROM " . DB_PREFIX . "reviewpro_attachments WHERE file = '" . $data . "'");
	}
	
	public function reviewstatus($data){
		$this->db->query("UPDATE " . DB_PREFIX . "reviewpro SET status = '". (int)$data['status'] ."' WHERE review_id = '" . (int)$data['review_id'] . "'");
	}
	
	public function reviewfeatured($data){
		$this->db->query("UPDATE " . DB_PREFIX . "reviewpro SET featured = '". (int)$data['featured'] ."' WHERE review_id = '" . (int)$data['review_id'] . "'");
	}
	
	public function removereview($review_id){
		$this->db->query("DELETE FROM " . DB_PREFIX . "reviewpro WHERE review_id = '" . $review_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "review_abuse WHERE review_id = '" . $review_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "reviewpro_attachments WHERE review_id = '" . $review_id . "'");
	}
	
	public function replydelete($review_id,$vote_id){
		$this->db->query("DELETE FROM " . DB_PREFIX . "review_reply WHERE review_id = '" . $review_id . "' AND vote_id = '" . $vote_id . "'");
	}
	
	public function getTotalReview($data){
		$sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "reviewpro WHERE review_id > 0";
		if(!empty($data['review_id'])){
			$sql .= " AND review_id = '". $data['review_id'] ."'";
		}
		
		if (!empty($data['product_id'])) {
			$sql .= " AND product_id = '". $data['product_id'] ."'";
		}
		
		if (!empty($data['customer_id'])) {
			$sql .= " AND customer_id = '". $data['customer_id'] ."'";
		}
		
		if (!empty($data['userreview'])) {
			if ($data['userreview'] == 1) {
				$sql .= " AND customer_id >= 1";
			}elseif($data['userreview'] == 'all'){
				$sql .= " AND customer_id >= 0";
			}else{
				$sql .= " AND customer_id = 0";
			}
		}
		
		if (!empty($data['filter_date_added'])) {
			$sql .= " AND DATE(date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
		}
		
		if (isset($data['status']) && $data['status'] !== '' ) {
			$sql .= " AND status = '". $data['status'] ."'";
		}
		
		$query = $this->db->query($sql);
		return $query->row['total'];
	}
	
	public function getReviews($data) {
		$sql = "SELECT * from " . DB_PREFIX . "reviewpro r WHERE r.review_id > 0";
		
		if($data['review_id']){
			$sql .= " AND r.review_id = '". $data['review_id'] ."'";
		}
		
		if (!empty($data['product_id'])) {
			$sql .= " AND r.product_id = '". $data['product_id'] ."'";
		}
		
		if (!empty($data['customer_id'])) {
			$sql .= " AND r.customer_id = '". $data['customer_id'] ."'";
		}
		
		if (!empty($data['userreview'])) {
			if ($data['userreview'] == 1) {
				$sql .= " AND r.customer_id >= 1";
			}elseif($data['userreview'] == 'all'){
				$sql .= " AND r.customer_id >= 0";
			}else{
				$sql .= " AND r.customer_id = 0";
			}
		}
		
		if (isset($data['status']) && $data['status'] !== '' ) {
			$sql .= " AND r.status = '". $data['status'] ."'";
		}
		
		if (!empty($data['filter_date_added'])) {
			$sql .= " AND DATE(r.date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
		}

		$sql .= " ORDER BY r.date_added DESC";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$query = $this->db->query($sql);
		return $query->rows;
	}
	
	public function getOldReviews(){
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "review");
		return $query->rows;
	}
	
	public function checkoldreview($data){
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "reviewpro WHERE customer_id = '". (int)$data['customer_id'] ."' AND product_id = '". (int)$data['product_id'] ."' AND comment = '". $this->db->escape($data['text']) ."'");
		return $query->row;
	}
	
	public function addreview($data){
		$this->db->query("INSERT INTO ". DB_PREFIX ."reviewpro SET product_id = '". $data['product_id'] ."', customer_id = '". $data['customer_id'] ."', comment = '". $this->db->escape($data['text']) ."', name = '". $data['author'] ."', status = '". $data['status'] ."', date_added = '". $data['date_added'] ."', date_modify = '". $data['date_modified'] ."'");
		$review_id = $this->db->getLastId();
		$returnarray = array(
			'review_id' => $review_id,
			'rating' 	=> $data['rating'],
		);
		return $returnarray;
	}
	
	public function addnewreview($data){
		$this->db->query("INSERT INTO ". DB_PREFIX ."reviewpro SET product_id = '". $data['product_id'] ."', customer_id = 0, comment = '". $this->db->escape($data['comment']) ."', name = '". $data['name'] ."', email = '". $data['email'] ."', title = '". $data['title'] ."', file = '',status = '1', date_added = '". $data['date_added'] ."'");
		$review_id = $this->db->getLastId();
		if(isset($data['rating'])){
			foreach($data['rating'] as $key => $value){
				$this->db->query("INSERT INTO " . DB_PREFIX . "reviewpro_rating SET reviewpro_id = '". $review_id ."', rating_id = '". $key ."',rating = '". $value ."'");
			}
		}
		
		if(isset($data['file'])){
			foreach($data['file'] as $key => $value){
				$this->db->query("INSERT INTO " . DB_PREFIX . "reviewpro_attachments SET review_id = '". $review_id ."', file = '". $value ."'");
			}
		}
	}
	
	public function editreview($review_id,$data){
		
		$this->db->query("UPDATE ". DB_PREFIX ."reviewpro SET product_id = '". $data['product_id'] ."', customer_id = '". $data['customer_id'] ."', comment = '". $this->db->escape($data['comment']) ."', name = '". $data['name'] ."', title = '". $data['title'] ."', file = '', status = '". $data['status'] ."', date_added = '". $data['date_added'] ."', date_modify = NOW() WHERE review_id = '". $review_id ."'");
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "reviewpro_rating WHERE reviewpro_id = '" . $review_id . "'");
		
		if(isset($data['rating'])){
			foreach($data['rating'] as $key => $value){
				$this->db->query("INSERT INTO " . DB_PREFIX . "reviewpro_rating SET reviewpro_id = '". $review_id ."', rating_id = '". $key ."',  	rating = '". $value ."'");
			}
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "reviewpro_attachments WHERE review_id = '" . $review_id . "'");
		if(isset($data['file'])){
			foreach($data['file'] as $key => $value){
				$this->db->query("INSERT INTO " . DB_PREFIX . "reviewpro_attachments SET review_id = '". $review_id ."', file = '". $value ."'");
			}
		}
	}
	
	public function getreview($review_id){
		$query = $this->db->query("SELECT * FROM ". DB_PREFIX ."reviewpro WHERE review_id = '". $review_id ."'");
		
		return $query->row;
	}
	
	public function addoldrating($data, $rating_id){
		$this->db->query("INSERT INTO ". DB_PREFIX ."reviewpro_rating SET reviewpro_id = '". $data['review_id'] ."', rating_id = '". $rating_id ."', rating = '". $data['rating'] ."'");
	}
	
	public function updateoldrating($data, $rating_id, $rating){
		$this->db->query("INSERT INTO ". DB_PREFIX ."reviewpro_rating SET reviewpro_id = '". $data['review_id'] ."', rating_id = '". $rating_id ."', rating = '". (int)$rating ."'");
	}
	
	public function deleteratingvalues($data){
		$this->db->query("DELETE FROM " . DB_PREFIX . "reviewpro_rating WHERE reviewpro_id = '" . (int)$data['review_id'] . "'");
	}
	public function getallReviews() {
		$query = $this->db->query("SELECT * from " . DB_PREFIX . "reviewpro r WHERE r.date_added <= NOW() AND r.review_id > 0");
		
		return $query->rows;
	}
	
	public function getattachments($review_id){
		$query = $this->db->query("SELECT * from " . DB_PREFIX . "reviewpro_attachments WHERE review_id = '". $review_id ."'");
		return $query->rows;
	}
}