<?php
class ModelExtensionStorecart extends Model {
	public function install() {
	$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."storecart` (
  `storecart_id` int(11) NOT NULL AUTO_INCREMENT,
  `cart_id` text NOT NULL,
  `customer_id` int(11) NOT NULL,
  `firstname` varchar(255) NOT NULL,
  `lastname` varchar(255) NOT NULL,
  `email` varchar(96) NOT NULL,
  `type` varchar(255) NOT NULL,
  `telephone` varchar(32) NOT NULL,
  `session_id` varchar(32) NOT NULL,
  `product_id` int(11) NOT NULL,
  `recurring_id` int(11) NOT NULL,
  `option` text NOT NULL,
  `quantity` int(5) NOT NULL,
  `date_added` datetime NOT NULL,
  `email_notify` tinyint(4) NOT NULL,
  `language_id` int(11) NOT NULL,
  `ip` VARCHAR(255) NOT NULL,  
  PRIMARY KEY (`storecart_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");

$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."storecart_crownjob` (
  `storecart_crownjob_id` int(11) NOT NULL AUTO_INCREMENT,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`storecart_crownjob_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");

$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."storecart_order` (
  `storecart_order_id` int(11) NOT NULL AUTO_INCREMENT,
  `cart_id` text NOT NULL,
  `customer_id` int(11) NOT NULL,
  `firstname` varchar(255) NOT NULL,
  `lastname` varchar(255) NOT NULL,
  `email` varchar(96) NOT NULL,
  `type` varchar(255) NOT NULL,
  `telephone` varchar(32) NOT NULL,
  `session_id` varchar(32) NOT NULL,
  `product_id` int(11) NOT NULL,
  `recurring_id` int(11) NOT NULL,
  `option` text NOT NULL,
  `quantity` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  `email_notify` tinyint(4) NOT NULL,
  `order_id` int(11) NOT NULL,
  `coupon` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`storecart_order_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");

$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."storecart_template` (
  `storecart_template_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `default` tinyint(4) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`storecart_template_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");

$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."storecart_template_description` (
  `storecart_template_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `message` longtext NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
	}
	public function uninstall() {
	$this->db->query("DROP TABLE IF EXISTS `".DB_PREFIX."storecart`");
	$this->db->query("DROP TABLE IF EXISTS `".DB_PREFIX."storecart_crownjob`");
	$this->db->query("DROP TABLE IF EXISTS `".DB_PREFIX."storecart_order`");
	$this->db->query("DROP TABLE IF EXISTS `".DB_PREFIX."storecart_template`");
	$this->db->query("DROP TABLE IF EXISTS `".DB_PREFIX."storecart_template_description`");
	}
	
	public function getTotalStorecartProducts() {
		$query = $this->db->query("SELECT COUNT(*) as total FROM ". DB_PREFIX ."storecart WHERE email != ''");
		
		return $query->row['total'];
	}
	
	public function getTotalStorecartEmailNotify() {
		$query = $this->db->query("SELECT COUNT(*) as total FROM ". DB_PREFIX ."storecart WHERE email != '' AND email_notify = '1'");
		
		return $query->row['total'];
	}
	
	/* march update */
	public function getTotalUseCoupons() {
		$query = $this->db->query("SELECT COUNT(*) as total FROM ". DB_PREFIX ."storecart_order WHERE coupon != ''");
		
		return $query->row['total'];
	}
	/* march update */
}
