<?php
/*
  Price Tax Calculator
  Premium Extension
  
  Copyright (c) 2013 - 2019 Adikon.eu
  http://www.adikon.eu/
  
  You may not copy or reuse code within this file without written permission.
*/
?>
<script type="text/javascript">
if (!jQuery.fn.live) {
    jQuery.fn.live = function(evt, func) {
        $('body').on(evt, this.selector, func);
    }
}

function doRound(x, places) {
	return Math.round(x * Math.pow(10, places)) / Math.pow(10, places);
}

function updatePriceGross(value) {
	tax_class_id = $('select[name="tax_class_id"] option:selected').val();

	if (tax_class_id == '' || tax_class_id == 0) {
		return value;
	}

	value = parseFloat(value);

	if (value == 0) {
		return 0;
	}

	var tax_rates = tax_class_rates[tax_class_id];
	var tax = 0;

	for (i in tax_rates) {
		if (tax_rates[i].type == 'F') {
			tax += parseFloat(tax_rates[i].rate);
		} else if (tax_rates[i].type == 'P') {
			tax += (value / 100 * parseFloat(tax_rates[i].rate));
		}
	}

	return doRound((value + tax), <?php echo $decimal_gross; ?>);
}

function updatePriceNet(value) {
	tax_class_id = $('select[name="tax_class_id"] option:selected').val();

	if (tax_class_id == '' || tax_class_id == 0) {
		return value;
	}

	value = parseFloat(value);

	if (value == 0) {
		return 0;
	}

	var tax_rates = tax_class_rates[tax_class_id];
	var tax_percentage = 0;
	var tax_fixed = 0;

	for (i in tax_rates) {
		if (tax_rates[i].type == 'F') {
			tax_fixed += parseFloat(tax_rates[i].rate);
		} else if (tax_rates[i].type == 'P') {
			tax_percentage += parseFloat(tax_rates[i].rate) / 100;
		}
	}

	return doRound(((value - tax_fixed) / (1 + tax_percentage)), <?php echo $decimal_net; ?>);
}

function addBrutto() {
	$('input[name="price"], input[name^="price"], input[name$="[price]"]').each(function() {
		if (!$(this).hasClass('has_brutto')) {
			price_gross = updatePriceGross($(this).val());

			<?php if (version_compare(VERSION, '2.0', '<')) { ?>
			var new_input = '<div class="is_brutto" style="margin-top: 5px;"><span style="display: inline-block; background: #f4f4f4; line-height: 20px; font-size: 12px; padding-left: 5px; padding-right: 8px; border: 1px solid #999; border-right: none;">Vergili Fiyat</span><input type="text" name="is_brutto[]" value="' + price_gross + '" style="max-width: 50%;" /></div>';
			<?php } else { ?>
			var new_input = '<div class="is_brutto input-group" style="margin-top: 5px;"><span class="input-group-addon">Vergili Fiyat</span><input type="text" name="is_brutto[]" value="' + price_gross + '" class="form-control" /></div>';
			<?php } ?>

			$(this).addClass('has_brutto').after(new_input);
		}
	});
}

var tax_class_rates = new Array();
tax_class_rates = <?php echo $tax_class_rates; ?>;

$(document).ready(function() {
	addBrutto();

	<?php if (version_compare(VERSION, '2.0', '<')) { ?>
	$('table[id^="option-value"] tfoot a.button, table[id="discount"] tfoot a.button, table[id="special"] tfoot a.button').live('click', function() {
	<?php } else { ?>
	$('table[id^="option-value"] tfoot .btn, table[id="discount"] tfoot .btn, table[id="special"] tfoot .btn').live('click', function() {
	<?php } ?>

		addBrutto();
	});

	$('select[name="tax_class_id"]').change(function() {
		$('input[class$="has_brutto"]').each(function() {
			$(this).next('.is_brutto').find('input').val(updatePriceGross($(this).val()));
		});
	});

	$('body').on('keyup', 'input[class$="has_brutto"]', function() {
		$(this).next('.is_brutto').find('input').val(updatePriceGross($(this).val()));
	});

	$('body').on('keyup', 'input[name^="is_brutto"]', function() {
		$(this).parents('.is_brutto').prev().val(updatePriceNet($(this).val()));
	});
});
//--></script>