<?php
$feed_options = array(
  'format' => 'xml',
  'content' => '',
  'extra_tabs' => array('custom' => $_language->get('entry_custom')),
  'ftp' => true,
);

$enabled = array(
  'multilingual' => false,
);

$disabled = array(
  'price_tax',
  'price_order',
);

$feed = array_merge(array(
  'header' => '<?xml version="1.0"?>
<itemlist>
<title>XML Feed - {date}</title>',
  'footer' => '</itemlist>',
  'node_name' => 'item',
), $feed);

ob_start(); ?>

<div id="tab-<?php echo $feed_row; ?>-custom" class="tab-pane">
  
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_custom_header_i'); ?>"><?php echo $_language->get('entry_custom_header'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-file-text-o"></i></span>
        <textarea rows="5" name="univfeed_feeds[<?php echo $feed_row; ?>][header]" class="form-control" placeholder=""><?php echo isset($feed['header']) ? $feed['header'] : ''; ?></textarea>
      </div>
      <div class="infotags"><?php echo $_language->get('text_header_tags'); ?></div>
    </div>
  </div>
  
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_node_name_i'); ?>"><?php echo $_language->get('entry_node_name'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-code"></i></span>
        <input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][node_name]" class="form-control" placeholder="item" value="<?php echo isset($feed['node_name']) ? $feed['node_name'] : ''; ?>"/>
      </div>
    </div>
  </div>
  
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_custom_content_i'); ?>"><?php echo $_language->get('entry_custom_content'); ?></span></label>
    <div class="col-sm-10">
      <table class="itemsTable table table-bordered">
        <thead>
          <tr class="nodrag">
            <th style="width:1%"></th>
            <th style="width:40%"><?php echo $_language->get('text_item_name'); ?></th>
            <th><?php echo $_language->get('text_item_value'); ?></th>
            <th style="width:1%"></th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($feed['item_nodes'])) foreach ($feed['item_nodes'] as $key => $item_node) { ?>
            <tr style="cursor:move">
              <td style="font-family:FontAwesome, sans-serif;color:#c3c3c3;font-size:15px">&nbsp;&nbsp;</td>
              <td><input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][item_nodes][]" class="form-control" value="<?php echo $item_node; ?>"/></td>
              <td><input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][item_values][]" class="form-control" value="<?php echo isset($feed['item_values'][$key]) ? $feed['item_values'][$key] : ''; ?>"/></td>
              <td><button type="button" class="btn btn-danger remove-csv-item"><i class="fa fa-minus-circle"></i></button></td>
            </tr>
          <?php } ?>
          <tr class="nodrag nodrop">
            <td colspan="4" style="text-align:center">
              <button type="button" class="btn btn-success add-csv-item" data-feed-row="<?php echo $feed_row; ?>"><i class="fa fa-plus"></i> <?php echo $_language->get('text_add_value'); ?></button>
            </td>
          </tr>
        </tbody>
      </table>
      <div class="infotags"><?php echo $_language->get('text_content_tags'); ?></div>
    </div>
  </div>
  
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_custom_header_i'); ?>"><?php echo $_language->get('entry_custom_footer'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-file-text-o"></i></span>
        <textarea rows="2" name="univfeed_feeds[<?php echo $feed_row; ?>][footer]" class="form-control" placeholder=""><?php echo  isset($feed['footer']) ? $feed['footer'] : ''; ?></textarea>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript"><!--
$(document).ready(function() {
	$('#feed-row-<?php echo $feed_row; ?> .itemsTable').tableDnD();
});
//--></script>

<?php $extra_tabs = ob_get_clean();

include(DIR_TEMPLATE.'feed/universal_feed_common.tpl'); ?>