<?php
$feed_options = array(
  'format' => 'xml',
);

$feed = array_merge(array(
  'store_category' => '',
  'gtin' => '',
  'id' => '',
  'shipping' => array(''),
  'option_size' => '',
  'option_color' => '',
), $feed);
?>
<?php ob_start(); ?>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_store_category_i'); ?>"><?php echo $_language->get('entry_store_category'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa fa-folder-open-o"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][store_category]" class="form-control">
          <option value=""><?php echo $_language->get('text_disabled'); ?></option>
          <option value="1" <?php if ($feed['store_category']) echo 'selected="selected"'; ?>><?php echo $_language->get('text_enabled'); ?></option>
        </select>
      </div>
    </div>
  </div>
  
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_multipack_i'); ?>"><?php echo $_language->get('entry_multipack'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa fa-folder-open-o"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][multipack]" class="form-control">
          <option value=""><?php echo $_language->get('text_disabled'); ?></option>
          <option value="1" <?php if ($feed['multipack']) echo 'selected="selected"'; ?>><?php echo $_language->get('text_enabled'); ?></option>
        </select>
      </div>
    </div>
  </div>

  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_identifier_exist_i'); ?>"><?php echo $_language->get('entry_identifier_exist'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa fa-folder-open-o"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][identifier_exist]" class="form-control">
          <option value=""><?php echo $_language->get('text_disabled'); ?></option>
          <option value="1" <?php if ($feed['identifier_exist']) echo 'selected="selected"'; ?>><?php echo $_language->get('text_enabled'); ?></option>
        </select>
      </div>
    </div>
  </div>

  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_title_suffix_i'); ?>"><?php echo $_language->get('entry_title_suffix'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa fa-folder-open-o"></i></span>
        <input type="text" class="form-control" name="univfeed_feeds[<?php echo $feed_row; ?>][title_suffix]" value="<?php if (!empty($feed['title_suffix'])) { echo $feed['title_suffix']; } else { echo ''; } ?>" />
      </div>
    </div>
  </div>
  
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_google_id_i'); ?>"><?php echo $_language->get('entry_google_id'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-tag"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][id]" class="form-control">
          <?php foreach (array('product_id', 'model', 'sku', 'upc', 'ean', 'jan', 'isbn') as $val) { ?>
          <option value="<?php echo $val; ?>" <?php if ($feed['id'] == $val) echo 'selected="selected"'; ?>><?php echo ($val == 'model') ? ucfirst($val) : strtoupper($val); ?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
  
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_gtin_i'); ?>"><?php echo $_language->get('entry_gtin'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-tag"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][gtin]" class="form-control">
          <option></option>
          <?php foreach (array('upc', 'ean', 'jan', 'isbn', 'model', 'product_id') as $val) { ?>
          <option value="<?php echo $val; ?>" <?php if ($feed['gtin'] == $val) echo 'selected="selected"'; ?>><?php echo ($val == 'model') ? ucfirst($val) : strtoupper($val); ?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
  
  <div class="form-group multiple">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_google_shipping_i'); ?>"><?php echo $_language->get('entry_shipping'); ?></span></label>
    <div class="col-sm-9">
      <?php foreach ($feed['shipping'] as $shipping) { ?>
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-truck"></i></span>
        <input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][shipping][]" value="<?php echo $shipping; ?>" class="form-control" placeholder="0-200:US::Ground:5.50 USD"/>
      </div>
      <?php } ?>
    </div>
    <div class="col-sm-1">
      <button title="<?php echo $_language->get('text_add_entry'); ?>" type="button" data-toggle="tooltip" class="btn btn-success pull-right copy-entry"><i class="fa fa-plus"></i></button>
      <?php array_pop($feed['shipping']); foreach ($feed['shipping'] as $shipping) { ?>
        <button style="clear:both" title="<?php echo $_language->get('text_remove_entry'); ?>" type="button" data-toggle="tooltip" class="btn btn-danger pull-right remove-entry"><i class="fa fa-minus-circle"></i></button>
      <?php } ?>
    </div>
  </div>
 
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_option_color_i'); ?>"><?php echo $_language->get('entry_option_color'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-user"></i></span>
        <select class="form-control" name="univfeed_feeds[<?php echo $feed_row; ?>][option_color]">
          <option value=""><?php echo $_language->get('text_disabled'); ?></option>
          <?php foreach ($options as $option) { ?>
            <option value="<?php echo $option['option_id']; ?>" <?php if($feed['option_color'] == $option['option_id']) echo 'selected="selected"'; ?>><?php echo $option['name']; ?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_option_size_i'); ?>"><?php echo $_language->get('entry_option_size'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-user"></i></span>
        <select class="form-control" name="univfeed_feeds[<?php echo $feed_row; ?>][option_size]">
          <option value=""><?php echo $_language->get('text_disabled'); ?></option>
          <?php foreach ($options as $option) { ?>
            <option value="<?php echo $option['option_id']; ?>" <?php if($feed['option_size'] == $option['option_id']) echo 'selected="selected"'; ?>><?php echo $option['name']; ?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
  
<?php $extra_options = ob_get_clean(); ?>

<?php include(DIR_TEMPLATE.'feed/universal_feed_common.tpl'); ?>