<div id="feed-row-<?php echo $feed_row; ?>">
<?php
if (!isset($disabled)) $disabled = array();
if (!isset($enabled)) $enabled = array();

$exportFormats = isset($exportFormats) ? $exportFormats : array('xml', 'csv');
$feed = array_merge(array(
  'format' => '',
  'display_quantity' => 0,
  'cache_delay' => 0,
  'cache_unit' => 'minute',
  'filter_language' => '',
  'currency' => '',
  'force_currency' => '',
  'manufacturer' => '',
  'code' => '',
  'price_tax' => '',
  'price_format' => '',
  'price_order' => '',
  'special_price_group' => '',
  'in_stock' => '',
  'store' => '',
  'shipping' => '',
  'ip' => '',
  'ftp_server' => '',
  'ftp_user' => '',
  'ftp_pwd' => '',
  'ftp_file' => '',
  'id_field' => '',
  'zipped' => '',
  'conditions' => array(),
  'conditions_or' => array(),
  'exclude_products' => array(),
  'replaces' => array(),
), $feed);
?>
<ul class="nav nav-tabs">
  <li class="active"><a href="#tab-<?php echo $feed_row; ?>-filters" data-toggle="tab"><?php echo $_language->get('entry_filters'); ?></a></li>
  <li><a href="#tab-<?php echo $feed_row; ?>-config" data-toggle="tab"><?php echo $_language->get('entry_options'); ?></a></li>
  <?php if (!empty($feed_options['extra_tabs'])) foreach ($feed_options['extra_tabs'] as $tab_key => $tab_name) { ?>
  <li><a href="#tab-<?php echo $feed_row; ?>-<?php echo $tab_key; ?>" data-toggle="tab"><?php echo $tab_name; ?></a></li>
  <?php } ?>
  <li><a href="#tab-<?php echo $feed_row; ?>-advanced" data-toggle="tab"><?php echo $_language->get('entry_advanced'); ?></a></li>
</ul>
<div class="tab-content">

<div id="tab-<?php echo $feed_row; ?>-config" class="tab-pane">
  <?php if (!empty($feed_options['format'])) { ?>
  <input name="univfeed_feeds[<?php echo $feed_row; ?>][format]" value="<?php echo $feed_options['format']; ?>" type="hidden"/>
  <?php } else { ?>
  <div class="form-group">
    <label class="col-sm-2 control-label"><?php echo $_language->get('entry_format'); ?></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-file-o"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][format]" class="form-control">
          <?php foreach ($exportFormats as $format) { ?>
          <option value="<?php echo $format; ?>" <?php if (isset($feed['format']) && $feed['format'] == $format) echo 'selected="selected"'; ?>><?php echo strtoupper($format); ?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
  <?php } ?>
  <?php if ($feed['type'] == 'custom') { ?>
  <div class="form-group">
    <label class="col-sm-2 control-label"><?php echo $_language->get('entry_csv_separator'); ?></label>
    <div class="col-sm-10">
       <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-code"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][csv_separator]" class="form-control">
          <?php foreach (array(',' => ',', ';' => ';', '|' => '|', '^' => '^', '~' => '~', "\t" => 'Tab') as $val => $name) { ?>
          <option value="<?php echo $val; ?>"  <?php if (isset($feed['csv_separator']) && $feed['csv_separator'] == $val) echo 'selected="selected"'; ?>><?php echo $name; ?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
  <?php } ?>
  
  <?php if (!in_array('option_row', $disabled)) { ?>
  <div class="form-group">
    <label class="col-sm-2 control-label"><?php echo $_language->get('entry_option_row'); ?></label>
    <div class="col-sm-10">
       <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-list"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][option_row]" class="form-control">
          <option value=""  <?php if (empty($feed['option_row'])) echo 'selected="selected"'; ?>><?php echo $_language->get('text_option_row_default'); ?></option>
          <option value="1"  <?php if (!empty($feed['option_row'])) echo 'selected="selected"'; ?>><?php echo $_language->get('text_option_row_option'); ?></option>
        </select>
      </div>
    </div>
  </div>
  <?php } ?>
  
  <div class="form-group">
    <label class="col-sm-2 control-label"><?php echo $_language->get('entry_language'); ?></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-flag"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][filter_language]" class="form-control">
          <?php if (in_array('multilingual', $enabled)) { ?>
          <option value=""><?php echo $_language->get('text_all'); ?></option>
          <?php } ?>
          <?php foreach ($languages as $language) { ?>
          <option value="<?php echo $language['language_id']; ?>" <?php if ($feed['filter_language'] == $language['language_id']) echo 'selected="selected"'; ?>><?php echo $language['name']; ?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
  <?php if (!in_array('currency', $disabled)) { ?>
  <div class="form-group">
    <label class="col-sm-2 control-label"><?php echo $_language->get('entry_currency'); ?></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-money"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][currency]" class="form-control">
          <?php foreach ($currencies as $currency) { ?>
          <option value="<?php echo $currency['code']; ?>" <?php if ($feed['currency'] == $currency['code']) echo 'selected="selected"'; ?>><?php echo $currency['title']; ?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_force_currency_i'); ?>"><?php echo $_language->get('entry_force_currency'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-money"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][force_currency]" class="form-control">
          <option value=""><?php echo $_language->get('text_disabled'); ?></option>
          <option value="1" <?php if ($feed['force_currency']) echo 'selected="selected"'; ?>><?php echo $_language->get('text_enabled'); ?></option>
        </select>
      </div>
    </div>
  </div>
  <?php } ?>
    <?php if (!in_array('price_order', $disabled)) { ?>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_price_order_i'); ?>"><?php echo $_language->get('entry_price_order'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-money"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][price_order]" class="form-control">
          <?php foreach (array('special_discount_price', 'discount_special_price', 'special_price', 'discount_price', 'price') as $priceType) { ?>
            <option value="<?php echo $priceType; ?>" <?php if($feed['price_order'] == $priceType) echo 'selected="selected"'; ?>><?php echo ucwords(str_replace(array('_', 'price'), array(' > ', 'regular'), $priceType)); ?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
  <?php } ?>
  <?php if (!in_array('price_tax', $disabled)) { ?>
  <div class="form-group">
    <label class="col-sm-2 control-label"><?php echo $_language->get('entry_price_tax'); ?></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-balance-scale"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][price_tax]" class="form-control">
          <option value="" <?php if (!$feed['price_tax']) echo 'selected="selected"'; ?>><?php echo $_language->get('text_yes'); ?></option>
          <option value="1" <?php if ($feed['price_tax']) echo 'selected="selected"'; ?>><?php echo $_language->get('text_no'); ?></option>
        </select>
      </div>
    </div>
  </div>
  <?php } ?>
  <?php if (!in_array('price_format', $disabled) && in_array($feed['type'], array('common_feed', 'custom', 'custom_xml'))) { ?>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_price_format_i'); ?>"><?php echo $_language->get('entry_price_format'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-money"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][price_format]" class="form-control">
          <option value="" <?php if (!$feed['price_format']) echo 'selected="selected"'; ?>><?php echo $_language->get('text_no'); ?></option>
          <option value="1" <?php if ($feed['price_format']) echo 'selected="selected"'; ?>><?php echo $_language->get('text_yes'); ?></option>
        </select>
      </div>
    </div>
  </div>
  <?php } ?>
  <?php if (!in_array('special_price_group', $disabled)) { ?>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_special_price_group_i'); ?>"><?php echo $_language->get('entry_special_price_group'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-user"></i></span>
        <select class="form-control" name="univfeed_feeds[<?php echo $feed_row; ?>][special_price_group]">
          <option value=""><?php echo $_language->get('text_default_store_value'); ?></option>
          <?php foreach ($customer_groups as $group) { ?>
            <option value="<?php echo $group['customer_group_id']; ?>" <?php if($feed['special_price_group'] == $group['customer_group_id']) echo 'selected="selected"'; ?>><?php echo $group['name']; ?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
  <?php } ?>
  <?php if (!in_array('stock_label', $disabled)) { ?>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_stock_label_i'); ?>"><?php echo $_language->get('entry_stock_label'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-check-square-o"></i></span>
        <textarea name="univfeed_feeds[<?php echo $feed_row; ?>][stock_label]" class="form-control" placeholder="0:Out of stock (1 per line)"><?php if (isset($feed['stock_label'])) echo $feed['stock_label']; ?></textarea>
      </div>
    </div>
  </div>
  <?php } ?>

  <?php if (in_array('id_field', $enabled)) { ?>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_id_field_i'); ?>"><?php echo $_language->get('entry_id_field'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-tag"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][id_field]" class="form-control">
          <?php foreach (array('product_id', 'model', 'sku', 'upc', 'ean', 'jan', 'isbn') as $val) { ?>
          <option value="<?php echo $val; ?>" <?php if ($feed['id_field'] == $val) echo 'selected="selected"'; ?>><?php echo ($val == 'model') ? ucfirst($val) : strtoupper($val); ?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
  <?php } ?>
  
  <?php if (in_array('shipping', $enabled)) { ?>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_shipping_i'); ?>"><?php echo $_language->get('entry_shipping'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-truck"></i></span>
        <textarea name="univfeed_feeds[<?php echo $feed_row; ?>][shipping]" class="form-control" placeholder="P0-50:5.90 (1 per line)"><?php if (isset($feed['shipping'])) echo $feed['shipping']; ?></textarea>
      </div>
    </div>
  </div>
  <?php } ?>
  
  <?php if (!in_array('replace', $disabled)) { ?>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_replace_i'); ?>"><?php echo $_language->get('entry_replace'); ?></span></label>
    <div class="col-sm-10">
    <?php foreach ($feed['replaces'] as $condition_key => $condition) { ?>
      <div class="input-group" style="margin-bottom:15px">
        <span class="input-group-addon"><i class="fa fa-edit"></i></span>
        <?php /*
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][conditions][<?php echo $condition_key; ?>][mode]" class="form-control">
          <?php foreach (array('include', 'exclude') as $mode) { ?>
          <option value="<?php echo $mode; ?>" <?php if ($condition['mode'] == $mode) echo 'selected="selected"'; ?>><?php echo $_language->get('text_'.$mode); ?></option>
          <?php } ?>
        </select>
        */ ?>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][replaces][<?php echo $condition_key; ?>][field]" class="form-control">
          <?php foreach (array('name', 'model', 'product_category', 'manufacturer', 'description', 'quantity', 'sku', 'upc', 'ean', 'jan', 'isbn', 'mpn', 'location') as $field) { ?>
          <option value="<?php echo $field; ?>" <?php if ($condition['field'] == $field) echo 'selected="selected"'; ?>><?php echo $_language->get('entry_'.$field); ?></option>
          <?php } ?>
        </select>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][replaces][<?php echo $condition_key; ?>][comparator]" class="form-control">
          <?php foreach (array('is_equal', 'is_not_equal', 'is_greater', 'is_lower', 'contain', 'not_contain') as $comparator) { ?>
          <option value="<?php echo $comparator; ?>" <?php if ($condition['comparator'] == $comparator) echo 'selected="selected"'; ?>><?php echo $_language->get('comparator_'.$comparator); ?></option>
          <?php } ?>
        </select>
        <input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][replaces][<?php echo $condition_key; ?>][value]" value="<?php echo $condition['value']; ?>" class="form-control" placeholder="<?php echo $_language->get('text_replace_condition'); ?>"/>
        <input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][replaces][<?php echo $condition_key; ?>][output]" value="<?php echo $condition['output']; ?>" class="form-control" placeholder="<?php echo $_language->get('text_replace_output'); ?>"/>
        <span class="input-group-addon"><button type="button" class="btn btn-danger btn-xs remove-condition" ><i class="fa fa-remove"></i></button></span>
      </div>
      <?php } ?>
      <button type="button" class="btn btn-default btn-block add-replace" data-feed-row="<?php echo $feed_row; ?>"><i class="fa fa-plus"></i> <?php echo $_language->get('text_add_replace'); ?></button>
    </div>
  </div>
  <?php } ?>
  
  <?php if (!empty($extra_options)) echo $extra_options; ?>

</div>

<div id="tab-<?php echo $feed_row; ?>-filters" class="tab-pane active">
  
  <div class="form-group">
    <label class="col-sm-2 control-label"><?php echo $_language->get('entry_store'); ?></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-home"></i></span>
        <select class="form-control" name="univfeed_feeds[<?php echo $feed_row; ?>][store]">
          <option value=""><?php echo $_language->get('text_all'); ?></option>
          <?php foreach ($stores as $store) { ?>
            <option value="<?php echo $store['store_id']; ?>" <?php if ($feed['store'] !== '' && $feed['store'] == $store['store_id']) echo 'selected="selected"'; ?>><?php echo $store['name']; ?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
  <div class="form-group">
    <label class="col-sm-2 control-label"><?php echo $_language->get('entry_category'); ?></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-folder-open-o"></i></span>
        <select class="selectize_option" name="univfeed_feeds[<?php echo $feed_row; ?>][filter_category][]" multiple>
          <option value=""><?php echo $_language->get('text_all'); ?></option>
          <?php foreach ($categories as $category) { ?>
            <option value="<?php echo $category['category_id']; ?>" <?php if (isset($feed['filter_category']) && in_array($category['category_id'], (array) $feed['filter_category'])) echo 'selected="selected"'; ?>><?php echo $category['name']; ?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
  <div class="form-group">
    <label class="col-sm-2 control-label"><?php echo $_language->get('entry_category_exclude'); ?></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-folder-o"></i></span>
        <select class="selectize_option" name="univfeed_feeds[<?php echo $feed_row; ?>][filter_category_exclude][]" multiple>
          <option value=""><?php echo $_language->get('text_none'); ?></option>
          <?php foreach ($categories as $category) { ?>
            <option value="<?php echo $category['category_id']; ?>" <?php if (isset($feed['filter_category_exclude']) && in_array($category['category_id'], (array) $feed['filter_category_exclude'])) echo 'selected="selected"'; ?>><?php echo $category['name']; ?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
  <div class="form-group">
    <label class="col-sm-2 control-label"><?php echo $_language->get('entry_manufacturer'); ?></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-wrench"></i></span>
        <select class="selectize_option" name="univfeed_feeds[<?php echo $feed_row; ?>][filter_manufacturer][]" multiple>
          <option value=""><?php echo $_language->get('text_all'); ?></option>
          <?php foreach ($manufacturers as $brand) { ?>
          <option value="<?php echo $brand['manufacturer_id']; ?>" <?php if (isset($feed['filter_manufacturer']) && in_array($brand['manufacturer_id'], (array) $feed['filter_manufacturer'])) echo 'selected="selected"'; ?>><?php echo $brand['name']; ?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
  <div class="form-group">
    <label class="col-sm-2 control-label" for="input-total"><?php echo $_language->get('entry_price'); ?></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-fw fa-dollar"></i></span>
        <input type="text" class="form-control" name="univfeed_feeds[<?php echo $feed_row; ?>][filter_price_min]" value="<?php echo isset($feed['filter_price_min']) ? $feed['filter_price_min'] : ''; ?>" placeholder="<?php echo $_language->get('filter_min'); ?>" />
        <span class="input-group-addon">-</span>
        <input type="text" class="form-control" name="univfeed_feeds[<?php echo $feed_row; ?>][filter_price_max]" value="<?php echo isset($feed['filter_price_max']) ? $feed['filter_price_max'] : ''; ?>" placeholder="<?php echo $_language->get('filter_max'); ?>"/>
      </div>
    </div>
  </div>
  <div class="form-group">
    <label class="col-sm-2 control-label"><?php echo $_language->get('entry_stock'); ?></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-check-square-o"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][in_stock]" class="form-control">
          <option value="" <?php if (!$feed['in_stock']) echo 'selected="selected"'; ?>><?php echo $_language->get('entry_stock_0'); ?></option>
          <option value="1" <?php if ($feed['in_stock']) echo 'selected="selected"'; ?>><?php echo $_language->get('entry_stock_1'); ?></option>
        </select>
      </div>
    </div>
  </div>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_conditions_i'); ?>"><?php echo $_language->get('entry_conditions'); ?></span></label>
    <div class="col-sm-10">
    <?php foreach ($feed['conditions'] as $condition_key => $condition) { ?>
      <div class="input-group" style="margin-bottom:15px">
        <span class="input-group-addon"><i class="fa fa-question-circle"></i></span>
        <?php /*
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][conditions][<?php echo $condition_key; ?>][mode]" class="form-control">
          <?php foreach (array('include', 'exclude') as $mode) { ?>
          <option value="<?php echo $mode; ?>" <?php if ($condition['mode'] == $mode) echo 'selected="selected"'; ?>><?php echo $_language->get('text_'.$mode); ?></option>
          <?php } ?>
        </select>
        */ ?>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][conditions][<?php echo $condition_key; ?>][field]" class="form-control">
          <?php foreach (array('name', 'model', 'manufacturer', 'description', 'quantity', 'sku', 'upc', 'ean', 'jan', 'isbn', 'mpn', 'location', 'stock_status_id', 'shipping') as $field) { ?>
          <option value="<?php echo $field; ?>" <?php if ($condition['field'] == $field) echo 'selected="selected"'; ?>><?php echo $_language->get('entry_'.$field); ?></option>
          <?php } ?>
        </select>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][conditions][<?php echo $condition_key; ?>][comparator]" class="form-control">
          <?php foreach (array('is_equal', 'is_not_equal', 'is_greater', 'is_lower', 'contain', 'not_contain') as $comparator) { ?>
          <option value="<?php echo $comparator; ?>" <?php if ($condition['comparator'] == $comparator) echo 'selected="selected"'; ?>><?php echo $_language->get('comparator_'.$comparator); ?></option>
          <?php } ?>
        </select>
        <input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][conditions][<?php echo $condition_key; ?>][value]" value="<?php echo $condition['value']; ?>" class="form-control" />
        <span class="input-group-addon"><button type="button" class="btn btn-danger btn-xs remove-condition" ><i class="fa fa-remove"></i></button></span>
      </div>
      <?php } ?>
      <button type="button" class="btn btn-default btn-block add-condition" data-feed-row="<?php echo $feed_row; ?>"><i class="fa fa-plus"></i> <?php echo $_language->get('text_add_condition'); ?></button>
    </div>
  </div>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_conditions_or_i'); ?>"><?php echo $_language->get('entry_conditions_or'); ?></span></label>
    <div class="col-sm-10">
    <?php foreach ($feed['conditions_or'] as $condition_key => $condition) { ?>
      <div class="input-group" style="margin-bottom:15px">
        <span class="input-group-addon"><i class="fa fa-question-circle"></i></span>
        <?php /*
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][conditions][<?php echo $condition_key; ?>][mode]" class="form-control">
          <?php foreach (array('include', 'exclude') as $mode) { ?>
          <option value="<?php echo $mode; ?>" <?php if ($condition['mode'] == $mode) echo 'selected="selected"'; ?>><?php echo $_language->get('text_'.$mode); ?></option>
          <?php } ?>
        </select>
        */ ?>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][conditions_or][<?php echo $condition_key; ?>][field]" class="form-control">
          <?php foreach (array('name', 'model', 'manufacturer', 'description', 'quantity', 'sku', 'upc', 'ean', 'jan', 'isbn', 'mpn', 'location', 'stock_status_id', 'shipping') as $field) { ?>
          <option value="<?php echo $field; ?>" <?php if ($condition['field'] == $field) echo 'selected="selected"'; ?>><?php echo $_language->get('entry_'.$field); ?></option>
          <?php } ?>
        </select>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][conditions_or][<?php echo $condition_key; ?>][comparator]" class="form-control">
          <?php foreach (array('is_equal', 'is_not_equal', 'is_greater', 'is_lower', 'contain', 'not_contain') as $comparator) { ?>
          <option value="<?php echo $comparator; ?>" <?php if ($condition['comparator'] == $comparator) echo 'selected="selected"'; ?>><?php echo $_language->get('comparator_'.$comparator); ?></option>
          <?php } ?>
        </select>
        <input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][conditions_or][<?php echo $condition_key; ?>][value]" value="<?php echo $condition['value']; ?>" class="form-control" />
        <span class="input-group-addon"><button type="button" class="btn btn-danger btn-xs remove-condition" ><i class="fa fa-remove"></i></button></span>
      </div>
      <?php } ?>
      <button type="button" class="btn btn-default btn-block add-or-condition" data-feed-row="<?php echo $feed_row; ?>"><i class="fa fa-plus"></i> <?php echo $_language->get('text_add_condition'); ?></button>
    </div>
  </div>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_exclude_products_i'); ?>"><?php echo $_language->get('entry_exclude_products'); ?></span></label>
    <div class="col-sm-10">
    <?php foreach ($feed['exclude_products'] as $condition_key => $condition) { ?>
      <div class="input-group" style="margin-bottom:15px">
        <span class="input-group-addon"><i class="fa fa-question-circle"></i></span>

        <select name="univfeed_feeds[<?php echo $feed_row; ?>][exclude_products][<?php echo $condition_key; ?>][field]" class="form-control">
          <?php foreach (array('name', 'model', 'manufacturer', 'description', 'quantity', 'sku', 'upc', 'ean', 'jan', 'isbn', 'mpn', 'location', 'stock_status_id', 'shipping') as $field) { ?>
          <option value="<?php echo $field; ?>" <?php if ($condition['field'] == $field) echo 'selected="selected"'; ?>><?php echo $_language->get('entry_'.$field); ?></option>
          <?php } ?>
        </select>

        <select name="univfeed_feeds[<?php echo $feed_row; ?>][exclude_products][<?php echo $condition_key; ?>][comparator]" class="form-control">
          <?php foreach (array('is_equal', 'is_not_equal', 'is_greater', 'is_lower', 'contain', 'not_contain') as $comparator) { ?>
          <option value="<?php echo $comparator; ?>" <?php if ($condition['comparator'] == $comparator) echo 'selected="selected"'; ?>><?php echo $_language->get('comparator_'.$comparator); ?></option>
          <?php } ?>
        </select>
        <input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][exclude_products][<?php echo $condition_key; ?>][value]" value="<?php echo $condition['value']; ?>" class="form-control" />
        <span class="input-group-addon"><button type="button" class="btn btn-danger btn-xs remove-condition" ><i class="fa fa-remove"></i></button></span>
      </div>
      <?php } ?>
      <button type="button" class="btn btn-default btn-block add-exclude-products-condition" data-feed-row="<?php echo $feed_row; ?>"><i class="fa fa-plus"></i> <?php echo $_language->get('text_add_condition'); ?></button>
    </div>
  </div>
</div>

<div id="tab-<?php echo $feed_row; ?>-advanced" class="tab-pane">
  
  <?php if(!empty($feed_options['ftp'])) { ?>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_ftp_i'); ?>"><?php echo $_language->get('entry_ftp'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-upload"></i></span>
        <input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][ftp_server]" value="<?php echo $feed['ftp_server']; ?>" class="form-control" placeholder="Server"/>
        <input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][ftp_user]" value="<?php echo $feed['ftp_user']; ?>" class="form-control" placeholder="Login"/>
        <input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][ftp_pwd]" value="<?php echo $feed['ftp_pwd']; ?>" class="form-control" placeholder="Password"/>
        <input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][ftp_file]" value="<?php echo $feed['ftp_file']; ?>" class="form-control" placeholder="File path /path/to/remote_file.csv"/>
      </div>
      <div class="btn btn-default btn-block" style="margin-top:10px" id="testFtp<?php echo $feed_row; ?>"><?php echo $_language->get('button_ftp_test'); ?></div>
    </div>
  </div>
  <?php } ?>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_ip_restriction_i'); ?>"><?php echo $_language->get('entry_ip_restriction'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-lock"></i></span>
        <input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][ip]" value="<?php echo $feed['ip']; ?>" class="form-control" placeholder="127.0.0.1;127.0.0.2"/>
      </div>
    </div>
  </div>
  <div class="form-group">
    <label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $_language->get('entry_protect_password_i'); ?>"><?php echo $_language->get('entry_protect_password'); ?></span></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-lock"></i></span>
        <input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][protect_password]" value="<?php echo !empty($feed['protect_password']) ? $feed['protect_password'] : ''; ?>" class="form-control" placeholder="Password"/>
      </div>
    </div>
  </div>
  <div class="form-group">
    <label class="col-sm-2 control-label"><?php echo $_language->get('entry_zipped'); ?></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-file-archive-o"></i></span>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][zipped]" class="form-control">
          <option value="" <?php if (!$feed['zipped']) echo 'selected="selected"'; ?>><?php echo $_language->get('text_no'); ?></option>
          <option value="1" <?php if ($feed['zipped']) echo 'selected="selected"'; ?>><?php echo $_language->get('text_yes'); ?></option>
        </select>
      </div>
    </div>
  </div>
  <div class="form-group">
    <label class="col-sm-2 control-label"><?php echo $_language->get('entry_cache_delay'); ?></label>
    <div class="col-sm-10">
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-clock-o"></i></span>
        <input type="text" name="univfeed_feeds[<?php echo $feed_row; ?>][cache_delay]" value="<?php echo $feed['cache_delay']; ?>" class="form-control" style="width:24.5%;margin-right:0.5%;border-radius:0 3px 3px 0;"/>
        <select name="univfeed_feeds[<?php echo $feed_row; ?>][cache_unit]" class="form-control" style="width:75%;border-radius:3px;">
          <option value="minute" <?php if ($feed['cache_unit'] == 'minute') echo 'selected="selected"'; ?>><?php echo $_language->get('text_minute'); ?></option>
          <option value="hour" <?php if ($feed['cache_unit'] == 'hour') echo 'selected="selected"'; ?>><?php echo $_language->get('text_hour'); ?></option>
          <option value="day" <?php if ($feed['cache_unit'] == 'day') echo 'selected="selected"'; ?>><?php echo $_language->get('text_day'); ?></option>
        </select>
      </div>
    </div>
  </div>
</div>
<?php if (!empty($extra_tabs)) echo $extra_tabs; ?>
</div>
</div>
<script type="text/javascript">
  jQuery('#feed-row-<?php echo $feed_row; ?> .selectize_option').selectize();
</script>
<?php if(!empty($feed_options['ftp'])) { ?>
<script type="text/javascript"><!--
$('body').on('click', '#testFtp<?php echo $feed_row; ?>', function() {
  $.ajax({
    url: 'index.php?route=feed/universal_feed/test_ftp&<?php echo $token; ?>',
    type: 'POST',
    data: {
      'ftp_server': $('input[name="univfeed_feeds[<?php echo $feed_row; ?>][ftp_server]"]').val(),
      'ftp_user': $('input[name="univfeed_feeds[<?php echo $feed_row; ?>][ftp_user]"]').val(),
      'ftp_pwd': $('input[name="univfeed_feeds[<?php echo $feed_row; ?>][ftp_pwd]"]').val(),
      'ftp_file': $('input[name="univfeed_feeds[<?php echo $feed_row; ?>][ftp_file]"]').val(),
    },
    success: function(res) {
      alert(res);
    }
  });
});
//--></script>
<?php } ?>