<?php

class ControllerExtensionCron extends Controller {

	// Store Cart Starts

	public function index() {

		if($this->config->get('crownjob_status')) {

			$this->load->language('extension/store_cart');

			

			$this->load->model('extension/store_cart');

			

			$this->load->model('extension/store_cart_products');

			

			$this->load->model('tool/image');

			

			$data['text_image'] = $this->language->get('text_image');

			$data['text_price'] = $this->language->get('text_price');

			$data['text_total'] = $this->language->get('text_total');

			$data['text_product'] = $this->language->get('text_product');

			$data['text_model'] = $this->language->get('text_model');

			$data['text_quantity'] = $this->language->get('text_quantity');

			

			$storecart_crownjob_info = $this->model_extension_store_cart->geStoreCartCrownjob();

			if($this->config->get('crownjob_status')) {

				

			$unnotify_customers = $this->model_extension_store_cart->getStoreCartCustomers();
				

					if(!empty($unnotify_customers)) {

						$total_customers =0;

						

						foreach($unnotify_customers as $unnotify_customer) {

	$total_customers++;

							

							$storecart_info = $this->model_extension_store_cart->getOneStoreCartsByEmail($unnotify_customer['email']);

							$mailinfo = $this->model_extension_store_cart->getMailTemplate($this->config->get('crownjob_storecart_template_id'),$unnotify_customer['language_id']);
/* Update 30  march */
					$this->load->model('localisation/language');
					$language_info = $this->model_localisation_language->getLanguage($unnotify_customer['language_id']);
					$language = new Language($language_info['code']);
					$language->load($language_info['code']);
					$language->load('extension/store_cart');
					$data['text_image'] = $language->get('text_image');
					$data['text_product'] = $language->get('text_product');
					$data['text_quantity'] = $language->get('text_quantity');
					$data['text_price'] = $language->get('text_price');
					$data['text_total'] = $language->get('text_total');
					$data['text_model'] = $language->get('text_model');
					/* Update 30  march */

							if($storecart_info && $mailinfo) {

								$find = array(

									'{store}',

									'{logo}',

									'{firstname}',

									'{lastname}',

									'{email}',

									'{telephone}',

									'{customer_id}',

									'{cart}',

									'{type}',

									'{date_added}',

								);



								$carts_products = $this->model_extension_store_cart_products->getStoreCcartProducts($storecart_info['email']);

								

								$data['products'] = array();

								foreach($carts_products as $product) {

									if ($product['image']) {

										$image = $this->model_tool_image->resize($product['image'], $this->config->get('crownjob_cartimage_width'), $this->config->get('crownjob_cartimage_width'));

									} else {

										$image = '';

									}

									

									$option_data = array();



									foreach ($product['option'] as $option) {

										if ($option['type'] != 'file') {

											$value = $option['value'];

										} else {

											$upload_info = $this->model_tool_upload->getUploadByCode($option['value']);



											if ($upload_info) {

												$value = $upload_info['name'];

											} else {

												$value = '';

											}

										}



										$option_data[] = array(

											'name'  => $option['name'],

											'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value),

											'type'  => $option['type']

										);

									}

									

									// Display prices

									if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {

										$price = $this->currency->format($this->tax->calculate($product['price'], $product['tax_class_id'], $this->config->get('config_tax')),$this->session->data['currency']);

									} else {

										$price = false;

									}



									// Display prices

									if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {

										$total = $this->currency->format($this->tax->calculate($product['price'], $product['tax_class_id'], $this->config->get('config_tax')) * $product['quantity'],$this->session->data['currency']);

									} else {

										$total = false;

									}



									$data['products'][] = array(

										'cart_id'   => $product['cart_id'],

										'thumb'     => $image,

										'name'      => $product['name'],

										'model'     => $product['model'],

										'option'    => $option_data,

										'recurring' => ($product['recurring'] ? $product['recurring']['name'] : ''),

										'quantity'  => $product['quantity'],

										'price'     => $price,

										'total'     => $total,

									);

								}

								

								if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/extension/customer_cart_products')) {

									$cart_html = $this->load->view($this->config->get('config_template') . '/template/extension/customer_cart_products', $data);

								} else {

									$cart_html = $this->load->view('extension/customer_cart_products', $data);

								}

								

								$replace = array(

									'store'     					=> $this->config->get('config_name'),

									'logo'      					=> "<img src='". HTTP_SERVER . 'image/' . $this->config->get('config_logo')."'/>",

									'firstname' 					=> $storecart_info['firstname'],

									'lastname' 	 					=> $storecart_info['lastname'],

									'email'           	  => $storecart_info['email'],

									'telephone' 					=> $storecart_info['telephone'],

									'customer_id' 				=> $storecart_info['customer_id'],

									'cart'					 			=> $cart_html,

									'type' 								=> ucfirst($storecart_info['type']),

									'date_added' 					=> date($this->language->get('date_format_short'), strtotime($storecart_info['date_added'])),

								);


								$subject = str_replace(array("\r\n", "\r", "\n"), '', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '', trim(str_replace($find, $replace, $mailinfo['subject']))));


								$message = str_replace(array("\r\n", "\r", "\n"), '', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '', trim(str_replace($find, $replace, $mailinfo['message']))));

								$dayofreturn = $this->config->get('crownjob_duration');

								$orderdate   = date('Y-m-d', strtotime($storecart_info['date_added']));
								$datesss     = strtotime("+".$dayofreturn." Day ", strtotime($orderdate));
								$expirydate  = date("Y-m-d", $datesss);
								$currentdate = date("Y-m-d");

								if($currentdate < $expirydate){
									$mail = new Mail($this->config->get('config_mail_engine'));

									$mail->parameter = $this->config->get('config_mail_parameter');
						
									$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
						
									$mail->smtp_username = $this->config->get('config_mail_smtp_username');
						
									$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
						
									$mail->smtp_port = $this->config->get('config_mail_smtp_port');
						
									$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

									if(!empty($carts_products)) {		

									$mail->setTo($storecart_info['email']);

									$mail->setFrom($this->config->get('config_email'));

									$mail->setSender(html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8'));

									$mail->setSubject($subject);

									$mail->setHtml(html_entity_decode($message));

									$mail->send();
	 								}
 								}

								$this->model_extension_store_cart->updateNotifyByEmail($storecart_info['email']);

							}

						}

					

					

					$this->model_extension_store_cart->updateStoreCartCrownJobTime();

				}

			}

			

			if(isset($total_customers)) {

				echo $total_customers.' Email Send!';

			}else{

				echo '0 Email Send!';

			}

		}else{

			echo 'Status Disabled!';

		}
	}

	// Store Cart Ends

}