<?php

use Opencartvip\Opencart\ModuleController;

class ControllerOpencartvipBlogCategories extends ModuleController {

	public function __construct($registry) {
		parent::__construct($registry);

		$this->load->model('opencartvip/blog');
	}

	/**
	 * @param \Opencartvip\Options\Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseGeneralSettings($parser, $index) {
		$results = $this->model_opencartvip_blog->getCategories();

		$items = array();

		foreach ($results as $result) {
			$items[] = array(
				'classes' => array('module-item'),
				'name'    => $result['name'],
				'href'    => $this->url->link('opencartvip/blog', 'opencartvip_blog_category_id=' . $result['category_id']),
			);
		}

		return array(
			'items' => $items,
		);
	}

	/**
	 * @param \Opencartvip\Options\Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseItemSettings($parser, $index) {
		return array();
	}

	/**
	 * @param \Opencartvip\Options\Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseSubitemSettings($parser, $index) {
		return array();
	}

}
