<?php

use Opencartvip\Opencart\ModuleController;

class ControllerOpencartvipBlogComments extends ModuleController {

	public function __construct($registry) {
		parent::__construct($registry);

		$this->load->model('opencartvip/blog');
	}

	/**
	 * @param \Opencartvip\Options\Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseGeneralSettings($parser, $index) {
		$results = $this->model_opencartvip_blog->getLatestComments();

		$items = array();

		foreach ($results as $result) {
			$items[] = array(
				'classes'  => array(
					'module-item',
				),
				'title'    => $result['post'],
				'avatar'   => md5(strtolower(trim($result['email']))),
				'href'     => $this->url->link('opencartvip/blog/post', 'opencartvip_blog_post_id=' . $result['post_id']) . '#c' . $result['comment_id'],
				'subtitle' => 'Admin',
			);
		}

		return array(
			'items' => $items,
		);
	}

	/**
	 * @param \Opencartvip\Options\Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseItemSettings($parser, $index) {
		return array();
	}

	/**
	 * @param \Opencartvip\Options\Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseSubitemSettings($parser, $index) {
		return array();
	}

}
