<?php

use Opencartvip\Opencart\ModuleController;

class ControllerOpencartvipBlogSearch extends ModuleController {

	public function __construct($registry) {
		parent::__construct($registry);

		$this->load->model('opencartvip/blog');
	}

	/**
	 * @param \Opencartvip\Options\Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseGeneralSettings($parser, $index) {
		return array(
			'search' => \Opencartvip\Utils\Arr::get($this->request->get, 'opencartvip_blog_search'),
			'url'    => $this->url->link('opencartvip/blog', 'opencartvip_blog_search='),
		);
	}

	/**
	 * @param \Opencartvip\Options\Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseItemSettings($parser, $index) {
		return array();
	}

	/**
	 * @param \Opencartvip\Options\Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseSubitemSettings($parser, $index) {
		return array();
	}

}
