<?php

use Opencartvip\Opencart\ModuleController;

class ControllerOpencartvipBlogTags extends ModuleController {

	public function __construct($registry) {
		parent::__construct($registry);

		$this->load->model('opencartvip/blog');
	}

	/**
	 * @param \Opencartvip\Options\Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseGeneralSettings($parser, $index) {
		$results = $this->model_opencartvip_blog->getTags($parser ->getSetting('limit'));

		$items = array();

		foreach ($results as $result) {
			$items[] = array(
				'name' => $result,
				'href' => $this->url->link('opencartvip/blog', 'opencartvip_blog_tag=' . $result),
			);
		}

		return array(
			'items' => $items,
		);
	}

	/**
	 * @param \Opencartvip\Options\Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseItemSettings($parser, $index) {
		return array();
	}

	/**
	 * @param \Opencartvip\Options\Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseSubitemSettings($parser, $index) {
		return array();
	}

}
