<?php

use Opencartvip\Opencart\ModuleController;
use Opencartvip\Options\Parser;

class ControllerOpencartvipCatalog extends ModuleController {

	public function __construct($registry) {
		parent::__construct($registry);
		$this->load->model('catalog/category');
		$this->load->model('catalog/manufacturer');
		$this->load->model('catalog/product');
		$this->load->model('opencartvip/category');
		$this->load->model('opencartvip/product');
	}

	public function index($args) {
		$data = parent::index($args);

		if (!$data) {
			return null;
		}

		if ($this->settings['carousel']) {
			$this->opencartvip->document->addStyle('catalog/view/theme/opencartvip/lib/swiper/swiper.min.css');
			$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/swiper/swiper.min.js', 'footer');
		}

		return $data;
	}

	/**
	 * @param Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseGeneralSettings($parser, $index) {
		$data = array(
			'classes'         => array(
				'carousel-mode'  => $parser->getSetting('carousel'),
				'image-on-hover' => $parser->getSetting('changeImageOnHover'),
			),
			'carouselOptions' => $this->opencartvip->carousel($parser->getJs(), 'carouselStyle'),
		);

		if ($this->opencartvip->settings->get('performanceLazyLoadImagesStatus')) {
			$data['dummy_image'] = $this->model_opencartvip_image->transparent($parser->getSetting('imageDimensions.width'), $parser->getSetting('imageDimensions.height'));
		}

		return $data;
	}

	/**
	 * @param Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseItemSettings($parser, $index) {
		$data = array(
			'classes' => array(
				'swiper-slide' => $this->settings['carousel'],
			),
			'items'   => array(),
			'image'   => '',
			'name'    => '',
			'href'    => '',
		);

		switch ($parser->getSetting('type')) {
			case 'category':
				$category_info = $this->model_catalog_category->getCategory($parser->getSetting('category'));

				if (!$category_info) {
					return null;
				}

				$data['href'] = $this->url->link('product/category', 'path=' . $parser->getSetting('category'));
				$data['name'] = $category_info['name'];

				if ($this->settings['images']) {
					$data['image'] = $this->model_opencartvip_image->resize($category_info['image'], $this->settings['imageDimensions']['width'], $this->settings['imageDimensions']['height'], $this->settings['imageDimensions']['resize']);
					$data['image2x'] = $this->model_opencartvip_image->resize($category_info['image'], $this->settings['imageDimensions']['width'] * 2, $this->settings['imageDimensions']['height'] * 2, $this->settings['imageDimensions']['resize']);
				}

				switch ($parser->getSetting('subtype')) {
					case 'category':
						$data['total'] = $this->model_opencartvip_category->getTotalCategories($parser->getSetting('category'));

						$results = $this->model_opencartvip_category->getCategories($parser->getSetting('category'), $parser->getSetting('limit'));

						foreach ($results as $result) {
							$data['items'][] = array(
								'name'    => $result['name'],
								'href'    => $this->url->link('product/category', 'path=' . $parser->getSetting('category') . '_' . $result['category_id']),
								'image'   => $this->model_opencartvip_image->resize($result['image'], $this->settings['imageDimensions']['width'], $this->settings['imageDimensions']['height'], $this->settings['imageDimensions']['resize']),
								'image2x' => $this->model_opencartvip_image->resize($result['image'], $this->settings['imageDimensions']['width'] * 2, $this->settings['imageDimensions']['height'] * 2, $this->settings['imageDimensions']['resize']),
							);
						}

						break;

					case 'product':
						$filter_data = array(
							'filter_category_id' => $parser->getSetting('category'),
							'limit'              => $parser->getSetting('limit'),
						);

						$data['total'] = $this->model_opencartvip_product->getTotalProducts($filter_data);

						$results = $this->model_opencartvip_product->getProducts($filter_data);

						foreach ($results as $result) {
							$data['items'][] = array(
								'name'    => $result['name'],
								'href'    => $this->url->link('product/product', 'path=' . $parser->getSetting('category') . '&product_id=' . $result['product_id']),
								'image'   => $this->model_opencartvip_image->resize($result['image'], $this->settings['imageDimensions']['width'], $this->settings['imageDimensions']['height'], $this->settings['imageDimensions']['resize']),
								'image2x' => $this->model_opencartvip_image->resize($result['image'], $this->settings['imageDimensions']['width'] * 2, $this->settings['imageDimensions']['height'] * 2, $this->settings['imageDimensions']['resize']),
							);
						}

						break;

					default:
						return null;
				}

				break;

			case 'manufacturer';
				$manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($parser->getSetting('manufacturer'));

				if (!$manufacturer_info) {
					return null;
				}

				$data['href'] = $this->url->link('product/manufacturer/info', 'manufacturer_id=' . $parser->getSetting('manufacturer'));
				$data['name'] = $manufacturer_info['name'];

				if ($this->settings['images']) {
					$data['image'] = $this->model_opencartvip_image->resize($manufacturer_info['image'], $this->settings['imageDimensions']['width'], $this->settings['imageDimensions']['height'], $this->settings['imageDimensions']['resize']);
					$data['image2x'] = $this->model_opencartvip_image->resize($manufacturer_info['image'], $this->settings['imageDimensions']['width'] * 2, $this->settings['imageDimensions']['height'] * 2, $this->settings['imageDimensions']['resize']);
				}

				$filter_data = array(
					'filter_manufacturer_id' => $parser->getSetting('manufacturer'),
					'limit'                  => $parser->getSetting('limit'),
				);

				$data['total'] = $this->model_opencartvip_product->getTotalProducts($filter_data);

				$results = $this->model_opencartvip_product->getProducts($filter_data);

				foreach ($results as $result) {
					$data['items'][] = array(
						'name'    => $result['name'],
						'href'    => $this->url->link('product/product', 'manufacturer_id=' . $result['manufacturer_id'] . '&product_id=' . $result['product_id']),
						'image'   => $this->model_opencartvip_image->resize($result['image'], $this->settings['imageDimensions']['width'], $this->settings['imageDimensions']['height'], $this->settings['imageDimensions']['resize']),
						'image2x' => $this->model_opencartvip_image->resize($result['image'], $this->settings['imageDimensions']['width'] * 2, $this->settings['imageDimensions']['height'] * 2, $this->settings['imageDimensions']['resize']),
					);
				}

				break;

			default:
				return null;
		}

		return $data;
	}

	/**
	 * @param Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseSubitemSettings($parser, $index) {
		return array();
	}

}
