<?php

use Opencartvip\Opencart\MenuController;
use Opencartvip\Options\Parser;

class ControllerOpencartvipFlyoutMenu extends MenuController {

	/**
	 * @param Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseGeneralSettings($parser, $index) {
		$display = $this->opencartvip->document->isMobile() ? 'accordion' : 'dropdown';

		$data = array(
			'classes' => array(
				'accordion-menu' => $display !== 'dropdown',

			),
			'display' => $display,
			'first'   => false,
		);

		return $data;
	}

	/**
	 * @param Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseItemSettings($parser, $index) {
		return array();
	}

	/**
	 * @param Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseSubitemSettings($parser, $index) {
		return $this->parseItemSettings($parser, $index);
	}

}
