<?php

use Opencartvip\Opencart\Controller;
use Opencartvip\Utils\Arr;

class ControllerOpencartvipSearch extends Controller {

	public function index() {
		$search = Arr::get($this->request->get, 'search');
		$category_id = Arr::get($this->request->get, 'category_id');

		$url = '';

		if ($search) {
			$url .= '&search=' . urlencode(html_entity_decode($this->request->get['search'], ENT_QUOTES, 'UTF-8'));
		}

		$limit = (int)$this->opencartvip->settings->get('searchStyleSearchAutoSuggestLimit');

		if (!$limit) {
			$limit = 10;
		}

		$filter_data = array(
			'filter_name'        => $search,
			'filter_description' => $this->opencartvip->settings->get('searchStyleSearchAutoSuggestDescription'),
			'start'              => 0,
			'limit'              => $limit,
		);

		if ($category_id) {
			$filter_data['filter_category_id'] = $category_id;
		}

		$this->load->model('catalog/product');
		$this->load->model('opencartvip/image');

		$products = array();

		$results = $this->model_catalog_product->getProducts($filter_data);

		foreach ($results as $result) {
			if ($result['image']) {
				$image = $this->model_opencartvip_image->resize($result['image'], $this->opencartvip->settings->get('image_dimensions_autosuggest.width'), $this->opencartvip->settings->get('image_dimensions_autosuggest.height'), $this->opencartvip->settings->get('image_dimensions_autosuggest.resize'));
				$image2 = $this->model_opencartvip_image->resize($result['image'], $this->opencartvip->settings->get('image_dimensions_autosuggest.width') * 2, $this->opencartvip->settings->get('image_dimensions_autosuggest.height') * 2, $this->opencartvip->settings->get('image_dimensions_autosuggest.resize'));
			} else {
				$image = $this->model_opencartvip_image->resize('placeholder.png', $this->opencartvip->settings->get('image_dimensions_autosuggest.width'), $this->opencartvip->settings->get('image_dimensions_autosuggest.height'), $this->opencartvip->settings->get('image_dimensions_autosuggest.resize'));
				$image2 = $this->model_opencartvip_image->resize('placeholder.png', $this->opencartvip->settings->get('image_dimensions_autosuggest.width') * 2, $this->opencartvip->settings->get('image_dimensions_autosuggest.height') * 2, $this->opencartvip->settings->get('image_dimensions_autosuggest.resize'));
			}

			if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
				$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
			} else {
				$price = false;
			}

			if ((float)$result['special']) {
				$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
			} else {
				$special = false;
			}

			$products[] = array(
				'product_id' => $result['product_id'],
				'name'       => html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8'),
				'thumb'      => $image,
				'thumb2'     => $image2,
				'price'      => $price,
				'special'    => $special,
				'href'       => $this->url->link('product/product', '&search=' . urlencode(html_entity_decode($this->request->get['search'], ENT_QUOTES, 'UTF-8')) . '&product_id=' . $result['product_id'] . $url),
			);
		}

		if ($products) {
			$url = '';

			if (isset($this->request->get['search'])) {
				$url .= '&search=' . urlencode(html_entity_decode($this->request->get['search'], ENT_QUOTES, 'UTF-8'));
			}

			if ($this->opencartvip->settings->get('searchStyleSearchAutoSuggestDescription')) {
				$url .= '&description=true';
			}

			if (isset($this->request->get['category_id'])) {
				$url .= '&category_id=' . $this->request->get['category_id'];
			}

			if (isset($this->request->get['sub_category'])) {
				$url .= '&sub_category=' . $this->request->get['sub_category'];
			}

			$products[] = array(
				'view_more' => true,
				'name'      => $this->opencartvip->settings->get('searchStyleSearchViewMoreText'),
				'href'      => $this->url->link('product/search', $url),
			);
		} else {
			$products[] = array(
				'no_results' => true,
				'name'       => $this->opencartvip->settings->get('searchStyleSearchNoResultsText'),
			);
		}

		$this->renderJson('success', $products);
	}

}
