<?php

use Opencartvip\Cache;
use Opencartvip\Opencart\Controller;
use Opencartvip\Options\Option;
use Opencartvip\Options\Parser;
use Opencartvip\Utils\Arr;
use Opencartvip\Utils\Request;

class ControllerOpencartvipSettings extends Controller {

	public function index() {
		Parser::setConfig('language_id', $this->opencartvip->getLanguageId());
		Parser::setConfig('currency_id', $this->opencartvip->getCurrencyId());
		Parser::setConfig('rtl', $this->language->get('direction') === 'rtl');
		Parser::setConfig('device', $this->opencartvip->document->getDevice());
		Parser::setConfig('customer', $this->opencartvip->isCustomer());
		Parser::setConfig('customer_group_id', $this->opencartvip->getCustomerGroupId());
		Parser::setConfig('store_id', $this->opencartvip->getStoreId());
		Parser::setConfig('admin', $this->opencartvip->isAdmin());

		if ($this->customer->isLogged()) {
			$this->load->model('account/wishlist');
			$wishlist_count = $this->model_account_wishlist->getTotalWishlist();
		} else {
			$wishlist_count = isset($this->session->data['wishlist']) ? count($this->session->data['wishlist']) : 0;
		}

		$compare_count = isset($this->session->data['compare']) ? count($this->session->data['compare']) : 0;

		Cache::setConfig('language_id', $this->opencartvip->getLanguageId());
		Cache::setConfig('currency_id', $this->opencartvip->getCurrencyId());
		Cache::setConfig('store_id', $this->opencartvip->getStoreId());
		Cache::setConfig('device', $this->opencartvip->document->getDevice());
		Cache::setConfig('customer', $this->opencartvip->isCustomer());
		Cache::setConfig('customer_group_id', $this->opencartvip->getCustomerGroupId());
		Cache::setConfig('wishlist', $wishlist_count);
		Cache::setConfig('compare', $compare_count);

		$this->_cache_key = 'settings';

		if ($this->_cache === false) {
			$variables = $this->model_opencartvip_settings->getVariables();
			$settings = $this->model_opencartvip_settings->getSettings();

			Option::setVariables($variables);

			$cache = array(
				'variables' => $variables,
				'php'       => array(),
				'js'        => array(),
				'fonts'     => array(),
				'css'       => '',
			);

			// css hash
			$cache['php']['css_file'] = 'style.' . substr(md5(time()) . Cache::getKey(), 0, 8) . '.css';

			// settings
			$files = array(
				'system/system',

				'settings/active_skin',
				'settings/blog',
				'settings/custom_code',
				'settings/general',
				'settings/performance',
				'settings/seo',

				'skin/blog/post',
				'skin/blog/posts',

				'skin/footer/general',

				'skin/global/countdown',
				'skin/global/general',
				'skin/global/notification',
				'skin/global/quickview',

				'skin/header/general',

				'skin/page/account',
				'skin/page/cart',
				'skin/page/category',
				'skin/page/checkout',
				'skin/page/compare',
				'skin/page/contact',
				'skin/page/information',
				'skin/page/maintenance',
				'skin/page/manufacturers',
				'skin/page/search',
				'skin/page/sitemap',
				'skin/page/wishlist',

				'skin/product/general',

				'skin/products/general',

				'skin/image_dimensions',

				'skin/catalog_mode',
			);

			$parser = new Parser($files, $settings);

			$cache['php'] += $parser->getPhp();
			$cache['js'] += $parser->getJs();
			$cache['fonts'] += $parser->getFonts();
			$cache['css'] .= $parser->getCss();

			// desktop header
			if ($data = Arr::get($cache, 'php.headerDesktop')) {
				list ($module_id, $module_type) = explode('/', $data);

				$settings = $this->model_opencartvip_module->get($module_id, $module_type);

				$files = glob(DIR_SYSTEM . 'library/opencartvip/data/settings/module/header_desktop/{*,*/*}.json', GLOB_BRACE);

				foreach ($files as &$file) {
					$file = str_replace(DIR_SYSTEM . 'library/opencartvip/data/settings/', '', $file);
					$file = str_replace('.json', '', $file);
				}

				$parser = new Parser($files, $settings['general']);

				$cache['php']['headerType'] = str_replace('header_desktop_', '', $module_type);
				$cache['php'] += $parser->getPhp();
				$cache['js'] += $parser->getJs();
				$cache['js']['headerType'] = $cache['php']['headerType'];
				$cache['fonts'] += $parser->getFonts();
				$cache['css'] .= $parser->getCss();
			}

			// mobile header
			if ($data = Arr::get($cache, 'php.headerMobile')) {
				list ($module_id, $module_type) = explode('/', $data);

				$settings = $this->model_opencartvip_module->get($module_id, $module_type);

				$files = glob(DIR_SYSTEM . 'library/opencartvip/data/settings/module/header_mobile/{*,*/*}.json', GLOB_BRACE);

				foreach ($files as &$file) {
					$file = str_replace(DIR_SYSTEM . 'library/opencartvip/data/settings/', '', $file);
					$file = str_replace('.json', '', $file);
				}

				$parser = new Parser($files, $settings['general']);

				$cache['php']['mobileHeaderType'] = str_replace('header_mobile_', '', $module_type);
				$cache['php'] += $parser->getPhp();
				$cache['js'] += $parser->getJs();
				$cache['fonts'] += $parser->getFonts();
				$cache['css'] .= $parser->getCss();
			}

			$cache['css'] .= strip_tags($this->load->view('opencartvip/css', array('data' => $cache['php'])));

//			$files = glob($this->opencartvip->minifier->getAssetsPath() . 'style.*');
//
//			foreach ($files as $file) {
//				if (is_file($file)) {
//					@unlink($file);
//				}
//			}
//
//			file_put_contents($this->opencartvip->minifier->getAssetsPath() . $cache['php']['css_file'], $cache['css']);
//
//			unset($cache['css']);

			// set cache
			$this->_cache = $cache;
		} else {
			Option::setVariables($this->_cache['variables']);
		}

		$this->opencartvip->settings->load($this->_cache['php']);
		$this->opencartvip->document->addJs($this->_cache['js']);
		$this->opencartvip->document->addFonts($this->_cache['fonts']);
		$this->opencartvip->document->addCss($this->_cache['css']);

		// image dimensions
		$image_dimensions = array_keys(json_decode(file_get_contents(DIR_SYSTEM . 'library/opencartvip/data/settings/skin/image_dimensions.json'), true));

		foreach ($image_dimensions as $image_dimension) {
			$dimensions = $this->opencartvip->settings->get($image_dimension);

			$this->config->set(str_replace('image_dimensions_', 'theme_opencartvip_image_', $image_dimension) . '_width', $dimensions['width']);
			$this->config->set(str_replace('image_dimensions_', 'theme_opencartvip_image_', $image_dimension) . '_height', $dimensions['height']);
		}

		// other settings
		$this->config->set('theme_opencartvip_product_limit', $this->opencartvip->settings->get('productLimit'));
		$this->config->set('theme_opencartvip_product_description_length', $this->opencartvip->settings->get('productDescriptionLimit'));

		// performance
		$ignored_routes = array(
			'account/',
			'checkout/',
			'extension/payment/',
		);

		if (
			$this->opencartvip->settings->get('developerMode')
			|| !$this->opencartvip->settings->get('performanceMinifiersStatus')
			|| !Request::isGet()
			|| Request::matches($ignored_routes)
		) {
			$this->opencartvip->settings->set('performanceHTMLMinify', false);
			$this->opencartvip->settings->set('performanceCSSMinify', false);
			$this->opencartvip->settings->set('performanceCSSInline', false);
			$this->opencartvip->settings->set('performanceJSMinify', false);
			$this->opencartvip->settings->set('performanceJSDefer', false);
		}

		// disable defer on routes
		$ignored_routes = array(
			'product/',
		);

		if (Request::matches($ignored_routes)) {
			$this->opencartvip->settings->set('performanceJSDefer', false);
		}

		// cdn
		if ($this->opencartvip->settings->get('performanceCDNStatus')) {
			if (Request::isHttps()) {
				$static_url = $this->opencartvip->settings->get('performanceCDNHttps');
			} else {
				$static_url = $this->opencartvip->settings->get('performanceCDNHttp');
			}

			if ($static_url) {
				define('OPENCARTVIP_STATIC_URL', $static_url);
			}
		}

		// active skin + active store
		$this->opencartvip->document->addClass('store-' . $this->opencartvip->getStoreId());
		$this->opencartvip->document->addClass('skin-' . $this->opencartvip->settings->get('active_skin'));

		// boxed layout
		if ($this->opencartvip->settings->get('globalPageBoxedLayout') === 'boxed') {
			$this->opencartvip->document->addClass('boxed-layout');
		}

		// active header
		if ((($this->opencartvip->settings->get('mobileHeaderOn') === 'phone') && $this->opencartvip->document->isPhone()) || (($this->opencartvip->settings->get('mobileHeaderOn') === 'tablet') && $this->opencartvip->document->isMobile())) {
			$this->opencartvip->document->addClass('mobile-header-active');
		} else {
			$this->opencartvip->document->addClass('desktop-header-active');
		}

		// sticky header compact desktop
		if ($this->opencartvip->settings->get('stickyStatus') && in_array($this->opencartvip->settings->get('headerType'), array('slim', 'compact'))) {
			$this->opencartvip->document->addClass('compact-sticky');
		}

		// mobile sticky
		if ($this->opencartvip->settings->get('headerMobileStickyStatus')) {
			$this->opencartvip->document->addClass('mobile-sticky');
		}

		// logo
		if ($this->opencartvip->settings->get('logo')) {
			$logo = $this->opencartvip->settings->get('logo');
		} else {
			$logo = $this->config->get('config_logo');
		}

		if (is_file(DIR_IMAGE . $logo)) {
			list ($width, $height) = getimagesize(DIR_IMAGE . $logo);

			$this->opencartvip->settings->set('logo_width', $width);
			$this->opencartvip->settings->set('logo_height', $height);
			$this->opencartvip->settings->set('logo_src', $this->model_opencartvip_image->resize($logo));

			$logo2x = $this->opencartvip->settings->get('logo2x');

			if (is_file(DIR_IMAGE . $logo2x)) {
				$this->opencartvip->settings->set('logo2x_src', $this->model_opencartvip_image->resize($logo2x));
			} else {
				$this->opencartvip->settings->set('logo2x_src', false);
			}
		} else {
			$this->opencartvip->settings->set('logo_src', false);
		}

		// default view
		if (isset($this->request->cookie['view'])) {
			$this->opencartvip->settings->set('globalProductView', $this->request->cookie['view']);
		}

		// old browser
		if ($this->opencartvip->settings->get('oldBrowserStatus') && $this->opencartvip->document->hasClass('ie') && !$this->opencartvip->document->hasClass('edge')) {
			$this->opencartvip->settings->set('oldBrowserChrome', $this->model_opencartvip_image->resize('catalog/opencartvip/misc/chrome.png'));
			$this->opencartvip->settings->set('oldBrowserFirefox', $this->model_opencartvip_image->resize('catalog/opencartvip/misc/firefox.png'));
			$this->opencartvip->settings->set('oldBrowserEdge', $this->model_opencartvip_image->resize('catalog/opencartvip/misc/edge.png'));
			$this->opencartvip->settings->set('oldBrowserOpera', $this->model_opencartvip_image->resize('catalog/opencartvip/misc/opera.png'));
			$this->opencartvip->settings->set('oldBrowserSafari', $this->model_opencartvip_image->resize('catalog/opencartvip/misc/safari.png'));
		} else {
			$this->opencartvip->settings->set('oldBrowserStatus', false);
		}

		// catalog mode
		if (!$this->opencartvip->settings->get('catalogLanguageStatus')) {
			$this->opencartvip->document->addClass('no-language');
		}

		if (!$this->opencartvip->settings->get('catalogCurrencyStatus')) {
			$this->opencartvip->document->addClass('no-currency');
		}

		if (!$this->opencartvip->settings->get('catalogSearchStatus')) {
			$this->opencartvip->document->addClass('no-search');
		}

		if (!$this->opencartvip->settings->get('catalogMiniCartStatus')) {
			$this->opencartvip->document->addClass('no-mini-cart');
		}

		if (!$this->opencartvip->settings->get('catalogCartStatus')) {
			$this->opencartvip->document->addClass('no-cart');
		}

		if (!$this->opencartvip->settings->get('catalogWishlistStatus')) {
			$this->opencartvip->document->addClass('no-wishlist');
		}

		if (!$this->opencartvip->settings->get('catalogCompareStatus')) {
			$this->opencartvip->document->addClass('no-compare');
		}

		// columns status on tablet
		if ($this->opencartvip->document->isTablet()) {
			if (!$this->opencartvip->settings->get('globalPageColumnLeftTabletStatus')) {
				$this->opencartvip->document->addClass('left-column-disabled');
			}

			if (!$this->opencartvip->settings->get('globalPageColumnRightTabletStatus')) {
				$this->opencartvip->document->addClass('right-column-disabled');
			}
		}

	}
}
