<?php

use Opencartvip\Opencart\Controller;
use Opencartvip\Utils\Arr;

class ControllerOpencartvipStartup extends Controller {

	public function index() {
		if ($this->config->get('config_theme') === 'opencartvip' || $this->config->get('config_theme') === 'theme_opencartvip' || $this->config->get('config_template') === 'opencartvip') {
			// needed for Stock: column_stock
			$this->load->language('account/wishlist');

			// redirect wrong hostname to avoid cors
//			if (Request::isGet()) {
//				$current_url = Request::getCurrentUrl();
//				$correct_url = $this->url->link('');
//
//				$current_host = parse_url($current_url, PHP_URL_SCHEME) . '://' . parse_url($current_url, PHP_URL_HOST);
//				$correct_host = parse_url($correct_url, PHP_URL_SCHEME) . '://' . parse_url($correct_url, PHP_URL_HOST);
//
//				if ($current_host !== $correct_host) {
//					$url = str_replace($current_host, $correct_host, $current_url);
//
//					if (!headers_sent()) {
//						header('Location: ' . $url);
//					} else {
//						echo '<script>location = "' . $url . '";</script>';
//					}
//
//					exit;
//				}
//			}

			define('OPENCARTVIP_CATALOG', true);
			define('OPENCARTVIP_ACTIVE', true);

			$this->registry->set('opencartvip', new Opencartvip($this->registry));

			// assets folder writable
			if (!is_writable($this->opencartvip->minifier->getAssetsPath())) {
				$this->print_error($this->opencartvip->minifier->getAssetsPath() . ' is not writable! <br /> <br /> <br /> <b style="color: red">Consult with your hosting provider for more information.</b>');
			}

			// document classes
			if ($this->opencartvip->isAdmin()) {
				$this->opencartvip->document->addClass('is-admin');
			}

			if ($this->opencartvip->isCustomer()) {
				$this->opencartvip->document->addClass('is-customer');
			} else {
				$this->opencartvip->document->addClass('is-guest');
			}

			if ($this->config->get('config_maintenance') && !$this->opencartvip->isAdmin()) {
				$this->opencartvip->document->addClass('maintenance-page');
			}

			// models
			$this->load->model('opencartvip/settings');
			$this->load->model('opencartvip/module');
			$this->load->model('opencartvip/image');

			// settings
			$this->load->controller('opencartvip/settings');

			// modernizr
			$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/modernizr/modernizr-custom.js');

			// jquery
			if ($this->opencartvip->isOC1()) {
				$this->opencartvip->document->addStyle('catalog/view/javascript/jquery/ui/themes/ui-lightness/jquery-ui-1.8.16.custom.css');
				$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/jquery/jquery-2.1.1.min.js');
				$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/jquery/jquery-migrate-1.2.1.min.js');
				$this->opencartvip->document->addScript('catalog/view/javascript/jquery/ui/jquery-ui-1.8.16.custom.min.js');
			} else {
				if ($this->opencartvip->isOC31()) {
					$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/jquery/jquery-3.3.1.js');
				} else {
					$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/jquery/jquery-2.1.1.min.js');
				}
			}

			// anime
			$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/anime/anime.min.js');

			// bootstrap
			if ($this->opencartvip->isOC1()) {
				$this->opencartvip->document->addStyle('catalog/view/theme/opencartvip/lib/bootstrap/css/bootstrap.min.css');
				$this->opencartvip->document->addStyle('catalog/view/theme/opencartvip/lib/font-awesome/css/font-awesome.min.css');
				$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/bootstrap/js/bootstrap.min.js');
			} else {
				$this->opencartvip->document->addStyle('catalog/view/javascript/bootstrap/css/bootstrap.min.css');
				$this->opencartvip->document->addStyle('catalog/view/javascript/font-awesome/css/font-awesome.min.css');

				if ($this->opencartvip->isOC31()) {
					$this->opencartvip->document->addScript('catalog/view/javascript/bootstrap/js/popper.min.js');
				}

				$this->opencartvip->document->addScript('catalog/view/javascript/bootstrap/js/bootstrap.min.js');
			}

			// bootstrap rtl
			if ($this->language->get('direction') === 'rtl') {
				$this->opencartvip->document->addStyle('catalog/view/theme/opencartvip/lib/bootstrap-rtl/bootstrap-rtl.min.css');
			}

			// lazy sizes
			if ($this->opencartvip->settings->get('performanceLazyLoadImagesStatus')) {
				$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/lazysizes/lazysizes.min.js', 'footer');
				$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/lazysizes/intersection-observer.js', 'footer');
			}

			// icons
			$this->opencartvip->document->addStyle('catalog/view/theme/opencartvip/icons/style.css');

			// common.js
			$this->opencartvip->document->addScript('catalog/view/javascript/common.js');

			// countdown
			$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/countdown/jquery.countdown.min.js', 'footer');

			// inobounce
			if ($this->opencartvip->document->isMobile()) {
				$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/inobounce/inobounce.min.js', 'footer');
			}

			// typeahead
			if ($this->opencartvip->settings->get('searchStyleSearchAutoSuggestStatus')) {
				$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/typeahead/typeahead.jquery.min.js', 'footer');
			}

			// hover intent
			$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/hoverintent/jquery.hoverIntent.min.js');

			// sticky
			//$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/sticky/sticky.min.js', 'footer');

			// infinite scroll
			if (in_array(Arr::get($this->request->get, 'route', ''), array(
				'product/catalog',
				'product/category',
				'product/manufacturer/info',
				'product/search',
				'product/special',
			))) {
				$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/ias/jquery-ias.min.js', 'footer');
			}

			// cookie
			$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/cookie/cookie.js', 'footer');

			// admin
			if ($this->opencartvip->isAdmin()) {
				$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/js/admin.js', 'footer');
			}

			// product extras
			$this->load->controller('opencartvip/product/extras', array('module_type' => 'product_label'));
			$this->load->controller('opencartvip/product/extras', array('module_type' => 'product_extra_button'));
			$this->load->controller('opencartvip/product/extras', array('module_type' => 'product_blocks'));
			$this->load->controller('opencartvip/product/second_image');
			$this->load->controller('opencartvip/product/countdown');

			// mega menu info blocks
			if ($this->opencartvip->settings->get('headerType') === 'mega' && $this->opencartvip->settings->get('infoBlocksModule')) {
				$this->opencartvip->settings->set('headerInfoBlocks', $this->load->controller('opencartvip/info_blocks', array(
					'module_id'   => $this->opencartvip->settings->get('infoBlocksModule'),
					'module_type' => 'info_blocks',
				)));
			}
		}
	}

	public function error() {
		if (!defined('OPENCARTVIP_INSTALLED')) {
			return;
		}

		if (
			($this->config->get('config_theme') === 'theme_default' || $this->config->get('config_theme') === 'default') &&
			($this->config->get('config_template') === 'opencartvip' || $this->config->get('theme_default_directory') === 'opencartvip')) {
			$this->print_error('Opencartvip must be activated from System > Settings > Your Store > General > Theme and not from Extension > Extension > Themes (like in Opencartvip2).');
		}

		$this->response->redirect($this->url->link('common/home'));
	}

	public function print_error($error) {
		echo "
			<style>
				.content {
					margin: 0 auto;
					max-width: 1024px;
					margin-top: 200px;
					text-align: center;
				}
			</style>
			<div class=\"content\">
				<h2>Opencartvip Theme Installation Error</h2>
				<hr/>
				<p>" . $error . "</p>
			</div>
		";

		exit;
	}
}
