<?php
class ModelAccountCustomerSwitcher extends Model {	
	public function switchCustomer() {
		//for update customer group
		$from_customer_group_id = $this->customer->getGroupId();
		
		$customer_group_value = $this->getCustomerGroup($from_customer_group_id);
		
		$reach_customer_group_id = $customer_group_value['reach_customer_group_id'];
		
		$down_customer_group_id = $customer_group_value['down_customer_group_id'];
		
		if ($reach_customer_group_id && $from_customer_group_id) {
			
			$reach_value = $customer_group_value['reach_value'];
		
			$period = $customer_group_value['period'];
			
			$s_status = $customer_group_value['s_status'];
		
			$ross = $customer_group_value['reach_order_status_ids'];
			
			$custotal=0;
			
			if ($ross) {		
				$values = $this->getOrderTotalValue($ross, $period);
				
				foreach ($values as $value) {
					$custotal = $custotal + $value['total'];
				}
			}
			
			if ($s_status) {
				if ($custotal >= $reach_value) {
					$this->editCustomer($this->customer->getId(), $from_customer_group_id, $reach_customer_group_id);
				}
			}
		} 
		
		if ($down_customer_group_id && $from_customer_group_id) {
			
			$down_group_value = $this->getCustomerGroup($down_customer_group_id);
			
			$down_value = $down_group_value['reach_value'];
		
			$period = $down_group_value['period'];
			
			$downgrade = $down_group_value['downgrade'];
		
			$ross = $down_group_value['reach_order_status_ids'];
			
			$custotal=0;
			
			if ($ross) {		
				$values = $this->getOrderTotalValue($ross, $period);
				
				foreach ($values as $value) {
					$custotal = $custotal + $value['total'];
				}
			}
			
			if ($downgrade) {
				if ($custotal < $down_value) {
					$this->editCustomer($this->customer->getId(), $from_customer_group_id, $down_customer_group_id, '_downgrade');
				}
			}
		}
		//end for            
	}
	
	public function getOrderTotalValue($order_statuses, $period=0) {
		$implode = array();

		foreach ($order_statuses as $order_status_id) {
			$implode[] = "order_status_id = '" . (int)$order_status_id . "'";
		}
		
		$sql = "SELECT total FROM `" . DB_PREFIX . "order` WHERE customer_id = '" . (int)$this->customer->getId() . "' AND (" . implode(" OR ", $implode) . ")";
		
		if ($period>0) {
			$sql .= " AND date_added>= DATE_ADD(CURDATE(), INTERVAL -'" . $period . "' DAY)";
		}
		
		$query = $this->db->query($sql);
	
		return $query->rows; 
	}
	
	public function editCustomer($customer_id, $from_customer_group_id, $to_customer_group_id, $type='_upgrade') {
		$this->db->query("UPDATE " . DB_PREFIX . "customer SET customer_group_id = '" . (int)$to_customer_group_id . "' WHERE customer_id = '" . (int)$customer_id . "'");
	
		//send notify email
		if ($type=='_downgrade') {
			$group_query = $this->db->query("SELECT admin_notify, customer_notify FROM " . DB_PREFIX . "customer_group WHERE customer_group_id = '" . (int)$to_customer_group_id . "'");
		} else {
			$group_query = $this->db->query("SELECT admin_notify, customer_notify FROM " . DB_PREFIX . "customer_group WHERE customer_group_id = '" . (int)$from_customer_group_id . "'");
		}
		
		$group_name = $this->db->query("SELECT `name` FROM " . DB_PREFIX . "customer_group_description WHERE customer_group_id = '" . (int)$to_customer_group_id . "' AND language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		$query = $this->db->query("SELECT email FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'");
		
		$this->load->language('mail/customer_switch');
			
		$mail = new Mail($this->config->get('config_mail_engine'));
		$mail->parameter = $this->config->get('config_mail_parameter');
		$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
		$mail->smtp_username = $this->config->get('config_mail_smtp_username');
		$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
		$mail->smtp_port = $this->config->get('config_mail_smtp_port');
		$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');
		
		$mail->setFrom($this->config->get('config_email'));
		$mail->setSender(html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8'));
		
		if ($group_query->row['customer_notify']) {
		
			$subject = sprintf($this->language->get('text_subject' . $type), $this->config->get('config_name'));
		
			$message = sprintf($this->language->get('text_welcome' . $type), $this->config->get('config_name')) . "\n\n";
	
			$message .= sprintf($this->language->get('text_login'), $group_name->row['name']) . "\n";
		
			$message .= $this->url->link('account/login', '', 'SSL') . "\n\n";
			$message .= $this->language->get('text_services' . $type) . "\n\n";
			$message .= $this->language->get('text_thanks') . "\n";
			$message .= $this->config->get('config_name');
			$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
			$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
			$mail->setTo($query->row['email']);
			$mail->send();
		}
		if ($group_query->row['admin_notify']) {
		// Send to main admin email if new account email is enabled
			$subject = sprintf($this->language->get('text_admin_subject' . $type), $this->config->get('config_name'), $group_name->row['name']);
		
			$message = sprintf($this->language->get('text_admin_content' . $type), $query->row['email'], $group_name->row['name']) . "\n\n";
	
			$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
			$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
			$mail->setTo($this->config->get('config_email'));
			$mail->send();
			
			// Send to additional alert emails if new account email is enabled
			if(strpos($this->config->get('config_mail_alert_email'), ',') !== false) {
				$emails = explode(',', $this->config->get('config_mail_alert_email'));

				foreach ($emails as $email) {
					if (utf8_strlen($email) > 0 && filter_var($email, FILTER_VALIDATE_EMAIL)) {
						$mail->setTo($email);
						$mail->send();
					}
				}
			}
		}
	}
	
	public function getCustomerGroup($customer_group_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "customer_group WHERE customer_group_id = '" . (int)$customer_group_id . "'");
		if (!isset($query->row['reach_value']) || !isset($query->row['reach_customer_group_id']) || !isset($query->row['reach_order_status_ids'])) {
			return array(
				'reach_value' => '',			
				'period' => '',
				'downgrade' => '',
				'reach_customer_group_id' => '',
				'down_customer_group_id' => '',
				'reach_order_status_ids' => '',
				's_status' => '',
			);
		} else {
			return array(
				'reach_value' => $query->row['reach_value'],			
				'period' => $query->row['period'],
				'downgrade' => $query->row['downgrade'],
				'reach_customer_group_id' => $query->row['reach_customer_group_id'],
				'down_customer_group_id' => $query->row['down_customer_group_id'],
				'reach_order_status_ids' => json_decode($query->row['reach_order_status_ids'], true),
				's_status' => $query->row['s_status'],
			);
		}
	}
	
	public function getCustomer($customer_id) {
		$query = $this->db->query("SELECT customer_group_id FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'");
		
		return $query->row['customer_group_id'];
	}
}