<?php
class ModelExtensionStoreCart extends Model {
	public function updateStoreCartCrownJobTime() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "storecart_crownjob ORDER BY date_added DESC LIMIT 0,1");
		
		if($query->row) {
			$this->db->query("UPDATE " . DB_PREFIX . "storecart_crownjob SET date_added = '". date('Y-m-d H:i:s') ."' WHERE storecart_crownjob_id = '". (int)$query->row['storecart_crownjob_id'] ."'");
		}else{
			$this->db->query("INSERT INTO " . DB_PREFIX . "storecart_crownjob SET date_added = '". date('Y-m-d H:i:s') ."'");
		}
	}
	
	public function geStoreCartCrownjob() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "storecart_crownjob ORDER BY date_added DESC LIMIT 0,1");
		
		return $query->row;
	}
	
	public function getStoreCartCustomers($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "storecart WHERE `email` !=''";
		
		$sql .= " AND `email_notify` = '0'";
		
		$sql .= " GROUP BY `email`";
		
		$sql .= " ORDER BY `date_added` DESC";
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getStoreCartsByEmail($data = array()) { 	
		if (!empty($data['filter_notify_order'])) {
			$sql = "SELECT `email_notify`, `product_id`, `option`, `date_added`, `quantity`  FROM " . DB_PREFIX . "storecart_order WHERE LCASE(email) = '". $this->db->escape(utf8_strtolower($data['email'])) ."'";
		}else{
			$sql = "SELECT `email_notify`, `product_id`, `option`, `date_added`, `quantity`  FROM " . DB_PREFIX . "storecart WHERE LCASE(email) = '". $this->db->escape(utf8_strtolower($data['email'])) ."'";
		}
		
		if (isset($data['filter_notify']) && !is_null($data['filter_notify'])) {
			$sql .= " AND email_notify LIKE '%" . $this->db->escape($data['filter_notify']) . "%'";
		}
		
		 $sql .= "ORDER BY date_added DESC";
		
		$query = $this->db->query($sql);

		return $query->rows;
  }
	
	public function getOneStoreCartsByEmail($email){ 	
		$sql = "SELECT * FROM " . DB_PREFIX . "storecart WHERE LCASE(email) = '". $this->db->escape(utf8_strtolower($email)) ."' ORDER BY date_added DESC LIMIT 0,1";
		
		$query = $this->db->query($sql);

		return $query->row;
  }
	
	/* update march */
	public function getMailTemplate($storecart_template_id, $language_id) {
	
		if($language_id==0){
			$language_id = $this->config->get('config_language_id');
		} 
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "storecart_template st LEFT JOIN " . DB_PREFIX . "storecart_template_description std ON (st.storecart_template_id=std.storecart_template_id) WHERE st.storecart_template_id = '" . (int)$storecart_template_id . "' AND std.language_id='". (int)$language_id ."'");

		return $query->row;
	}
	
	public function updateNotifyByEmail($email) {
		$this->db->query("UPDATE " . DB_PREFIX . "storecart SET email_notify = 1 WHERE LCASE(email) = '". $this->db->escape(utf8_strtolower($email)) ."'");
	}
}
