<?php
@set_time_limit(1800);

class ModelUniversalFeedCeneje extends Model {

  public function writeHeader($fh, $config) {
    fwrite($fh, '<?xml version="1.0" encoding="windows-1250"?>'.
                '<CNJExport>'."\n");
  }
  
  public function writeFooter($fh) {
    fwrite($fh, '</CNJExport>');
  }
  
  public function writeBody($fh, $config) {
    $config['filter_store'] = $this->config->get('config_store_id');
    
    $products = $this->model_universal_feed_driver_product->getItems($config);
    
    //$products = $this->model_tool_universal_feed->getProducts($config);

    $price_modifier = !empty($config['price_modifier']) ? $config['price_modifier'] : 1;
    $currency = !empty($config['currency']) ? $config['currency'] : 'USD';
    $gtin = !empty($config['gtin']) ? $config['gtin'] : '';

    $row = 0;
    $save_count = 0;
    
    foreach ($products as $item) {
      if ($this->config->get('univfeed_sleep')) {
        usleep((int) $this->config->get('univfeed_sleep') * 1000); // 1 000 000 = 1s
      }
      
      // fix issues of some special chars in descriptions
      $item['description'] = preg_replace('~[^\P{Cc}\r\n]+~u', '', $item['description']);
      
      $this->session->data['ufeed_lastItem'] = $item['product_id'];
      
      // which price to show?
      $price_order = !empty($config['price_order']) ? explode('_', $config['price_order']) : array('special', 'discount', 'price');
      
      foreach ($price_order as $p) {
        if ($item[$p]) {
          $price_value = $item[$p];
          break;
        } 
      }
      
      if (empty($config['price_tax'])) {
        $price = $this->currency->format($this->tax->calculate($price_value * $price_modifier, $item['tax_class_id']), $currency, false, false);
      } else {
        $price = $this->currency->format($price_value * $price_modifier, $currency, false, false);
      }
      
      // $line = array(
      //   'Name' => $item['name'],
      //   'Model' => $item['model'],
      //   'Link' => $this->url->link('product/product', 'product_id='.$item['product_id']),
      //   'Price' => number_format($price, 2),
      //   'Category' => $item['product_category'],
      //   'Description' => $item['description'],
      //   'Tags' => $item['tag'],
      //   'Status' => $item['stock_status'],
      //   'Quantity' => $item['quantity'],
      //   'Manufacturer' => $item['manufacturer'],
      //   'Meta_Description' => $item['meta_description'],
      //   'ISBN' => $item['isbn'],
      //   'UPC' => $item['upc'],
      //   'EAN' => $item['ean'],
      //   'JAN' => $item['jan'],
      //   'SKU' => $item['sku'],
      //   'Image' => $item['image'],
      //   'Weight' => $this->weight->format($item['weight'], $item['weight_class_id']),
      //   //'Images' => $item['additional_images'],
      //   //'Thumbnail' => $thumb,
      // );
      
      // if (!empty($config['thumbnail']) && !empty($item['image_path'])) {
      //   $line['Thumbnail'] = @$this->model_tool_image->resize($item['image_path'], 400, 400);
      // }

      $output = '<Item>' . "\n";
      $output .= '<ID>'.$item['product_id'].'</ID>' . "\n";
      $output .= '<brand>'.$item['manufacturer'].'</brand>' . "\n";
      $output .= '<price>'.str_replace('.',',',$this->tax->calculate($price_value * $price_modifier, $item['tax_class_id'])).'</price>' . "\n";
      $output .= '<curCode>'.$currency.'</curCode>' . "\n";
      $output .= '<name>'.$item['name'].'</name>' . "\n";
      $output .= '<link>'.$this->url->link('product/product', 'product_id='.$item['product_id']).'</link>' . "\n";
      $output .= '<in_stock>'.$item['stock_status'].'</in_stock>' . "\n";
      $output .= '<EAN>'.$item['ean'].'</EAN>' . "\n";
      $output .= '<UPC>'.$item['upc'].'</UPC>' . "\n";
      $output .= '<stvArtikla>'.$item['sku'].'</stvArtikla>' . "\n";
      $output .= '<modArtikla>'.$item['model'].'</modArtikla>' . "\n";
      $output .= '<slikaVelika>'.$item['image'].'</slikaVelika>' . "\n";
      $output .= '<fileUnder>'.str_replace('>', ' - ', $item['product_category']).'</fileUnder>' . "\n";
      $output .= '<garancija>'."".'</garancija>' . "\n";
      $output .= '<moreImages>'.str_replace('|',',',$item['additional_images']).'</moreImages>' . "\n";
      $output .= '<![CDATA['.$item['description'].']]>' . "\n";
      // foreach ($line as $k => $v) {
      //   if ($v) {
      //     $output .= '<'.$k.'><![CDATA['.html_entity_decode($v, ENT_QUOTES, 'UTF-8').']]></'.$k.'>'."\n";
      //   } else {
      //     $output .= '<'.$k.'/>'."\n";
      //   }
      // }
      
      // $output .= '<Attributes>'."\n";
      // foreach (explode('|', $item['product_attribute']) as $attr) {
      //   if (strpos($attr, ':') !== false) {
      //     $attributes = explode(':', $attr);
      //     if (!empty($attributes)) {
      //       $output .= '<Attribute>';
            
      //       if (isset($attributes[0])) {
      //         $output .= '<group><![CDATA['.html_entity_decode($attributes[0], ENT_QUOTES, 'UTF-8').']]></group>';
      //       }
            
      //       if (isset($attributes[1])) {
      //         $output .= '<name><![CDATA['.html_entity_decode($attributes[1], ENT_QUOTES, 'UTF-8').']]></name>';
      //       }
            
      //       if (isset($attributes[2])) {
      //         $output .= '<value><![CDATA['.html_entity_decode($attributes[2], ENT_QUOTES, 'UTF-8').']]></value>';
      //       }
            
      //       $output .= '</Attribute>'."\n";
      //     }
      //   }
      // }
      // $output .= '</Attributes>'."\n";
      
      $output .= '</Item>' . "\n";
      
      fwrite($fh, $output);
      
      $row++;
    }
    
    // return false when no more products
    return !empty($output);
  }
  
  public function getTotalItems($data = array()) {
    return $this->model_universal_feed_driver_product->getTotalItems($data);
  }
  
  private function getGoogleCategory($product_id) {
		$gcats = array();
		$categories = $this->db->query("SELECT c.google_merchant_id, cd.name FROM " . DB_PREFIX . "product_to_category p2c LEFT JOIN " . DB_PREFIX . "category c ON (p2c.category_id = c.category_id) LEFT JOIN " . DB_PREFIX . "category_description cd ON (c.category_id = cd.category_id) AND cd.language_id = " . $this->config->get('config_language_id') . " WHERE product_id = '" . (int)$product_id . "'")->rows;
		
		foreach($categories as $category) {
      if (!empty($category['google_merchant_id'])) {
        return array(
          'id' => $category['google_merchant_id'],
          'name' => $category['name'],
        );
      }
		}
	}
}