<?php
@set_time_limit(1800);

class ModelUniversalFeedCommonFeedJson extends Model {

  public function writeHeader($fh, $config) {
    fwrite($fh, "[\n");
  }
  
  public function writeFooter($fh, $config) {
    /*
    fclose($fh);
    $fh = fopen($config['temp_file'], 'r+');
    $stat = fstat($fh);
    ftruncate($fh, $stat['size']-4);
    fclose($fh);
    $fh = fopen($config['temp_file'], 'a');
    */
    fwrite($fh, "\n]");
  }
  
  public function writeBody($fh, $config) {
    $config['filter_store'] = $this->config->get('config_store_id');
    
    $products = $this->model_universal_feed_driver_product->getItems($config);
    
    //$products = $this->model_tool_universal_feed->getProducts($config);

    $price_modifier = !empty($config['price_modifier']) ? $config['price_modifier'] : 1;
    $currency = !empty($config['currency']) ? $config['currency'] : 'USD';
    $gtin = !empty($config['gtin']) ? $config['gtin'] : '';

    $row = 0;
    $save_count = 0;
    
    foreach ($products as $item) {
      if ($this->config->get('univfeed_sleep')) {
        usleep((int) $this->config->get('univfeed_sleep') * 1000); // 1 000 000 = 1s
      }
      
      // fix issues of some special chars in descriptions
      $item['description'] = preg_replace('~[^\P{Cc}\r\n]+~u', '', $item['description']);
      
      $this->session->data['ufeed_lastItem'] = $item['product_id'];
      
      // which price to show?
      $price_order = !empty($config['price_order']) ? explode('_', $config['price_order']) : array('special', 'discount', 'price');
      
      foreach ($price_order as $p) {
        if ($item[$p]) {
          $price_value = $item[$p];
          break;
        } 
      }
      
      if (empty($config['price_tax'])) {
        $price = $this->currency->format($this->tax->calculate($price_value * $price_modifier, $item['tax_class_id']), $currency, false, false);
      } else {
        $price = $this->currency->format($price_value * $price_modifier, $currency, false, false);
      }
      
      $line = array(
        'Name' => $item['name'],
        'Model' => $item['model'],
        'Link' => $this->url->link('product/product', 'product_id=' . $item['product_id'] . (!empty($config['force_currency']) ? '&currency='.$currency : '')),
        'Price' => number_format($price, 2),
        'Category' => $item['product_category'],
        'Description' => $item['description'],
        'Tags' => $item['tag'],
        'Status' => $item['stock_status'],
        'Quantity' => $item['quantity'],
        'Manufacturer' => $item['manufacturer'],
        'Meta_Description' => $item['meta_description'],
        'ISBN' => $item['isbn'],
        'UPC' => $item['upc'],
        'EAN' => $item['ean'],
        'JAN' => $item['jan'],
        'SKU' => $item['sku'],
        'Image' => $item['image'],
        'Weight' => $this->weight->format($item['weight'], $item['weight_class_id']),
        //'Images' => $item['additional_images'],
        //'Thumbnail' => $thumb,
      );
      
      if (!empty($config['thumbnail']) && !empty($item['image_path'])) {
        $line['Thumbnail'] = @$this->model_tool_image->resize($item['image_path'], 400, 400);
      }
    
      $output = '<item>';
      
      foreach ($line as $k => $v) {
        if ($v) {
          $output .= '<'.$k.'><![CDATA['.html_entity_decode($v, ENT_QUOTES, 'UTF-8').']]></'.$k.'>'."\n";
        } else {
          $output .= '<'.$k.'/>'."\n";
        }
      }
      
      $output .= '<Attributes>'."\n";
      foreach (explode('|', $item['product_attribute']) as $attr) {
        if (strpos($attr, ':') !== false) {
          $attributes = explode(':', $attr);
          if (!empty($attributes)) {
            $output .= '<Attribute>';
            
            if (isset($attributes[0])) {
              $output .= '<group><![CDATA['.html_entity_decode($attributes[0], ENT_QUOTES, 'UTF-8').']]></group>';
            }
            
            if (isset($attributes[1])) {
              $output .= '<name><![CDATA['.html_entity_decode($attributes[1], ENT_QUOTES, 'UTF-8').']]></name>';
            }
            
            if (isset($attributes[2])) {
              $output .= '<value><![CDATA['.html_entity_decode($attributes[2], ENT_QUOTES, 'UTF-8').']]></value>';
            }
            
            $output .= '</Attribute>'."\n";
          }
        }
      }
      $output .= '</Attributes>'."\n";
      
      $output .= '</item>' . "\n";
      
      fwrite($fh, "\n" . json_encode($line) . ",");
      
      $row++;
    }
    
    // return false when no more products
    return !empty($output);
  }
  
  public function getTotalItems($data = array()) {
    return $this->model_universal_feed_driver_product->getTotalItems($data);
  }
  
}