<?php
@set_time_limit(1800);

class ModelUniversalFeedCompariRo extends Model {

  public function writeHeader($fh, $config) {
    fwrite($fh, '<?xml version="1.0" encoding="UTF-8" ?>'."\n".
                '<products>'."\n");
  }
  
  public function writeFooter($fh) {
    fwrite($fh, '</products>');
  }
  
  public function writeBody($fh, $config) {
    $config['filter_store'] = $this->config->get('config_store_id');
    $config['one_category'] = true;
    
    $products = $this->model_universal_feed_driver_product->getItems($config);
    
    //$products = $this->model_tool_universal_feed->getProducts($config);

    $price_modifier = !empty($config['price_modifier']) ? $config['price_modifier'] : 1;
    $currency = !empty($config['currency']) ? $config['currency'] : 'USD';
    $gtin = !empty($config['gtin']) ? $config['gtin'] : '';

    $row = 0;
    $save_count = 0;
    
    foreach ($products as $item) {
      if ($this->config->get('univfeed_sleep')) {
        usleep((int) $this->config->get('univfeed_sleep') * 1000); // 1 000 000 = 1s
      }
      
      $this->session->data['ufeed_lastItem'] = $item['product_id'];
      
      // which price to show?
      $price_order = !empty($config['price_order']) ? explode('_', $config['price_order']) : array('special', 'discount', 'price');
      
      foreach ($price_order as $p) {
        if ($item[$p]) {
          $price_value = $item[$p];
          break;
        } 
      }
      
      if (empty($config['price_tax'])) {
        $price = $this->currency->format($this->tax->calculate($price_value * $price_modifier, $item['tax_class_id']), $currency, false, false);
      } else {
        $price = $this->currency->format($price_value * $price_modifier, $currency, false, false);
      }
      
      $line = array(
        'identifier' => $item['model'],
        'manufacturer' => $item['manufacturer'],
        'name' => $item['name'],
        'product_url' => $this->url->link('product/product', 'product_id=' . $item['product_id'] . (!empty($config['force_currency']) ? '&currency='.$currency : '')),
        'price' => $price,
        'currency' => $currency,
        'image_url' => $item['image'],
        'category' => $item['product_category'],
        'description' => $item['meta_description'],
        'Delivery_Time' => isset($config['shipping_time']) ? $config['shipping_time'] : '',
        'Delivery_Cost' => isset($config['shipping_cost']) ? $config['shipping_cost'] : '',
        'EAN_code' => $item['ean'],
      );
    
      $output = '<product>';
      
      foreach ($line as $k => $v) {
        if (strpos($v, '<') !== false || strpos($v, '&') !== false) {
          $output .= "\t\t".'<'.$k.'><![CDATA['.html_entity_decode($v, ENT_QUOTES, 'UTF-8').']]></'.$k.'>'."\n";
        } else if ($v !== '') {
          $output .= "\t\t".'<'.$k.'>'.html_entity_decode($v, ENT_QUOTES, 'UTF-8').'</'.$k.'>'."\n";
        } else {
          $output .= "\t\t".'<'.$k.'/>'."\n";
        }
      }
      
      $output .= '</product>' . "\n";
      
      fwrite($fh, $output);
      
      $row++;
    }
    
    // return false when no more products
    return !empty($output);
  }
  
  public function getTotalItems($data = array()) {
    return $this->model_universal_feed_driver_product->getTotalItems($data);
  }
  
  private function getGoogleCategory($product_id) {
		$gcats = array();
		$categories = $this->db->query("SELECT c.google_merchant_id, cd.name FROM " . DB_PREFIX . "product_to_category p2c LEFT JOIN " . DB_PREFIX . "category c ON (p2c.category_id = c.category_id) LEFT JOIN " . DB_PREFIX . "category_description cd ON (c.category_id = cd.category_id) AND cd.language_id = " . $this->config->get('config_language_id') . " WHERE product_id = '" . (int)$product_id . "'")->rows;
		
		foreach($categories as $category) {
      if (!empty($category['google_merchant_id'])) {
        return array(
          'id' => $category['google_merchant_id'],
          'name' => $category['name'],
        );
      }
		}
	}
}