<?php
@set_time_limit(1800);

class ModelUniversalFeedCustomCsv extends Model {

  public function writeHeader($fh, $config) {
    $delimiter = ',';
    /*
    if ($config['format'] == 'tsv') {
      $delimiter = "\t";
    }
    */
    if (!empty($config['csv_separator'])) {
      $delimiter = $config['csv_separator'];
    }

    if (empty($config['item_nodes'])) {
      die('Some fields must be configured into Feed configuration > Custom feed configuration');
    }
    
    $this->write_csv($fh, $config['item_nodes'], $delimiter);
  }
  
  public function writeFooter($fh) {}
  
  public function writeBody($fh, $config, $header = false) {
    $delimiter = ',';
    /*
    if ($config['format'] == 'tsv') {
      $delimiter = "\t";
    }
    */
    
    if (!empty($config['csv_separator'])) {
      $delimiter = $config['csv_separator'];
    }
    
    $config['filter_store'] = $this->config->get('config_store_id');
    
    $products = $this->model_universal_feed_driver_product->getItems($config);
    
    $price_modifier = !empty($config['price_modifier']) ? $config['price_modifier'] : 1;
    $currency = !empty($config['currency']) ? $config['currency'] : 'USD';
    $gtin = !empty($config['gtin']) ? $config['gtin'] : '';

    $row = 0;
    $save_count = 0;
    
    // if(!empty($products[0])) {
      // $this->write_csv($fh, array_keys($products[0]), ',');
    // }
    
    foreach ($products as $item) {
      if ($this->config->get('univfeed_sleep')) {
        usleep((int) $this->config->get('univfeed_sleep') * 1000); // 1 000 000 = 1s
      }
      
      $this->session->data['ufeed_lastItem'] = $item['product_id'];
      
      // which price to show?
      $price_order = !empty($config['price_order']) ? explode('_', $config['price_order']) : array('special', 'discount', 'price');
      
      foreach ($price_order as $p) {
        if ($item[$p]) {
          $price_value = $item[$p];
          break;
        } 
      }
      
      $best_price = $item['price'];
      
      foreach (array('special', 'discount') as $p) {
        if ($item[$p] && $item[$p] < $best_price) {
          $best_price = $item[$p];
          break;
        } 
      }
      
      
      // remove double spaces, tabs and html tags from description to properly open in excel
      /*
      $item['description'] = preg_replace('/[ ]{2,}|[\t]/', ' ', trim($item['description']));
      $item['description'] = preg_replace('/\"\"/', '"', $item['description']);
      $item['description'] = html_entity_decode($item['description'],ENT_QUOTES,"UTF-8");
      $item['description'] = strip_tags($item['description']);
      $item['description'] = trim($item['description']);
      */
      
      $item_price = $item['price'];
      $item_special = $item['special'];
      $item_discount = $item['discount'];
      
      $item['best_price'] = $this->currency->format($this->tax->calculate($best_price * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format']));
      $item['price'] = $this->currency->format($this->tax->calculate($item_price * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format']));
      $item['price_unformatted'] = $this->currency->format($this->tax->calculate($item_price * $price_modifier, $item['tax_class_id']), $currency, false, false);
      $item['special'] = $item_special ? $this->currency->format($this->tax->calculate($item_special * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format'])) : '';
      $item['discount'] = $item_discount ? $this->currency->format($this->tax->calculate($item_discount * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format'])) : '';
      
      /* no more price_tax option, use _notax tags
      if (empty($config['price_tax'])) {
        $item['best_price'] = $this->currency->format($this->tax->calculate($best_price * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format']));
        $item['price'] = $this->currency->format($this->tax->calculate($item_price * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format']));
        $item['price_unformatted'] = $this->currency->format($this->tax->calculate($item_price * $price_modifier, $item['tax_class_id']), $currency, false, false);
        $item['special'] = $item['special'] ? $this->currency->format($this->tax->calculate($item['special'] * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format'])) : '';
        $item['discount'] = $item['discount'] ? $this->currency->format($this->tax->calculate($item['discount'] * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format'])) : '';
      } else {
        $item['best_price'] = $this->currency->format($best_price * $price_modifier, $currency, false, !empty($config['price_format']));
        $item['price_unformatted'] = $this->currency->format($item_price * $price_modifier, $currency, false, false);
        $item['price'] = $this->currency->format($item_price * $price_modifier, $currency, false, !empty($config['price_format']));
        $item['special'] = $item['special'] ? $this->currency->format($item['special'] * $price_modifier, $currency, false, !empty($config['price_format'])) : '';
        $item['discount'] = $item['discount'] ? $this->currency->format($item['discount'] * $price_modifier, $currency, false, !empty($config['price_format'])) : '';
      }
      */
      
      $item['best_price_notax'] = $this->currency->format($best_price * $price_modifier, $currency, false, !empty($config['price_format']));
      $item['price_notax'] = $this->currency->format($item_price * $price_modifier, $currency, false, !empty($config['price_format']));
      $item['special_notax'] = $item_special ? $this->currency->format($item_special * $price_modifier, $currency, false, !empty($config['price_format'])) : '';
      $item['discount_notax'] = $item_discount ? $this->currency->format($item_discount * $price_modifier, $currency, false, !empty($config['price_format'])) : '';
        
      if (empty($config['price_format'])) {
        $item['best_price'] = number_format($item['best_price'], 2);
        $item['price'] = number_format($item['price'], 2);
        $item['special'] = $item['special'] ? number_format($item['special'], 2) : '';
        $item['discount'] = $item['discount'] ? number_format($item['discount'], 2) : '';
        
        $item['best_price_notax'] = number_format($item['best_price_notax'], 2);
        $item['price_notax'] = number_format($item['price_notax'], 2);
        $item['special_notax'] = $item['special_notax'] ? number_format($item['special_notax'], 2) : '';
        $item['discount_notax'] = $item['discount_notax'] ? number_format($item['discount_notax'], 2) : '';
      }
      
      $line = array_combine($config['item_nodes'], $config['item_values']);
      
      $item['link'] = $this->url->link('product/product', 'product_id=' . $item['product_id'] . (!empty($config['force_currency']) ? '&currency='.$currency : ''));
      $item['currency'] = $currency;
      $item['weight'] = $this->weight->format($item['weight'], $item['weight_class_id']);
      
      $item['categories'] = $item['product_category'];
      $item['attributes'] = $item['product_attribute']; // only for csv
      $item['filters'] = $item['product_filter']; // only for csv
      
      $item['category_shortest'] = '';
      $item['category_largest'] = '';
      
      $categories = explode('|', $item['product_category']);
      
      if (count($categories)) {
        usort($categories, array($this, 'sortBySubcatNumber'));
        $item['category_shortest'] = reset($categories);
        $item['category_largest'] = end($categories);
      }
      
      $additional_images = explode('|', $item['additional_images']);
      
      for ($i = 0; $i < 20; $i++) {
        $item['image_'.($i+1)] = isset($additional_images[$i]) ? $additional_images[$i] : '';
      }

      foreach ($line as &$val) {
        foreach ($item as $k => $v) {
          // replace tags with no functions
          $val = str_replace('{'.$k.'}', $v, $val);
          
          // apply functions
          if (preg_match_all('/\{'.$k.'\|([^\}]+)\}/', $val, $matches)) {
            foreach ($matches[1] as $i => $fn) {
              $functions = explode('|', $fn);
              
              foreach ($functions as $fn) {
                $params = explode(':', $fn);
                $fn = array_shift($params);
                
                if ($fn == 'replace') {
                  $v = str_replace($params[0], $params[1], $v);
                } else if ($fn == 'float') {
                    $dotPos = strrpos($v, '.');
                    $commaPos = strrpos($v, ',');
                    $sep = (($dotPos > $commaPos) && $dotPos) ? $dotPos :
                        ((($commaPos > $dotPos) && $commaPos) ? $commaPos : false);
                        
                    if (!$sep) {
                      $v = floatval(preg_replace("/[^0-9]/", "", $v));
                    } else {
                      $v = floatval(
                          preg_replace("/[^0-9]/", "", substr($v, 0, $sep)) . '.' .
                          preg_replace("/[^0-9]/", "", substr($v, $sep+1, strlen($v)))
                      );
                    }
                } else if ($fn == 'multiply') {
                  $v = floatval($v) * $params[0];
                } else if ($fn == 'divide') {
                  $v = floatval($v) / $params[0];
                } else if ($fn == 'add') {
                  $v = floatval($v) + $params[0];
                } else if ($fn == 'subtract') {
                  $v = floatval($v) - $params[0];
                }
              }
              
              $val = str_replace($matches[0][$i], $v, $val);
            }
          }
        }
        
        // strip unassigned options
        $val = preg_replace('/{option_\w+}/', '', $val);
      }
      
      // if (!empty($config['thumbnail']) && !empty($item['image_path'])) {
        // $line['Thumbnail'] = @$this->model_tool_image->resize($item['image_path'], 400, 400);
      // }

      
      $this->write_csv($fh, $line, $delimiter);
      
      $row++;
    }
    
    // return false when no more products
    return !empty($output);
  }
  
  private function sortBySubcatNumber($a, $b) {
    if (substr_count($a, '>') == substr_count($b, '>')) {
        return 0;
    }
    return (substr_count($a, '>') < substr_count($a, '>')) ? -1 : 1;
  }
  
  public function getTotalItems($data = array()) {
    return $this->model_universal_feed_driver_product->getTotalItems($data);
  }
  
  private function write_csv($fh, array $fields, $delimiter = ',', $enclosure = '"', $mysql_null = false) {
    fputcsv($fh, array_map(array($this, 'escapeLineBreaks'), $fields), $delimiter, $enclosure);
    return;
    $delimiter_esc = preg_quote($delimiter, '/');
    $enclosure_esc = preg_quote($enclosure, '/');

    $output = array();
    foreach ($fields as $field) {
      if ($field === null && $mysql_null) {
        $output[] = 'NULL';
        continue;
      }

      $output[] = preg_match("/(?:${delimiter_esc}|${enclosure_esc}|\s)/", $field) ? (
        $enclosure . str_replace($enclosure, $enclosure . $enclosure, $field) . $enclosure
      ) : $field;
    }

    fwrite($fh, join($delimiter, $output) . "\n");
  }
  
  private function escapeLineBreaks($v) {
    return html_entity_decode(str_replace(array("\r\n","\n"), '', $v), ENT_QUOTES, 'UTF-8');
    //return preg_replace("/\r*\n/", "\\n", $v);
  }
}