<?php
@set_time_limit(1800);

class ModelUniversalFeedCustomXml extends Model {

  public function __construct($registry) {
		parent::__construct($registry);
    $this->xml_tools = $this->model_tool_universal_feed;
  }
  
  public function writeHeader($fh, $config) {
    if (empty($config['item_nodes'])) {
      die('Some fields must be configured into Feed configuration > Custom feed configuration');
    }
    
    fwrite($fh, html_entity_decode(str_replace('{date}', date($this->language->get('datetime_format')), $config['header']), ENT_QUOTES, 'UTF-8')."\n");
  }
  
  public function writeFooter($fh, $config) {
    fwrite($fh, html_entity_decode($config['footer'], ENT_QUOTES, 'UTF-8'));
  }
  
  public function writeBody($fh, $config) {
    $config['filter_store'] = $this->config->get('config_store_id');
    
    $config['node_name'] = !empty($config['node_name']) ? $config['node_name'] : 'item';
    
    $products = $this->model_universal_feed_driver_product->getItems($config);
    
    //$products = $this->model_tool_universal_feed->getProducts($config);

    $price_modifier = !empty($config['price_modifier']) ? $config['price_modifier'] : 1;
    $currency = !empty($config['currency']) ? $config['currency'] : 'USD';
    $gtin = !empty($config['gtin']) ? $config['gtin'] : '';

    $row = 0;
    $save_count = 0;
    
    foreach ($products as $item) {
      if ($this->config->get('univfeed_sleep')) {
        usleep((int) $this->config->get('univfeed_sleep') * 1000); // 1 000 000 = 1s
      }
      
      $this->session->data['ufeed_lastItem'] = $item['product_id'];
      
      // which price to show?
      $price_order = !empty($config['price_order']) ? explode('_', $config['price_order']) : array('special', 'discount', 'price');
      
      foreach ($price_order as $p) {
        if ($item[$p]) {
          $price_value = $item[$p];
          break;
        } 
      }
      
      $best_price = $item['price'];
      
      foreach (array('special', 'discount') as $p) {
        if ($item[$p] && $item[$p] < $best_price) {
          $best_price = $item[$p];
          break;
        } 
      }
      
      $item_price = $item['price'];
      $item_special = $item['special'];
      $item_discount = $item['discount'];
      
      $item['best_price'] = $this->currency->format($this->tax->calculate($best_price * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format']));
      $item['price'] = $this->currency->format($this->tax->calculate($item_price * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format']));
      $item['price_unformatted'] = $this->currency->format($this->tax->calculate($item_price * $price_modifier, $item['tax_class_id']), $currency, false, false);
      $item['special'] = $item_special ? $this->currency->format($this->tax->calculate($item_special * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format'])) : '';
      $item['discount'] = $item_discount ? $this->currency->format($this->tax->calculate($item_discount * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format'])) : '';
      
      /* no more price_tax option, use _notax tags
      if (empty($config['price_tax'])) {
        $item['best_price'] = $this->currency->format($this->tax->calculate($best_price * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format']));
        $item['price'] = $this->currency->format($this->tax->calculate($item_price * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format']));
        $item['price_unformatted'] = $this->currency->format($this->tax->calculate($item_price * $price_modifier, $item['tax_class_id']), $currency, false, false);
        $item['special'] = $item['special'] ? $this->currency->format($this->tax->calculate($item['special'] * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format'])) : '';
        $item['discount'] = $item['discount'] ? $this->currency->format($this->tax->calculate($item['discount'] * $price_modifier, $item['tax_class_id']), $currency, false, !empty($config['price_format'])) : '';
      } else {
        $item['best_price'] = $this->currency->format($best_price * $price_modifier, $currency, false, !empty($config['price_format']));
        $item['price_unformatted'] = $this->currency->format($item_price * $price_modifier, $currency, false, false);
        $item['price'] = $this->currency->format($item_price * $price_modifier, $currency, false, !empty($config['price_format']));
        $item['special'] = $item['special'] ? $this->currency->format($item['special'] * $price_modifier, $currency, false, !empty($config['price_format'])) : '';
        $item['discount'] = $item['discount'] ? $this->currency->format($item['discount'] * $price_modifier, $currency, false, !empty($config['price_format'])) : '';
      }
      */
      
      $item['best_price_notax'] = $this->currency->format($best_price * $price_modifier, $currency, false, !empty($config['price_format']));
      $item['price_notax'] = $this->currency->format($item_price * $price_modifier, $currency, false, !empty($config['price_format']));
      $item['special_notax'] = $item_special ? $this->currency->format($item_special * $price_modifier, $currency, false, !empty($config['price_format'])) : '';
      $item['discount_notax'] = $item_discount ? $this->currency->format($item_discount * $price_modifier, $currency, false, !empty($config['price_format'])) : '';
        
      if (empty($config['price_format'])) {
        $item['best_price'] = number_format($item['best_price'], 2);
        $item['price'] = number_format($item['price'], 2);
        $item['special'] = $item['special'] ? number_format($item['special'], 2) : '';
        $item['discount'] = $item['discount'] ? number_format($item['discount'], 2) : '';
        
        $item['best_price_notax'] = number_format($item['best_price_notax'], 2);
        $item['price_notax'] = number_format($item['price_notax'], 2);
        $item['special_notax'] = $item['special_notax'] ? number_format($item['special_notax'], 2) : '';
        $item['discount_notax'] = $item['discount_notax'] ? number_format($item['discount_notax'], 2) : '';
      }
      
      $line = array_combine($config['item_nodes'], $config['item_values']);
      
      $item['link'] = $this->url->link('product/product', 'product_id=' . $item['product_id'] . (!empty($config['force_currency']) ? '&currency='.$currency : ''));
      $item['currency'] = $currency;
      $item['weight'] = $this->weight->format($item['weight'], $item['weight_class_id']);
      
      $item['categories'] = $item['product_category'];
      $item['category_shortest'] = '';
      $item['category_largest'] = '';
      
      $categories = explode('|', $item['product_category']);
      
      if (count($categories)) {
        usort($categories, array($this, 'sortBySubcatNumber'));
        $item['category_shortest'] = reset($categories);
        $item['category_largest'] = end($categories);
      }
      
      $additional_images = explode('|', $item['additional_images']);
      
      for ($i = 0; $i < 20; $i++) {
        $item['image_'.($i+1)] = isset($additional_images[$i]) ? $additional_images[$i] : '';
      }
      
      /*
      if ($item['product_attribute']) {
        $attributes = explode('|', $item['product_attribute']);
        var_dump($attributes);die;
      }
      
      for ($i = 0; $i < 20; $i++) {
        $item['attribute_val_'.($i+1)] = isset($additional_images[$i]) ? $additional_images[$i] : '';
      }
      */

      foreach ($line as &$val) {
        foreach ($item as $k => $v) {
          // replace tags with no functions
          $val = str_replace('{'.$k.'}', $v, $val);
          
          // apply functions
          if (preg_match_all('/\{'.$k.'\|([^\}]+)\}/', $val, $matches)) {
            foreach ($matches[1] as $i => $fn) {
              $functions = explode('|', $fn);
              
              foreach ($functions as $fn) {
                $params = explode(':', $fn);
                $fn = array_shift($params);
                
                if ($fn == 'replace') {
                  $v = str_replace($params[0], $params[1], $v);
                } else if ($fn == 'float') {
                    $dotPos = strrpos($v, '.');
                    $commaPos = strrpos($v, ',');
                    $sep = (($dotPos > $commaPos) && $dotPos) ? $dotPos :
                        ((($commaPos > $dotPos) && $commaPos) ? $commaPos : false);
                        
                    if (!$sep) {
                      $v = floatval(preg_replace("/[^0-9]/", "", $v));
                    } else {
                      $v = floatval(
                          preg_replace("/[^0-9]/", "", substr($v, 0, $sep)) . '.' .
                          preg_replace("/[^0-9]/", "", substr($v, $sep+1, strlen($v)))
                      );
                    }
                } else if ($fn == 'multiply') {
                  $v = floatval($v) * $params[0];
                } else if ($fn == 'divide') {
                  $v = floatval($v) / $params[0];
                } else if ($fn == 'add') {
                  $v = floatval($v) + $params[0];
                } else if ($fn == 'subtract') {
                  $v = floatval($v) - $params[0];
                }
              }
              
              $val = str_replace($matches[0][$i], $v, $val);
            }
          }
        }
        
        // strip unassigned options
        $val = preg_replace('/{option_\w+}/', '', $val);
      }

      $output = '<'.$config['node_name'].'>'. "\n";
      
      foreach ($line as $k => $v) {
        if ($v == '{attributes}') {
          if ($item['product_attribute']) {
            $output .= "\t".'<'.str_replace(' ', '_', $k).'>';
            
            foreach (explode('|', $item['product_attribute']) as $attr) {
              if (strpos($attr, ':') !== false) {
                $attributes = explode(':', $attr);
                if (!empty($attributes)) {
                  $output .= "\n\t\t".'<attribute>';
                  
                  if (isset($attributes[0])) {
                    $output .= "\n\t\t\t";
                    if (strpos($attributes[0], '<') !== false || strpos($attributes[0], '&') !== false) {
                      $output .= '<group><![CDATA['.html_entity_decode($attributes[0], ENT_QUOTES, 'UTF-8').']]></group>';
                    } else {
                      $output .= '<group>'.html_entity_decode($attributes[0], ENT_QUOTES, 'UTF-8').'</group>';
                    }
                  }
                  
                  if (isset($attributes[1])) {
                    $output .= "\n\t\t\t";
                    if (strpos($attributes[1], '<') !== false || strpos($attributes[1], '&') !== false) {
                      $output .= '<name><![CDATA['.html_entity_decode($attributes[1], ENT_QUOTES, 'UTF-8').']]></name>';
                    } else {
                      $output .= '<name>'.html_entity_decode($attributes[1], ENT_QUOTES, 'UTF-8').'</name>';
                    }
                  }
                  
                  if (isset($attributes[2])) {
                    $output .= "\n\t\t\t";
                    if (strpos($attributes[2], '<') !== false || strpos($attributes[2], '&') !== false) {
                      $output .= '<value><![CDATA['.html_entity_decode($attributes[2], ENT_QUOTES, 'UTF-8').']]></value>';
                    } else {
                      $output .= '<value>'.html_entity_decode($attributes[2], ENT_QUOTES, 'UTF-8').'</value>';
                    }
                  }
                  
                  $output .= "\n\t\t".'</attribute>';
                }
              }
            }
            
            $output .= "\n\t".'</'.str_replace(' ', '_', $k).'>'."\n";
          } else {
            $output .= "\t".'<'.str_replace(' ', '_', $k).'/>'."\n";
          }
        } else if ($v == '{attribute_tags}') {
          if ($item['product_attribute']) {
            if ($k) {
              $output .= "\t".'<'.str_replace(' ', '_', $k).'>';
            }
            
            foreach (explode('|', $item['product_attribute']) as $attr) {
              if (strpos($attr, ':') !== false) {
                $attributes = explode(':', $attr);
                if (!empty($attributes)) {
                  if (isset($attributes[2])) {
                    $output .= "\n\t\t";
                    if (strpos($attributes[2], '<') !== false || strpos($attributes[2], '&') !== false) {
                      $output .= '<'.trim(preg_replace('/\W+/u', '_', $attributes[1]), '_').'><![CDATA['.html_entity_decode($attributes[2], ENT_QUOTES, 'UTF-8').']]></'.trim(preg_replace('/\W+/u', '_', $attributes[1]), '_').'>';
                    } else {
                      $output .= '<'.trim(preg_replace('/\W+/u', '_', $attributes[1]), '_').'>'.html_entity_decode($attributes[2], ENT_QUOTES, 'UTF-8').'</'.trim(preg_replace('/\W+/u', '_', $attributes[1]), '_').'>';
                    }
                  }
                }
              }
            }
            
            if ($k) {
              $output .= "\n\t".'</'.str_replace(' ', '_', $k).'>'."\n";
            }
          } else {
            $output .= "\t".'<'.str_replace(' ', '_', $k).'/>'."\n";
          }
        } else if ($v == '{filters}') {
          if ($item['product_filter']) {
          $output .= "\t".'<'.str_replace(' ', '_', $k).'>';
            foreach (explode('|', $item['product_filter']) as $attr) {
              if (strpos($attr, ':') !== false) {
                $attributes = explode(':', $attr);
                if (!empty($attributes)) {
                  $output .= "\n\t\t".'<filter>';
                  
                  if (isset($attributes[0])) {
                    $output .= "\n\t\t\t";
                    if (strpos($attributes[0], '<') !== false || strpos($attributes[0], '&') !== false) {
                      $output .= '<name><![CDATA['.html_entity_decode($attributes[0], ENT_QUOTES, 'UTF-8').']]></name>';
                    } else {
                      $output .= '<name>'.html_entity_decode($attributes[0], ENT_QUOTES, 'UTF-8').'</name>';
                    }
                  }
                  
                  if (isset($attributes[1])) {
                    $output .= "\n\t\t\t";
                    if (strpos($attributes[1], '<') !== false || strpos($attributes[1], '&') !== false) {
                      $output .= '<value><![CDATA['.html_entity_decode($attributes[1], ENT_QUOTES, 'UTF-8').']]></value>';
                    } else {
                      $output .= '<value>'.html_entity_decode($attributes[1], ENT_QUOTES, 'UTF-8').'</value>';
                    }
                  }
                  
                  $output .= "\n\t\t".'</filter>';
                }
              }
            }
            $output .= "\n\t".'</'.str_replace(' ', '_', $k).'>'."\n";
          } else {
            $output .= "\t".'<'.str_replace(' ', '_', $k).'/>'."\n";
          }
        } else if ($v !== '') {
          if (strpos($v, '<') !== false || strpos($v, '&') !== false) {
            $output .= "\t".'<'.str_replace(' ', '_', $k).'><![CDATA['.html_entity_decode($v, ENT_QUOTES, 'UTF-8').']]></'.str_replace(' ', '_', $k).'>'."\n";
          } else {
            $output .= "\t".'<'.str_replace(' ', '_', $k).'>'.html_entity_decode($v, ENT_QUOTES, 'UTF-8').'</'.str_replace(' ', '_', $k).'>'."\n";
          }
        } else {
          $output .= "\t".'<'.str_replace(' ', '_', $k).'/>'."\n";
        }
      }
      
      /*
      $output .= '<Attributes>'."\n";
      foreach (explode('|', $item['product_attribute']) as $attr) {
        if (strpos($attr, ':') !== false) {
          $attributes = explode(':', $attr);
          if (!empty($attributes)) {
            $output .= '<Attribute>';
            
            if (isset($attributes[0])) {
              $output .= '<group><![CDATA['.html_entity_decode($attributes[0], ENT_QUOTES, 'UTF-8').']]></group>';
            }
            
            if (isset($attributes[1])) {
              $output .= '<name><![CDATA['.html_entity_decode($attributes[1], ENT_QUOTES, 'UTF-8').']]></name>';
            }
            
            if (isset($attributes[2])) {
              $output .= '<value><![CDATA['.html_entity_decode($attributes[2], ENT_QUOTES, 'UTF-8').']]></value>';
            }
            
            $output .= '</Attribute>'."\n";
          }
        }
      }
      $output .= '</Attributes>'."\n";
      */
      
      $output .= '</'.$config['node_name'].'>'. "\n";
      
      fwrite($fh, $output);
      
      $row++;
    }
    
    // return false when no more products
    return !empty($output);
  }
  
  private function sortBySubcatNumber($a, $b) {
    if (substr_count($a, '>') == substr_count($b, '>')) {
        return 0;
    }
    return (substr_count($a, '>') < substr_count($a, '>')) ? -1 : 1;
  }
  
  public function getTotalItems($data = array()) {
    return $this->model_universal_feed_driver_product->getTotalItems($data);
  }
  
  private function getGoogleCategory($product_id) {
		$gcats = array();
		$categories = $this->db->query("SELECT c.google_merchant_id, cd.name FROM " . DB_PREFIX . "product_to_category p2c LEFT JOIN " . DB_PREFIX . "category c ON (p2c.category_id = c.category_id) LEFT JOIN " . DB_PREFIX . "category_description cd ON (c.category_id = cd.category_id) AND cd.language_id = " . $this->config->get('config_language_id') . " WHERE product_id = '" . (int)$product_id . "'")->rows;
		
		foreach($categories as $category) {
      if (!empty($category['google_merchant_id'])) {
        return array(
          'id' => $category['google_merchant_id'],
          'name' => $category['name'],
        );
      }
		}
	}
}