<?php
class ModelUniversalFeedDriverProduct extends Model {
  private $langIdToCode = array();
  
  public function getItems($data = array(), $count = false) {
    // store_id for use with URL and multistore, set to 0 if empty
    if (!empty($data['filter_store'])) {
      $store_id = $data['filter_store'];
    } else {
      $store_id = 0;
    }
    
    if ($count) {
      $select = 'COUNT(DISTINCT p.product_id) AS total';
    } else {
      $select = 'p.*, m.name as manufacturer';
      if (isset($data['filter_language']) && $data['filter_language'] !== '') {
        $select .= ", pd.*";
      }
      
      if (empty($data['param_image_path'])) {
        $select .= ", CONCAT('".$this->config->get('config_url')."image/', p.image) as image, p.image as image_path";
        //$select .= ", (SELECT * FROM " . DB_PREFIX . "product_image WHERE product_id = p.product_id ORDER BY sort_order ASC)";
      }
    }
    
    // current special price
    if (!empty($data['special_price_group'])) {
      $special_price_group = $data['special_price_group'];
    } else {
      $special_price_group = $this->config->get('config_customer_group_id');
    }
    
    $special = ", (SELECT price FROM " . DB_PREFIX . "product_special ps WHERE ps.product_id = p.product_id AND ps.customer_group_id = '" . (int)$special_price_group . "' AND ((ps.date_start = '0000-00-00' OR ps.date_start < NOW()) AND (ps.date_end = '0000-00-00' OR ps.date_end > NOW())) ORDER BY ps.priority ASC, ps.price ASC LIMIT 1) AS special";
    $special .= ", (SELECT price FROM " . DB_PREFIX . "product_discount pd2 WHERE pd2.product_id = p.product_id AND pd2.customer_group_id = '" . (int)$special_price_group . "' AND pd2.quantity > '0' AND ((pd2.date_start = '0000-00-00' OR pd2.date_start < NOW()) AND (pd2.date_end = '0000-00-00' OR pd2.date_end > NOW())) ORDER BY pd2.priority ASC, pd2.price ASC LIMIT 1) AS discount";
    
    $sql = "SELECT " . $select . $special . " FROM " . DB_PREFIX . "product p";

    $sql .= " LEFT JOIN " . DB_PREFIX . "manufacturer m ON (p.manufacturer_id = m.manufacturer_id)";
    
    if (isset($data['filter_language']) && $data['filter_language'] !== '') {
      $sql .= " LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id)";
    }
    
    if (isset($data['filter_store']) && $data['filter_store'] !== '') {
      $sql .= " LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id)";
    }
    
    if (!empty($data['filter_category']) || !empty($data['filter_category_exclude'])) {
      $sql .=  " LEFT JOIN " . DB_PREFIX . "product_to_category p2c ON (p.product_id = p2c.product_id)";
    }
    
    // WHERE
    $sql .= " WHERE status = 1";
    
    // languages
    $filter_language = isset($data['filter_language']) ? $data['filter_language'] : '';
    
    if (isset($data['filter_language']) && $data['filter_language'] !== '') {
      $sql .= " AND pd.language_id = '" . (int)$data['filter_language'] . "'";
    } else {
      $lgquery = $this->db->query("SELECT DISTINCT language_id, code FROM " . DB_PREFIX . "language WHERE status = 1")->rows;
      
      foreach ($lgquery as $lang) {
        $this->langIdToCode[$lang['language_id']] = substr($lang['code'], 0, 2);
      }
    }
    
    if (isset($data['filter_store']) && $data['filter_store'] !== '') {
      $sql .= " AND p2s.store_id = '" . (int)$data['filter_store'] . "'";
    }
    
    // conditions
    if (!empty($data['conditions'])) {
      foreach ($data['conditions'] as $condition) {
        $tableField = 'p.`' . $this->db->escape($condition['field']) . '`';
        if (in_array($condition['field'], array('name', 'description'))) {
          $tableField = 'pd.' . $this->db->escape($condition['field']);
        } else if ($condition['field'] == 'manufacturer') {
          $tableField = 'm.name';
        }
        
        $sql .= " AND ".$tableField;
        switch ($condition['comparator']) {
          case 'is_equal': default: $sql .= " = '".$this->db->escape($condition['value'])."'"; break;
          case 'is_not_equal': $sql .= " != '".$this->db->escape($condition['value'])."'"; break;
          case 'is_greater': $sql .= " > '".$this->db->escape($condition['value'])."'"; break;
          case 'is_lower': $sql .= " < '".$this->db->escape($condition['value'])."'"; break;
          case 'contain': $sql .= " LIKE '%".$this->db->escape($condition['value'])."%'"; break;
          case 'not_contain': $sql .= " NOT LIKE '%".$this->db->escape($condition['value'])."%'"; break;
        }
      }
    }
    
    if (!empty($data['conditions_or'])) {
      $sql .= " AND (";
      $first = true;
      
      foreach ($data['conditions_or'] as $condition) {
        $tableField = 'p.`' . $this->db->escape($condition['field']) . '`';
        if (in_array($condition['field'], array('name', 'description'))) {
          $tableField = 'pd.' . $this->db->escape($condition['field']);
        } else if ($condition['field'] == 'manufacturer') {
          $tableField = 'm.name';
        }
        
        if (!$first) {
          $sql .= " OR ";
        }
        
        $first = false;
        
        $sql .= $tableField;
        
        switch ($condition['comparator']) {
          case 'is_equal': default: $sql .= " = '".$this->db->escape($condition['value'])."'"; break;
          case 'is_not_equal': $sql .= " != '".$this->db->escape($condition['value'])."'"; break;
          case 'is_greater': $sql .= " > '".$this->db->escape($condition['value'])."'"; break;
          case 'is_lower': $sql .= " < '".$this->db->escape($condition['value'])."'"; break;
          case 'contain': $sql .= " LIKE '%".$this->db->escape($condition['value'])."%'"; break;
          case 'not_contain': $sql .= " NOT LIKE '%".$this->db->escape($condition['value'])."%'"; break;
        }
      }
      $sql .= ")";
    }
    
        // exclude products
    if (!empty($data['exclude_products'])) {
      foreach ($data['exclude_products'] as $condition) {
        $tableField = 'p.`' . $this->db->escape($condition['field']) . '`';
        if (in_array($condition['field'], array('name', 'description'))) {
          $tableField = 'pd.' . $this->db->escape($condition['field']);
        } else if ($condition['field'] == 'manufacturer') {
          $tableField = 'm.name';
        }
        
        $sql .= " AND ".$tableField;
        switch ($condition['comparator']) {
          case 'is_equal': default: $sql .= " != '".$this->db->escape($condition['value'])."'"; break;
          case 'is_not_equal': $sql .= " = '".$this->db->escape($condition['value'])."'"; break;
          case 'is_greater': $sql .= " < '".$this->db->escape($condition['value'])."'"; break;
          case 'is_lower': $sql .= " > '".$this->db->escape($condition['value'])."'"; break;
          case 'contain': $sql .= " NOT LIKE '%".$this->db->escape($condition['value'])."%'"; break;
          case 'not_contain': $sql .= " LIKE LIKE '%".$this->db->escape($condition['value'])."%'"; break;
        }
      }
    }
    
    if (!empty($data['filter_category'])) {
      $data['filter_category'] = implode(',', array_map('intval', (array) $data['filter_category']));
			$sql .= " AND p2c.category_id IN (" . $data['filter_category'] . ")";
    }
    
    if (!empty($data['filter_category_exclude'])) {
      $data['filter_category_exclude'] = implode(',', array_map('intval', (array) $data['filter_category_exclude']));
			$sql .= " AND p2c.category_id NOT IN (" . $data['filter_category_exclude'] . ")";
    }
    
    if (!empty($data['filter_manufacturer'])) {
      $data['filter_manufacturer'] = implode(',', array_map('intval', (array) $data['filter_manufacturer']));
			$sql .= " AND p.manufacturer_id IN (" . $data['filter_manufacturer'] . ")";
		}
    
    if (!empty($this->request->get['search'])) {
			$sql .= " AND pd.name LIKE '%" . $this->db->escape($this->request->get['search']) . "%'";
		}
    
		if (!empty($data['filter_name'])) {
			$sql .= " AND pd.name LIKE '" . $this->db->escape($data['filter_name']) . "%'";
		}
    // price
    if (!empty($data['filter_price_min'])) {
			$sql .= " AND p.price >= '" . (float)$data['filter_price_min'] . "'";
		}
    
    if (!empty($data['filter_price_max'])) {
			$sql .= " AND p.price <= '" . (float)$data['filter_price_max'] . "'";
		}

		if (!empty($data['filter_model'])) {
			$sql .= " AND p.model LIKE '" . $this->db->escape($data['filter_model']) . "%'";
		}

		if (isset($data['filter_price']) && !is_null($data['filter_price'])) {
			$sql .= " AND p.price LIKE '" . $this->db->escape($data['filter_price']) . "%'";
		}

		if (!empty($data['in_stock'])) {
			$sql .= " AND p.quantity >= '" . (int)$data['in_stock'] . "'";
		}
    
		if (isset($data['filter_quantity']) && !is_null($data['filter_quantity'])) {
			$sql .= " AND p.quantity = '" . (int)$data['filter_quantity'] . "'";
		}

		if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
			$sql .= " AND p.status = '" . (int)$data['filter_status'] . "'";
		}
    
    // return count
    if ($count) {
      return $this->db->query($sql)->row['total'];
    }
    
		$sql .= " GROUP BY p.product_id";
    
		$sort_data = array(
			'pd.name',
			'p.model',
			'p.price',
			'p.quantity',
			'p.status',
			'p.sort_order',
			'p.date_added',
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY p.product_id";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);
    
    $rows = array();
    
    foreach ($query->rows as &$row) {
      if (!empty($data['shipping'])) {
        $shippingValues = is_string($data['shipping']) ? explode("\n", $data['shipping']) : $data['shipping'];
        
        $shipping_price = $shipping_time = 0;
        
        foreach ($shippingValues as $shippingRow) {
          $shipping = explode('=', str_replace("\r", '', $shippingRow));
          
          if (!isset($shipping[1])) continue;
          
          if (substr($shipping[0], 0, 1) == 'W') {
            if (strpos($shipping[0], '-') !== false) {
              list($valMin, $valMax) = explode('-', str_replace('P', '', $shipping[0]));
              
              if ($row['weight'] >= $valMin && $row['weight'] < $valMax) {
                $shipping_price = $shipping[1];
                $shipping_time = isset($shipping[2]) ? $shipping[2] : 0;
                break;
              }
            }
          } else {
            if (strpos($shipping[0], '-') !== false) {
              list($valMin, $valMax) = explode('-', str_replace('P', '', $shipping[0]));
              
              if ($row['price'] >= $valMin && $row['price'] < $valMax) {
                $shipping_price = $shipping[1];
                $shipping_time = isset($shipping[2]) ? $shipping[2] : 0;
                break;
              }
            }
          }
        }
        
        $row['shipping_price'] = $shipping_price;
        $row['shipping_time'] = $shipping_time;
      } else {
        $row['stock_status'] = $row['quantity'] ? 'in stock' : 'out of stock';
      }
      
      if (!empty($data['stock_label'])) {
        $stockLabelValues = explode("\n", $data['stock_label']);
        natsort($stockLabelValues);
        foreach ($stockLabelValues as $stockLabelRow) {
          $stockLabel = explode(':', $stockLabelRow);
          if (isset($stockLabel[1]) && $row['quantity'] <= $stockLabel[0]) {
            $row['stock_status'] = $stockLabel[1];
            break;
          }
        }
        if (!isset($row['stock_status']) && !empty($stockLabelValues)) {
          $stockLabel = explode(':', end($stockLabelValues));
          if (isset($stockLabel[1])) {
            $row['stock_status'] = $stockLabel[1];
          }
        }
      } else {
        $row['stock_status'] = $row['quantity'] ? 'in stock' : 'out of stock';
      }
      
      if (isset($data['filter_language']) && $data['filter_language'] === '') {
        $row += $this->getProductDescription($row['product_id']);
      } else if ($this->config->get('mlseo_enabled') && $this->config->get('mlseo_multistore') && $store_id) {
        $this->setSeoDescription($row, $store_id, $data['filter_language']);
      }
      
      // fix chinese special chars
      if ($this->config->get('univfeed_fix_chinese_chars')) {
        $row['name'] = preg_replace('~[^\P{Cc}\r\n]+~u', '', $row['name']);
        $row['model'] = preg_replace('~[^\P{Cc}\r\n]+~u', '', $row['model']);
        $row['description'] = preg_replace('~[^\P{Cc}\r\n]+~u', '', $row['description']);
        $row['meta_description'] = preg_replace('~[^\P{Cc}\r\n]+~u', '', $row['meta_description']);
      }
      
      $row['additional_images'] = $this->getProductImages($row['product_id'], empty($data['param_image_path']), !empty($data['addtionalImageAsArray']));
      $row['product_filter'] = $this->getProductFilters($row['product_id'], !empty($data['filterAsArray']));
      $row['product_attribute'] = $this->getProductAttributes($row['product_id'], !empty($data['attributeAsArray']));
      $row['product_option'] = $this->getProductOptions($row['product_id'], !empty($data['optionAsArray']));
      $this->setProductCategoryData($row['product_id'], $row);
      $row['product_category'] = $this->getProductCategories($row['product_id'], $data, !empty($data['categoryAsArray']));
      $row['product_discount'] = $this->getProductDiscounts($row['product_id']);
      
      if (!empty($data['get_coupon'])) {
        $row['coupon'] = $this->getProductCoupon($row['product_id']);
      }
      
      //$row['product_special'] = $this->getProductSpecial($row['product_id']);
      
      if (!empty($data['replaces'])) {
        foreach ($data['replaces'] as $condition) {
          switch ($condition['comparator']) {
            case 'is_equal': default: $row[$condition['field']] = ($row[$condition['field']] == $condition['value']) ? $condition['output'] : $row[$condition['field']]; break;
            case 'is_not_equal':  $row[$condition['field']] = ($row[$condition['field']] != $condition['value']) ? $condition['output'] : $row[$condition['field']]; break;
            case 'is_greater':  $row[$condition['field']] = ($row[$condition['field']] > $condition['value']) ? $condition['output'] : $row[$condition['field']]; break;
            case 'is_lower':  $row[$condition['field']] = ($row[$condition['field']] < $condition['value']) ? $condition['output'] : $row[$condition['field']]; break;
            case 'contain':  $row[$condition['field']] = ($condition['value'] !== '' && strpos($row[$condition['field']], $condition['value']) !== false) ? $condition['output'] : $row[$condition['field']]; break;
            case 'not_contain':  $row[$condition['field']] = ($condition['value'] !== '' && strpos($row[$condition['field']], $condition['value']) === false) ? $condition['output'] : $row[$condition['field']]; break;
          }
        }
      }
      
      if (!empty($data['option_row']) && $options = $this->getProductOptions($row['product_id'], true)) {
        $variant_count = 0;
        foreach ($options as $option) {
          // include only sepcific option variants
          if (!empty($data['include_only_option_id']) && $data['include_only_option_id'] != $option['id']) {
            continue;
          }
          
          foreach ($option as $opt_type => $opt_value) {
            $row['option_'.$opt_type] = $opt_value;
          }
          
          // include option values into current data
          $opt_model = isset($option['model']) ? $option['model'] : str_pad($variant_count+1, 2, '0', STR_PAD_LEFT);
          
          $opt_data = array(
            'model' => $row['model'] . '-' . $opt_model,
            'name' => $row['name'] . ' - ' . $option['value'],
            'orig_name' => $row['name'],
            'quantity' => $option['quantity'],
            'price' => $row['price'] + $option['price'],
            'special' => $row['special'] ? $row['special']+$option['price'] : $row['special'],
            'discount' => $row['discount'] ? $row['discount']+$option['price'] : $row['discount'],
            'image' => !empty($option['image']) ? $this->config->get('config_url').'image/'.$option['image'] : $row['image'],
            'image_path' => !empty($option['image']) ? $option['image'] : $row['image'],
          );
          
          $row['is_variant'] = true;
          $row['variant_count'] = $variant_count++;
          $rows[] = $opt_data + $row;
        }
      } else {
        $rows[] = $row;
      }
    }
    
		return $rows;
	}
  
  public function getProductDescription($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_description WHERE product_id = '" . (int)$product_id . "' ORDER BY language_id ASC");
    
    $res = array();
    
    foreach ($query->rows as &$row) {
      foreach ($row as $key => $val) {
        if (!in_array($key, array('language_id', 'product_id'))) {
          $res[$key.'_'.$this->langIdToCode[$row['language_id']]] = $val;
        }
      }
    }
    
		return $res;
	}
  
  private function setSeoDescription(&$row, $store_id, $language_id) {
    $seoDescription = $this->db->query("SELECT * FROM " . DB_PREFIX . "seo_product_description d WHERE product_id = '" . (int)$row['product_id'] . "' AND store_id = '".(int) $store_id."' AND language_id = '".(int) $language_id."'")->row;
		
    if (!empty($seoDescription['meta_title'])) {
      $row['meta_title'] = $seoDescription['meta_title'];
    }
    
    if (!empty($seoDescription['meta_description'])) {
      $row['meta_description'] = $seoDescription['meta_description'];
    }
    
    if (!empty($seoDescription['meta_keyword'])) {
      $row['meta_keyword'] = $seoDescription['meta_keyword'];
    }
    
    if (!empty($seoDescription['image_alt'])) {
      $row['image_alt'] = $seoDescription['image_alt'];
    }
    
    if (!empty($seoDescription['image_title'])) {
      $row['image_title'] = $seoDescription['image_title'];
    }
    
    if (!empty($seoDescription['name'])) {
      $row['name'] = $seoDescription['name'];
    }
    
    if (isset($seoDescription['description']) && trim(strip_tags($seoDescription['description']))) {
      $row['description'] = $seoDescription['description'];
    }
    
    if (!empty($seoDescription['seo_h1'])) {
      $row['seo_h1'] = $seoDescription['seo_h1'];
    }
    
    if (!empty($seoDescription['seo_h2'])) {
      $row['seo_h2'] = $seoDescription['seo_h2'];
    }
    
    if (!empty($seoDescription['seo_h3'])) {
      $row['seo_h3'] = $seoDescription['seo_h3'];
    }
    
	}
  
  public function getProductImages($product_id, $full_path, $asArray = false) {
    $query = $this->db->query("SELECT image FROM " . DB_PREFIX . "product_image WHERE product_id = '" . (int)$product_id . "' ORDER BY sort_order ASC");
    
    if ($asArray) {
      $res = array();
      
      foreach ($query->rows as &$row) {
        if ($row['image']) {
          $res[] = $this->config->get('config_url').'image/'.$row['image'];
        }
      }
      
      return $res;
    }
    
    $res = '';
    
    foreach ($query->rows as &$row) {
      if ($row['image']) {
        $res .= $res ? '|' : '';
        
        if ($full_path) {
          $res .= $this->config->get('config_url').'image/'.$row['image'];
        } else {
          $res .= $row['image'];
        }
      }
    }
    
		return $res;
	}
  
  public function getProductAttributes($product_id, $asArray = false) {
		$product_attribute_data = array();

		$product_attribute_query = $this->db->query("SELECT pa.attribute_id FROM " . DB_PREFIX . "product_attribute pa WHERE pa.product_id = '" . (int)$product_id . "' GROUP BY pa.attribute_id");

		foreach ($product_attribute_query->rows as $product_attribute) {
			$product_attribute_description_data = array();

			$product_attribute_description_query = $this->db->query(
        "SELECT pa.text, pa.language_id, ad.name, agd.name as 'group'
          FROM " . DB_PREFIX . "product_attribute pa
           LEFT JOIN " . DB_PREFIX . "attribute a ON (pa.attribute_id = a.attribute_id)
           LEFT JOIN " . DB_PREFIX . "attribute_description ad ON (pa.attribute_id = ad.attribute_id AND pa.language_id = ad.language_id)
           LEFT JOIN " . DB_PREFIX . "attribute_group_description agd ON (a.attribute_group_id = agd.attribute_group_id AND pa.language_id = agd.language_id)
          WHERE pa.product_id = '" . (int)$product_id . "'
           AND pa.attribute_id = '" . (int)$product_attribute['attribute_id'] . "'");

			foreach ($product_attribute_description_query->rows as $product_attribute_description) {
				$product_attribute_description_data[$product_attribute_description['language_id']] = array(
          'group' => $product_attribute_description['group'],
          'attribute' => $product_attribute_description['name'],
          'value' => $product_attribute_description['text'],
        );
			}

			$product_attribute_data[] = $product_attribute_description_data;
		}
    
    if ($asArray) {
      return $product_attribute_data;
    }

    $res = '';
    
    // get formatted string for CSV, take only default language
    foreach ($product_attribute_data as $langs) {
      foreach ($langs as $lang => $item) {
        if ($lang != $this->config->get('config_language_id')) continue;
        
        $res .= $res ? '|' : '';
        $res .= $item['group'] . ':' . $item['attribute'] . ':' . $item['value'];
      }
    }
    
		return $res;
	}
  
  public function getProductOptions($product_id, $asArray = false) {
		$product_option_data = array();

		$product_option_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product_option` po LEFT JOIN `" . DB_PREFIX . "option` o ON (po.option_id = o.option_id) LEFT JOIN `" . DB_PREFIX . "option_description` od ON (o.option_id = od.option_id) WHERE po.product_id = '" . (int)$product_id . "' AND od.language_id = '" . (int)$this->config->get('config_language_id') . "'");
    
		foreach ($product_option_query->rows as $product_option) {
			$product_option_value_data = array();

			$product_option_value_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_option_value pov LEFT JOIN " . DB_PREFIX . "option_value ov ON(pov.option_value_id = ov.option_value_id) LEFT JOIN " . DB_PREFIX . "option_value_description ovd ON(pov.option_value_id = ovd.option_value_id AND ovd.language_id = '" . (int)$this->config->get('config_language_id') . "') WHERE pov.product_option_id = '" . (int)$product_option['product_option_id'] . "' ORDER BY ov.sort_order ASC");

      if (!empty($product_option['value'])) {
        $product_option_data[] = array(
          'id'                   => $product_option['option_id'],
          'type'                 => $product_option['type'],
          'name'                 => $product_option['name'],
          'required'             => $product_option['required'],
          'quantity'             => '',
          'subtract'             => '',
          'value'                => $product_option['value'],
          'price'                => '',
          'weight'               => '',
        );
      } else {
        foreach ($product_option_value_query->rows as $product_option_value) {
          $product_option_data[] = array(
            'id'                   => $product_option['option_id'],
            'type'                 => $product_option['type'],
            'name'                 => $product_option['name'],
            'required'             => $product_option['required'],
			'model'             => $product_option_value['model'],
            'quantity'             => $product_option_value['quantity'],
            'subtract'             => $product_option_value['subtract'],
            'value'                => !empty($product_option_value['name']) ? $product_option_value['name'] : $product_option['value'],
            'price'                => $product_option_value['price_prefix'] . $product_option_value['price'],
            'weight'               => $product_option_value['weight_prefix'] . $product_option_value['weight'],
            'image'                => !empty($product_option_value['image']) ? $product_option_value['image'] : '',
          );
          /*
          $product_option_value_data[] = array(
            'option_name'             => $product_option_value['name'],
            'product_option_value_id' => $product_option_value['product_option_value_id'],
            'option_value_id'         => $product_option_value['option_value_id'],
            'quantity'                => $product_option_value['quantity'],
            'subtract'                => $product_option_value['subtract'],
            'price'                   => $product_option_value['price'],
            'price_prefix'            => $product_option_value['price_prefix'],
            'points'                  => $product_option_value['points'],
            'points_prefix'           => $product_option_value['points_prefix'],
            'weight'                  => $product_option_value['weight'],
            'weight_prefix'           => $product_option_value['weight_prefix']
          );
          */
        }
			}
      /*
			$product_option_data[] = array(
				'product_option_id'    => $product_option['product_option_id'],
				'option_id'            => $product_option['option_id'],
				'name'                 => $product_option['name'],
				'type'                 => $product_option['type'],
				'value'                => $product_option['value'],
				'price'                => $product_option_value['price_prefix'] . $product_option_value['price'],
				'required'             => $product_option['required'],
				'product_option_value' => $product_option_value_data,
			);
      */
		}
    
    // type:name:value:price:qty:subtract:weight:required
    
    $res = '';
    
    if ($asArray) {
      return $product_option_data;
    }
    
    // get formatted string for CSV, take only default language
    foreach ($product_option_data as $item) {
      $res .= $res ? '|' : '';
      $res .= $item['type'] . ':' . $item['name'] . ':' . $item['value']. ':' . $item['price'] . ':' . $item['quantity'] . ':' . $item['subtract'] . ':' . $item['weight'] . ':' . $item['required'];
    }
    
		return $res;
	}
  
  public function getProductCoupon($product_id) {
    $query = $this->db->query("SELECT c.code FROM " . DB_PREFIX . "coupon_product cp LEFT JOIN " . DB_PREFIX . "coupon c ON (cp.coupon_id = c.coupon_id) WHERE cp.product_id = '". (int)$product_id."'")->row;
    
    if (!empty($query['code'])) {
      return $query['code'];
    }
    
    $categories = $this->db->query("SELECT category_id FROM " . DB_PREFIX . "product_to_category WHERE product_id = '" . (int)$product_id . "'")->rows;
    
    if (empty($categories)) {
      return '';
    }
    
    $cats = array();
    foreach ($categories as $category) {
      $cats[] = $category['category_id'];
    }
    
    $categories = implode(',', $cats);
    
    if (empty($categories)) {
      return '';
    }
    
    $query = $this->db->query("SELECT c.code FROM " . DB_PREFIX . "coupon_category cc LEFT JOIN " . DB_PREFIX . "coupon c ON (cc.coupon_id = c.coupon_id) WHERE cc.category_id IN (". $categories . ")")->row;
    
    if (!empty($query['code'])) {
      return $query['code'];
    }
    
    return '';
  }
  
  public function setProductCategoryData($product_id, &$row) {
    $categories = $this->db->query("
      SELECT pcd.name as parent_category, cd.name as category, c.category_id, c.parent_id as parent_category_id
      FROM " . DB_PREFIX . "product_to_category p2c
       LEFT JOIN " . DB_PREFIX . "category c ON (p2c.category_id = c.category_id)
       LEFT JOIN " . DB_PREFIX . "category_description cd ON (p2c.category_id = cd.category_id AND cd.language_id = '" . (int)$this->config->get('config_language_id') . "')
       LEFT JOIN " . DB_PREFIX . "category_description pcd ON (c.parent_id = pcd.category_id AND pcd.language_id = '" . (int)$this->config->get('config_language_id') . "')
      WHERE p2c.product_id = '" . (int)$product_id . "' AND c.status = 1 ORDER BY c.parent_id DESC")->row;
      
      if (empty($categories)) {
        $categories = array(
          'category' => '',
          'category_id' => '',
          'parent_category' => '',
          'parent_category_id' => '',
        );
      }
      $row = array_merge($row, $categories);
  }
  
  public function getProductCategories($product_id, $config = array(), $asArray = false) {
		$res = array();
    
		$categories = $this->db->query("
      SELECT pcd.name as parent_name, cd.name, c.category_id, c.parent_id
      FROM " . DB_PREFIX . "product_to_category p2c
       LEFT JOIN " . DB_PREFIX . "category c ON (p2c.category_id = c.category_id)
       LEFT JOIN " . DB_PREFIX . "category_description cd ON (p2c.category_id = cd.category_id AND cd.language_id = '" . (int)$this->config->get('config_language_id') . "')
       LEFT JOIN " . DB_PREFIX . "category_description pcd ON (c.parent_id = pcd.category_id AND pcd.language_id = '" . (int)$this->config->get('config_language_id') . "')
      WHERE p2c.product_id = '" . (int)$product_id . "' AND c.status = 1")->rows;
      
		foreach ($categories as $key => $category) {
      $res[$key] = '';
      
			if (!$category) continue;
      
      if (!empty($category['name'])) {
        $res[$key] = $category['name'];
      }
			
			while (!empty($category['parent_id'])) {
        if ($category['category_id'] === $category['parent_id']) {
          break;
        }
        
				$res[$key] = $category['parent_name'] . '>' . $res[$key];
				$category = $this->db->query("
          SELECT pcd.name as parent_name, c.category_id, c.parent_id FROM " . DB_PREFIX . "category c
           LEFT JOIN " . DB_PREFIX . "category_description pcd ON (c.parent_id = pcd.category_id AND pcd.language_id = '" . (int)$this->config->get('config_language_id') . "')
          WHERE c.category_id = '" . $category['parent_id']. "' AND c.status = 1")->row;
			}
		}
    
    if ($asArray) {
      if (!empty($config['one_category'])) {
        $res = (array) array_shift($res);
      }
      
      return $res;
    }
    
		if (!count($res)) return '';
    
    if (!empty($config['one_category'])) {
      $res = array_shift($res);
    } else {
      $res = implode('|', $res);
    }
    
    return $res;
	}
  
  public function getProductFilters($product_id, $asArray = false) {
		$query = $this->db->query("SELECT fd.name as name, fgd.name as group_name FROM " . DB_PREFIX . "product_filter pf
    LEFT JOIN " . DB_PREFIX . "filter f ON (pf.filter_id = f.filter_id)
    LEFT JOIN " . DB_PREFIX . "filter_description fd ON (pf.filter_id = fd.filter_id)
    LEFT JOIN " . DB_PREFIX . "filter_group fg ON (f.filter_group_id = fg.filter_group_id)
    LEFT JOIN " . DB_PREFIX . "filter_group_description fgd ON (f.filter_group_id = fgd.filter_group_id)
    WHERE pf.product_id = '" . (int)$product_id . "'
    AND fd.language_id = '" . (int)$this->config->get('config_language_id') . "'
    AND fgd.language_id = '" . (int)$this->config->get('config_language_id') . "'
    ORDER BY f.sort_order, fg.sort_order, f.filter_id");


    if ($asArray) {
      return $query->rows;
    }
    
    // get formatted string for CSV, take only default language
    $res = '';
    
    foreach ($query->rows as $item) {
      $res .= $res ? '|' : '';
      $res .= $item['group_name'] . ':' . $item['name'];
    }
    
		return $res;
	}
  
  public function getProductDiscounts($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_discount WHERE product_id = '" . (int)$product_id . "' ORDER BY quantity, priority, price");

    $res = '';
    
    // get formatted string for CSV, take only default language
    foreach ($query->rows as $item) {
      return $item['price'];
      // $res .= $res ? '|' : '';
      // $res .= $item['customer_group_id'] . ':' . $item['quantity'] . ':' . $item['priority'] . ':' . $item['price'] . ':' . $item['date_start'] . ':' . $item['date_end'];
    }
    
		return $res;
	}
  
  public function getProductSpecial($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int)$product_id . "' ORDER BY priority, price LIMIT 1");
    
    foreach ($query->rows as $item) {
      return $item['price'];
    }
    
	}
  
  public function getProductSpecials($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int)$product_id . "' ORDER BY priority, price");

    $res = '';
    
    // get formatted string for CSV, take only default language
    foreach ($query->rows as $item) {
      $res .= $res ? '|' : '';
      $res .= $item['customer_group_id'] . ':' . $item['priority'] . ':' . $item['price'] . ':' . $item['date_start'] . ':' . $item['date_end'];
    }
    
		return $res;
	}
  
  public function getTotalItems($data = array()) {
    return $this->getItems($data, true);
  }
}