<?php
@set_time_limit(1800);

class ModelUniversalFeedGlamiRo extends Model {

  public function writeHeader($fh, $config) {
    fwrite($fh, '<?xml version="1.0" encoding="UTF-8"?>'.
                '<SHOP>'."\n");
  }
  
  public function writeFooter($fh) {
    fwrite($fh, '</SHOP>');
  }
  
  public function writeBody($fh, $config) {
    $config['attributeAsArray'] = $config['optionAsArray'] = true;
    
    $config['filter_store'] = $this->config->get('config_store_id');
    if (!empty($config['option_size']) || !empty($config['option_color'])) {
      $config['option_row'] = true;
    }
    
    $products = $this->model_universal_feed_driver_product->getItems($config);
    
    //$products = $this->model_tool_universal_feed->getProducts($config);

    $price_modifier = !empty($config['price_modifier']) ? $config['price_modifier'] : 1;
    $currency = !empty($config['currency']) ? $config['currency'] : 'USD';
    $gtin = !empty($config['gtin']) ? $config['gtin'] : '';

    $row = 0;
    $save_count = 0;
    
    foreach ($products as $item) {
      if ($this->config->get('univfeed_sleep')) {
        usleep((int) $this->config->get('univfeed_sleep') * 1000); // 1 000 000 = 1s
      }
      
      $this->session->data['ufeed_lastItem'] = $item['product_id'];
      
      // which price to show?
      $price_order = !empty($config['price_order']) ? explode('_', $config['price_order']) : array('special', 'discount', 'price');
      
      foreach ($price_order as $p) {
        if ($item[$p]) {
          $price_value = $item[$p];
          break;
        } 
      }
      
      if (empty($config['price_tax'])) {
        $price = $this->currency->format($this->tax->calculate($price_value * $price_modifier, $item['tax_class_id']), $currency, false, false);
      } else {
        $price = $this->currency->format($price_value * $price_modifier, $currency, false, false);
      }
      
      $category = $this->getCategory($item['product_id']);
      
      // set id field
      $item_id = $item['product_id'];
      if (!empty($config['id_field']) && isset($item[$config['id_field']])) {
        $item_id = $item[$config['id_field']];
      }
      
      $line = array(
        'ITEM_ID' => $item_id . (!empty($item['variant_count']) ? '-'.$item['variant_count'] : ''),
        'ITEMGROUP_ID' => $item['model'], //variants for options
        'PRODUCTNAME' => $item['name'],
        'DESCRIPTION' => $item['description'],
        'IMGURL' => $item['image'],
        'URL' => $this->url->link('product/product', 'product_id=' . $item['product_id'] . (!empty($config['force_currency']) ? '&currency='.$currency : '')),
        'PRICE_VAT' => $price,
        'MANUFACTURER' => $item['manufacturer'],
        'CATEGORYTEXT' => $item['product_category'],
        'CATEGORY_ID' => !empty($category['id']) ? $category['id'] : '',
        'EAN' => $item['ean'],
        'GLAMI_CPC' => 0,
        'DELIVERY_DATE' => isset($config['shipping_time']) ? $config['shipping_time'] : '',
      );
      
      if (isset($item['option_id']) && $item['option_id'] == $config['option_size']) {
        $line['SIZE'] = $item['option_value'];
      }
      
      if (isset($item['option_id']) && $item['option_id'] == $config['option_color']) {
        $line['COLOR'] = $item['option_value'];
      }
      
      if (!empty($config['thumbnail']) && !empty($item['image_path'])) {
        $line['Thumbnail'] = @$this->model_tool_image->resize($item['image_path'], 400, 400);
      }
    
      $output = '<SHOPITEM>';
      
      foreach ($line as $k => $v) {
        if (strpos($v, '<') !== false || strpos($v, '&') !== false) {
          $output .= "\t\t".'<'.$k.'><![CDATA['.html_entity_decode($v, ENT_QUOTES, 'UTF-8').']]></'.$k.'>'."\n";
        } else if ($v !== '') {
          $output .= "\t\t".'<'.$k.'>'.html_entity_decode($v, ENT_QUOTES, 'UTF-8').'</'.$k.'>'."\n";
        } else {
          $output .= "\t\t".'<'.$k.'/>'."\n";
        }
      }
      
      /*foreach ($item['product_attribute'] as $params) {
        foreach ($params as $param) {
          $output .= ' <PARAM><PARAM_NAME><![CDATA[' . $param['attribute'] . ']]></PARAM_NAME><VAL><![CDATA[' . $param['value'] . ']]></VAL></PARAM>';
        }
      }*/
      
      foreach ($item['product_option'] as $param) {
        $output .= ' <PARAM><PARAM_NAME><![CDATA[' . $param['name'] . ']]></PARAM_NAME><VAL><![CDATA[' . $param['value'] . ']]></VAL></PARAM>';
      }
      
      $images = $this->model_tool_universal_feed->getProductImages($item['product_id']);
      
      foreach ($images as $i => $image) {
        $output .= '<IMGURL_ALTERNATIVE><![CDATA[' . @$this->model_tool_image->resize($image['image'], 250, 250) . ']]></IMGURL_ALTERNATIVE>';
      }
      
      $output .= '</SHOPITEM>' . "\n";
      
      fwrite($fh, $output);
      
      $row++;
    }
    
    // return false when no more products
    return !empty($output);
  }
  
  public function getTotalItems($data = array()) {
    return $this->model_universal_feed_driver_product->getTotalItems($data);
  }
  
  private function getCategory($product_id) {
		$gcats = array();
		$categories = $this->db->query("SELECT c.glami_ro_cat, cd.name FROM " . DB_PREFIX . "product_to_category p2c LEFT JOIN " . DB_PREFIX . "category c ON (p2c.category_id = c.category_id) LEFT JOIN " . DB_PREFIX . "category_description cd ON (c.category_id = cd.category_id) AND cd.language_id = " . $this->config->get('config_language_id') . " WHERE product_id = '" . (int)$product_id . "'")->rows;
		
		foreach ($categories as $category) {
      if (!empty($category['glami_ro_cat'])) {
        return array(
          'id' => $category['glami_ro_cat'],
          'name' => $category['name'],
        );
      }
		}
	}
}