<?php
class ModelUniversalFeedGooglePromotionCsv extends Model {

  public function writeHeader($fh, $config) {
    $data = array(
      'promotion_id',
      'product_applicability',
      'long_title',
      'promotion_effective_dates',
      'promotion_display_dates',
      'redemption_channel',
      'offer_type',
      'generic_redemption_code',
    );
    
    $this->model_tool_universal_feed->write_csv($fh, $data, ';');
  }
  
  public function writeFooter($fh) {}
  
  public function writeBody($fh, $config) {
    $config['filter_store'] = $this->config->get('config_store_id');

    $items = $this->getCoupons();
    
    $row = 0;
    $save_count = 0;

    foreach ($items as $item) {
      if ($this->config->get('univfeed_sleep')) {
        usleep((int) $this->config->get('univfeed_sleep') * 1000); // 1 000 000 = 1s
      }
      
      $this->session->data['ufeed_lastItem'] = $item['coupon_id'];

      $onProducts = $this->getCouponProducts($item['coupon_id']);
      $onCategories = $this->getCouponCategories($item['coupon_id']);
      
      $output = array();
      $output[] = $item['code'];
      $output[] = (empty($onCategories) && empty($onProducts)) ? 'ALL_PRODUCTS' : 'SPECIFIC_PRODUCTS';
      $output[] = $item['name'];
      $output[] = date('c', strtotime($item['date_start'])) . '/' . date('c', strtotime($item['date_end']));
      $output[] = 'ONLINE';
      $output[] = 'GENERIC_CODE';
      $output[] = $item['code'];
      
      $this->model_tool_universal_feed->write_csv($fh, $output, ';');
      
      $row++;
    }
    
    // return false when no more items
    return !empty($output);
  }
  
  public function getTotalItems($data = array()) {
    return $this->model_universal_feed_driver_product->getTotalItems($data);
  }
  
  private function getGoogleCategory($item_id) {
		$gcats = array();
		$categories = $this->db->query("SELECT c.google_merchant_id, cd.name FROM " . DB_PREFIX . "product_to_category p2c LEFT JOIN " . DB_PREFIX . "category c ON (p2c.category_id = c.category_id) LEFT JOIN " . DB_PREFIX . "category_description cd ON (c.category_id = cd.category_id) AND cd.language_id = " . $this->config->get('config_language_id') . " WHERE coupon_id = '" . (int)$item_id . "'")->rows;
		
		foreach($categories as $category) {
      if (!empty($category['google_merchant_id'])) {
        return array(
          'id' => $category['google_merchant_id'],
          'name' => $category['name'],
        );
      }
		}
	}
  
  public function getCoupons($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "coupon";

		$sort_data = array(
			'name',
			'code',
			'discount',
			'date_start',
			'date_end',
			'status'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY name";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}
  
  public function getCouponProducts($coupon_id) {
		$coupon_product_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "coupon_product WHERE coupon_id = '" . (int)$coupon_id . "'");

		foreach ($query->rows as $result) {
			$coupon_product_data[] = $result['product_id'];
		}

		return $coupon_product_data;
	}

	public function getCouponCategories($coupon_id) {
		$coupon_category_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "coupon_category WHERE coupon_id = '" . (int)$coupon_id . "'");

		foreach ($query->rows as $result) {
			$coupon_category_data[] = $result['category_id'];
		}

		return $coupon_category_data;
	}
}