<?php
class ModelUniversalFeedGoogleReviews extends Model {

  public function writeHeader($fh, $config) {
    fwrite($fh,
'<?xml version="1.0" encoding="UTF-8"?>
<feed xmlns:vc="http://www.w3.org/2007/XMLSchema-versioning"
      xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
      xsi:noNamespaceSchemaLocation="http://www.google.com/shopping/reviews/schema/product/2.1/product_reviews.xsd">
  <publisher>
    <name>'.$this->config->get('config_name').'</name>
  </publisher>
  <reviews>' . "\n");
  }
  
  public function writeFooter($fh) {
    fwrite($fh, '  </reviews>'."\n".'</feed>');
  }
  
  public function writeBody($fh, $config) {
    ini_set('display_errors', 0);
    $config['filter_store'] = $this->config->get('config_store_id');
    
    $this->load->model('universal_feed/driver_review');
    $items = $this->model_universal_feed_driver_review->getItems($config);
    
    $row = 0;
    $save_count = 0;

    $this->load->model('catalog/product');
	
    foreach ($items as $item) {
      if ($this->config->get('univfeed_sleep')) {
        usleep((int) $this->config->get('univfeed_sleep') * 1000); // 1 000 000 = 1s
      }
      
      // google requires to strip urls and emails
      $item['text'] = preg_replace('/(?:@|https?:\/\/)?([\da-z.-]+\.[a-z.]{2,6})\b(?!@)/', '', $item['text']);
      
      // do not include empty reviews
      if (!trim($item['text'])) {
        continue;
      }
      
      $prod_info = $this->model_catalog_product->getProduct($item['product_id']);
		
      $this->session->data['ufeed_lastItem'] = $item['review_id'];
      $output = '<review>';
      $output .= '<review_id>' . (int) $item['review_id'] . '</review_id>';
      $output .= '<reviewer>';
        $output .= '<name><![CDATA[' . html_entity_decode($item['author'], ENT_QUOTES, 'UTF-8') . ']]></name>';
        $output .= '<reviewer_id>' . (int) $item['customer_id'] . '</reviewer_id>';
      $output .= '</reviewer>';
			$output .= '<review_timestamp>' . date('Y-m-d\TH:i:sP', strtotime( $item['date_added'] )) . '</review_timestamp>';
			$output .= '<content><![CDATA[' . html_entity_decode($item['text'], ENT_QUOTES, 'UTF-8') . ']]></content>';
      $output .= '<ratings>';
        $output .= '<overall min="1" max="5">' . $item['rating'] . '</overall>';
      $output .= '</ratings>';
      $output .= '<review_url type="singleton"><![CDATA[' .  $this->url->link('product/product', 'product_id=' . $item['product_id']) . ']]></review_url>';
      $output .= '<products><product>';
      
      $output .= '<product_name><![CDATA[' . html_entity_decode($item['name'], ENT_QUOTES, 'UTF-8') . ']]></product_name>';

        $output .= '<product_url><![CDATA[' .  $this->url->link('product/product', 'product_id=' . $item['product_id']) . ']]></product_url>';
      $output .= '</product></products>';
      
      $output .= '<product_ids>';
      $output .= '<gtins>';
      $output .= '<gtin>'.$prod_info['upc'].'</gtin>';
      $output .= '</gtins>';
      $output .= '<mpns>';
      $output .= '<mpn>'.(!empty($prod_info['mpn']) ? $prod_info['mpn'] : $prod_info['model']).'</mpn>';
      $output .= '</mpns>';
      $output .= '<skus>';
      $output .= '<sku>'.$prod_info['sku'].'</sku>';
      $output .= '</skus>';
      $output .= '<brands>';
      $output .= '<brand>'.$prod_info['manufacturer'].'</brand>';
      $output .= '</brands>';
      $output .= '</product_ids>';
      
      /*
			//<!-- 2 of the following 3 attributes are required fot this item according to the Unique Product Identifier Rules -->
      $has_identifier = 0;
      
      if (!empty($item[$gtin])) {
        $has_identifier++;
        $output .= '<g:gtin>' . $item[$gtin] . '</g:gtin>';
      }
      
      if ($item['manufacturer']) {
        $has_identifier++;
        $output .= '<g:brand><![CDATA[' . htmlentities($item['manufacturer'], ENT_QUOTES, 'UTF-8', 0) . ']]></g:brand>';
      }
      
      if ($item['mpn']) {
        $has_identifier++;
        $output .= '<g:mpn>' . $item['mpn'] . '</g:mpn>';
      }
			
      if ($has_identifier < 2) {
        $output .= '<g:identifier_exists>FALSE</g:identifier_exists>';
      }
      */
     
      $output .= '</review>' . "\n";
      
      fwrite($fh, $output);
      
      $row++;
    }
    
    // return false when no more products
    return !empty($output);
  }
  
  public function getTotalItems($data = array()) {
    $this->load->model('universal_feed/driver_review');
    return $this->model_universal_feed_driver_review->getTotalItems($data);
  }
}