<?php
class ModelUniversalFeedGoogleReviews extends Model {

  public function writeHeader($fh, $config) {
    fwrite($fh,
'<?xml version="1.0" encoding="UTF-8"?>
<feed xmlns="http://schemas.google.com/merchant_reviews/5.0"
      xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
      xsi:schemaLocation="http://schemas.google.com/merchant_reviews/5.0 http://www.gstatic.com/productsearch/static/reviews/5.0/merchant_reviews.xsd">'. "\n"
. '<reviews>' . "\n");
  }
  
/*
<merchants>
  <merchant id="'.$config['merchant_id'].'">
    <name>Google Store</name>
    <merchant_url>'.$this->config->get('config_url').'</merchant_url>
    <rating_url>'.$this->config->get('config_url').'</rating_url>
    <create_timestamp>'.date('c').'</create_timestamp>
    <last_update_timestamp>'.date('c').'</last_update_timestamp>
  </merchant>
</merchants>
*/

  public function writeFooter($fh) {
    fwrite($fh, '  </reviews>'."\n".'</feed>');
  }
  
  public function writeBody($fh, $config) {
    ini_set('display_errors', 0);
    $config['filter_store'] = $this->config->get('config_store_id');
    
    $this->load->model('universal_feed/driver_review');
    $items = $this->model_universal_feed_driver_review->getItems($config);
    
    $country_query = $this->db->query("SELECT iso_code_2 FROM ".DB_PREFIX."country WHERE country_id = '".(int) $this->config->get('config_country_id')."'")->row;
    $country = !empty($country_query['iso_code_2']) ? $country_query['iso_code_2'] : 'US';
    
    $row = 0;
    $save_count = 0;
    foreach ($items as $item) {
      if ($this->config->get('univfeed_sleep')) {
        usleep((int) $this->config->get('univfeed_sleep') * 1000); // 1 000 000 = 1s
      }

      $this->session->data['ufeed_lastItem'] = $item['product_id'];
      $output = '<review id="' . (int) $item['product_id'] . '" mid="' . $config['merchant_id'] . '">';
        $output .= '<reviewer_name><![CDATA[' . htmlentities($item['author'], ENT_QUOTES, 'UTF-8', 0) . ']]></reviewer_name>';
        $output .= '<create_timestamp>' . date('c', strtotime( $item['date_added'] )) . '</create_timestamp>';
        $output .= '<last_update_timestamp>' . date('c', strtotime( $item['date_added'] )) . '</last_update_timestamp>';
        $output .= '<country_code>' . $country . '</country_code>';
        $output .= '<content><![CDATA[' . htmlentities($item['text'], ENT_QUOTES, 'UTF-8', 0) . ']]></content>';
        $output .= '<collection_method>after_fulfillment</collection_method>';
        $output .= '<ratings>';
          $output .= '<overall min="1" max="5">' . $item['rating'] . '</overall>';
        $output .= '</ratings>';
        /*
        $output .= '<products><product>';
          $output .= '<product_name><![CDATA[' . $item['name'] . ']]></product_name>';
          $output .= '<product_url><![CDATA[' . $this->url->link('product/product', 'product_id=' . $item['product_id']) . ']]></product_url>';
        $output .= '</product></products>';
        */
      $output .= '</review>' . "\n";
      // old format
      /*
      $output .= '<review_id>' . (int) $item['product_id'] . '</review_id>';
      $output .= '<reviewer>';
        $output .= '<name><![CDATA[' . htmlentities($item['author'], ENT_QUOTES, 'UTF-8', 0) . ']]></name>';
        $output .= '<reviewer_id>' . (int) $item['customer_id'] . '</reviewer_id>';
      $output .= '</reviewer>';
			$output .= '<review_timestamp>' . date('Y-m-d\TH:i:sP', strtotime( $item['date_added'] )) . '</review_timestamp>';
			$output .= '<content><![CDATA[' . htmlentities($item['text'], ENT_QUOTES, 'UTF-8', 0) . ']]></content>';
      $output .= '<ratings>';
        $output .= '<overall min="1" max="5">' . $item['rating'] . '</overall>';
      $output .= '</ratings>';
      $output .= '<products><product>';
        $output .= '<product_name><![CDATA[' . $item['name'] . ']]></product_name>';
        $output .= '<product_url><![CDATA[' . $this->url->link('product/product', 'product_id=' . $item['product_id']) . ']]></product_url>';
      $output .= '</product></products>';
      */
      /*
			//<!-- 2 of the following 3 attributes are required fot this item according to the Unique Product Identifier Rules -->
      $has_identifier = 0;
      
      if (!empty($item[$gtin])) {
        $has_identifier++;
        $output .= '<g:gtin>' . $item[$gtin] . '</g:gtin>';
      }
      
      if ($item['manufacturer']) {
        $has_identifier++;
        $output .= '<g:brand><![CDATA[' . htmlentities($item['manufacturer'], ENT_QUOTES, 'UTF-8', 0) . ']]></g:brand>';
      }
      
      if ($item['mpn']) {
        $has_identifier++;
        $output .= '<g:mpn>' . $item['mpn'] . '</g:mpn>';
      }
			
      if ($has_identifier < 2) {
        $output .= '<g:identifier_exists>FALSE</g:identifier_exists>';
      }
      */
     
      
      
      fwrite($fh, $output);
      
      $row++;
    }
    
    // return false when no more products
    return !empty($output);
  }
  
  public function getTotalItems($data = array()) {
    $this->load->model('universal_feed/driver_review');
    return $this->model_universal_feed_driver_review->getTotalItems($data);
  }
}