<?php
@set_time_limit(1800);

class ModelUniversalFeedOkazjeInfo extends Model {

  public function writeHeader($fh, $config) {
    fwrite ($fh, '<?xml version="1.0" encoding="UTF-8" ?>'.
                '<okazje>'.
                '<offers>');
  }
  
  public function writeFooter($fh) {
    fwrite($fh, '</offers></okazje>');
  }
  
  public function writeBody($fh, $config) {
    $config['filter_store'] = $this->config->get('config_store_id');
    
    $products = $this->model_universal_feed_driver_product->getItems($config);
    
    //$products = $this->model_tool_universal_feed->getProducts($config);

    $price_modifier = !empty($config['price_modifier']) ? $config['price_modifier'] : 1;
    $currency = !empty($config['currency']) ? $config['currency'] : 'USD';
    $gtin = !empty($config['gtin']) ? $config['gtin'] : '';

    $row = 0;
    $save_count = 0;
    
    foreach ($products as $item) {
      if ($this->config->get('univfeed_sleep')) {
        usleep((int) $this->config->get('univfeed_sleep') * 1000); // 1 000 000 = 1s
      }
      
      // fix issues of some special chars in descriptions
      $item['description'] = preg_replace('~[^\P{Cc}\r\n]+~u', '', $item['description']);
      
      $this->session->data['ufeed_lastItem'] = $item['product_id'];
      
      // which price to show?
      $price_order = !empty($config['price_order']) ? explode('_', $config['price_order']) : array('special', 'discount', 'price');
      
      foreach ($price_order as $p) {
        if ($item[$p]) {
          $price_value = $item[$p];
          break;
        } 
      }
      
      if (empty($config['price_tax'])) {
        $price = $this->currency->format($this->tax->calculate($price_value * $price_modifier, $item['tax_class_id']), $currency, false, false);
      } else {
        $price = $this->currency->format($price_value * $price_modifier, $currency, false, false);
      }
      
      $output = '<offer>'."\n";
      $output .= '<id>'.$item['product_id'].'</id>'."\n";
      $output .= '<name><![CDATA['.html_entity_decode($item['name'], ENT_QUOTES, 'UTF-8').']]></name>'."\n";
      $output .= '<description><![CDATA['.html_entity_decode($item['description'], ENT_QUOTES, 'UTF-8').']]></description>'."\n";

      $output .= '<category><![CDATA['.html_entity_decode(str_replace('|', ' / ', $item['product_category']), ENT_QUOTES, 'UTF-8').']]></category>'."\n";
      
      $output .= '<price>'.$item['price'].'</price>'."\n";
      $output .= '<url>'.$this->url->link('product/product', 'product_id='.$item['product_id'], 'SSL').'</url>'."\n";
      $output .= '<producer><![CDATA['.html_entity_decode($item['manufacturer'], ENT_QUOTES, 'UTF-8').']]></producer>'."\n";
      $output .= '<images>'."\n";
      $output .= '<image>'.$item['image'].'</image>'."\n";
      if(!empty($item['additional_images'])){
        $addimages = explode('|',$item['additional_images']);
        foreach ($addimages as $ai_k => $ai_v) {
          $output .= '<addimage>'.$ai_v.'</addimage>'."\n";
        }
      }
      $output .= '</images>'."\n";

      $output .= '<attribute name="kod producenta">'.$item['model'].'</attribute>'."\n";

      if(!empty($item['ean'])){
        $output .= '<attribute name="EAN">'.$item['ean'].'</attribute>'."\n";
      }
      if(!empty($item['isbn'])){
        $output .= '<attribute name="ISBN">'.$item['isbn'].'</attribute>'."\n";
      }
      foreach (explode('|', $item['product_option']) as $opts) {
        if (strpos($opts, ':') !== false) {
          list($opts_type,$opts_name,$opts_value) = explode(':', $opts);

          $output .= '<attribute name="'.html_entity_decode($opts_name, ENT_QUOTES, 'UTF-8').'">'.html_entity_decode($opts_value, ENT_QUOTES, 'UTF-8').'</attribute>'."\n";
        }
      }
      foreach (explode('|', $item['product_attribute']) as $attr) {
        if (strpos($attr, ':') !== false) {
          list($attr_name, $attr_value) = explode(':', $attr);
          $output .= '<attribute name="'.html_entity_decode($attr_name, ENT_QUOTES, 'UTF-8').'">'.html_entity_decode($attr_value, ENT_QUOTES, 'UTF-8').'</attribute>'."\n";
        }
      }
      $output .= '<weight>'.$this->weight->format($item['weight'], $item['weight_class_id']).'</weight>'."\n";
      if($item['quantity'] > 0){
        $output .= '<availability>1</availability>'."\n";
      } else {
        $output .= '<availability>14</availability>'."\n";
      }
      
      $output .= '</offer>'."\n";

      fwrite($fh, $output);
      
      $row++;
    }
    
    // return false when no more products
    return !empty($output);
  }
  
  public function getTotalItems($data = array()) {
    return $this->model_universal_feed_driver_product->getTotalItems($data);
  }
  
  private function getGoogleCategory($product_id) {
		$gcats = array();
		$categories = $this->db->query("SELECT c.google_merchant_id, cd.name FROM " . DB_PREFIX . "product_to_category p2c LEFT JOIN " . DB_PREFIX . "category c ON (p2c.category_id = c.category_id) LEFT JOIN " . DB_PREFIX . "category_description cd ON (c.category_id = cd.category_id) AND cd.language_id = " . $this->config->get('config_language_id') . " WHERE product_id = '" . (int)$product_id . "'")->rows;
		
		foreach($categories as $category) {
      if (!empty($category['google_merchant_id'])) {
        return array(
          'id' => $category['google_merchant_id'],
          'name' => $category['name'],
        );
      }
		}
	}
}