<?php
@set_time_limit(1800);

class ModelUniversalFeedStockmount extends Model {

  public function __construct($registry) {
		parent::__construct($registry);
    $this->xml_tools = $this->model_tool_universal_feed;
  }

  public function writeHeader($fh, $config) {
    fwrite($fh, '<?xml version="1.0" encoding="UTF-8"?>'.
                $this->xml_tools->openXmlNode('Products', 0));
  }
  
  public function writeFooter($fh) {
    fwrite($fh, $this->xml_tools->closeXmlNode('Products', 0));
  }
  
  public function writeBody($fh, $config) {
    $config['attributeAsArray'] = true;
    $config['optionAsArray'] = true;
    
    $config['filter_store'] = $this->config->get('config_store_id');
    // if (!empty($config['option_size']) || !empty($config['option_color'])) {
      // $config['option_row'] = true;
    // }
    $products = $this->model_universal_feed_driver_product->getItems($config);

    $price_modifier = !empty($config['price_modifier']) ? $config['price_modifier'] : 1;
    $currency = !empty($config['currency']) ? $config['currency'] : 'USD';
    $gtin = !empty($config['gtin']) ? $config['gtin'] : '';

    $row = 0;
    $save_count = 0;
    
    $depth = 1;
    
    foreach ($products as $item) {
      if ($this->config->get('univfeed_sleep')) {
        usleep((int) $this->config->get('univfeed_sleep') * 1000); // 1 000 000 = 1s
      }
      
      $this->session->data['ufeed_lastItem'] = $item['product_id'];
      
      // which price to show?
      $price_order = !empty($config['price_order']) ? explode('_', $config['price_order']) : array('special', 'discount', 'price');
      
      foreach ($price_order as $p) {
        if ($item[$p]) {
          $price_value = $item[$p];
          break;
        } 
      }
      
      $discount_price = '';
      if (!empty($item['discount'])) {
        $discount_price = $this->currency->format($this->tax->calculate($item['discount'] * $price_modifier, $item['tax_class_id']), $currency, false, false);
      }
      
      $special_price = '';
      if (!empty($item['discount'])) {
        $special_price = $this->currency->format($this->tax->calculate($item['special'] * $price_modifier, $item['tax_class_id']), $currency, false, false);
      }
      
      $tax_rate = 0;
      $tax_rates = $this->cart->tax->getRates(0, $item['tax_class_id']);
      
      foreach ($tax_rates as $rate) {
        if ($rate['type'] == 'P') {
          $tax_rate = $rate['rate'];
        }
      }
      
      if (empty($config['price_tax'])) {
        $price = $this->currency->format($this->tax->calculate($price_value * $price_modifier, $item['tax_class_id']), $currency, false, false);
      } else {
        $price = $this->currency->format($price_value * $price_modifier, $currency, false, false);
      }
      
      $priceNoVat = $this->currency->format($price_value * $price_modifier, $currency, false, false);
      
      $taxQuery = $this->db->query("SELECT * FROM " . DB_PREFIX . "tax_class WHERE tax_class_id = '" . (int)$item['tax_class_id'] . "'")->row;
      $tax_class = isset($taxQuery['title']) ? $taxQuery['title'] : '';
      
            $item['category_shortest'] = '';
      $item['category_largest'] = '';
      
      $categories = explode('|', $item['product_category']);
      
      if (count($categories)) {
        usort($categories, array($this, 'sortBySubcatNumber'));
        $item['category_shortest'] = reset($categories);
        $item['category_largest'] = end($categories);
      }
      
     
      $line = array(
        'ProductCode' => $item['model'],
        'ProductName' => $item['name'],
        'Quantity' => $item['quantity'],
        'Price' => $price,
        'Currency' => $currency,
        'TaxRate' => $tax_class,
        'Barcode' => $item['ean'],
        'Category' => $item['category_largest'],
        'Description' => $item['meta_description'] ? $item['meta_description'] : $this->model_tool_universal_feed->truncate($this->model_tool_universal_feed->sanitize($item['description']), 5000),
        'Image1' => $item['image'],
        'Brand' => $item['manufacturer'],
        
      );
      
      $output = $this->xml_tools->openXmlNode('Product', $depth++);
      
      foreach ($line as $k => $v) {
        $output .= $this->xml_tools->getXmlNode($k, $v, $depth);
      }
      
      /*
      if (!empty($item['product_attribute'])) {
        $output .= $this->xml_tools->openXmlNode('attributesNumbered', $depth++);
        
        foreach ($item['product_attribute'] as $k => $attr) {
            if (!empty($attr[$this->config->get('config_language_id')])) {
              $attributes = $attr[$this->config->get('config_language_id')];
              $k++;
              $output .= $this->xml_tools->openXmlNode('attribute_'.$k, $depth++);
              
              if (isset($attributes['group'])) {
                $output .= $this->xml_tools->getXmlNode('attr_group_'.$k, $attributes['group'], $depth);
              }
              
              if (isset($attributes['attribute'])) {
                $output .= $this->xml_tools->getXmlNode('attr_name_'.$k, $attributes['attribute'], $depth);
              }
              
              if (isset($attributes['value'])) {
                $output .= $this->xml_tools->getXmlNode('attr_value_'.$k, $attributes['value'], $depth);
              }
              
              $output .= $this->xml_tools->closeXmlNode('attribute_'.$k, --$depth);
            }
        }
        
        $output .= $this->xml_tools->closeXmlNode('attributesNumbered', --$depth);
      } else {
        $output .= $this->xml_tools->getXmlNode('attributesNumbered', '', $depth);
      }
      */
      
     
      
      /*
      if (!empty($item['product_attribute'])) {
        $output .= $this->xml_tools->openXmlNode('attributes', $depth++);
        
        foreach ($item['product_attribute'] as $attr) {
            if (!empty($attr[$this->config->get('config_language_id')])) {
              $attributes = $attr[$this->config->get('config_language_id')];
              
              $output .= $this->xml_tools->openXmlNode('attribute', $depth++);
              
              if (isset($attributes['group'])) {
                $output .= $this->xml_tools->getXmlNode('attr_group', $attributes['group'], $depth);
              }
              
              if (isset($attributes['attribute'])) {
                $output .= $this->xml_tools->getXmlNode('attr_name', $attributes['attribute'], $depth);
              }
              
              if (isset($attributes['value'])) {
                $output .= $this->xml_tools->getXmlNode('attr_value', $attributes['value'], $depth);
              }
              
              $output .= $this->xml_tools->closeXmlNode('attribute', --$depth);
            }
        }
        
        $output .= $this->xml_tools->closeXmlNode('attributes', --$depth);
      } else {
        $output .= $this->xml_tools->getXmlNode('attributes', '', $depth);
      }
      */
      
      // Combined different possibilities mode
      if (!empty($item['product_option'])) {
        $mergedOptions = array();
        $defaultOption = $item['product_option'][0]['name'];
        
        foreach ($item['product_option'] as $i => $option) {
          if ($option['name'] == $defaultOption) {
          }
        }
        
        foreach ($item['product_option'] as $i => $option) {
          $hasSubOptions = false;
          
          if ($option['name'] == $defaultOption) {
            foreach ($item['product_option'] as $i2 => $subOption) {
              if ($subOption['name'] != $defaultOption) {
                $hasSubOptions = true;
                $mergedOptions[$i.'-'.($i2+1)] = $option;
                $mergedOptions[$i.'-'.($i2+1)]['options'][$option['name']] = $option['value'];
                $mergedOptions[$i.'-'.($i2+1)]['options'][$subOption['name']] = $subOption['value'];
                if (isset($mergedOptions[$i.'-'.($i2+1)]['options']['quantity'])) {
                  $mergedOptions[$i.'-'.($i2+1)]['options']['quantity'] += $subOption['quantity'];
                } else {
                  $mergedOptions[$i.'-'.($i2+1)]['options']['quantity'] = $subOption['quantity'];
                }
              }
            }
            
            if (empty($hasSubOptions)) {
              $mergedOptions[$i] = $option;
              $mergedOptions[$i]['options'][$option['name']] = $option['value'];
              $mergedOptions[$i]['options']['quantity'] = $subOption['quantity'];
            }
          }
        }
        
        $variant_count = 0;
        
        $output .= $this->xml_tools->openXmlNode('Variants', $depth++);
        foreach ($mergedOptions as $option) {
          /*
          if (empty($config['price_tax'])) {
            $option_price = $this->currency->format($this->tax->calculate(($price_value + $option['price']) * $price_modifier, $item['tax_class_id']), $currency, false, false);
          } else {
            $option_price = $this->currency->format(($price_value + $option['price']) * $price_modifier, $currency, false, false);
          }
          */
          $output .= $this->xml_tools->openXmlNode('Variant', $depth++);
          $output .= $this->xml_tools->getXmlNode('VariantCode', $option['model'], $depth);
    $output .= $this->xml_tools->getXmlNode('VariantQuantity', $option['options']['quantity'], $depth);
           $output .= $this->xml_tools->getXmlNode('VariantPrice', $price, $depth);
          $output .= $this->xml_tools->getXmlNode('VariantName1', $option['name'], $depth);
          $output .= $this->xml_tools->getXmlNode('VariantValue1', $option['value'], $depth);
         
          if (!empty($option['image'])) {
            $output .= $this->xml_tools->getXmlNode('option_image', $this->config->get('config_url').'image/'.$option['image'], $depth);
          }
       
          $output .= $this->xml_tools->closeXmlNode('Variant', --$depth);
        }
        $output .= $this->xml_tools->closeXmlNode('Variants', --$depth);
      } else {
        $output .= $this->xml_tools->getXmlNode('Variants', '', $depth);
      }
      /* normal mode
      if (!empty($item['product_option'])) {
        $variant_count = 0;
        
        $output .= $this->xml_tools->openXmlNode('options', $depth++);
        foreach ($item['product_option'] as $option) {
          if (empty($config['price_tax'])) {
            $option_price = $this->currency->format($this->tax->calculate(($price_value + $option['price']) * $price_modifier, $item['tax_class_id']), $currency, false, false);
          } else {
            $option_price = $this->currency->format(($price_value + $option['price']) * $price_modifier, $currency, false, false);
          }
          
          $output .= $this->xml_tools->openXmlNode('option', $depth++);
          $output .= $this->xml_tools->getXmlNode('option_code', $item['model'] . '-' . str_pad(++$variant_count, 2, '0', STR_PAD_LEFT), $depth);
          $output .= $this->xml_tools->getXmlNode('option_name', $option['name'], $depth);
          $output .= $this->xml_tools->getXmlNode('option_value', $option['value'], $depth);
          $output .= $this->xml_tools->getXmlNode('option_price', $option_price, $depth);
          if (!empty($option['image'])) {
            $output .= $this->xml_tools->getXmlNode('option_image', $this->config->get('config_url').'image/'.$option['image'], $depth);
          }
          $output .= $this->xml_tools->closeXmlNode('option', --$depth);
        }
        $output .= $this->xml_tools->closeXmlNode('options', --$depth);
      } else {
        $output .= $this->xml_tools->getXmlNode('options', '', $depth);
      }
      */
      //var_dump($item); die;
      $images = $this->model_tool_universal_feed->getProductImages($item['product_id']);
      
      foreach ($images as $i => $image) {
        $output .= $this->xml_tools->getXmlNode('image'.($i+2), $this->config->get('config_url').'image/'.$image['image'], $depth);
        if ($i >= 9) break; // limit is to 10 images
      }
      
      $output .= $this->xml_tools->closeXmlNode('Product', --$depth);
      
      fwrite($fh, $output);
      
      $row++;
    }
    
    // return false when no more products
    return !empty($output);
  }
  
  public function getTotalItems($data = array()) {
    return $this->model_universal_feed_driver_product->getTotalItems($data);
  }
  
  private function getCategory($product_id) {
		$gcats = array();
		$categories = $this->db->query("SELECT c.glami_ro_cat, cd.name FROM " . DB_PREFIX . "product_to_category p2c LEFT JOIN " . DB_PREFIX . "category c ON (p2c.category_id = c.category_id) LEFT JOIN " . DB_PREFIX . "category_description cd ON (c.category_id = cd.category_id) AND cd.language_id = " . $this->config->get('config_language_id') . " WHERE product_id = '" . (int)$product_id . "'")->rows;
		
		foreach ($categories as $category) {
      if (!empty($category['glami_ro_cat'])) {
        return array(
          'id' => $category['glami_ro_cat'],
          'name' => $category['name'],
        );
      }
		}
	}
}