<?php
@set_time_limit(1800);

class ModelUniversalFeedWishCsv extends Model {

  public function writeHeader($fh, $config) {
    $config['limit'] = 1;
    $this->writeBody($fh, $config, true);
  }
  
  public function writeFooter($fh) {}
  
  public function writeBody($fh, $config, $header = false) {
    $config['filter_store'] = $this->config->get('config_store_id');
    $config['one_category'] = true;
    
    $products = $this->model_universal_feed_driver_product->getItems($config);
    
    $price_modifier = !empty($config['price_modifier']) ? $config['price_modifier'] : 1;
    $currency = !empty($config['currency']) ? $config['currency'] : 'USD';
    $gtin = !empty($config['gtin']) ? $config['gtin'] : '';

    $row = 0;
    $save_count = 0;
    
    // if(!empty($products[0])) {
      // $this->write_csv($fh, array_keys($products[0]), ',');
    // }
    
    $this->load->model('localisation/country');
    $getCountry = $this->model_localisation_country->getCountry($this->config->get('config_country_id'));
    $country_code = $getCountry['iso_code_2'];
      
    foreach ($products as $item) {
      if ($this->config->get('univfeed_sleep')) {
        usleep((int) $this->config->get('univfeed_sleep') * 1000); // 1 000 000 = 1s
      }
      
      // which price to show?
      $price_order = !empty($config['price_order']) ? explode('_', $config['price_order']) : array('special', 'discount', 'price');
      
      foreach ($price_order as $p) {
        if ($item[$p]) {
          $price_value = $item[$p];
          break;
        } 
      }
      
      if (empty($config['price_tax'])) {
        $price = $this->currency->format($this->tax->calculate($price_value * $price_modifier, $item['tax_class_id']), $currency, false, false);
      } else {
        $price = $this->currency->format($price_value * $price_modifier, $currency, false, false);
      }
      
      if ($item['special']) {
        if (empty($config['price_tax'])) {
          $regular_price = $this->currency->format($this->tax->calculate($item['price'] * $price_modifier, $item['tax_class_id']), $currency, false, false);
        } else {
          $regular_price = $this->currency->format($item['price'] * $price_modifier, $currency, false, false);
        }
      } else {
        $regular_price = '';
      }
      
      $images = array();
      
      if ($item['additional_images']) {
        $images = explode('|', $item['additional_images']);
      }
      
      $line = array(
        'Unique Id' => $item['model'] . (!empty($item['option_value']) ? '-'.$item['option_value'] : ''),
        'Price' => $price,
        'Name' => $item['name'],
        'Quantity' => $item['quantity'],
        'Shipping' => isset($config['shipping_cost']) ? $config['shipping_cost'] : '',
        'Main Image URL' => $item['image'],
        'Tags' => $item['tag'],
        'Description' => $item['meta_description'],
        'Parent Unique Id' => $item['model'],
        'Size' => (isset($item['option_name']) && strtolower($item['option_name']) == 'size') ? $item['option_value'] : '',
        'Color' => (isset($item['option_name']) && strtolower($item['option_name']) == 'color') ? $item['option_value'] : '',
        'MSRP' => $regular_price,
        'Brand' => $item['manufacturer'],
        'Landing Page URL' => $this->url->link('product/product', 'product_id=' . $item['product_id'] . (!empty($config['force_currency']) ? '&currency='.$currency : '')),
        'Extra Image URL' => !empty($images[0]) ? $images[0] : '',
        'UPC' => $item['upc'],
        'Shipping Time' => isset($config['shipping_time']) ? $config['shipping_time'] : '',
        'Extra Image URL 1' => !empty($images[1]) ? $images[1] : '',
        'Extra Image URL 2' => !empty($images[2]) ? $images[2] : '',
        'Extra Image URL 3' => !empty($images[3]) ? $images[3] : '',
        'Extra Image URL 4' => !empty($images[4]) ? $images[4] : '',
        'Extra Image URL 5' => !empty($images[5]) ? $images[5] : '',
        'Extra Image URL 6' => !empty($images[6]) ? $images[6] : '',
        'Extra Image URL 7' => !empty($images[7]) ? $images[7] : '',
        'Extra Image URL 8' => !empty($images[8]) ? $images[8] : '',
        'Extra Image URL 9' => !empty($images[9]) ? $images[9] : '',
        'Extra Image URL 10' => !empty($images[10]) ? $images[10] : '',
        'Package Length' => $item['length'],
        'Package Width' => $item['width'],
        'Package Height' => $item['height'],
        'Package Weight' => $item['weight'],
        'Custom HS Code' => '',
        'Country Of Origin' => $country_code,
        'Contains Powder' => 'no',
        'Contains Liquid' => 'no',
        'Contains Battery' => 'no',
        'Custom Declared Value' => $price,
        'Declared Name' => $item['parent_category'],
        'Declared Local Name' => $item['parent_category'],
        'Pieces Included' => 1,
        'Contains Metal' => 'no',
        'Max Quantity' => $item['quantity'],
      );
      
      foreach (array('BE','BG','BA','BB','BM','BH','JM','JO','BR','JE','RU','RS','RO','GU','GR','JP','GD','GB','GL','GI','OM','HR','HU','HN','VE','PR','PT','PF','UY','PE','PK','PH','PL','EE','EG','ZA','EC','IT','SA','ES','ME','MD','MA','MC','MK','MU','MT','MV','MS','MY','MX','IL','FR','FI','FO','NL','NO','NC','NZ','CH','CO','CL','CA','CZ','CY','CR','KN','SK','KR','SI','KW','SM','SC','KY','SG','SE','DO','DM','DK','DE','US','LB','LC','TW','TT','TR','LI','LV','LT','LU','TH','AE','AD','AG','VG','AI','VI','IS','AL','VN','AR','AU','AT','AW','IN','IE','ID','UA','QA') as $country) {
        if ($country == $country_code) {
          $line[$country] = $price;
        } else {
          $line[$country] = 'disabled';
        }
      }
      
      if (!empty($header)) {
        $this->write_csv($fh, array_keys($line), ';');
        return;
      }
      
      $this->write_csv($fh, $line, ';');
      
      $row++;
    }
    
    // return false when no more products
    return !empty($output);
  }
  
  public function getTotalItems($data = array()) {
    return $this->model_universal_feed_driver_product->getTotalItems($data);
  }
  
  private function write_csv($fh, array $fields, $delimiter = ',', $enclosure = '"', $mysql_null = false) {
    fputcsv($fh, array_map(array($this, 'escapeLineBreaks'), $fields), $delimiter, $enclosure);
    return;
    $delimiter_esc = preg_quote($delimiter, '/');
    $enclosure_esc = preg_quote($enclosure, '/');

    $output = array();
    foreach ($fields as $field) {
      if ($field === null && $mysql_null) {
        $output[] = 'NULL';
        continue;
      }

      $output[] = preg_match("/(?:${delimiter_esc}|${enclosure_esc}|\s)/", $field) ? (
        $enclosure . str_replace($enclosure, $enclosure . $enclosure, $field) . $enclosure
      ) : $field;
    }

    fwrite($fh, join($delimiter, $output) . "\n");
  }
  
  private function escapeLineBreaks($v) {
    return html_entity_decode(str_replace(array("\r\n","\n"), '', $v), ENT_QUOTES, 'UTF-8');
    //return preg_replace("/\r*\n/", "\\n", $v);
  }
}