/**
  * Copyright (c) Facebook, Inc. and its affiliates.
  * All rights reserved.
  *
  * This source code is licensed under the license found in the
  * LICENSE file in the root directory of this source tree.
  */

; (function(facebookAdsExtension, window, document, undefined) {
  var facebookPixel =
    facebookAdsExtension.facebookPixel =
    facebookAdsExtension.facebookPixel || (function () {
    var init = function(facebook_pixel_id, pii, params) {
      fbq('init', facebook_pixel_id, pii, params);
      fbq('track', 'PageView');
    };

    var firePixel = function(facebook_pixel_event_params) {
      event_name = facebook_pixel_event_params.event_name;
      delete facebook_pixel_event_params.event_name;
      track_param =
        facebook_pixel_event_params.is_custom_event ? 'trackCustom' : 'track';
      delete facebook_pixel_event_params.is_custom_event;
      event_id = facebook_pixel_event_params.event_id;
      delete facebook_pixel_event_params.event_id;
      fbq(track_param, event_name, facebook_pixel_event_params, {eventID: event_id});
    };

    return {
      init: init,
      firePixel: firePixel
    };
  }());
}(window._facebookAdsExtension = window._facebookAdsExtension || {}, window, document));

(function () {
  function fireProductInfoEvent(eventName, productID, quantity) {
    jQuery.get(
      'index.php?route=extension/module/facebook_business/getProductInfoForFacebookPixel',
      {
        event_name: eventName,
        product_id: productID,
        quantity: quantity,
      },
        function (json) {
        if (json.facebook_pixel_event_params) {
          _facebookAdsExtension.facebookPixel.firePixel(
            json.facebook_pixel_event_params);
        }
      }
    );
  }

  jQuery(function ($) {
    $('#button-cart').on('click', function() {
      var quantity = Number(
        $("input[name*='quantity'], input[id*='quantity']").first().val()
      );
      quantity = isNaN(quantity) || quantity <= 0 ? 1 : quantity;
      var productID = $('#fbProductID').val();
      if (typeof productID === 'undefined') {
        // unable to locate plugin's fbProductID
        // fall back to product_id available in opencart's default template
        productID = $('input[name=product_id]').val()
      }
      fireProductInfoEvent('AddToCart', productID, quantity);
    });

    // catalog/view/javascript/common.js has a cart variable which is used by
    // various product listing pages to add product to cart directly.
    // We would like to modify and inject AddToCart event in the cart.add() method.
    // However, OpenCart's modification system does not support js and css files
    // as they are not accessible from the front end.
    // https://github.com/vqmod/vqmod/wiki/About-vQmod
    // Instead, we modify the existing cart.add method and fire off addToCart.
    // An ajax call is fire to the URl endpoint /getproductinfoforfacebookpixel
    // to get the price and name of the product
    // added defensive checks to ensure the cart is loaded
    if (typeof cart !== 'undefined') {
      var oldCartAdd = cart.add;
      cart.add = function(productID, quantity) {
        fireProductInfoEvent('AddToCart', productID, quantity);
        oldCartAdd.apply(oldCartAdd, [productID, quantity]);
      };
    } else {
      console.log('cart variable is not available, AddToCart event is not able to be fired');
    }


    // adopting the same cart.add strategy for wishlist.add
    // added defensive checks to ensure the wishlist is loaded
    if (typeof wishlist !== 'undefined') {
      var oldWishlist = wishlist.add;
      wishlist.add = function(productID) {
        fireProductInfoEvent('AddToWishlist', productID);
        oldWishlist.apply(oldWishlist, [productID]);
      };
    } else {
      console.log('wishlist variable is not available, AddToWishlist event is not able to be fired');
    }
  });
})();
