<?php
class ControllerCatalogProduct extends Controller {
	private $error = array();

//BOF Product Series
			public function createProductSeries() {

				// << Related Options 
				$this->load->language('extension/module/related_options');
				// >> Related Options
			
				$this->load->language('catalog/product');
				$this->load->language('catalog/pds');
				
				$this->document->setTitle($this->language->get('heading_title'));
				
				$this->load->model('catalog/product'); //for getlist
				$this->load->model('catalog/product_master');
				
				if ($this->validateCreateProductSeries()) {
					
					$this->model_catalog_product_master->createProductSeries($this->request->post['selected'], '2');

					$this->session->data['success'] = $this->language->get('text_success_series_created');
					
					$url = '';
					

    if (isset($this->request->get['filter_import_batch'])) {
      $url .= '&filter_import_batch=' . urlencode(html_entity_decode($this->request->get['filter_import_batch'], ENT_QUOTES, 'UTF-8'));
    }
      
					if (isset($this->request->get['filter_name'])) {
						$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
					}
				  
					if (isset($this->request->get['filter_model'])) {
						$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
					}
					
					if (isset($this->request->get['filter_price'])) {
						$url .= '&filter_price=' . $this->request->get['filter_price'];
					}
					
					if (isset($this->request->get['filter_quantity'])) {
						$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
					}	
				
					if (isset($this->request->get['filter_status'])) {
						$url .= '&filter_status=' . $this->request->get['filter_status'];
					}
							
					if (isset($this->request->get['sort'])) {
						$url .= '&sort=' . $this->request->get['sort'];
					}

					if (isset($this->request->get['order'])) {
						$url .= '&order=' . $this->request->get['order'];
					}

					if (isset($this->request->get['page'])) {
						$url .= '&page=' . $this->request->get['page'];
					}
					
					$this->response->redirect($this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
				}

				$this->getList();
			}
			
			private function validateCreateProductSeries() {
				if (!$this->user->hasPermission('modify', 'catalog/product')) {
					$this->error['warning'] = $this->language->get('error_permission');  
				}
				
				if(!isset($this->request->post['selected']))
				{
					$this->error['warning'] = $this->language->get('error_no_product_selected');  
				}
				else if(sizeof($this->request->post['selected']) == 0)
				{
					$this->error['warning'] = $this->language->get('error_no_product_selected');  
				}
				else
				{
					$unslavable_names = array();
					
					foreach($this->request->post['selected'] as $product_id)
					{
						if (!$this->model_catalog_product_master->isSlavable($product_id, '2')) {
							//$this->error['warning'] = $this->language->get('error_cannot_be_added_to_a_series');  
							$product = $this->model_catalog_product->getProduct($product_id);
							
							array_push($unslavable_names, $product['name']);
						}
					}
					
					if(sizeof($unslavable_names) > 0)
					{
						$this->error['warning'] = $this->language->get('error_cannot_be_added_to_a_series');
						
						$this->error['warning'] .= '<ul>';
						
						foreach($unslavable_names as $unslavable_name)
						{
							$this->error['warning'] .= '<li>' . $unslavable_name . '</li>';
						}
						
						$this->error['warning'] .= '</ul>';
					}
				}
				
				if (!$this->error) {
					return true;
				} else {
					return false;
				}
			}
			//EOF Product Series
	public function index() {

				// << Related Options 
				$this->load->language('extension/module/related_options');
				// >> Related Options
			
		$this->load->language('catalog/product');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/product');

		$this->getList();
	}


    //SF PRODUCTS IMAGE MANAGER->
      public function encodeLinkImage()
      {
        if(!empty($_POST['urls']))
        {
          $url = $_POST['urls'];

          if(@getimagesize($_POST['urls']))
          {   
            $prop = preg_replace("#(\.(jpe?g|png|gif|bmp)).*|\W((?<!-|\/))#i", '$1', $url);
            $prop = pathinfo($prop);

            if(isset($prop['extension']))
            {
              $type = $prop['extension'];
              $name = $prop['basename'];
            }
            else
            {
              $type = 'jpeg';
              $name = $prop['basename'] . '.' . $type;  
            }

            echo  json_encode(['src'=>'data:image/' . $type . ';base64,'.base64_encode(file_get_contents($url)),'name'=>$name]);
          }
          else
          {
            echo json_encode(['src'=>'','name'=>'']);
          }
        }
      }

      public function productsImageManagerSettings($inner = false, $data = [])
      {
        
        if(empty($_POST['settings']) && !$inner)
        {
          return false;
        }
        elseif($inner)
        {
          $content = $inner;
        }
        else
        {
          $content = $_POST['settings'];
        }

        $this->load->language('catalog/product');
        
        $pimLang = (array) $this->language->get('sf_pim');

        $__ = function ($key) use ($pimLang)
        {
          return isset($pimLang[$key]) ? $pimLang[$key] : $key;
        };

        $permission  = $this->user->hasPermission('modify', 'setting/setting');

        $response['content'] = ['max_images'=>20,'image_size'=>2,'image_quality'=>10,'image_name'=>'default','upload_folder'=>'{monufacturer}|products_{year}','remove_images'=>3];

        $dir = rtrim(DIR_APPLICATION . "view/template/extension/sf_products_image_manager/include/");

        // Find image link 
        if (!empty($this->request->server['HTTPS']))
        {
          $server = HTTPS_CATALOG;
          $serverAdmin = HTTPS_SERVER;
        }
        else
        {
          $server = HTTP_CATALOG;
          $serverAdmin = HTTP_SERVER;
        }

        //get setting

        if($content === 'modal.html' || $content === 'settings.json')
        { 
          if($permission)
          {
            if (is_file($dir . $content))
            {
              $response['content'] = strpos($content, '.json') ? json_decode(file_get_contents($dir . $content),true) : file_get_contents($dir . $content);
              $response['success'] = ' Success: ' .  $__('received_success') . date("Y-m-d - H:i:s");
            }
            else
            {
              $response['error'] = ' Error: ' . $__('file_error') . $dir . $content;
            }
          }
          elseif (!$inner)
          {
            $response['error'] = ' Warning: ' . $__('permission_error');
          }

          if($inner)
          {
            $tokenKey = intval(VERSION) > 2 ? 'user_token' : 'token';

            $response['lang'] = $pimLang;
            $response['permission'] = $permission;
            $response['token'] =  "&$tokenKey=" . $this->session->data[$tokenKey];
            $response['images_path'] =  $server . 'image/';
            $response['wm_bg'] = $serverAdmin . 'view/template/extension/sf_products_image_manager/include/wm_bg.png';
            $response['year']  =  date('Y');
            $response['month'] =  date('m');
            $response['day']   =  date('d');
            $response['product_id']  =  !isset($this->request->get['product_id']) ? 0 : $this->request->get['product_id'];

            return $response;
          }

          echo json_encode($response);
          return; 
        }



        //save setting and watermark
        if ($content && !$inner && $permission)
        {
          parse_str(html_entity_decode($content), $set);

          if(isset($set['max_images'],$set['image_size'],$set['image_quality'],$set['image_name'],$set['upload_folder'],$set['remove_images']))
          {   
            empty($set['max_images']) ? $set['max_images'] = 1 : null;

            if (!isset($set['watermark'],$set['watermark_status']))
            {
              $set['watermark_status'] = false;
            }
            //watermark image upload
            else if(!strpos($set['watermark']['src'], 'watermark.png')) 
            {
              $src = $set['watermark']['src'];

              $watermark = $server . 'image/watermark.png' . '?v=' . time();

              if(strpos($src, 'data:image/png;base64') === 0)
              {
                $src = base64_decode(str_replace('data:image/png;base64,', '', $src));

                file_put_contents(DIR_IMAGE . 'watermark.png', $src);
              }
              elseif(@getimagesize($src))
              {
                file_put_contents(DIR_IMAGE . 'watermark.png', file_get_contents($src));
              }
              else
              {
                $watermark = '';
              }


              $set['watermark']['src'] = $watermark;
            }

            if(is_dir($dir))
            {
              //file write
              $settingsFile = fopen($dir . 'settings.json','w');

              fwrite($settingsFile,json_encode($set));

              fclose($settingsFile);

              $response['content'] = $set;
              $response['success'] = ' Success: ' . $__('save_success') . ' ' . date("Y-m-d - H:i:s");        
            }
            else
            {
              $response['error'] = ' Error: ' . $__('nodir_error') . ' (' . $dir . ')';
            }

          }
          else
          {
            $response['error'] = ' Error: ' . $__('save_error');
          }

          echo json_encode($response);

        }
      }


      public function uploadNewImage()
      {
        if(strtolower($_SERVER['REQUEST_METHOD'])=='post')
        {

          if(!empty($_POST["dels"]))
          {
            $this->delProductImage($_POST["dels"]);
          }
          
          if(!empty($_FILES))
          {
            $dir = rtrim(DIR_IMAGE.$_POST["catalog"]);

            if(!is_dir($dir))
            {
              mkdir($dir,0755,true);
            }
            
            foreach($_FILES as $file)
            {
              move_uploaded_file($file["tmp_name"],$dir.$file["name"]);
            }
          }
        }
      }

      public function imageExist()
      {
        if(isset($_POST))
        {
          header('Content-Type: application/json');
          $imgpath=rtrim($_POST["name"]);
          $namearr=preg_split('/\.(?=[^.]*$)/i',$imgpath);
          $nIdx=0;

          do
          {
            $filepath=$nIdx!=0 ? $namearr[0].'-'.$nIdx.'.'.$namearr[1] : $imgpath;

            if(!is_file(DIR_IMAGE.$filepath))
            {
              echo json_encode(array("newname"=>preg_replace("/\S*\/(?=\S*$)/i","",$filepath),"status"=>$nIdx));

              break;
            }
          }

          while(++$nIdx);
        }

        die();
      }

      public function delProductImage($delInfo)
      {
        $this->load->model('catalog/product');
        if(!is_array($delInfo))
        {
          $unlikUrls=array();
          $parsedProductImage = $this->model_catalog_product->parseProductImage($delInfo);
          
          foreach($parsedProductImage as $key=>$value)
          {
            if(isset($value["description"]))
            {
              $search = preg_replace('/\S*(?=(\\\\)\/\S*\/\S*\/$)/i',"",preg_replace("/\\\|\//","\/",DIR_IMAGE));

              preg_match_all("/(?<=".$search.")\S*(?=&quot;)/im",$value["description"],$newUrls);
              $unlikUrls=array_merge($newUrls[0],$unlikUrls);
            }
            else
            {
              $unlikUrls[]=$value["image"];
            }
          }

          $delInfo=array('id'=>$delInfo,'value'=>array_unique($unlikUrls));
        }

        foreach($delInfo["value"] as $value)
        {
          $imgIs=$this->model_catalog_product->getUnlikUrls($delInfo["id"],$value)->rows["0"]["result"];

          if($imgIs==0  &&  $value  &&  file_exists(DIR_IMAGE.$value))
          {
            unlink(DIR_IMAGE.$value);
          }
        }
      }
    //<-SF PRODUCTS IMAGE MANAGER
  
	public function add() {

				// << Related Options 
				$this->load->language('extension/module/related_options');
				// >> Related Options
			
		$this->load->language('catalog/product');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/product');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_catalog_product->addProduct($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';


		if ($this->config->get('module_admin_quick_edit_status') && $this->config->get('module_admin_quick_edit_catalog_products_status')) {
			foreach ($this->config->get('module_admin_quick_edit_catalog_products') as $column => $attr) {
				if ($attr['filter']['show'] && isset($this->request->get['filter_' . $column])) {
					$url .= '&filter_' . $column . '=' . urlencode(html_entity_decode($this->request->get['filter_' . $column], ENT_QUOTES, 'UTF-8'));
				}
			}
			if (isset($this->request->get['filter_sub_category'])) {
				$url .= '&filter_sub_category=' . urlencode(html_entity_decode($this->request->get['filter_sub_category'], ENT_QUOTES, 'UTF-8'));
			}
		}
			

    if (isset($this->request->get['filter_import_batch'])) {
      $url .= '&filter_import_batch=' . urlencode(html_entity_decode($this->request->get['filter_import_batch'], ENT_QUOTES, 'UTF-8'));
    }
      
			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_price'])) {
				$url .= '&filter_price=' . urlencode(html_entity_decode($this->request->get['filter_price'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . urlencode(html_entity_decode($this->request->get['filter_quantity'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . urlencode(html_entity_decode($this->request->get['sort'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . urlencode(html_entity_decode($this->request->get['order'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . urlencode(html_entity_decode($this->request->get['page'], ENT_QUOTES, 'UTF-8'));
			}

			$this->response->redirect($this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {

		$data['button_view'] = $this->language->get('button_view');

				// << Related Options 
				$this->load->language('extension/module/related_options');
				// >> Related Options
			
		$this->load->language('catalog/product');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/product');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_catalog_product->editProduct($this->request->get['product_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';


		if ($this->config->get('module_admin_quick_edit_status') && $this->config->get('module_admin_quick_edit_catalog_products_status')) {
			foreach ($this->config->get('module_admin_quick_edit_catalog_products') as $column => $attr) {
				if ($attr['filter']['show'] && isset($this->request->get['filter_' . $column])) {
					$url .= '&filter_' . $column . '=' . urlencode(html_entity_decode($this->request->get['filter_' . $column], ENT_QUOTES, 'UTF-8'));
				}
			}
			if (isset($this->request->get['filter_sub_category'])) {
				$url .= '&filter_sub_category=' . urlencode(html_entity_decode($this->request->get['filter_sub_category'], ENT_QUOTES, 'UTF-8'));
			}
		}
			

    if (isset($this->request->get['filter_import_batch'])) {
      $url .= '&filter_import_batch=' . urlencode(html_entity_decode($this->request->get['filter_import_batch'], ENT_QUOTES, 'UTF-8'));
    }
      
			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_price'])) {
				$url .= '&filter_price=' . urlencode(html_entity_decode($this->request->get['filter_price'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . urlencode(html_entity_decode($this->request->get['filter_quantity'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . urlencode(html_entity_decode($this->request->get['sort'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . urlencode(html_entity_decode($this->request->get['order'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . urlencode(html_entity_decode($this->request->get['page'], ENT_QUOTES, 'UTF-8'));
			}

			$this->response->redirect($this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {

      //SF PRODUCTS IMAGE MANAGER->
      $settings = $this->productsImageManagerSettings('settings.json');
      //<-SF PRODUCTS IMAGE MANAGER
    

				// << Related Options 
				$this->load->language('extension/module/related_options');
				// >> Related Options
			
		$this->load->language('catalog/product');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/product');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $product_id) {

          //SF PRODUCTS IMAGE MANAGER->
          if($settings['content']['remove_images'] == '1' || $settings['content']['remove_images'] == '3')
          {
            $this->delProductImage($product_id);
          }
          //<-SF PRODUCTS IMAGE MANAGER
    
				$this->model_catalog_product->deleteProduct($product_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';


		if ($this->config->get('module_admin_quick_edit_status') && $this->config->get('module_admin_quick_edit_catalog_products_status')) {
			foreach ($this->config->get('module_admin_quick_edit_catalog_products') as $column => $attr) {
				if ($attr['filter']['show'] && isset($this->request->get['filter_' . $column])) {
					$url .= '&filter_' . $column . '=' . urlencode(html_entity_decode($this->request->get['filter_' . $column], ENT_QUOTES, 'UTF-8'));
				}
			}
			if (isset($this->request->get['filter_sub_category'])) {
				$url .= '&filter_sub_category=' . urlencode(html_entity_decode($this->request->get['filter_sub_category'], ENT_QUOTES, 'UTF-8'));
			}
		}
			

    if (isset($this->request->get['filter_import_batch'])) {
      $url .= '&filter_import_batch=' . urlencode(html_entity_decode($this->request->get['filter_import_batch'], ENT_QUOTES, 'UTF-8'));
    }
      
			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_price'])) {
				$url .= '&filter_price=' . urlencode(html_entity_decode($this->request->get['filter_price'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . urlencode(html_entity_decode($this->request->get['filter_quantity'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . urlencode(html_entity_decode($this->request->get['sort'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . urlencode(html_entity_decode($this->request->get['order'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . urlencode(html_entity_decode($this->request->get['page'], ENT_QUOTES, 'UTF-8'));
			}

			$this->response->redirect($this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	public function copy() {

				// << Related Options 
				$this->load->language('extension/module/related_options');
				// >> Related Options
			
		$this->load->language('catalog/product');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/product');

		if (isset($this->request->post['selected']) && $this->validateCopy()) {
			foreach ($this->request->post['selected'] as $product_id) {
				$this->model_catalog_product->copyProduct($product_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';


		if ($this->config->get('module_admin_quick_edit_status') && $this->config->get('module_admin_quick_edit_catalog_products_status')) {
			foreach ($this->config->get('module_admin_quick_edit_catalog_products') as $column => $attr) {
				if ($attr['filter']['show'] && isset($this->request->get['filter_' . $column])) {
					$url .= '&filter_' . $column . '=' . urlencode(html_entity_decode($this->request->get['filter_' . $column], ENT_QUOTES, 'UTF-8'));
				}
			}
			if (isset($this->request->get['filter_sub_category'])) {
				$url .= '&filter_sub_category=' . urlencode(html_entity_decode($this->request->get['filter_sub_category'], ENT_QUOTES, 'UTF-8'));
			}
		}
			

    if (isset($this->request->get['filter_import_batch'])) {
      $url .= '&filter_import_batch=' . urlencode(html_entity_decode($this->request->get['filter_import_batch'], ENT_QUOTES, 'UTF-8'));
    }
      
			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_price'])) {
				$url .= '&filter_price=' . urlencode(html_entity_decode($this->request->get['filter_price'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . urlencode(html_entity_decode($this->request->get['filter_quantity'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . urlencode(html_entity_decode($this->request->get['sort'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . urlencode(html_entity_decode($this->request->get['order'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . urlencode(html_entity_decode($this->request->get['page'], ENT_QUOTES, 'UTF-8'));
			}

			$this->response->redirect($this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {

    // univ import filter by batch label
    $importLabels = $this->db->query("SELECT import_batch FROM " . DB_PREFIX . "product WHERE import_batch <> '' GROUP BY import_batch")->rows;
    
    $data['importLabels'] = array();
    
    foreach ($importLabels as $importLabel) {
      $data['importLabels'][] = $importLabel['import_batch'];
    }
    
    if (isset($this->request->get['filter_import_batch'])) {
			$filter_import_batch = $this->request->get['filter_import_batch'];
		} else {
			$filter_import_batch = null;
		}
    
    $data['filter_import_batch'] = $filter_import_batch;
      
		if (isset($this->request->get['filter_name'])) {
			$filter_name = $this->request->get['filter_name'];
		} else {
			$filter_name = '';
		}

		if (isset($this->request->get['filter_model'])) {
			$filter_model = $this->request->get['filter_model'];
		} else {
			$filter_model = '';
		}

		if (isset($this->request->get['filter_price'])) {
			$filter_price = $this->request->get['filter_price'];
		} else {
			$filter_price = '';
		}

		if (isset($this->request->get['filter_quantity'])) {
			$filter_quantity = $this->request->get['filter_quantity'];
		} else {
			$filter_quantity = '';
		}

		if (isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
		} else {
			$filter_status = '';
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'pd.name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';


		if ($this->config->get('module_admin_quick_edit_status') && $this->config->get('module_admin_quick_edit_catalog_products_status')) {
			foreach ($this->config->get('module_admin_quick_edit_catalog_products') as $column => $attr) {
				if ($attr['filter']['show'] && isset($this->request->get['filter_' . $column])) {
					$url .= '&filter_' . $column . '=' . urlencode(html_entity_decode($this->request->get['filter_' . $column], ENT_QUOTES, 'UTF-8'));
				}
			}
			if (isset($this->request->get['filter_sub_category'])) {
				$url .= '&filter_sub_category=' . urlencode(html_entity_decode($this->request->get['filter_sub_category'], ENT_QUOTES, 'UTF-8'));
			}
		}
			

    if (isset($this->request->get['filter_import_batch'])) {
      $url .= '&filter_import_batch=' . urlencode(html_entity_decode($this->request->get['filter_import_batch'], ENT_QUOTES, 'UTF-8'));
    }
      
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . urlencode(html_entity_decode($this->request->get['filter_price'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . urlencode(html_entity_decode($this->request->get['filter_quantity'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . urlencode(html_entity_decode($this->request->get['order'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . urlencode(html_entity_decode($this->request->get['page'], ENT_QUOTES, 'UTF-8'));
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('catalog/product/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['copy'] = $this->url->link('catalog/product/copy', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('catalog/product/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

			//BOF Product Series
			$data['create_product_series'] = $this->url->link('catalog/product/createProductSeries', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
			//EOF Product Series

		$data['products'] = array();

		$filter_data = array(
			'filter_name'	  => $filter_name,
     'filter_import_batch'	  => $filter_import_batch,
			'filter_model'	  => $filter_model,
			'filter_price'	  => $filter_price,
			'filter_quantity' => $filter_quantity,
			'filter_status'   => $filter_status,
			'sort'            => $sort,
			'order'           => $order,
			'start'           => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit'           => $this->config->get('config_limit_admin')
		);

		$this->load->model('tool/image');

		$product_total = $this->model_catalog_product->getTotalProducts($filter_data);

		$results = $this->model_catalog_product->getProducts($filter_data);

		foreach ($results as $result) {
			if (is_file(DIR_IMAGE . $result['image'])) {
				$image = $this->model_tool_image->resize($result['image'], 40, 40);
			} else {
				$image = $this->model_tool_image->resize('no_image.png', 40, 40);
			}

			$special = false;

			$product_specials = $this->model_catalog_product->getProductSpecials($result['product_id']);

			foreach ($product_specials  as $product_special) {
				if (($product_special['date_start'] == '0000-00-00' || strtotime($product_special['date_start']) < time()) && ($product_special['date_end'] == '0000-00-00' || strtotime($product_special['date_end']) > time())) {
					$special = $this->currency->format($product_special['price'], $this->config->get('config_currency'));

					break;
				}
			}

			$data['products'][] = array(
				'product_id' => $result['product_id'],
				'image'      => $image,
				'name'       => $result['name'],
				'model'      => $result['model'],
				'price'      => $this->currency->format($result['price'], $this->config->get('config_currency')),
				'special'    => $special,
				'quantity'   => $result['quantity'],
				'status'     => $result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled'),
				'edit'       => $this->url->link('catalog/product/edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $result['product_id'] . $url, true)
			);
		}

		$data['user_token'] = $this->session->data['user_token'];

//BOF Product Series
			
			if (isset($this->error['master_product'])) {
				$data['error_master_product'] = $this->error['master_product'];
			} else {
				$data['error_master_product'] = '';
			}
			
			if (isset($this->request->post['new_product_name'])) {
				$data['new_product_name'] = $this->request->post['new_product_name'];
			} else {
				$data['new_product_name'] = '';
			}
			
			if (isset($this->request->post['new_product_code'])) {
				$data['new_product_code'] = $this->request->post['new_product_code'];
			} else {
				$data['new_product_code'] = '';
			}
			
			if (isset($this->request->post['master_product'])) {
				$data['master_product'] = $this->request->post['master_product'];
			} else {
				$data['master_product'] = '-1';
			}
			
			//get existing colors		
			$this->load->model('catalog/special_attribute');		
			$this->load->model('catalog/product_special_attribute');
			$this->load->model('catalog/product_master');	
			
			$results = $this->model_catalog_special_attribute->getAllSpecialAttribute('2'); //2 is Image
			$data['all_product_colors'] = array();
			foreach($results as $result)
			{
				$data['all_product_colors'][] = array(
					'color_id' => $result['special_attribute_id'],
					'color_name' => $result['special_attribute_name'],
					'color_code' => $result['special_attribute_value'],
				);
			}
			
			//get list of available master products
			$data['all_master_product'] = $this->model_catalog_product_master->getAllMasterableProducts('2'); //2 is Image
			
			if (isset($this->request->post['product_series_image'])) {
				$data['product_series_image'] = $this->request->post['product_series_image'];
			} elseif (isset($this->request->get['product_id'])) {
				$psa = $this->model_catalog_product_special_attribute->getProductSpecialAttribute($this->request->get['product_id'], '2'); //'2' is image
				 
				$data['product_series_image'] = $psa['special_attribute_value'];
			} else {
				$data['product_series_image'] = 'no_image.png'; //NA by default
			}
			
			$this->load->model('tool/image');			
			
			if (isset($data['product_series_image']) && file_exists(DIR_IMAGE . $data['product_series_image'])) {
				if($data['product_series_image'] != '')
				{
					$data['product_series_thumb'] = $this->model_tool_image->resize($data['product_series_image'], 200, 200)/*SF PRODUCTS IMAGE MANAGER-> replace 100x100 to 200x200*/;
				}
				else
				{
					$data['product_series_thumb'] = $this->model_tool_image->resize('no_image.png', 200, 200)/*SF PRODUCTS IMAGE MANAGER-> replace 100x100 to 200x200*/;
				}
			} else {
				$data['product_series_thumb'] = $this->model_tool_image->resize('no_image.png', 200, 200)/*SF PRODUCTS IMAGE MANAGER-> replace 100x100 to 200x200*/;
			}
			
			if (isset($this->request->post['master_product'])) {
				$data['master_product'] = $this->request->post['master_product'];
			} elseif (isset($this->request->get['product_id'])) {
				$data['master_product'] = $this->model_catalog_product_master->getMasterProductId($this->request->get['product_id'], '2'); //2 is Image
			} else {
				$data['master_product'] = '-1'; //is single item by default
			}
			
			if(isset($this->request->get['product_id']))
			{
				$product_id = $this->request->get['product_id'];
				$data['product_id'] = $product_id;
				
				//$data['current_product_color'] = $this->model_catalog_product_special_attribute->getProductSpecialAttribute($product_id, '2'); //2 is Image
				
				$data['color_linked_products'] = array();
				$results = $this->model_catalog_product_master->getLinkedProducts($product_id, '2'); //2 is Image
				foreach($results as $result)
				{
					$data['color_linked_products'][] = array(
						'product_id' => $result['product_id'],
						'product_name' => $result['product_name'],
						'product_model' => $result['product_model'],				
						'color_name' => $result['special_attribute_name'],					
						'product_series_thumb' => $result['special_attribute_value'] != '' ?
						$this->model_tool_image->resize($result['special_attribute_value'], 50, 50) :
						$this->model_tool_image->resize($result['image'], 50, 50)	,
						'edit_href' => $this->url->link('catalog/product/edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $result['product_id'], 'SSL')
					);
				}
			}
			else
			{
				$data['product_id'] = '';
				//$data['current_product_color'] = '';
				$data['color_linked_products'] = array();
			}
			
			//get product color option
			if (isset($this->request->post['color_option'])) {
				$data['color_option'] = $this->request->post['color_option'];
			/*} else if ((int)$data['current_product_color'] > 0){
				$data['color_option'] = 'existingColor';
			}*/
			} else{
				$data['color_option'] = 'colorNotAvailable';
			}
			
			//get Product Series type
			$data['is_single_item'] = (int)$data['master_product'] == -1;
			$data['is_product_series_master'] = (int)$data['master_product'] == 0;
			$data['is_product_series_slave'] = (int)$data['master_product'] > 0;		
			$data['is_linked_product_series_master'] = ($data['is_product_series_master'] && sizeof($data['color_linked_products']) > 0);
			
			//text
			$this->load->language('catalog/pds');
			$this->setDataLang($data, 'entry_this_product');
			$this->setDataLang($data, 'entry_product_series_image');
			$this->setDataLang($data, 'entry_link_to_a_product_series');
			
			$data['tab_product_series'] = $this->language->get('tab_product_series');
			
			$data['text_is_a_product_series_master'] = $this->language->get('text_is_a_product_series_master');
			$data['text_product_under_same_product_series'] = $this->language->get('text_product_under_same_product_series');
			$data['text_edit'] = $this->language->get('text_edit');
			$data['text_confirm_leave_page'] = $this->language->get('text_confirm_leave_page');
			$data['text_is_single_item'] = $this->language->get('text_is_single_item');
			$data['text_is_product_series_master'] = $this->language->get('text_is_product_series_master');
			$data['text_is_product_series_slave'] = $this->language->get('text_is_product_series_slave');			
			$this->setDataLang($data, 'text_help_product_series_image');
			
			$this->setDataLang($data, 'column_image');
			$data['column_name'] = $this->language->get('column_name');
			$data['column_action'] = $this->language->get('column_action');
			$data['column_model'] = $this->language->get('column_model');
			
			$data['button_create_product_series'] = $this->language->get('button_create_product_series');
			
			//EOF Product Series
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';


		if ($this->config->get('module_admin_quick_edit_status') && $this->config->get('module_admin_quick_edit_catalog_products_status')) {
			foreach ($this->config->get('module_admin_quick_edit_catalog_products') as $column => $attr) {
				if ($attr['filter']['show'] && isset($this->request->get['filter_' . $column])) {
					$url .= '&filter_' . $column . '=' . urlencode(html_entity_decode($this->request->get['filter_' . $column], ENT_QUOTES, 'UTF-8'));
				}
			}
			if (isset($this->request->get['filter_sub_category'])) {
				$url .= '&filter_sub_category=' . urlencode(html_entity_decode($this->request->get['filter_sub_category'], ENT_QUOTES, 'UTF-8'));
			}
		}
			

    if (isset($this->request->get['filter_import_batch'])) {
      $url .= '&filter_import_batch=' . urlencode(html_entity_decode($this->request->get['filter_import_batch'], ENT_QUOTES, 'UTF-8'));
    }
      
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . urlencode(html_entity_decode($this->request->get['filter_price'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . urlencode(html_entity_decode($this->request->get['filter_quantity'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
		}

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . urlencode(html_entity_decode($this->request->get['page'], ENT_QUOTES, 'UTF-8'));
		}

		$data['sort_name'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . '&sort=pd.name' . $url, true);
		$data['sort_model'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . '&sort=p.model' . $url, true);
		$data['sort_price'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . '&sort=p.price' . $url, true);
		$data['sort_quantity'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . '&sort=p.quantity' . $url, true);
		$data['sort_status'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . '&sort=p.status' . $url, true);
		$data['sort_order'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . '&sort=p.sort_order' . $url, true);

		$url = '';


		if ($this->config->get('module_admin_quick_edit_status') && $this->config->get('module_admin_quick_edit_catalog_products_status')) {
			foreach ($this->config->get('module_admin_quick_edit_catalog_products') as $column => $attr) {
				if ($attr['filter']['show'] && isset($this->request->get['filter_' . $column])) {
					$url .= '&filter_' . $column . '=' . urlencode(html_entity_decode($this->request->get['filter_' . $column], ENT_QUOTES, 'UTF-8'));
				}
			}
			if (isset($this->request->get['filter_sub_category'])) {
				$url .= '&filter_sub_category=' . urlencode(html_entity_decode($this->request->get['filter_sub_category'], ENT_QUOTES, 'UTF-8'));
			}
		}
			

    if (isset($this->request->get['filter_import_batch'])) {
      $url .= '&filter_import_batch=' . urlencode(html_entity_decode($this->request->get['filter_import_batch'], ENT_QUOTES, 'UTF-8'));
    }
      
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . urlencode(html_entity_decode($this->request->get['filter_price'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . urlencode(html_entity_decode($this->request->get['filter_quantity'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . urlencode(html_entity_decode($this->request->get['sort'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . urlencode(html_entity_decode($this->request->get['order'], ENT_QUOTES, 'UTF-8'));
		}

		$pagination = new Pagination();
		$pagination->total = $product_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($product_total - $this->config->get('config_limit_admin'))) ? $product_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $product_total, ceil($product_total / $this->config->get('config_limit_admin')));

		$data['filter_name'] = $filter_name;
		$data['filter_model'] = $filter_model;
		$data['filter_price'] = $filter_price;
		$data['filter_quantity'] = $filter_quantity;
		$data['filter_status'] = $filter_status;

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('catalog/product_list', $data));
	}

	protected function getForm() {

      //SF PRODUCTS IMAGE MANAGER->
      $this->document->addStyle('view/template/extension/sf_products_image_manager/css/pim.css?v=3.0.7');
      $data['pim_data'] = $this->productsImageManagerSettings('settings.json');
      //<-SF PRODUCTS IMAGE MANAGER
  

				// << Related Options
				
				$data = $this->load->controller('extension/module/related_options/productForm', isset($data) ? $data : array());

				// >> Related Options
			

			$this->load->config('price_tax_calculator');
			$this->load->model($this->config->get('ptc_module_path'));

			$ptc_module_model = $this->config->get('ptc_module_model');
			$ptc_module_model = $this->{$ptc_module_model};

			$data['price_tax_calculator'] = $ptc_module_model->compatibility()->getChild($this->config->get('ptc_module_path') . '/calculator', array());
			
		$data['text_form'] = !isset($this->request->get['product_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

//BOF Product Series
			
			if (isset($this->error['master_product'])) {
				$data['error_master_product'] = $this->error['master_product'];
			} else {
				$data['error_master_product'] = '';
			}
			
			if (isset($this->request->post['new_product_name'])) {
				$data['new_product_name'] = $this->request->post['new_product_name'];
			} else {
				$data['new_product_name'] = '';
			}
			
			if (isset($this->request->post['new_product_code'])) {
				$data['new_product_code'] = $this->request->post['new_product_code'];
			} else {
				$data['new_product_code'] = '';
			}
			
			if (isset($this->request->post['master_product'])) {
				$data['master_product'] = $this->request->post['master_product'];
			} else {
				$data['master_product'] = '-1';
			}
			
			//get existing colors		
			$this->load->model('catalog/special_attribute');		
			$this->load->model('catalog/product_special_attribute');
			$this->load->model('catalog/product_master');	
			
			$results = $this->model_catalog_special_attribute->getAllSpecialAttribute('2'); //2 is Image
			$data['all_product_colors'] = array();
			foreach($results as $result)
			{
				$data['all_product_colors'][] = array(
					'color_id' => $result['special_attribute_id'],
					'color_name' => $result['special_attribute_name'],
					'color_code' => $result['special_attribute_value'],
				);
			}
			
			//get list of available master products
			$data['all_master_product'] = $this->model_catalog_product_master->getAllMasterableProducts('2'); //2 is Image
			
			if (isset($this->request->post['product_series_image'])) {
				$data['product_series_image'] = $this->request->post['product_series_image'];
			} elseif (isset($this->request->get['product_id'])) {
				$psa = $this->model_catalog_product_special_attribute->getProductSpecialAttribute($this->request->get['product_id'], '2'); //'2' is image
				 
				$data['product_series_image'] = $psa['special_attribute_value'];
			} else {
				$data['product_series_image'] = 'no_image.png'; //NA by default
			}
			
			$this->load->model('tool/image');			
			
			if (isset($data['product_series_image']) && file_exists(DIR_IMAGE . $data['product_series_image'])) {
				if($data['product_series_image'] != '')
				{
					$data['product_series_thumb'] = $this->model_tool_image->resize($data['product_series_image'], 200, 200)/*SF PRODUCTS IMAGE MANAGER-> replace 100x100 to 200x200*/;
				}
				else
				{
					$data['product_series_thumb'] = $this->model_tool_image->resize('no_image.png', 200, 200)/*SF PRODUCTS IMAGE MANAGER-> replace 100x100 to 200x200*/;
				}
			} else {
				$data['product_series_thumb'] = $this->model_tool_image->resize('no_image.png', 200, 200)/*SF PRODUCTS IMAGE MANAGER-> replace 100x100 to 200x200*/;
			}
			
			if (isset($this->request->post['master_product'])) {
				$data['master_product'] = $this->request->post['master_product'];
			} elseif (isset($this->request->get['product_id'])) {
				$data['master_product'] = $this->model_catalog_product_master->getMasterProductId($this->request->get['product_id'], '2'); //2 is Image
			} else {
				$data['master_product'] = '-1'; //is single item by default
			}
			
			if(isset($this->request->get['product_id']))
			{
				$product_id = $this->request->get['product_id'];
				$data['product_id'] = $product_id;
				
				//$data['current_product_color'] = $this->model_catalog_product_special_attribute->getProductSpecialAttribute($product_id, '2'); //2 is Image
				
				$data['color_linked_products'] = array();
				$results = $this->model_catalog_product_master->getLinkedProducts($product_id, '2'); //2 is Image
				foreach($results as $result)
				{
					$data['color_linked_products'][] = array(
						'product_id' => $result['product_id'],
						'product_name' => $result['product_name'],
						'product_model' => $result['product_model'],				
						'color_name' => $result['special_attribute_name'],					
						'product_series_thumb' => $result['special_attribute_value'] != '' ?
						$this->model_tool_image->resize($result['special_attribute_value'], 50, 50) :
						$this->model_tool_image->resize($result['image'], 50, 50)	,
						'edit_href' => $this->url->link('catalog/product/edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $result['product_id'], 'SSL')
					);
				}
			}
			else
			{
				$data['product_id'] = '';
				//$data['current_product_color'] = '';
				$data['color_linked_products'] = array();
			}
			
			//get product color option
			if (isset($this->request->post['color_option'])) {
				$data['color_option'] = $this->request->post['color_option'];
			/*} else if ((int)$data['current_product_color'] > 0){
				$data['color_option'] = 'existingColor';
			}*/
			} else{
				$data['color_option'] = 'colorNotAvailable';
			}
			
			//get Product Series type
			$data['is_single_item'] = (int)$data['master_product'] == -1;
			$data['is_product_series_master'] = (int)$data['master_product'] == 0;
			$data['is_product_series_slave'] = (int)$data['master_product'] > 0;		
			$data['is_linked_product_series_master'] = ($data['is_product_series_master'] && sizeof($data['color_linked_products']) > 0);
			
			//text
			$this->load->language('catalog/pds');
			$this->setDataLang($data, 'entry_this_product');
			$this->setDataLang($data, 'entry_product_series_image');
			$this->setDataLang($data, 'entry_link_to_a_product_series');
			
			$data['tab_product_series'] = $this->language->get('tab_product_series');
			
			$data['text_is_a_product_series_master'] = $this->language->get('text_is_a_product_series_master');
			$data['text_product_under_same_product_series'] = $this->language->get('text_product_under_same_product_series');
			$data['text_edit'] = $this->language->get('text_edit');
			$data['text_confirm_leave_page'] = $this->language->get('text_confirm_leave_page');
			$data['text_is_single_item'] = $this->language->get('text_is_single_item');
			$data['text_is_product_series_master'] = $this->language->get('text_is_product_series_master');
			$data['text_is_product_series_slave'] = $this->language->get('text_is_product_series_slave');			
			$this->setDataLang($data, 'text_help_product_series_image');
			
			$this->setDataLang($data, 'column_image');
			$data['column_name'] = $this->language->get('column_name');
			$data['column_action'] = $this->language->get('column_action');
			$data['column_model'] = $this->language->get('column_model');
			
			$data['button_create_product_series'] = $this->language->get('button_create_product_series');
			
			//EOF Product Series
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['name'])) {
			$data['error_name'] = $this->error['name'];
		} else {
			$data['error_name'] = array();
		}

		if (isset($this->error['meta_title'])) {
			$data['error_meta_title'] = $this->error['meta_title'];
		} else {
			$data['error_meta_title'] = array();
		}

		if (isset($this->error['model'])) {
			$data['error_model'] = $this->error['model'];
		} else {
			$data['error_model'] = '';
		}

		if (isset($this->error['keyword'])) {
			$data['error_keyword'] = $this->error['keyword'];
		} else {
			$data['error_keyword'] = '';
		}

		$url = '';


		if ($this->config->get('module_admin_quick_edit_status') && $this->config->get('module_admin_quick_edit_catalog_products_status')) {
			foreach ($this->config->get('module_admin_quick_edit_catalog_products') as $column => $attr) {
				if ($attr['filter']['show'] && isset($this->request->get['filter_' . $column])) {
					$url .= '&filter_' . $column . '=' . urlencode(html_entity_decode($this->request->get['filter_' . $column], ENT_QUOTES, 'UTF-8'));
				}
			}
			if (isset($this->request->get['filter_sub_category'])) {
				$url .= '&filter_sub_category=' . urlencode(html_entity_decode($this->request->get['filter_sub_category'], ENT_QUOTES, 'UTF-8'));
			}
		}
			

    if (isset($this->request->get['filter_import_batch'])) {
      $url .= '&filter_import_batch=' . urlencode(html_entity_decode($this->request->get['filter_import_batch'], ENT_QUOTES, 'UTF-8'));
    }
      
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . urlencode(html_entity_decode($this->request->get['filter_price'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . urlencode(html_entity_decode($this->request->get['filter_quantity'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . urlencode(html_entity_decode($this->request->get['sort'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . urlencode(html_entity_decode($this->request->get['order'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . urlencode(html_entity_decode($this->request->get['page'], ENT_QUOTES, 'UTF-8'));
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['product_id'])) {
			$data['action'] = $this->url->link('catalog/product/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('catalog/product/edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $this->request->get['product_id'] . $url, true);
		}


            if (isset($this->request->get['product_id'])) {
                $data['view'] = '/index.php?route=product/product&product_id='.$this->request->get['product_id'];
            }
		$data['cancel'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['product_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$product_info = $this->model_catalog_product->getProduct($this->request->get['product_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('localisation/language');

		$data['languages'] = $this->model_localisation_language->getLanguages();

		if (isset($this->request->post['product_description'])) {
			$data['product_description'] = $this->request->post['product_description'];
		} elseif (isset($this->request->get['product_id'])) {
			$data['product_description'] = $this->model_catalog_product->getProductDescriptions($this->request->get['product_id']);
		} else {
			$data['product_description'] = array();
		}

		if (isset($this->request->post['model'])) {
			$data['model'] = $this->request->post['model'];
		} elseif (!empty($product_info)) {
			$data['model'] = $product_info['model'];
		} else {
			$data['model'] = '';
		}

		if (isset($this->request->post['sku'])) {
			$data['sku'] = $this->request->post['sku'];
		} elseif (!empty($product_info)) {
			$data['sku'] = $product_info['sku'];
		} else {
			$data['sku'] = '';
		}

		if (isset($this->request->post['upc'])) {
			$data['upc'] = $this->request->post['upc'];
		} elseif (!empty($product_info)) {
			$data['upc'] = $product_info['upc'];
		} else {
			$data['upc'] = '';
		}

		if (isset($this->request->post['ean'])) {
			$data['ean'] = $this->request->post['ean'];
		} elseif (!empty($product_info)) {
			$data['ean'] = $product_info['ean'];
		} else {
			$data['ean'] = '';
		}

		if (isset($this->request->post['jan'])) {
			$data['jan'] = $this->request->post['jan'];
		} elseif (!empty($product_info)) {
			$data['jan'] = $product_info['jan'];
		} else {
			$data['jan'] = '';
		}

		if (isset($this->request->post['isbn'])) {
			$data['isbn'] = $this->request->post['isbn'];
		} elseif (!empty($product_info)) {
			$data['isbn'] = $product_info['isbn'];
		} else {
			$data['isbn'] = '';
		}

		if (isset($this->request->post['mpn'])) {
			$data['mpn'] = $this->request->post['mpn'];
		} elseif (!empty($product_info)) {
			$data['mpn'] = $product_info['mpn'];
		} else {
			$data['mpn'] = '';
		}

		if (isset($this->request->post['location'])) {
			$data['location'] = $this->request->post['location'];
		} elseif (!empty($product_info)) {
			$data['location'] = $product_info['location'];
		} else {
			$data['location'] = '';
		}

		$this->load->model('setting/store');

		$data['stores'] = array();
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $this->language->get('text_default')
		);
		
		$stores = $this->model_setting_store->getStores();

		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}

		if (isset($this->request->post['product_store'])) {
			$data['product_store'] = $this->request->post['product_store'];
		} elseif (isset($this->request->get['product_id'])) {
			$data['product_store'] = $this->model_catalog_product->getProductStores($this->request->get['product_id']);
		} else {
			$data['product_store'] = array(0);
		}

		if (isset($this->request->post['shipping'])) {
			$data['shipping'] = $this->request->post['shipping'];
		} elseif (!empty($product_info)) {
			$data['shipping'] = $product_info['shipping'];
		} else {
			$data['shipping'] = 1;
		}

		if (isset($this->request->post['price'])) {
			$data['price'] = $this->request->post['price'];
		} elseif (!empty($product_info)) {
			$data['price'] = $product_info['price'];
		} else {
			$data['price'] = '';
		}

		$this->load->model('catalog/recurring');

		$data['recurrings'] = $this->model_catalog_recurring->getRecurrings();

		if (isset($this->request->post['product_recurrings'])) {
			$data['product_recurrings'] = $this->request->post['product_recurrings'];
		} elseif (!empty($product_info)) {
			$data['product_recurrings'] = $this->model_catalog_product->getRecurrings($product_info['product_id']);
		} else {
			$data['product_recurrings'] = array();
		}

		$this->load->model('localisation/tax_class');

		$data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();

		if (isset($this->request->post['tax_class_id'])) {
			$data['tax_class_id'] = $this->request->post['tax_class_id'];
		} elseif (!empty($product_info)) {
			$data['tax_class_id'] = $product_info['tax_class_id'];
		} else {
			$data['tax_class_id'] = 0;
		}

		if (isset($this->request->post['date_available'])) {
			$data['date_available'] = $this->request->post['date_available'];
		} elseif (!empty($product_info)) {
			$data['date_available'] = ($product_info['date_available'] != '0000-00-00') ? $product_info['date_available'] : '';
		} else {
			$data['date_available'] = date('Y-m-d');
		}


        if($this->config->get('module_notify_when_available_status') && isset($this->request->get['product_id'])){
            $data['product_id'] = $this->request->get['product_id'];
            if($product_info){
                $data['old_quantity'] = $product_info['quantity'];
            }
        }
       
		if (isset($this->request->post['quantity'])) {
			$data['quantity'] = $this->request->post['quantity'];
		} elseif (!empty($product_info)) {
			$data['quantity'] = $product_info['quantity'];
		} else {
			$data['quantity'] = 1;
		}

		if (isset($this->request->post['minimum'])) {
			$data['minimum'] = $this->request->post['minimum'];
		} elseif (!empty($product_info)) {
			$data['minimum'] = $product_info['minimum'];
		} else {
			$data['minimum'] = 1;
		}

		if (isset($this->request->post['subtract'])) {
			$data['subtract'] = $this->request->post['subtract'];
		} elseif (!empty($product_info)) {
			$data['subtract'] = $product_info['subtract'];
		} else {
			$data['subtract'] = 1;
		}

		if (isset($this->request->post['sort_order'])) {
			$data['sort_order'] = $this->request->post['sort_order'];
		} elseif (!empty($product_info)) {
			$data['sort_order'] = $product_info['sort_order'];
		} else {
			$data['sort_order'] = 1;
		}

		$this->load->model('localisation/stock_status');

		$data['stock_statuses'] = $this->model_localisation_stock_status->getStockStatuses();

		if (isset($this->request->post['stock_status_id'])) {
			$data['stock_status_id'] = $this->request->post['stock_status_id'];
		} elseif (!empty($product_info)) {
			$data['stock_status_id'] = $product_info['stock_status_id'];
		} else {
			$data['stock_status_id'] = 0;
		}

		if (isset($this->request->post['status'])) {
			$data['status'] = $this->request->post['status'];
		} elseif (!empty($product_info)) {
			$data['status'] = $product_info['status'];
		} else {
			$data['status'] = true;
		}

		if (isset($this->request->post['weight'])) {
			$data['weight'] = $this->request->post['weight'];
		} elseif (!empty($product_info)) {
			$data['weight'] = $product_info['weight'];
		} else {
			$data['weight'] = '';
		}

		$this->load->model('localisation/weight_class');

		$data['weight_classes'] = $this->model_localisation_weight_class->getWeightClasses();

		if (isset($this->request->post['weight_class_id'])) {
			$data['weight_class_id'] = $this->request->post['weight_class_id'];
		} elseif (!empty($product_info)) {
			$data['weight_class_id'] = $product_info['weight_class_id'];
		} else {
			$data['weight_class_id'] = $this->config->get('config_weight_class_id');
		}

		if (isset($this->request->post['length'])) {
			$data['length'] = $this->request->post['length'];
		} elseif (!empty($product_info)) {
			$data['length'] = $product_info['length'];
		} else {
			$data['length'] = '';
		}

		if (isset($this->request->post['width'])) {
			$data['width'] = $this->request->post['width'];
		} elseif (!empty($product_info)) {
			$data['width'] = $product_info['width'];
		} else {
			$data['width'] = '';
		}

		if (isset($this->request->post['height'])) {
			$data['height'] = $this->request->post['height'];
		} elseif (!empty($product_info)) {
			$data['height'] = $product_info['height'];
		} else {
			$data['height'] = '';
		}

		$this->load->model('localisation/length_class');

		$data['length_classes'] = $this->model_localisation_length_class->getLengthClasses();

		if (isset($this->request->post['length_class_id'])) {
			$data['length_class_id'] = $this->request->post['length_class_id'];
		} elseif (!empty($product_info)) {
			$data['length_class_id'] = $product_info['length_class_id'];
		} else {
			$data['length_class_id'] = $this->config->get('config_length_class_id');
		}

		$this->load->model('catalog/manufacturer');

		if (isset($this->request->post['manufacturer_id'])) {
			$data['manufacturer_id'] = $this->request->post['manufacturer_id'];
		} elseif (!empty($product_info)) {
			$data['manufacturer_id'] = $product_info['manufacturer_id'];
		} else {
			$data['manufacturer_id'] = 0;
		}

		if (isset($this->request->post['manufacturer'])) {
			$data['manufacturer'] = $this->request->post['manufacturer'];
		} elseif (!empty($product_info)) {
			$manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($product_info['manufacturer_id']);

			if ($manufacturer_info) {
				$data['manufacturer'] = $manufacturer_info['name'];
			} else {
				$data['manufacturer'] = '';
			}
		} else {
			$data['manufacturer'] = '';
		}

		// Categories
		$this->load->model('catalog/category');

		if (isset($this->request->post['product_category'])) {
			$categories = $this->request->post['product_category'];
		} elseif (isset($this->request->get['product_id'])) {
			$categories = $this->model_catalog_product->getProductCategories($this->request->get['product_id']);
		} else {
			$categories = array();
		}

		$data['product_categories'] = array();

		foreach ($categories as $category_id) {
			$category_info = $this->model_catalog_category->getCategory($category_id);

			if ($category_info) {
				$data['product_categories'][] = array(
					'category_id' => $category_info['category_id'],
					'name'        => ($category_info['path']) ? $category_info['path'] . ' &gt; ' . $category_info['name'] : $category_info['name']
				);
			}
		}

		// Filters
		$this->load->model('catalog/filter');

		if (isset($this->request->post['product_filter'])) {
			$filters = $this->request->post['product_filter'];
		} elseif (isset($this->request->get['product_id'])) {
			$filters = $this->model_catalog_product->getProductFilters($this->request->get['product_id']);
		} else {
			$filters = array();
		}

		$data['product_filters'] = array();

		foreach ($filters as $filter_id) {
			$filter_info = $this->model_catalog_filter->getFilter($filter_id);

			if ($filter_info) {
				$data['product_filters'][] = array(
					'filter_id' => $filter_info['filter_id'],
					'name'      => $filter_info['group'] . ' &gt; ' . $filter_info['name']
				);
			}
		}

		// Attributes
		$this->load->model('catalog/attribute');

		if (isset($this->request->post['product_attribute'])) {
			$product_attributes = $this->request->post['product_attribute'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_attributes = $this->model_catalog_product->getProductAttributes($this->request->get['product_id']);
		} else {
			$product_attributes = array();
		}

		$data['product_attributes'] = array();

		foreach ($product_attributes as $product_attribute) {
			$attribute_info = $this->model_catalog_attribute->getAttribute($product_attribute['attribute_id']);

			if ($attribute_info) {
				$data['product_attributes'][] = array(
					'attribute_id'                  => $product_attribute['attribute_id'],
					'name'                          => $attribute_info['name'],
					'product_attribute_description' => $product_attribute['product_attribute_description']
				);
			}
		}

		// Options
		$this->load->model('catalog/option');

		if (isset($this->request->post['product_option'])) {
			$product_options = $this->request->post['product_option'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_options = $this->model_catalog_product->getProductOptions($this->request->get['product_id']);
		} else {
			$product_options = array();
		}

		$data['product_options'] = array();

		foreach ($product_options as $product_option) {
			$product_option_value_data = array();

			if (isset($product_option['product_option_value'])) {
				foreach ($product_option['product_option_value'] as $product_option_value) {
					$product_option_value_data[] = array(

        // begin: owq_option_fields
        'model'       => (!empty($product_option_value['model']) ? $product_option_value['model'] : ''),
    
        // end: owq_option_fields
      
						'product_option_value_id' => $product_option_value['product_option_value_id'],
						'option_value_id'         => $product_option_value['option_value_id'],
						'quantity'                => $product_option_value['quantity'],
						'subtract'                => $product_option_value['subtract'],
						'price'                   => $product_option_value['price'],
						'price_prefix'            => $product_option_value['price_prefix'],
						'points'                  => $product_option_value['points'],
						'points_prefix'           => $product_option_value['points_prefix'],
						'weight'                  => $product_option_value['weight'],
						'weight_prefix'           => $product_option_value['weight_prefix']
					);
				}
			}

			$data['product_options'][] = array(
				'product_option_id'    => $product_option['product_option_id'],
				'product_option_value' => $product_option_value_data,
				'option_id'            => $product_option['option_id'],
				'name'                 => $product_option['name'],
				'type'                 => $product_option['type'],
				'value'                => isset($product_option['value']) ? $product_option['value'] : '',
				'required'             => $product_option['required']
			);
		}

		$data['option_values'] = array();

		foreach ($data['product_options'] as $product_option) {
			if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') {
				if (!isset($data['option_values'][$product_option['option_id']])) {
					$data['option_values'][$product_option['option_id']] = $this->model_catalog_option->getOptionValues($product_option['option_id']);
				}
			}
		}

		$this->load->model('customer/customer_group');

		$data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

		if (isset($this->request->post['product_discount'])) {
			$product_discounts = $this->request->post['product_discount'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_discounts = $this->model_catalog_product->getProductDiscounts($this->request->get['product_id']);
		} else {
			$product_discounts = array();
		}

		$data['product_discounts'] = array();

		foreach ($product_discounts as $product_discount) {
			$data['product_discounts'][] = array(
				'customer_group_id' => $product_discount['customer_group_id'],
				'quantity'          => $product_discount['quantity'],
				'priority'          => $product_discount['priority'],
				'price'             => $product_discount['price'],
				'date_start'        => ($product_discount['date_start'] != '0000-00-00') ? $product_discount['date_start'] : '',
				'date_end'          => ($product_discount['date_end'] != '0000-00-00') ? $product_discount['date_end'] : ''
			);
		}

		if (isset($this->request->post['product_special'])) {
			$product_specials = $this->request->post['product_special'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_specials = $this->model_catalog_product->getProductSpecials($this->request->get['product_id']);
		} else {
			$product_specials = array();
		}

		$data['product_specials'] = array();

		foreach ($product_specials as $product_special) {
			$data['product_specials'][] = array(
				'customer_group_id' => $product_special['customer_group_id'],
				'priority'          => $product_special['priority'],
				'price'             => $product_special['price'],
				'date_start'        => ($product_special['date_start'] != '0000-00-00') ? $product_special['date_start'] : '',
				'date_end'          => ($product_special['date_end'] != '0000-00-00') ? $product_special['date_end'] :  ''
			);
		}
		
		// Image
		if (isset($this->request->post['image'])) {
			$data['image'] = $this->request->post['image'];
		} elseif (!empty($product_info)) {
			$data['image'] = $product_info['image'];
		} else {
			$data['image'] = '';
		}

		$this->load->model('tool/image');

		if (isset($this->request->post['image']) && is_file(DIR_IMAGE . $this->request->post['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 200, 200)/*SF PRODUCTS IMAGE MANAGER-> replace 100x100 to 200x200*/;
		} elseif (!empty($product_info) && is_file(DIR_IMAGE . $product_info['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($product_info['image'], 200, 200)/*SF PRODUCTS IMAGE MANAGER-> replace 100x100 to 200x200*/;
		} else {
			$data['thumb'] = $this->model_tool_image->resize('no_image.png', 200, 200)/*SF PRODUCTS IMAGE MANAGER-> replace 100x100 to 200x200*/;
		}

		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 200, 200)/*SF PRODUCTS IMAGE MANAGER-> replace 100x100 to 200x200*/;

		// Images
		if (isset($this->request->post['product_image'])) {
			$product_images = $this->request->post['product_image'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_images = $this->model_catalog_product->getProductImages($this->request->get['product_id']);
		} else {
			$product_images = array();
		}

		$data['product_images'] = array();

		foreach ($product_images as $product_image) {
			if (is_file(DIR_IMAGE . $product_image['image'])) {
				$image = $product_image['image'];
				$thumb = $product_image['image'];
			} else {
				$image = '';
				$thumb = 'no_image.png';
			}

			$data['product_images'][] = array(
				'image'      => $image,
				'thumb'      => $this->model_tool_image->resize($thumb, 200, 200)/*SF PRODUCTS IMAGE MANAGER-> replace 100x100 to 200x200*/,
				'sort_order' => $product_image['sort_order']
			);
		}

		// Downloads
		$this->load->model('catalog/download');

		if (isset($this->request->post['product_download'])) {
			$product_downloads = $this->request->post['product_download'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_downloads = $this->model_catalog_product->getProductDownloads($this->request->get['product_id']);
		} else {
			$product_downloads = array();
		}

		$data['product_downloads'] = array();

		foreach ($product_downloads as $download_id) {
			$download_info = $this->model_catalog_download->getDownload($download_id);

			if ($download_info) {
				$data['product_downloads'][] = array(
					'download_id' => $download_info['download_id'],
					'name'        => $download_info['name']
				);
			}
		}

		if (isset($this->request->post['product_related'])) {
			$products = $this->request->post['product_related'];
		} elseif (isset($this->request->get['product_id'])) {
			$products = $this->model_catalog_product->getProductRelated($this->request->get['product_id']);
		} else {
			$products = array();
		}

		$data['product_relateds'] = array();

		foreach ($products as $product_id) {
			$related_info = $this->model_catalog_product->getProduct($product_id);

			if ($related_info) {
				$data['product_relateds'][] = array(
					'product_id' => $related_info['product_id'],
					'name'       => $related_info['name']
				);
			}
		}

		if (isset($this->request->post['points'])) {
			$data['points'] = $this->request->post['points'];
		} elseif (!empty($product_info)) {
			$data['points'] = $product_info['points'];
		} else {
			$data['points'] = '';
		}

		if (isset($this->request->post['product_reward'])) {
			$data['product_reward'] = $this->request->post['product_reward'];
		} elseif (isset($this->request->get['product_id'])) {
			$data['product_reward'] = $this->model_catalog_product->getProductRewards($this->request->get['product_id']);
		} else {
			$data['product_reward'] = array();
		}

		if (isset($this->request->post['product_seo_url'])) {
			$data['product_seo_url'] = $this->request->post['product_seo_url'];
		} elseif (isset($this->request->get['product_id'])) {
			$data['product_seo_url'] = $this->model_catalog_product->getProductSeoUrls($this->request->get['product_id']);
		} else {
			$data['product_seo_url'] = array();
		}

		if (isset($this->request->post['product_layout'])) {
			$data['product_layout'] = $this->request->post['product_layout'];
		} elseif (isset($this->request->get['product_id'])) {
			$data['product_layout'] = $this->model_catalog_product->getProductLayouts($this->request->get['product_id']);
		} else {
			$data['product_layout'] = array();
		}

		$this->load->model('design/layout');

		$data['layouts'] = $this->model_design_layout->getLayouts();
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');


        $this->load->model('catalog/seo_package');
        
        $data['seo_multistore_active'] = $this->config->get('mlseo_multistore');
        
        if ($this->config->get('mlseo_multistore')) {
          if (isset($this->request->post['seo_product_description'])) {
            $data['seo_product_description'] = $this->request->post['seo_product_description'];
          } elseif (isset($this->request->get['product_id'])) {
            $data['seo_product_description'] = $this->model_catalog_seo_package->getSeoDescriptions('product', $this->request->get['product_id']);
          } else {
            $data['seo_product_description'] = array();
          }
        }
        
        if (isset($this->request->post['meta_robots'])) {
          $data['meta_robots'] = $this->request->post['meta_robots'];
        } elseif (!empty($product_info['meta_robots'])) {
          $data['meta_robots'] = $product_info['meta_robots'];
        } else {
          $data['meta_robots'] = '';
        }
        
        unset($this->session->data['gkd_seorand']);
        
        $this->load->model('tool/gkd_lib');
        $data['item_type'] = 'product';
        $data['seo_package_tab'] = $this->model_tool_gkd_lib->fetch('module/complete_seo_inc', $data, 'seo_tab');
        $data['seo_package_snippet_robots'] = $this->model_tool_gkd_lib->fetch('module/complete_seo_inc', $data, 'snippet_robots');
        $data['seo_package_snippet_metas'] = $this->model_tool_gkd_lib->fetch('module/complete_seo_inc', $data, 'snippet_metas', 'all');
      
		$this->response->setOutput($this->load->view('catalog/product_form', $data));
	}

	protected function validateForm() {

				// << Related Options 
				
				$this->load->model('extension/module/related_options');
				$ro_warning = $this->model_extension_module_related_options->productSaveValidate();
				if ( $ro_warning ) {
					$this->error['warning'] = $ro_warning;
				}
					
				// >> Related Options
			
		if (!$this->user->hasPermission('modify', 'catalog/product')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		foreach ($this->request->post['product_description'] as $language_id => $value) {
			if ((utf8_strlen($value['name']) < 1) || (utf8_strlen($value['name']) > 255)) {
				$this->error['name'][$language_id] = $this->language->get('error_name');
			}

			if ((utf8_strlen($value['meta_title']) < 1) || (utf8_strlen($value['meta_title']) > 255)) {
				$this->error['meta_title'][$language_id] = $this->language->get('error_meta_title');
			}
		}

		if ((utf8_strlen($this->request->post['model']) < 1) || (utf8_strlen($this->request->post['model']) > 64)) {
			$this->error['model'] = $this->language->get('error_model');
		}

		if (false) {
			$this->load->model('design/seo_url');
			
			foreach ($this->request->post['product_seo_url'] as $store_id => $language) {
				foreach ($language as $language_id => $keyword) {
					if (!empty($keyword)) {
						if (count(array_keys($language, $keyword)) > 1) {
							$this->error['keyword'][$store_id][$language_id] = $this->language->get('error_unique');
						}						
						
						$seo_urls = $this->model_design_seo_url->getSeoUrlsByKeyword($keyword);
						
						foreach ($seo_urls as $seo_url) {
							if (($seo_url['store_id'] == $store_id) && (!isset($this->request->get['product_id']) || (($seo_url['query'] != 'product_id=' . $this->request->get['product_id'])))) {
								$this->error['keyword'][$store_id][$language_id] = $this->language->get('error_keyword');
								
								break;
							}
						}
					}
				}
			}
		}

//BOF Product Series
			$this->load->model('catalog/special_attribute');
			
			//- link to master product -> if the passed product is not a master one -> return error message
			if(isset($this->request->post['master_product']))
			{
				if((int)$this->request->post['master_product'] > 0)
				{
					$this->load->model('catalog/product_master');
					if(!$this->model_catalog_product_master->isMasterable($this->request->post['master_product'], '2')) //2 is Image
					{
						$this->error['master_product'] = $this->language->get('error_master_product');
					}
					
					if(isset($this->request->post['product_id'])) //update product
					{			
						if($this->model_catalog_product_master->isMaster($this->request->post['product_id'], '2')) //2 is Image
						{
							$this->error['master_product'] = $this->language->get('error_master_product_cannot_be_changed');
						}
					}
				}
			}
			//EOF Product Series
		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'catalog/product')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}

	protected function validateCopy() {
		if (!$this->user->hasPermission('modify', 'catalog/product')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}

	public function autocomplete() {
		$json = array();

		if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_model'])) {
			$this->load->model('catalog/product');
			$this->load->model('catalog/option');

			if (isset($this->request->get['filter_name'])) {
				$filter_name = $this->request->get['filter_name'];
			} else {
				$filter_name = '';
			}

			if (isset($this->request->get['filter_model'])) {
				$filter_model = $this->request->get['filter_model'];
			} else {
				$filter_model = '';
			}

			if (isset($this->request->get['limit'])) {
				$limit = $this->request->get['limit'];
			} else {
				$limit = 5;
			}

			$filter_data = array(
				'filter_name'  => $filter_name,
				'filter_model' => $filter_model,
				'start'        => 0,
				'limit'        => $limit
			);

			$results = $this->model_catalog_product->getProducts($filter_data);

			foreach ($results as $result) {
				$option_data = array();

				$product_options = $this->model_catalog_product->getProductOptions($result['product_id']);

				foreach ($product_options as $product_option) {
					$option_info = $this->model_catalog_option->getOption($product_option['option_id']);

					if ($option_info) {
						$product_option_value_data = array();

						foreach ($product_option['product_option_value'] as $product_option_value) {
							$option_value_info = $this->model_catalog_option->getOptionValue($product_option_value['option_value_id']);

							if ($option_value_info) {
								$product_option_value_data[] = array(
									'product_option_value_id' => $product_option_value['product_option_value_id'],
									'option_value_id'         => $product_option_value['option_value_id'],
									'name'                    => $option_value_info['name'],
									'price'                   => (float)$product_option_value['price'] ? $this->currency->format($product_option_value['price'], $this->config->get('config_currency')) : false,
									'price_prefix'            => $product_option_value['price_prefix']
								);
							}
						}

						$option_data[] = array(
							'product_option_id'    => $product_option['product_option_id'],
							'product_option_value' => $product_option_value_data,
							'option_id'            => $product_option['option_id'],
							'name'                 => $option_info['name'],
							'type'                 => $option_info['type'],
							'value'                => $product_option['value'],
							'required'             => $product_option['required']
						);
					}
				}

				$json[] = array(
					'product_id' => $result['product_id'],
					'name'       => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),
					'model'      => $result['model'],
					'option'     => $option_data,
					'price'      => $result['price']
				);
			}
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}
