<?php
class ControllerCommonHeader extends Controller {
	public function index() {

      $this->load->model('tool/seo_package');
      $this->model_tool_seo_package->metaRobots();
      $this->model_tool_seo_package->checkCanonical();
      $this->model_tool_seo_package->hrefLang();
      $this->model_tool_seo_package->richSnippets();
      
      if (version_compare(VERSION, '2', '>=')) {
        $data['mlseo_meta'] = $this->document->renderSeoMeta();
      } else {
        $this->data['mlseo_meta'] = $this->document->renderSeoMeta();
      }
      
      $seoTitlePrefix = $this->config->get('mlseo_title_prefix');
      $seoTitlePrefix = isset($seoTitlePrefix[$this->config->get('config_store_id').$this->config->get('config_language_id')]) ? $seoTitlePrefix[$this->config->get('config_store_id').$this->config->get('config_language_id')] : '';
      
      $seoTitleSuffix = $this->config->get('mlseo_title_suffix');
      $seoTitleSuffix = isset($seoTitleSuffix[$this->config->get('config_store_id').$this->config->get('config_language_id')]) ? $seoTitleSuffix[$this->config->get('config_store_id').$this->config->get('config_language_id')] : '';

      if (version_compare(VERSION, '2', '<')) {
        if ($this->config->get('mlseo_fix_search')) {
          $this->data['mlseo_fix_search'] = true;
          $this->data['csp_search_url'] = $this->url->link('product/search');
        }
      }
      

			if ($this->customer->isLogged()) {
				$this->load->model('account/customer_switcher'); //for update customer group
				$this->model_account_customer_switcher->switchCustomer();
			}
            
		// Analytics
		$this->load->model('setting/extension');

		$data['analytics'] = array();

		$analytics = $this->model_setting_extension->getExtensions('analytics');

		foreach ($analytics as $analytic) {
			if ($this->config->get('analytics_' . $analytic['code'] . '_status')) {
				$data['analytics'][] = $this->load->controller('extension/analytics/' . $analytic['code'], $this->config->get('analytics_' . $analytic['code'] . '_status'));
			}
		}

		if ($this->request->server['HTTPS']) {
			$server = $this->config->get('config_ssl');
		} else {
			$server = $this->config->get('config_url');
		}

		if (is_file(DIR_IMAGE . $this->config->get('config_icon'))) {
			$this->document->addLink($server . 'image/' . $this->config->get('config_icon'), 'icon');
		}

		

				if($this->config->get('reviewpro_fields')['status']){
					$this->document->addScript('catalog/view/javascript/reviewpro/jquery.cookie.min.js');
					$this->document->addScript('catalog/view/javascript/reviewpro/jquery.magnific-popup.min.js');
					$this->document->addStyle('catalog/view/javascript/reviewpro/magnific-popup.css');
					$this->document->addStyle('catalog/view/javascript/reviewpro/style.css');
				}
				$data['reviewpropopup'] = $this->load->controller('extension/reviewpropopup');
				
        //$data['title'] = $this->document->getTitle();
        $data['title'] = (isset($seoTitlePrefix) ? $seoTitlePrefix : '') . $this->document->getTitle() . (isset($seoTitleSuffix) ? $seoTitleSuffix : '');
      

		$data['base'] = $server;
		$data['description'] = $this->document->getDescription();
		$data['keywords'] = $this->document->getKeywords();
		$data['links'] = $this->document->getLinks();
		$data['styles'] = $this->document->getStyles();

				// << Related Options
				
				$this->load->model('extension/liveopencart/related_options');
				if ( $this->model_extension_liveopencart_related_options->installed()) {
					$ro_basic_scripts = $this->model_extension_liveopencart_related_options->getBasicScripts();
					foreach ( $ro_basic_scripts as $ro_basic_script) {
						$this->document->addScript($ro_basic_script);
					}
				}
				// >> Related Options
			
		$data['scripts'] = $this->document->getScripts('header');
		$data['lang'] = $this->language->get('code');
		$data['direction'] = $this->language->get('direction');

		$data['name'] = $this->config->get('config_name');

		if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
			$data['logo'] = $server . 'image/' . $this->config->get('config_logo');
		} else {
			$data['logo'] = '';
		}

		$this->load->language('common/header');

		// Wishlist
		if ($this->customer->isLogged()) {
			$this->load->model('account/wishlist');

			$data['text_wishlist'] = sprintf($this->language->get('text_wishlist'), $this->model_account_wishlist->getTotalWishlist());
		} else {
			$data['text_wishlist'] = sprintf($this->language->get('text_wishlist'), (isset($this->session->data['wishlist']) ? count($this->session->data['wishlist']) : 0));
		}

		$data['text_logged'] = sprintf($this->language->get('text_logged'), $this->url->link('account/account', '', true), $this->customer->getFirstName(), $this->url->link('account/logout', '', true));
		
		$data['home'] = $this->url->link('common/home');
		$data['wishlist'] = $this->url->link('account/wishlist', '', true);
		$data['logged'] = $this->customer->isLogged();
		$data['account'] = $this->url->link('account/account', '', true);
		$data['register'] = $this->url->link('account/register', '', true);
		$data['login'] = $this->url->link('account/login', '', true);
		$data['order'] = $this->url->link('account/order', '', true);
		$data['transaction'] = $this->url->link('account/transaction', '', true);
		$data['download'] = $this->url->link('account/download', '', true);
		$data['logout'] = $this->url->link('account/logout', '', true);
		$data['shopping_cart'] = $this->url->link('checkout/cart');
		$data['checkout'] = $this->url->link('checkout/checkout', '', true);
		$data['contact'] = $this->url->link('information/contact');
		$data['telephone'] = $this->config->get('config_telephone');
		
		$data['language'] = $this->load->controller('common/language');
		$data['currency'] = $this->load->controller('common/currency');
		$data['search'] = $this->load->controller('common/search');

				$data['idquantity'] = $this->config->get('quantity_id');
			
		$data['cart'] = $this->load->controller('common/cart');
		$data['menu'] = $this->load->controller('common/menu');


            $this->load->language('extension/module/notify_when_available');
            $data['notify_heading'] = $this->language->get('notify_heading');
            $data['entry_name_notify']     = $this->language->get('entry_name_notify');
            $data['entry_email_notify']    = $this->language->get('entry_email_notify');
            $data['entry_message_notify']      = $this->language->get('entry_message_notify');
            $data['button_notify_send']  = $this->language->get('button_notify_send');
            if ($this->customer->isLogged()) {
                $data['notify_name']           = $this->customer->getFirstName().' '.$this->customer->getLastName();
                $data['notify_email']          = $this->customer->getEmail();
            }else{
                $data['notify_name']           = '';
                $data['notify_email']          = '';
            }
            $data['out_of_stock_show'] = $this->config->get('module_notify_when_available_stock');
            $data['out_of_stock_notify'] = $this->config->get('module_notify_when_available_notify');
       
		return $this->load->view('common/header', $data);
	}
}
