<?php
class ControllerCommonSearch extends Controller {
	public function index() {

            if (defined('OPENCARTVIP_ACTIVE')) {
                $this->load->model('opencartvip/links');

                $data['search_url'] = $this->model_opencartvip_links->url('product/search', 'search=');

                if ($this->opencartvip->settings->get('searchStyleSearchCategoriesSelectorStatus')) {
                    $this->load->language('product/search');
                    $this->load->model('opencartvip/category');

                    $category_id = (int)\Opencartvip\Utils\Arr::get($this->request->get, 'category_id', 0);
                    $category = $this->language->get('text_category');

                    if ($category_id) {
                        $category_info = $this->model_catalog_category->getCategory($category_id);

                        if ($category_info) {
                            $category = $category_info['name'];
                        }
                    }

                    $data['text_category'] = $this->language->get('text_category');
                    $data['category'] = $category;
                    $data['category_id'] = $category_id;

                    if ($this->opencartvip->settings->get('searchStyleSearchCategoriesType') === 'top') {
                        $categories = $this->model_opencartvip_category->getCategories(0, 0);

                        $data['categories'] = array();

                        foreach ($categories as $category) {
                            $data['categories'][] = array(
                                'category_id' => $category['category_id'],
                                'title' => $category['name'],
                                'items' => array()
                            );
                        }
                    } else {
                        $data['categories'] = $this->model_opencartvip_category->getSubcategories(0);
                    }
                }
            }
            
		$this->load->language('common/search');

		$data['text_search'] = $this->language->get('text_search');

		if (isset($this->request->get['search'])) {
			$data['search'] = $this->request->get['search'];
		} else {
			$data['search'] = '';
		}


        if ($this->config->get('mlseo_fix_search')) {
          $data['csp_search_url'] = $this->url->link('product/search');
          
          return $this->load->view('common/csp_search', $data);
        }
      
		return $this->load->view('common/search', $data);
	}
}