<?php
class ControllerExtensionModuleAgreePopup extends Controller {
	public function index() {

        $this->load->language('extension/module/notify_when_available');
        $data['text_out_of_stock'] = $this->language->get('text_out_of_stock');
        $data['out_of_stock_show'] = $this->config->get('module_notify_when_available_stock');
        $data['out_of_stock_notify'] = $this->config->get('module_notify_when_available_notify');
        
		$data['lang_id'] = $this->config->get('config_language_id');
		$data['agreedata'] = $this->config->get('agreedata');	
		$data['agree_description'] = $data['agreedata'][$data['lang_id']]['agree_description'] ? html_entity_decode($data['agreedata'][$data['lang_id']]['agree_description'], ENT_QUOTES, 'UTF-8') : '' ;   
		$this->response->setOutput($this->load->view('extension/module/agree_popup', $data));		
		
	}
	public function saveAgreeCookie() {
		$agreedata = $this->config->get('agreedata');
		$cookie_day = $agreedata['cookie_day'] ? $agreedata['cookie_day'] : '1';
		if (isset($this->request->get['saveAgreeCookie'])) {
			setcookie('PopupAgree', 1, time() + (60*60*24*$cookie_day), "/");
		}
	}
}