<?php
class ControllerExtensionModuleEbayListing extends Controller {
	public function index() {

        $this->load->language('extension/module/notify_when_available');
        $data['text_out_of_stock'] = $this->language->get('text_out_of_stock');
        $data['out_of_stock_show'] = $this->config->get('module_notify_when_available_stock');
        $data['out_of_stock_notify'] = $this->config->get('module_notify_when_available_notify');
        
		if ($this->config->get('ebay_status') == 1) {
			$this->load->language('extension/module/ebay');
			
			$this->load->model('tool/image');
			$this->load->model('extension/openbay/ebay_product');

			$data['heading_title'] = $this->language->get('heading_title');

			$data['products'] = array();

			$products = $this->cache->get('ebay_listing.' . md5(serialize($products)));

			if (!$products) {
				$products = $this->model_extension_openbay_ebay_product->getDisplayProducts();
				
				$this->cache->set('ebay_listing.' . md5(serialize($products)), $products);
			}

			foreach($products['products'] as $product) {
				if (isset($product['pictures'][0])) {
					$image = $this->model_extension_openbay_ebay_product->resize($product['pictures'][0], $this->config->get('ebay_listing_width'), $this->config->get('ebay_listing_height'));
				} else {
					$image = $this->model_tool_image->resize('placeholder.png', $this->config->get('ebay_listing_width'), $this->config->get('ebay_listing_height'));
				}


					if (isset($product_info) && isset($product_info['product_id'])) {
                        $wgtm = $product_info;
                    }elseif(isset($result) && isset($result['product_id'])) {
                        $wgtm = $result;
                    }
				if($this->config->get('reviewpro_fields')['status']){
					$this->load->model('extension/reviewpro');
					$rating_desc = $this->model_extension_reviewpro->getratinglist();
					$avgrating = array();
					$total_avg = 0;
					$items = 0;
					foreach ($rating_desc as $rating_result) {
						$count = $this->model_extension_reviewpro->getratingparcount($rating_result['rating_id'],$wgtm['product_id']);
						$avg = $this->model_extension_reviewpro->getratingparavg($rating_result['rating_id'], $wgtm['product_id']);
						if($count){
							$total_avg = $avg + $total_avg;
							$items++;
						}
					}
					if($total_avg){
						$averagerating = round($total_avg / $items, 1);
					}else{
						$averagerating = 0;
					}
					$rating = round($averagerating);
				}
			
				$data['products'][] = array(

        'quantity'  => isset($result['quantity']) ? $result['quantity'] : (isset($product_info['quantity']) ? $product_info['quantity'] : 1),
        
					'thumb' => $image, 
					'name'  => base64_decode($product['Title']), 
					'price' => $this->currency->format($product['priceGross'], $this->session->data['currency']), 
					'href'  => (string)$product['link']
				);
			}

			$data['tracking_pixel'] = $products['tracking_pixel'];

			return $this->load->view('extension/module/ebay', $data);
		}
	}
}