<?php
class ControllerExtensionModuleLatest extends Controller {
	public function index($setting) {

			$data['idquantity'] = $this->config->get('quantity_id');
			

        $this->load->language('extension/module/notify_when_available');
        $data['text_out_of_stock'] = $this->language->get('text_out_of_stock');
        $data['out_of_stock_show'] = $this->config->get('module_notify_when_available_stock');
        $data['out_of_stock_notify'] = $this->config->get('module_notify_when_available_notify');
        
		$this->load->language('extension/module/latest');

		$this->load->model('catalog/product');

		$this->load->model('tool/image');

		$data['products'] = array();

		$filter_data = array(
			'sort'  => 'p.date_added',
			'order' => 'DESC',
			'start' => 0,
			'limit' => $setting['limit']
		);

		$results = $this->model_catalog_product->getProducts($filter_data);

		if ($results) {
			foreach ($results as $result) {
				if ($result['image']) {
					$image = $this->model_tool_image->resize($result['image'], $setting['width'], $setting['height']);
				} else {
					$image = $this->model_tool_image->resize('placeholder.png', $setting['width'], $setting['height']);
				}

				if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$price = false;
				}

				if ((float)$result['special']) {
					$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$special = false;
				}

				if ($this->config->get('config_tax')) {
					$tax = $this->currency->format((float)$result['special'] ? $result['special'] : $result['price'], $this->session->data['currency']);
				} else {
					$tax = false;
				}

				if ($this->config->get('config_review_status')) {
					$rating = $result['rating'];
				} else {
					$rating = false;
				}


			if(isset($product_info)){
				$value = $product_info;
			}elseif(isset($result)){
				$value = $result;
			}elseif(isset($product)){
				$value = $product;
			}
			

					if (isset($product_info) && isset($product_info['product_id'])) {
                        $wgtm = $product_info;
                    }elseif(isset($result) && isset($result['product_id'])) {
                        $wgtm = $result;
                    }
				if($this->config->get('reviewpro_fields')['status']){
					$this->load->model('extension/reviewpro');
					$rating_desc = $this->model_extension_reviewpro->getratinglist();
					$avgrating = array();
					$total_avg = 0;
					$items = 0;
					foreach ($rating_desc as $rating_result) {
						$count = $this->model_extension_reviewpro->getratingparcount($rating_result['rating_id'],$wgtm['product_id']);
						$avg = $this->model_extension_reviewpro->getratingparavg($rating_result['rating_id'], $wgtm['product_id']);
						if($count){
							$total_avg = $avg + $total_avg;
							$items++;
						}
					}
					if($total_avg){
						$averagerating = round($total_avg / $items, 1);
					}else{
						$averagerating = 0;
					}
					$rating = round($averagerating);
				}
			
				$data['products'][] = array(

        'quantity'  => isset($result['quantity']) ? $result['quantity'] : (isset($product_info['quantity']) ? $product_info['quantity'] : 1),
        
					'product_id'  => $result['product_id'],

        'quantity'  => $result['quantity'],
        
					'thumb'       => $image,
					'name'        => $result['name'],
					'description' => utf8_substr(trim(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8'))), 0, $this->config->get('theme_' . $this->config->get('config_theme') . '_product_description_length')) . '..',
					'price'       => $price,
					'special'     => $special,
					'tax'         => $tax,
'max'         => $value['quantity'],
						  'min'         => $value['minimum'],	
			
					'rating'      => $rating,
					'href'        => $this->url->link('product/product', 'product_id=' . $result['product_id'])
				);
			}

			return $this->load->view('extension/module/latest', $data);
		}
	}
}
