<?php

use Opencartvip\Opencart\ModuleController;
use Opencartvip\Options\Parser;
use Opencartvip\Utils\Arr;

class ControllerOpencartvipBlocks extends ModuleController {

	private static $PRODUCT_INFO;
	private static $CATEGORY_INFO;

	public function __construct($registry) {
		parent::__construct($registry);
		$this->load->model('opencartvip/links');
	}

	public function index($args) {
		$data = parent::index($args);

		if (!$data) {
			return null;
		}

		if ($this->settings['carousel']) {
			$this->opencartvip->document->addStyle('catalog/view/theme/opencartvip/lib/swiper/swiper.min.css');
			$this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/swiper/swiper.min.js', 'footer');
		}

		return $data;
	}

	/**
	 * @param Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseGeneralSettings($parser, $index) {
		$default = $parser->getSetting('default');

		$data = array(
			'classes'         => array(
				'blocks-' . $parser->getSetting('display'),
				'carousel-mode' => $parser->getSetting('carousel'),
			),
			'carouselOptions' => $this->opencartvip->carousel($parser->getJs(), 'carouselStyle'),
		);

		$data['default_index'] = $parser->getSetting('display') === 'tabs' ? 1 : 0;

		if ($default) {
			foreach (Arr::get($this->module_data, 'items') as $index => $item) {
				if ($default === Arr::get($item, 'id')) {
					$data['default_index'] = $index + 1;
					break;
				}
			}
		}

		return $data;
	}

	/**
	 * @param Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseItemSettings($parser, $index) {
		$title = $parser->getSetting('title');

		switch ($parser->getSetting('contentType')) {
			case 'description':
			case 'attributes':
			case 'reviews':
			case 'dynamic':
				$content = '';
				break;

			default:
				$content = $parser->getSetting('content');
		}

		return array(
			'tab_classes'   => array(
				'tab-' . $this->item_id,
				'active' => ($this->settings['display'] === 'tabs') && ($index === $this->settings['default_index']),
			),
			'panel_classes' => array(
				'panel-collapse',
				'collapse',
				'in' => ($this->settings['display'] === 'accordion') && ($index === $this->settings['default_index']),
			),
			'classes'       => array(
				'tab-pane'     => $this->settings['display'] === 'tabs',
				'active'       => ($this->settings['display'] === 'tabs') && ($index === $this->settings['default_index']),
				'panel'        => $this->settings['display'] === 'accordion',
				'panel-active' => ($this->settings['display'] === 'accordion') && ($index === $this->settings['default_index']),
				'swiper-slide' => ($this->settings['display'] === 'grid') && $this->settings['carousel'],
			),
			'image'         => $this->model_opencartvip_image->resize($parser->getSetting('image'), $this->settings['imageDimensions']['width'], $this->settings['imageDimensions']['height'], $this->settings['imageDimensions']['resize']),
		
			'title'         => $title,
			'content'       => $content,
		);
	}

	/**
	 * @param Parser $parser
	 * @param $index
	 * @return array
	 */
	protected function parseSubitemSettings($parser, $index) {
		return array();
	}

	protected function beforeRender() {
		foreach ($this->settings['items'] as $key => &$item) {
			// product tabs
			if (isset($this->request->get['product_id'])) {
				if (in_array($item['contentType'], array('description', 'short_description', 'attributes', 'reviews'))) {
					$item['content'] = $this->productContent($item['contentType'], $item['shortDescriptionLimit']);
				}
			} else if (isset($this->request->get['path'])) {
				if (in_array($item['contentType'], array('description', 'short_description'))) {
					$item['content'] = $this->categoryContent($item['contentType'], $item['shortDescriptionLimit']);
				}
			}

			// dynamic
			if ($item['contentType'] === 'dynamic' && $item['dynamic']) {
				$item['content'] = $this->load->controller($item['dynamic'], array(
					'module_id' => $this->module_id,
					'item'      => $item,
					'settings'  => $this->settings,
				));
			}

			$limit = (int)$this->opencartvip->settings->get('globalExpandCharactersLimit');

			if ($limit > 0 && (utf8_strlen(strip_tags($item['content'])) <= $limit)) {
				$item['classes'][] = 'no-expand';
			}

			if (!$item['content']) {
				// force update default_index before render if current item is default
				if ($key === $this->settings['default_index']) {
					$this->settings['default_index'] = -1;
				}

				unset($this->settings['items'][$key]);

				continue;
			}
		}

		if (!$this->settings['items']) {
			$this->settings = null;

			return;
		}

		if ($this->settings['display'] === 'tabs') {
			if ($this->settings['default_index'] === -1) {
				reset($this->settings['items']);
				$key = key($this->settings['items']);

				$this->settings['items'][$key]['tab_classes'][] = 'active';
				$this->settings['items'][$key]['classes'][] = 'active';
			}
		}

		if ($this->settings['display'] === 'accordion') {
			if ($this->settings['default_index'] === -1) {
				reset($this->settings['items']);
				$key = key($this->settings['items']);

				$this->settings['items'][$key]['panel_classes'][] = 'in';
				$this->settings['items'][$key]['classes'][] = 'active';
			}
		}
	}

	private function productContent($type, $short_description_limit) {
		if (static::$PRODUCT_INFO === null) {
			$product_info = $this->model_catalog_product->getProduct($this->request->get['product_id']);

			// desc
			static::$PRODUCT_INFO['description'] = html_entity_decode($product_info['description'], ENT_QUOTES, 'UTF-8');

			if (!trim(strip_tags(static::$PRODUCT_INFO['description'], '<img>'))) {
				static::$PRODUCT_INFO['description'] = '';
			}

			static::$PRODUCT_INFO['short_description'] = utf8_substr(strip_tags(html_entity_decode(static::$PRODUCT_INFO['description'], ENT_QUOTES, 'UTF-8')), 0, $short_description_limit) . '..';

			// attrs
			$data['attribute_groups'] = $this->model_catalog_product->getProductAttributes($this->request->get['product_id']);
			static::$PRODUCT_INFO['attributes'] = $this->renderView('opencartvip/module/product_blocks_attributes', $data);

			// reviews
			$this->load->language('product/product');

			$data['text_write'] = $this->language->get('text_write');
			$data['entry_name'] = $this->language->get('entry_name');
			$data['entry_review'] = $this->language->get('entry_review');
			$data['text_note'] = $this->language->get('text_note');
			$data['entry_rating'] = $this->language->get('entry_rating');
			$data['entry_bad'] = $this->language->get('entry_bad');
			$data['entry_good'] = $this->language->get('entry_good');
			$data['text_loading'] = $this->language->get('text_loading');
			$data['button_continue'] = $this->language->get('button_continue');

			$data['text_login'] = sprintf($this->language->get('text_login'), $this->url->link('account/login', '', true), $this->url->link('account/register', '', true));
			$data['tab_review'] = sprintf($this->language->get('tab_review'), $product_info['reviews']);

			$data['review_status'] = $this->config->get('config_review_status');

			if ($this->config->get('config_review_guest') || $this->customer->isLogged()) {
				$data['review_guest'] = true;
			} else {
				$data['review_guest'] = false;
			}

			if ($this->customer->isLogged()) {
				$data['customer_name'] = $this->customer->getFirstName() . '&nbsp;' . $this->customer->getLastName();
			} else {
				$data['customer_name'] = '';
			}

			$data['reviews'] = sprintf($this->language->get('text_reviews'), (int)$product_info['reviews']);
			$data['rating'] = (int)$product_info['rating'];

			$data['reviewprostatus'] = $this->config->get('reviewpro_fields')['status'];
			$data['forstars'] = '';
			$data['reviewfeatured'] = '';
				if($this->config->get('reviewpro_fields')['status']){
					$this->load->model('extension/reviewpro');
					$this->load->language('extension/reviewpro');
					
					$data['entry_title'] = $this->language->get('entry_title');
					$data['entry_email'] = $this->language->get('entry_email');
					$data['entry_comment'] = $this->language->get('entry_comment');
					$data['entry_rating'] = $this->language->get('entry_rating');
					$data['entry_attachment'] = $this->language->get('entry_attachment');
					$data['text_verified'] = $this->language->get('text_verified');
					$data['text_featured_reviews'] = $this->language->get('text_featured_reviews');
					$data['text_clearfilter'] = $this->language->get('text_clearfilter');
					$data['text_descending'] = $this->language->get('text_descending');
					$data['text_asc'] = $this->language->get('text_asc');
					$data['text_no_reviews'] = $this->language->get('text_no_reviews');
					
					$data['reviewprostatus'] = $this->config->get('reviewpro_fields')['status'];
					$data['review_status'] = $this->config->get('reviewpro_fields')['status'];
					$data['displayform'] = $this->config->get('reviewpro_fields')['displayform'];
					$data['reviewpro_fields'] = $this->config->get('reviewpro_fields');
					if(isset($this->config->get('reviewpro_fields')['filter'])){
						$data['reviewfilters'] = $this->config->get('reviewpro_fields')['filter'];
					}else{
						$data['reviewfilters'] = '';
					}
					
					if(isset($this->config->get('reviewpro_fields')['reviewsnippet'])){
						$data['reviewsnippet'] = $this->config->get('reviewpro_fields')['reviewsnippet'];
					}else{
						$data['reviewsnippet'] = '';
					}
					$data['meta_descriptions'] = html_entity_decode($product_info['meta_description'], ENT_QUOTES, 'UTF-8');
					
					$data['product_id'] = $this->request->get['product_id'];
					
					$data['ratinglists'] = $this->model_extension_reviewpro->getratinglist();
					$data['textadmin'] = $this->config->get('reviewpro_fields')['overall'][$this->config->get('config_language_id')];
					$data['votetext'] = $this->config->get('reviewpro_fields')[$this->config->get('config_language_id')];
					$data['product_name'] = $this->model_catalog_product->getProduct($this->request->get['product_id'])['name'];
					$data['rating_desc'] = $this->model_extension_reviewpro->getratinglist();
					$data['review_total'] = $this->model_extension_reviewpro->getTotalReviewsByProductId($this->request->get['product_id']);
					$data['tab_review'] = sprintf($this->language->get('tab_review'), $data['review_total']);
					$data['reviewtotals'] = sprintf($this->language->get('text_reviews'), (int)$data['review_total']);
					$data['reviewform'] = $this->config->get('reviewpro_fields')['reviewform'][$this->config->get('config_language_id')];
					
					if ($this->config->get('reviewpro_fields')['guestreview'] || $this->customer->isLogged()) {
						$data['review_guest'] = true;
					} else {
						$data['review_guest'] = false;
					}
					if ($this->customer->isLogged()) {
						$data['customer_email'] = $this->customer->getEmail();
					} else {
						$data['customer_email'] = '';
					}
					
					if ($this->config->get('reviewpro_fields')['guestreview']) {
						$data['guestreview'] = true;
					}elseif($this->customer->isLogged() && !$this->config->get('reviewpro_fields')['guestreview']){
						$data['guestreview'] = true;
					}else{
						$data['guestreview'] = false;
					}
					
					$data['text_descending'] = $this->language->get('text_descending');
					$data['text_asc'] = $this->language->get('text_asc');
 				
					if (isset($this->request->get['page'])) {
						$page = $this->request->get['page'];
					} else {
						$page = 1;
					}

					if (isset($this->request->get['rating_id'])) {
						$rating_id = $this->request->get['rating_id'];
					}else{
						$rating_id = '0';
					}
					
					if (isset($this->request->get['ratings'])) {
						$ratings = $this->request->get['ratings'];
					}else{
						$ratings = '0';
					}
					
					if($this->config->get('reviewpro_fields')['noofreview']){
						$noofreview = $this->config->get('reviewpro_fields')['noofreview'];
					}else{
						$noofreview = 5;
					}
					
					$filter_data = array(
						'rating_id'  => $rating_id,
						'ratings'  => $ratings,
						'limit' => $noofreview,
						'start' => ($page - 1) * $noofreview,
					);
					
					$data['allreviews'] = array();
					
					$reviewss = $this->model_extension_reviewpro->getReviewsByProductId($this->request->get['product_id'],$filter_data);
					$data['reviewfeatured'] = $this->model_extension_reviewpro->getfeaturedReviewsByProductId($this->request->get['product_id'], $filter_data);
					
					foreach($reviewss as $review){
						$ratingss = $this->model_extension_reviewpro->getreviewrating($review['review_id']);
						$i = 0;
						$ratingvalue = array();
						foreach($ratingss as $ratings){
							$ratingvalue[] = $ratings['rating'];
							$i++;
						}
						if(!empty($ratingvalue)){
							$sumrating = array_sum($ratingvalue) / $i;
						}
						$data['allreviews'][] = array(
							'name' => $review['name'],
							'comment' => $review['comment'],
							'date_added' => $review['date_added'],
							'sumrating' => isset($sumrating) ? $sumrating : ''
						);
					}
					
					$data['avgrating'] = array();
					$total_avg = 0;
					$items = 0;
					foreach ($data['rating_desc'] as $result) {
						$count = $this->model_extension_reviewpro->getratingparcount($result['rating_id'], $this->request->get['product_id']);
						$sum = $this->model_extension_reviewpro->getratingparsum($result['rating_id'], $this->request->get['product_id']);
						$avg = $this->model_extension_reviewpro->getratingparavg($result['rating_id'], $this->request->get['product_id']);
						$per = $avg*100/5;
						if($count){
							$data['avgrating'][$result['rating_id']] = array(
								'count'       => $count,
								'sum'     	  => $sum,
								'average'     => $avg,
								'per'     	  => round($per,1).'%'
							);
							$total_avg = $avg + $total_avg;
							$items++;
						}
					}
					if($total_avg){
						$data['averagerating'] = round($total_avg / $items, 1);
					}else{
						$data['averagerating'] = 0;
					}
					$data['forstars'] = round($data['averagerating']);
					$data['reviewstotal'] = sprintf($this->language->get('text_reviews'), $data['review_total']);
					if(!empty($total_avg) && !empty($items)){
						$data['rating'] = round($total_avg / $items);
					}else{
						$data['rating'] = '';
					}
					$data['getcurrencycode'] = $this->session->data['currency'];
					
					if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
						$data['reviewprice'] = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency'] , '' , false);
					} else {
						$data['reviewprice'] = false;
					}
					if ((float)$product_info['special']) {
						$data['reviewspecial'] = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency'] , '' , false);
					} else {
						$data['reviewspecial'] = false;
					}
				}
			
			

			// Captcha
			if ($this->config->get('captcha_' . $this->config->get('config_captcha') . '_status') && in_array('review', (array)$this->config->get('config_captcha_page'))) {
				$data['captcha'] = $this->load->controller('extension/captcha/' . $this->config->get('config_captcha'));
			} else {
				$data['captcha'] = '';
			}

			static::$PRODUCT_INFO['reviews'] = $this->renderView('opencartvip/module/product_blocks_reviews', $data);
		}

		return static::$PRODUCT_INFO[$type];
	}

	private function categoryContent($type, $short_description_limit) {
		if (static::$CATEGORY_INFO === null) {
			$parts = explode('_', (string)$this->request->get['path']);

			$category_id = (int)array_pop($parts);

			$category_info = $this->model_catalog_category->getCategory($category_id);

			// desc
			static::$CATEGORY_INFO['description'] = html_entity_decode($category_info['description'], ENT_QUOTES, 'UTF-8');

			if (!trim(strip_tags(static::$CATEGORY_INFO['description'], '<img>'))) {
				static::$CATEGORY_INFO['description'] = '';
			}

			static::$CATEGORY_INFO['short_description'] = utf8_substr(strip_tags(html_entity_decode(static::$CATEGORY_INFO['description'], ENT_QUOTES, 'UTF-8')), 0, $short_description_limit) . '..';
		}

		return static::$CATEGORY_INFO[$type];
	}

}
