<?php
class ControllerProductCategory extends Controller {
	public function index() {

			$data['idquantity'] = $this->config->get('quantity_id');
			

				// path manager - preserve bc
				if (isset($this->request->get['path']) && $this->config->get('mlseo_fpp_directcat')) {
					$cat_id = strrchr('_'.$this->request->get['path'], '_');
					$cat_id = str_replace('_', '', $cat_id);
          $this->load->model('tool/path_manager');
          $this->request->get['path'] = $this->model_tool_path_manager->getFullCategoryPath($cat_id);
				}
			

        $this->load->language('extension/module/notify_when_available');
        $data['text_out_of_stock'] = $this->language->get('text_out_of_stock');
        $data['out_of_stock_show'] = $this->config->get('module_notify_when_available_stock');
        $data['out_of_stock_notify'] = $this->config->get('module_notify_when_available_notify');
        
		$this->load->language('product/category');

		$this->load->model('catalog/category');

		$this->load->model('catalog/product');

		$this->load->model('tool/image');
if (defined('OPENCARTVIP_ACTIVE')) {
                $this->load->model('opencartvip/image');
            }

		if (isset($this->request->get['filter'])) {
			$filter = $this->request->get['filter'];
		} else {
			$filter = '';
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'p.date_added';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['limit'])) {
			$limit = (int)$this->request->get['limit'];
		} else {
			$limit = $this->config->get('theme_' . $this->config->get('config_theme') . '_product_limit');
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		if (isset($this->request->get['path'])) {
//BOF Product Series	
			$pds_show_thumbnails = $this->getData('pds_show_thumbnails', 1);
			
			if($pds_show_thumbnails)
			{
				if(isset($data['products']))
				{
					$pds_list_thumbnail_width = $this->getData('pds_list_thumbnail_width', 20);
					$pds_list_thumbnail_height = $this->getData('pds_list_thumbnail_height', 20);
					$pds_thumbnail_hover_effect = $this->getData('pds_thumbnail_hover_effect', 'rollover');
					
					if($pds_thumbnail_hover_effect == 'rollover')
					{
						$pds_list_hover_width = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width');
						$pds_list_hover_height = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height');
						$pds_list_thumbnail_class = 'pds-thumb-rollover';
					}
					else if($pds_thumbnail_hover_effect == 'preview')
					{
						$pds_list_hover_width = $this->getData('pds_list_preview_width', 200);
						$pds_list_hover_height = $this->getData('pds_list_preview_height', 200);
						$pds_list_thumbnail_class = 'preview';
					}
					else //none
					{
						$pds_list_thumbnail_class = '';
					}
					
					$this->load->model('catalog/product_master');
					$linkedProducts = $this->model_catalog_product_master->getAllLinkedProducts('2'); //2 is Image
					
					foreach ($data['products'] as &$product) //& is for reference
					{
						$product['pds'] = array();
						
						foreach ($linkedProducts as $result) {
							if($result['master_product_id'] == $product['product_id'])
							{
								$product_pds_image = ($result['special_attribute_value'] != '' && strtolower($result['special_attribute_value']) != 'no_image.png')
								? $this->model_tool_image->resize($result['special_attribute_value'], $pds_list_thumbnail_width, $pds_list_thumbnail_height)
								: $this->model_tool_image->resize($result['image'], $pds_list_thumbnail_width, $pds_list_thumbnail_height);
								
								if($pds_thumbnail_hover_effect == 'rollover' || $pds_thumbnail_hover_effect == 'preview')
								{
									$product_pds_image_hover = $this->model_tool_image->resize($result['image'], $pds_list_hover_width, $pds_list_hover_height);
								}
								else //none
								{
									$product_pds_image_hover = '';
								}
							
								$product['pds'][] = array(
									'product_link' => $this->url->link('product/product', $url . '&product_id=' . $result['product_id']),
									'product_name' => $result['product_name'],
									'product_pds_image' => $product_pds_image,
									'product_master_image' => $product['thumb'],
									'product_pds_image_hover' => $product_pds_image_hover,
									'pds_list_thumbnail_class' => $pds_list_thumbnail_class
								);
							}
						}
					}
				}
			}
			else
			{
				if(isset($data['products']))
				{
					foreach ($data['products'] as &$product) //& is for reference
					{
						$product['pds'] = array();
					}
				}
			}
			//EOF Product Series
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$path = '';

			$parts = explode('_', (string)$this->request->get['path']);

			$category_id = (int)array_pop($parts);

			foreach ($parts as $path_id) {
				if (!$path) {
					$path = (int)$path_id;
				} else {
					$path .= '_' . (int)$path_id;
				}

				$category_info = $this->model_catalog_category->getCategory($path_id);

				if ($category_info) {

				$data['telephone'] = $this->config->get('config_telephone');
			
					$data['breadcrumbs'][] = array(
						'text' => $category_info['name'],
						'href' => $this->url->link('product/category', 'path=' . $path . $url)
					);
				}
			}
		} else {
			$category_id = 0;
		}

		$category_info = $this->model_catalog_category->getCategory($category_id);

		if ($category_info) {

				$data['telephone'] = $this->config->get('config_telephone');
			
			$this->document->setTitle(!empty($category_info['meta_title']) && $this->config->get('mlseo_enabled') ? $category_info['meta_title'] : $category_info['name']);
			$this->document->setDescription($category_info['meta_description']);
			$this->document->setKeywords($category_info['meta_keyword']);

			$data['heading_title'] = !empty($category_info['seo_h1']) && $this->config->get('mlseo_enabled') ? $category_info['seo_h1'] : $category_info['name'];
      if (version_compare(VERSION, '2', '>=')) {
        $data['seo_h1'] = !empty($category_info['seo_h1']) ? $category_info['seo_h1'] : '';
        $data['seo_h2'] = !empty($category_info['seo_h2']) ? $category_info['seo_h2'] : '';
        $data['seo_h3'] = !empty($category_info['seo_h3']) ? $category_info['seo_h3'] : '';
      } else {
        $this->data['seo_h1'] = !empty($category_info['seo_h1']) ? $category_info['seo_h1'] : '';
        $this->data['seo_h2'] = !empty($category_info['seo_h2']) ? $category_info['seo_h2'] : '';
        $this->data['seo_h3'] = !empty($category_info['seo_h3']) ? $category_info['seo_h3'] : '';
      }
      
      if ($this->config->get('mlseo_enabled')) {
        $this->load->model('tool/seo_package');
        
        if ($this->config->get('mlseo_microdata')) {
          if (version_compare(VERSION, '2', '>=')) {
            $this->document->addSeoMeta($this->model_tool_seo_package->rich_snippet('microdata', 'category', $data));
          } else {
            $this->document->addSeoMeta($this->model_tool_seo_package->rich_snippet('microdata', 'category', $this->data));
          }
        }
      }
      
      if ($this->config->get('mlseo_header_lm_category')) {
        $gkd_header_lm_date = strtotime($category_info['date_modified']);
        
        $this->response->addHeader('Last-Modified: '.date('D, d M Y H:i:s', $gkd_header_lm_date).' GMT');
      }
      

			if (defined('OPENCARTVIP_ACTIVE')) {
                $data['text_compare'] = $this->opencartvip->countBadge($this->language->get('text_compare'), isset($this->session->data['compare']) ? count($this->session->data['compare']) : 0);
            } else {
                $data['text_compare'] = sprintf($this->language->get('text_compare'), (isset($this->session->data['compare']) ? count($this->session->data['compare']) : 0));
            }

			// Set the last category breadcrumb
			$data['breadcrumbs'][] = array(
				'text' => $category_info['name'],
				'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'])
			);

			if ($category_info['image']) {
				if (defined('OPENCARTVIP_ACTIVE')) {
                $data['thumb'] = $this->model_opencartvip_image->resize($category_info['image'], $this->opencartvip->settings->get('image_dimensions_category.width'), $this->opencartvip->settings->get('image_dimensions_category.height'), $this->opencartvip->settings->get('image_dimensions_category.resize'));
               
            } else {
                $data['thumb'] = $this->model_tool_image->resize($category_info['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_category_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_category_height'));
            }
			} else {
				$data['thumb'] = '';
			}

			$data['description'] = html_entity_decode($category_info['description'], ENT_QUOTES, 'UTF-8');
			$data['compare'] = $this->url->link('product/compare');

//BOF Product Series	
			$pds_show_thumbnails = $this->getData('pds_show_thumbnails', 1);
			
			if($pds_show_thumbnails)
			{
				if(isset($data['products']))
				{
					$pds_list_thumbnail_width = $this->getData('pds_list_thumbnail_width', 20);
					$pds_list_thumbnail_height = $this->getData('pds_list_thumbnail_height', 20);
					$pds_thumbnail_hover_effect = $this->getData('pds_thumbnail_hover_effect', 'rollover');
					
					if($pds_thumbnail_hover_effect == 'rollover')
					{
						$pds_list_hover_width = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width');
						$pds_list_hover_height = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height');
						$pds_list_thumbnail_class = 'pds-thumb-rollover';
					}
					else if($pds_thumbnail_hover_effect == 'preview')
					{
						$pds_list_hover_width = $this->getData('pds_list_preview_width', 200);
						$pds_list_hover_height = $this->getData('pds_list_preview_height', 200);
						$pds_list_thumbnail_class = 'preview';
					}
					else //none
					{
						$pds_list_thumbnail_class = '';
					}
					
					$this->load->model('catalog/product_master');
					$linkedProducts = $this->model_catalog_product_master->getAllLinkedProducts('2'); //2 is Image
					
					foreach ($data['products'] as &$product) //& is for reference
					{
						$product['pds'] = array();
						
						foreach ($linkedProducts as $result) {
							if($result['master_product_id'] == $product['product_id'])
							{
								$product_pds_image = ($result['special_attribute_value'] != '' && strtolower($result['special_attribute_value']) != 'no_image.png')
								? $this->model_tool_image->resize($result['special_attribute_value'], $pds_list_thumbnail_width, $pds_list_thumbnail_height)
								: $this->model_tool_image->resize($result['image'], $pds_list_thumbnail_width, $pds_list_thumbnail_height);
								
								if($pds_thumbnail_hover_effect == 'rollover' || $pds_thumbnail_hover_effect == 'preview')
								{
									$product_pds_image_hover = $this->model_tool_image->resize($result['image'], $pds_list_hover_width, $pds_list_hover_height);
								}
								else //none
								{
									$product_pds_image_hover = '';
								}
							
								$product['pds'][] = array(
									'product_link' => $this->url->link('product/product', $url . '&product_id=' . $result['product_id']),
									'product_name' => $result['product_name'],
									'product_pds_image' => $product_pds_image,
									'product_master_image' => $product['thumb'],
									'product_pds_image_hover' => $product_pds_image_hover,
									'pds_list_thumbnail_class' => $pds_list_thumbnail_class
								);
							}
						}
					}
				}
			}
			else
			{
				if(isset($data['products']))
				{
					foreach ($data['products'] as &$product) //& is for reference
					{
						$product['pds'] = array();
					}
				}
			}
			//EOF Product Series
			$url = '';

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['categories'] = array();

			if (defined('OPENCARTVIP_ACTIVE')) {
                if ($this->opencartvip->settings->get('refineCategories') !== 'none') {
                    if ($this->opencartvip->settings->get('subcategoriesDisplay') === 'carousel') {
                        $this->opencartvip->document->addStyle('catalog/view/theme/opencartvip/lib/swiper/swiper.min.css');
			            $this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/swiper/swiper.min.js', 'footer');
                    }
                    $results = $this->model_catalog_category->getCategories($category_id);
                } else {
                    $results = array();
                }
            } else {
                $results = $this->model_catalog_category->getCategories($category_id);
            }

			foreach ($results as $result) {
				$filter_data = array(
					'filter_category_id'  => $result['category_id'],
					'filter_sub_category' => true
				);

				$data['categories'][] = array(
					'name' => defined('OPENCARTVIP_ACTIVE') ? $this->opencartvip->countBadge($result['name'], $this->config->get('config_product_count') ? $this->model_catalog_product->getTotalProducts($filter_data) : null) : $result['name'] . ($this->config->get('config_product_count') ? ' (' . $this->model_catalog_product->getTotalProducts($filter_data) . ')' : ''),
            'image' => defined('OPENCARTVIP_ACTIVE') ? $this->model_opencartvip_image->resize($result['image'], $this->opencartvip->settings->get('image_dimensions_subcategory.width'), $this->opencartvip->settings->get('image_dimensions_subcategory.height'), $this->opencartvip->settings->get('image_dimensions_subcategory.resize')) : '',
            'alt' => defined('OPENCARTVIP_ACTIVE') ? $result['name'] : '',
					'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '_' . $result['category_id'] . $url)
				);
			}

			$data['products'] = array();

			$filter_data = array(
				'filter_category_id' => $category_id,
				'filter_filter'      => $filter,
				'sort'               => $sort,
				'order'              => $order,
				'start'              => ($page - 1) * $limit,
				'limit'              => $limit
			);

			
            if (defined('OPENCARTVIP_ACTIVE')) {
                $this->load->model('opencartvip/filter');

                $filter_data = array_merge($this->model_opencartvip_filter->parseFilterData(), $filter_data);

                $this->model_opencartvip_filter->setFilterData($filter_data);

                $product_total = $this->model_opencartvip_filter->getTotalProducts();
            } else {
                $product_total = $this->model_catalog_product->getTotalProducts($filter_data);
            }
            

			
            if (defined('OPENCARTVIP_ACTIVE')) {
                $results = $this->model_opencartvip_filter->getProducts($filter_data);
            } else {
                $results = $this->model_catalog_product->getProducts($filter_data);
            }
            

            if (defined('OPENCARTVIP_ACTIVE')) {
                $this->load->model('opencartvip/product');

                $data['image_width'] = $this->opencartvip->settings->get('image_dimensions_product.width');
                $data['image_height'] = $this->opencartvip->settings->get('image_dimensions_product.height');

                if ($this->opencartvip->settings->get('performanceLazyLoadImagesStatus')) {
			        $data['dummy_image'] = $this->model_opencartvip_image->transparent($data['image_width'], $data['image_width']);
                }
            }
            

			foreach ($results as $result) {
				if ($result['image']) {
					if (defined('OPENCARTVIP_ACTIVE')) {
                $image = $this->model_opencartvip_image->resize($result['image'], $this->opencartvip->settings->get('image_dimensions_product.width'), $this->opencartvip->settings->get('image_dimensions_product.height'), $this->opencartvip->settings->get('image_dimensions_product.resize'));
            } else {
                $image = $this->model_tool_image->resize($result['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height'));
            }
				} else {
					$image = $this->model_tool_image->resize('placeholder.png', $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height'));
				}

				if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$price = false;
				}

				if ((float)$result['special']) {
					$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$special = false;
				}

				if ($this->config->get('config_tax')) {
					$tax = $this->currency->format((float)$result['special'] ? $result['special'] : $result['price'], $this->session->data['currency']);
				} else {
					$tax = false;
				}

				if ($this->config->get('config_review_status')) {
					$rating = (int)$result['rating'];
				} else {
					$rating = false;
				}


            if (defined('OPENCARTVIP_ACTIVE')) {
            

                if ($this->opencartvip->document->isDesktop() && $this->opencartvip->settings->get('globalProductGridSecondImageStatus') && ($additional_image = $this->opencartvip->productSecondImage($result))) {
                    $second_image = $this->model_opencartvip_image->resize($additional_image, $this->opencartvip->themeConfig('image_product_width'), $this->opencartvip->themeConfig('image_product_height'), $this->opencartvip->themeConfig('image_product_resize'));
                   
                } else {
                    $second_image = false;
                }
            }
            

			if(isset($product_info)){
				$value = $product_info;
			}elseif(isset($result)){
				$value = $result;
			}elseif(isset($product)){
				$value = $product;
			}
			

				if($this->config->get('reviewpro_fields')['status']){
					$this->load->model('extension/reviewpro');
					$rating_desc = $this->model_extension_reviewpro->getratinglist();
					$avgrating = array();
					$total_avg = 0;
					$items = 0;
					foreach ($rating_desc as $rating_result) {
						$count = $this->model_extension_reviewpro->getratingparcount($rating_result['rating_id'],$result['product_id']);
						$avg = $this->model_extension_reviewpro->getratingparavg($rating_result['rating_id'], $result['product_id']);
						if($count){
							$total_avg = $avg + $total_avg;
							$items++;
						}
					}
					if($total_avg){
						$averagerating = round($total_avg / $items, 1);
					}else{
						$averagerating = 0;
					}
					$rating = round($averagerating);
				}
			
				$data['products'][] = array(

                'quantity'       => defined('OPENCARTVIP_ACTIVE') ? $result['quantity'] : null,
				'stock_status'   => defined('OPENCARTVIP_ACTIVE') ? $result['stock_status'] : null,
				'second_thumb'   => defined('OPENCARTVIP_ACTIVE') ? $second_image : null,
				'labels'         => defined('OPENCARTVIP_ACTIVE') ? $this->opencartvip->productLabels($result, $price, $special) : null,
				'extra_buttons'  => defined('OPENCARTVIP_ACTIVE') ? $this->opencartvip->productExtraButton($result, $price, $special) : null,
				'date_end'       => defined('OPENCARTVIP_ACTIVE') ? $this->opencartvip->productCountdown($result) : null,
				'price_value'    => defined('OPENCARTVIP_ACTIVE') ? ($result['special'] ? $result['special'] > 0 : $result['price'] > 0) : null,
				'stat1'          => defined('OPENCARTVIP_ACTIVE') ? $this->opencartvip->productStat($result, $this->opencartvip->settings->get('globalProductStat1')) : null,
				'stat2'          => defined('OPENCARTVIP_ACTIVE') ? $this->opencartvip->productStat($result, $this->opencartvip->settings->get('globalProductStat2')) : null,
            
					'product_id'  => $result['product_id'],

        'image_title' => isset($result['image_title']) ? $result['image_title'] : '',
        'image_alt' => isset($result['image_alt']) ? $result['image_alt'] : '',
        

        'quantity'  => $result['quantity'],
        
					'thumb'       => $image,
					'name'        => $result['name'],
					'description' => utf8_substr(trim(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8'))), 0, $this->config->get('theme_' . $this->config->get('config_theme') . '_product_description_length')) . '..',
					'price'       => $price,
					'special'     => $special,
					'tax'         => $tax,
'max'         => $value['quantity'],
						  'min'         => $value['minimum'],	
			
					'minimum'     => $result['minimum'] > 0 ? $result['minimum'] : 1,
					
				'rating'      => $rating,
			
					'href'        => $this->url->link('product/product', 'path=' . $this->request->get['path'] . '&product_id=' . $result['product_id'] . $url)
				);
			}

//BOF Product Series	
			$pds_show_thumbnails = $this->getData('pds_show_thumbnails', 1);
			
			if($pds_show_thumbnails)
			{
				if(isset($data['products']))
				{
					$pds_list_thumbnail_width = $this->getData('pds_list_thumbnail_width', 20);
					$pds_list_thumbnail_height = $this->getData('pds_list_thumbnail_height', 20);
					$pds_thumbnail_hover_effect = $this->getData('pds_thumbnail_hover_effect', 'rollover');
					
					if($pds_thumbnail_hover_effect == 'rollover')
					{
						$pds_list_hover_width = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width');
						$pds_list_hover_height = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height');
						$pds_list_thumbnail_class = 'pds-thumb-rollover';
					}
					else if($pds_thumbnail_hover_effect == 'preview')
					{
						$pds_list_hover_width = $this->getData('pds_list_preview_width', 200);
						$pds_list_hover_height = $this->getData('pds_list_preview_height', 200);
						$pds_list_thumbnail_class = 'preview';
					}
					else //none
					{
						$pds_list_thumbnail_class = '';
					}
					
					$this->load->model('catalog/product_master');
					$linkedProducts = $this->model_catalog_product_master->getAllLinkedProducts('2'); //2 is Image
					
					foreach ($data['products'] as &$product) //& is for reference
					{
						$product['pds'] = array();
						
						foreach ($linkedProducts as $result) {
							if($result['master_product_id'] == $product['product_id'])
							{
								$product_pds_image = ($result['special_attribute_value'] != '' && strtolower($result['special_attribute_value']) != 'no_image.png')
								? $this->model_tool_image->resize($result['special_attribute_value'], $pds_list_thumbnail_width, $pds_list_thumbnail_height)
								: $this->model_tool_image->resize($result['image'], $pds_list_thumbnail_width, $pds_list_thumbnail_height);
								
								if($pds_thumbnail_hover_effect == 'rollover' || $pds_thumbnail_hover_effect == 'preview')
								{
									$product_pds_image_hover = $this->model_tool_image->resize($result['image'], $pds_list_hover_width, $pds_list_hover_height);
								}
								else //none
								{
									$product_pds_image_hover = '';
								}
							
								$product['pds'][] = array(
									'product_link' => $this->url->link('product/product', $url . '&product_id=' . $result['product_id']),
									'product_name' => $result['product_name'],
									'product_pds_image' => $product_pds_image,
									'product_master_image' => $product['thumb'],
									'product_pds_image_hover' => $product_pds_image_hover,
									'pds_list_thumbnail_class' => $pds_list_thumbnail_class
								);
							}
						}
					}
				}
			}
			else
			{
				if(isset($data['products']))
				{
					foreach ($data['products'] as &$product) //& is for reference
					{
						$product['pds'] = array();
					}
				}
			}
			//EOF Product Series
			$url = '';

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}


            if (defined('OPENCARTVIP_ACTIVE')) {
                $url .= $this->model_opencartvip_filter->buildFilterData($filter_data);
            }
            
			$data['sorts'] = array();

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_default'),
				'value' => 'p.sort_order-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.sort_order&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_name_asc'),
				'value' => 'pd.name-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=pd.name&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_name_desc'),
				'value' => 'pd.name-DESC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=pd.name&order=DESC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_price_asc'),
				'value' => 'p.price-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.price&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_price_desc'),
				'value' => 'p.price-DESC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.price&order=DESC' . $url)
			);

			if ($this->config->get('config_review_status')) {
				$data['sorts'][] = array(
					'text'  => $this->language->get('text_rating_desc'),
					'value' => 'rating-DESC',
					'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=rating&order=DESC' . $url)
				);

				$data['sorts'][] = array(
					'text'  => $this->language->get('text_rating_asc'),
					'value' => 'rating-ASC',
					'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=rating&order=ASC' . $url)
				);
			}

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_model_asc'),
				'value' => 'p.model-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.model&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_model_desc'),
				'value' => 'p.model-DESC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.model&order=DESC' . $url)
			);

//BOF Product Series	
			$pds_show_thumbnails = $this->getData('pds_show_thumbnails', 1);
			
			if($pds_show_thumbnails)
			{
				if(isset($data['products']))
				{
					$pds_list_thumbnail_width = $this->getData('pds_list_thumbnail_width', 20);
					$pds_list_thumbnail_height = $this->getData('pds_list_thumbnail_height', 20);
					$pds_thumbnail_hover_effect = $this->getData('pds_thumbnail_hover_effect', 'rollover');
					
					if($pds_thumbnail_hover_effect == 'rollover')
					{
						$pds_list_hover_width = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width');
						$pds_list_hover_height = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height');
						$pds_list_thumbnail_class = 'pds-thumb-rollover';
					}
					else if($pds_thumbnail_hover_effect == 'preview')
					{
						$pds_list_hover_width = $this->getData('pds_list_preview_width', 200);
						$pds_list_hover_height = $this->getData('pds_list_preview_height', 200);
						$pds_list_thumbnail_class = 'preview';
					}
					else //none
					{
						$pds_list_thumbnail_class = '';
					}
					
					$this->load->model('catalog/product_master');
					$linkedProducts = $this->model_catalog_product_master->getAllLinkedProducts('2'); //2 is Image
					
					foreach ($data['products'] as &$product) //& is for reference
					{
						$product['pds'] = array();
						
						foreach ($linkedProducts as $result) {
							if($result['master_product_id'] == $product['product_id'])
							{
								$product_pds_image = ($result['special_attribute_value'] != '' && strtolower($result['special_attribute_value']) != 'no_image.png')
								? $this->model_tool_image->resize($result['special_attribute_value'], $pds_list_thumbnail_width, $pds_list_thumbnail_height)
								: $this->model_tool_image->resize($result['image'], $pds_list_thumbnail_width, $pds_list_thumbnail_height);
								
								if($pds_thumbnail_hover_effect == 'rollover' || $pds_thumbnail_hover_effect == 'preview')
								{
									$product_pds_image_hover = $this->model_tool_image->resize($result['image'], $pds_list_hover_width, $pds_list_hover_height);
								}
								else //none
								{
									$product_pds_image_hover = '';
								}
							
								$product['pds'][] = array(
									'product_link' => $this->url->link('product/product', $url . '&product_id=' . $result['product_id']),
									'product_name' => $result['product_name'],
									'product_pds_image' => $product_pds_image,
									'product_master_image' => $product['thumb'],
									'product_pds_image_hover' => $product_pds_image_hover,
									'pds_list_thumbnail_class' => $pds_list_thumbnail_class
								);
							}
						}
					}
				}
			}
			else
			{
				if(isset($data['products']))
				{
					foreach ($data['products'] as &$product) //& is for reference
					{
						$product['pds'] = array();
					}
				}
			}
			//EOF Product Series
			$url = '';

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			$data['limits'] = array();

			$limits = array_unique(array($this->config->get('theme_' . $this->config->get('config_theme') . '_product_limit'), 25, 50, 75, 100));

			sort($limits);


            if (defined('OPENCARTVIP_ACTIVE')) {
                $url .= $this->model_opencartvip_filter->buildFilterData($filter_data);
            }
            
			foreach($limits as $value) {
				$data['limits'][] = array(
					'text'  => $value,
					'value' => $value,
					'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&limit=' . $value)
				);
			}

//BOF Product Series	
			$pds_show_thumbnails = $this->getData('pds_show_thumbnails', 1);
			
			if($pds_show_thumbnails)
			{
				if(isset($data['products']))
				{
					$pds_list_thumbnail_width = $this->getData('pds_list_thumbnail_width', 20);
					$pds_list_thumbnail_height = $this->getData('pds_list_thumbnail_height', 20);
					$pds_thumbnail_hover_effect = $this->getData('pds_thumbnail_hover_effect', 'rollover');
					
					if($pds_thumbnail_hover_effect == 'rollover')
					{
						$pds_list_hover_width = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width');
						$pds_list_hover_height = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height');
						$pds_list_thumbnail_class = 'pds-thumb-rollover';
					}
					else if($pds_thumbnail_hover_effect == 'preview')
					{
						$pds_list_hover_width = $this->getData('pds_list_preview_width', 200);
						$pds_list_hover_height = $this->getData('pds_list_preview_height', 200);
						$pds_list_thumbnail_class = 'preview';
					}
					else //none
					{
						$pds_list_thumbnail_class = '';
					}
					
					$this->load->model('catalog/product_master');
					$linkedProducts = $this->model_catalog_product_master->getAllLinkedProducts('2'); //2 is Image
					
					foreach ($data['products'] as &$product) //& is for reference
					{
						$product['pds'] = array();
						
						foreach ($linkedProducts as $result) {
							if($result['master_product_id'] == $product['product_id'])
							{
								$product_pds_image = ($result['special_attribute_value'] != '' && strtolower($result['special_attribute_value']) != 'no_image.png')
								? $this->model_tool_image->resize($result['special_attribute_value'], $pds_list_thumbnail_width, $pds_list_thumbnail_height)
								: $this->model_tool_image->resize($result['image'], $pds_list_thumbnail_width, $pds_list_thumbnail_height);
								
								if($pds_thumbnail_hover_effect == 'rollover' || $pds_thumbnail_hover_effect == 'preview')
								{
									$product_pds_image_hover = $this->model_tool_image->resize($result['image'], $pds_list_hover_width, $pds_list_hover_height);
								}
								else //none
								{
									$product_pds_image_hover = '';
								}
							
								$product['pds'][] = array(
									'product_link' => $this->url->link('product/product', $url . '&product_id=' . $result['product_id']),
									'product_name' => $result['product_name'],
									'product_pds_image' => $product_pds_image,
									'product_master_image' => $product['thumb'],
									'product_pds_image_hover' => $product_pds_image_hover,
									'pds_list_thumbnail_class' => $pds_list_thumbnail_class
								);
							}
						}
					}
				}
			}
			else
			{
				if(isset($data['products']))
				{
					foreach ($data['products'] as &$product) //& is for reference
					{
						$product['pds'] = array();
					}
				}
			}
			//EOF Product Series
			$url = '';

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}


            if (defined('OPENCARTVIP_ACTIVE')) {
                $url .= $this->model_opencartvip_filter->buildFilterData($filter_data);
            }
            

      if ($this->config->get('mlseo_enabled')) {
        $this->load->model('tool/seo_package');
        
        if ($this->config->get('mlseo_multistore') && $this->config->get('config_store_id')) {
          $seoDescription = $this->model_tool_seo_package->getSeoDescription('category', $category_info['category_id']);
          
          if (isset($seoDescription['meta_title'])) {
            $this->document->setTitle($seoDescription['meta_title']);
            $product_info['meta_title'] = $seoDescription['meta_title'];
          }
          
          if (isset($seoDescription['meta_description'])) {
            $this->document->setDescription($seoDescription['meta_description']);
            $product_info['meta_description'] = $seoDescription['meta_description'];
          }
          
          if (isset($seoDescription['meta_keyword'])) {
            $this->document->setKeywords($seoDescription['meta_keyword']);
          }
          
          if (isset($seoDescription['image_alt'])) {
            $data['image_alt'] = $seoDescription['image_alt'];
          }
          
          if (isset($seoDescription['description'])) {
            $data['description'] = html_entity_decode($seoDescription['description'], ENT_QUOTES, 'UTF-8');
          }
          
          if (isset($seoDescription['seo_h1'])) {
            $data['seo_h1'] = $seoDescription['seo_h1'];
          }
          
          if (isset($seoDescription['seo_h2'])) {
            $data['seo_h2'] = $seoDescription['seo_h2'];
          }
          
          if (isset($seoDescription['seo_h3'])) {
            $data['seo_h3'] = $seoDescription['seo_h3'];
          }
        }
      }
      
			$pagination = new Pagination();
			$pagination->total = $product_total;
			$pagination->page = $page;
			$pagination->limit = $limit;
			$pagination->url = $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&page={page}');

			$data['pagination'] = $pagination->render();

			$data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $limit) + 1 : 0, ((($page - 1) * $limit) > ($product_total - $limit)) ? $product_total : ((($page - 1) * $limit) + $limit), $product_total, ceil($product_total / $limit));

			// http://googlewebmastercentral.blogspot.com/2011/09/pagination-with-relnext-and-relprev.html

      if ($page > 1 AND $this->config->get('mlseo_pagination_canonical')) {
         $this->load->model('tool/path_manager'); $this->document->addLink($this->url->link('product/category', 'path=' . ($this->config->get('mlseo_fpp_cat_canonical') ? $this->model_tool_path_manager->getFullCategoryPath($category_info['category_id']) : $category_info['category_id']) . '&page='. $page, true), 'canonical');
      }
      
			if ($page == 1) {
			    
        $this->load->model('tool/path_manager');
        if (empty($this->request->get['mfp_seo_alias'])) {
          $this->document->addLink($this->url->link('product/category', 'path=' . ($this->config->get('mlseo_fpp_cat_canonical') ? $this->model_tool_path_manager->getFullCategoryPath($category_info['category_id']) : $category_info['category_id'])), 'canonical');
				} else {
					$this->document->addLink( rtrim( $this->url->link('product/category', 'path=' . ($this->config->get('mlseo_enabled') && $this->config->get('mlseo_pagination_fix') ? $this->request->get['path'] : $category_info['category_id']), true), '/' ) . '/' . $this->request->get['mfp_seo_alias'], 'canonical');
        }
        
			} else {
				$this->load->model('tool/path_manager'); $this->document->addLink($this->url->link('product/category', 'path=' . ($this->config->get('mlseo_fpp_cat_canonical') ? $this->model_tool_path_manager->getFullCategoryPath($category_info['category_id']) : $category_info['category_id']) . '&page='. $page), 'canonical');
			}
			
			if ($page > 1) {
			    $this->load->model('tool/path_manager'); $this->document->addLink($this->url->link('product/category', 'path=' . ($this->config->get('mlseo_fpp_cat_canonical') ? $this->model_tool_path_manager->getFullCategoryPath($category_info['category_id']) : $category_info['category_id']) . (($page - 2) ? '&page='. ($page - 1) : '')), 'prev');
			}

			if ($limit && ceil($product_total / $limit) > $page) {
			    $this->load->model('tool/path_manager'); $this->document->addLink($this->url->link('product/category', 'path=' . ($this->config->get('mlseo_fpp_cat_canonical') ? $this->model_tool_path_manager->getFullCategoryPath($category_info['category_id']) : $category_info['category_id']) . '&page='. ($page + 1)), 'next');
			}

			$data['sort'] = $sort;
			$data['order'] = $order;
			$data['limit'] = $limit;

			$data['continue'] = $this->url->link('common/home');

			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] = $this->load->controller('common/footer');
			$data['header'] = $this->load->controller('common/header');

			$this->response->setOutput($this->load->view('product/category', $data));
		} else {
//BOF Product Series	
			$pds_show_thumbnails = $this->getData('pds_show_thumbnails', 1);
			
			if($pds_show_thumbnails)
			{
				if(isset($data['products']))
				{
					$pds_list_thumbnail_width = $this->getData('pds_list_thumbnail_width', 20);
					$pds_list_thumbnail_height = $this->getData('pds_list_thumbnail_height', 20);
					$pds_thumbnail_hover_effect = $this->getData('pds_thumbnail_hover_effect', 'rollover');
					
					if($pds_thumbnail_hover_effect == 'rollover')
					{
						$pds_list_hover_width = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width');
						$pds_list_hover_height = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height');
						$pds_list_thumbnail_class = 'pds-thumb-rollover';
					}
					else if($pds_thumbnail_hover_effect == 'preview')
					{
						$pds_list_hover_width = $this->getData('pds_list_preview_width', 200);
						$pds_list_hover_height = $this->getData('pds_list_preview_height', 200);
						$pds_list_thumbnail_class = 'preview';
					}
					else //none
					{
						$pds_list_thumbnail_class = '';
					}
					
					$this->load->model('catalog/product_master');
					$linkedProducts = $this->model_catalog_product_master->getAllLinkedProducts('2'); //2 is Image
					
					foreach ($data['products'] as &$product) //& is for reference
					{
						$product['pds'] = array();
						
						foreach ($linkedProducts as $result) {
							if($result['master_product_id'] == $product['product_id'])
							{
								$product_pds_image = ($result['special_attribute_value'] != '' && strtolower($result['special_attribute_value']) != 'no_image.png')
								? $this->model_tool_image->resize($result['special_attribute_value'], $pds_list_thumbnail_width, $pds_list_thumbnail_height)
								: $this->model_tool_image->resize($result['image'], $pds_list_thumbnail_width, $pds_list_thumbnail_height);
								
								if($pds_thumbnail_hover_effect == 'rollover' || $pds_thumbnail_hover_effect == 'preview')
								{
									$product_pds_image_hover = $this->model_tool_image->resize($result['image'], $pds_list_hover_width, $pds_list_hover_height);
								}
								else //none
								{
									$product_pds_image_hover = '';
								}
							
								$product['pds'][] = array(
									'product_link' => $this->url->link('product/product', $url . '&product_id=' . $result['product_id']),
									'product_name' => $result['product_name'],
									'product_pds_image' => $product_pds_image,
									'product_master_image' => $product['thumb'],
									'product_pds_image_hover' => $product_pds_image_hover,
									'pds_list_thumbnail_class' => $pds_list_thumbnail_class
								);
							}
						}
					}
				}
			}
			else
			{
				if(isset($data['products']))
				{
					foreach ($data['products'] as &$product) //& is for reference
					{
						$product['pds'] = array();
					}
				}
			}
			//EOF Product Series
			$url = '';

			if (isset($this->request->get['path'])) {
				$url .= '&path=' . $this->request->get['path'];
			}

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_error'),
				'href' => $this->url->link('product/category', $url)
			);

			$this->document->setTitle($this->language->get('text_error'));

			$data['continue'] = $this->url->link('common/home');

			$this->response->addHeader($this->request->server['SERVER_PROTOCOL'] . ' 404 Not Found');

			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] = $this->load->controller('common/footer');
			$data['header'] = $this->load->controller('common/header');

			$this->response->setOutput($this->load->view('error/not_found', $data));
		}
	}
}
